# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'GuestPoliciesAssignmentArgs',
    'GuestPoliciesAssignmentGroupLabelArgs',
    'GuestPoliciesAssignmentOsTypeArgs',
    'GuestPoliciesPackageArgs',
    'GuestPoliciesPackageRepositoryArgs',
    'GuestPoliciesPackageRepositoryAptArgs',
    'GuestPoliciesPackageRepositoryGooArgs',
    'GuestPoliciesPackageRepositoryYumArgs',
    'GuestPoliciesPackageRepositoryZypperArgs',
    'GuestPoliciesRecipeArgs',
    'GuestPoliciesRecipeArtifactArgs',
    'GuestPoliciesRecipeArtifactGcsArgs',
    'GuestPoliciesRecipeArtifactRemoteArgs',
    'GuestPoliciesRecipeInstallStepArgs',
    'GuestPoliciesRecipeInstallStepArchiveExtractionArgs',
    'GuestPoliciesRecipeInstallStepDpkgInstallationArgs',
    'GuestPoliciesRecipeInstallStepFileCopyArgs',
    'GuestPoliciesRecipeInstallStepFileExecArgs',
    'GuestPoliciesRecipeInstallStepMsiInstallationArgs',
    'GuestPoliciesRecipeInstallStepRpmInstallationArgs',
    'GuestPoliciesRecipeInstallStepScriptRunArgs',
    'GuestPoliciesRecipeUpdateStepArgs',
    'GuestPoliciesRecipeUpdateStepArchiveExtractionArgs',
    'GuestPoliciesRecipeUpdateStepDpkgInstallationArgs',
    'GuestPoliciesRecipeUpdateStepFileCopyArgs',
    'GuestPoliciesRecipeUpdateStepFileExecArgs',
    'GuestPoliciesRecipeUpdateStepMsiInstallationArgs',
    'GuestPoliciesRecipeUpdateStepRpmInstallationArgs',
    'GuestPoliciesRecipeUpdateStepScriptRunArgs',
    'PatchDeploymentInstanceFilterArgs',
    'PatchDeploymentInstanceFilterGroupLabelArgs',
    'PatchDeploymentOneTimeScheduleArgs',
    'PatchDeploymentPatchConfigArgs',
    'PatchDeploymentPatchConfigAptArgs',
    'PatchDeploymentPatchConfigGooArgs',
    'PatchDeploymentPatchConfigPostStepArgs',
    'PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs',
    'PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs',
    'PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs',
    'PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs',
    'PatchDeploymentPatchConfigPreStepArgs',
    'PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs',
    'PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs',
    'PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs',
    'PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs',
    'PatchDeploymentPatchConfigWindowsUpdateArgs',
    'PatchDeploymentPatchConfigYumArgs',
    'PatchDeploymentPatchConfigZypperArgs',
    'PatchDeploymentRecurringScheduleArgs',
    'PatchDeploymentRecurringScheduleMonthlyArgs',
    'PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs',
    'PatchDeploymentRecurringScheduleTimeOfDayArgs',
    'PatchDeploymentRecurringScheduleTimeZoneArgs',
    'PatchDeploymentRecurringScheduleWeeklyArgs',
    'PatchDeploymentRolloutArgs',
    'PatchDeploymentRolloutDisruptionBudgetArgs',
]

@pulumi.input_type
class GuestPoliciesAssignmentArgs:
    def __init__(__self__, *,
                 group_labels: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentGroupLabelArgs']]]] = None,
                 instance_name_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_types: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentOsTypeArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentGroupLabelArgs']]] group_labels: Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups,
               for example "env=prod or env=staging".
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_name_prefixes: Targets VM instances whose name starts with one of these prefixes.
               Like labels, this is another way to group VM instances when targeting configs,
               for example prefix="prod-".
               Only supported for project-level policies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Targets any of the instances specified. Instances are specified by their URI in the form
               zones/[ZONE]/instances/[INSTANCE_NAME].
               Instance targeting is uncommon and is supported to facilitate the management of changes
               by the instance or to target specific VM instances for development and testing.
               Only supported for project-level policies and must reference instances within this project.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentOsTypeArgs']]] os_types: Targets VM instances matching at least one of the following OS types.
               VM instances must match all supplied criteria for a given OsType to be included.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Targets instances in any of these zones. Leave empty to target instances in any zone.
               Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if os_types is not None:
            pulumi.set(__self__, "os_types", os_types)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentGroupLabelArgs']]]]:
        """
        Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups,
        for example "env=prod or env=staging".
        Structure is documented below.
        """
        return pulumi.get(self, "group_labels")

    @group_labels.setter
    def group_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentGroupLabelArgs']]]]):
        pulumi.set(self, "group_labels", value)

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VM instances whose name starts with one of these prefixes.
        Like labels, this is another way to group VM instances when targeting configs,
        for example prefix="prod-".
        Only supported for project-level policies.
        """
        return pulumi.get(self, "instance_name_prefixes")

    @instance_name_prefixes.setter
    def instance_name_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_name_prefixes", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets any of the instances specified. Instances are specified by their URI in the form
        zones/[ZONE]/instances/[INSTANCE_NAME].
        Instance targeting is uncommon and is supported to facilitate the management of changes
        by the instance or to target specific VM instances for development and testing.
        Only supported for project-level policies and must reference instances within this project.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="osTypes")
    def os_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentOsTypeArgs']]]]:
        """
        Targets VM instances matching at least one of the following OS types.
        VM instances must match all supplied criteria for a given OsType to be included.
        Structure is documented below.
        """
        return pulumi.get(self, "os_types")

    @os_types.setter
    def os_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesAssignmentOsTypeArgs']]]]):
        pulumi.set(self, "os_types", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets instances in any of these zones. Leave empty to target instances in any zone.
        Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class GuestPoliciesAssignmentGroupLabelArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class GuestPoliciesAssignmentOsTypeArgs:
    def __init__(__self__, *,
                 os_architecture: Optional[pulumi.Input[str]] = None,
                 os_short_name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] os_architecture: Targets VM instances with OS Inventory enabled and having the following OS architecture.
        :param pulumi.Input[str] os_short_name: Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        :param pulumi.Input[str] os_version: Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_short_name is not None:
            pulumi.set(__self__, "os_short_name", os_short_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS architecture.
        """
        return pulumi.get(self, "os_architecture")

    @os_architecture.setter
    def os_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_architecture", value)

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        """
        return pulumi.get(self, "os_short_name")

    @os_short_name.setter
    def os_short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_short_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class GuestPoliciesPackageArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 desired_state: Optional[pulumi.Input[str]] = None,
                 manager: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param pulumi.Input[str] desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe.
               INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
               INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
               if a higher version of the recipe is assigned to this instance.
               REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
               Default value is `INSTALLED`.
               Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        :param pulumi.Input[str] manager: Type of package manager that can be used to install this package. If a system does not have the package manager,
               the package is not installed or removed no error message is returned. By default, or if you specify ANY,
               the agent attempts to install and remove this package using the default package manager.
               This is useful when creating a policy that applies to different types of systems.
               The default behavior is ANY.
               Default value is `ANY`.
               Possible values are `ANY`, `APT`, `YUM`, `ZYPPER`, and `GOO`.
        """
        pulumi.set(__self__, "name", name)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[str]]:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe.
        INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
        INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
        if a higher version of the recipe is assigned to this instance.
        REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        Default value is `INSTALLED`.
        Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input[str]]:
        """
        Type of package manager that can be used to install this package. If a system does not have the package manager,
        the package is not installed or removed no error message is returned. By default, or if you specify ANY,
        the agent attempts to install and remove this package using the default package manager.
        This is useful when creating a policy that applies to different types of systems.
        The default behavior is ANY.
        Default value is `ANY`.
        Possible values are `ANY`, `APT`, `YUM`, `ZYPPER`, and `GOO`.
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manager", value)


@pulumi.input_type
class GuestPoliciesPackageRepositoryArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['GuestPoliciesPackageRepositoryAptArgs']] = None,
                 goo: Optional[pulumi.Input['GuestPoliciesPackageRepositoryGooArgs']] = None,
                 yum: Optional[pulumi.Input['GuestPoliciesPackageRepositoryYumArgs']] = None,
                 zypper: Optional[pulumi.Input['GuestPoliciesPackageRepositoryZypperArgs']] = None):
        """
        :param pulumi.Input['GuestPoliciesPackageRepositoryAptArgs'] apt: An Apt Repository.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesPackageRepositoryGooArgs'] goo: A Goo Repository.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesPackageRepositoryYumArgs'] yum: A Yum Repository.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesPackageRepositoryZypperArgs'] zypper: A Zypper Repository.
               Structure is documented below.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['GuestPoliciesPackageRepositoryAptArgs']]:
        """
        An Apt Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['GuestPoliciesPackageRepositoryAptArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['GuestPoliciesPackageRepositoryGooArgs']]:
        """
        A Goo Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['GuestPoliciesPackageRepositoryGooArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['GuestPoliciesPackageRepositoryYumArgs']]:
        """
        A Yum Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['GuestPoliciesPackageRepositoryYumArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['GuestPoliciesPackageRepositoryZypperArgs']]:
        """
        A Zypper Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['GuestPoliciesPackageRepositoryZypperArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class GuestPoliciesPackageRepositoryAptArgs:
    def __init__(__self__, *,
                 components: pulumi.Input[Sequence[pulumi.Input[str]]],
                 distribution: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 archive_type: Optional[pulumi.Input[str]] = None,
                 gpg_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] components: List of components for this repository. Must contain at least one item.
        :param pulumi.Input[str] distribution: Distribution of this repository.
        :param pulumi.Input[str] uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        :param pulumi.Input[str] archive_type: Type of archive files in this repository. The default behavior is DEB.
               Default value is `DEB`.
               Possible values are `DEB` and `DEB_SRC`.
        :param pulumi.Input[str] gpg_key: URI of the key file for this repository. The agent maintains a keyring at
               /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.
        """
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "uri", uri)
        if archive_type is not None:
            pulumi.set(__self__, "archive_type", archive_type)
        if gpg_key is not None:
            pulumi.set(__self__, "gpg_key", gpg_key)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Input[str]:
        """
        Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of archive files in this repository. The default behavior is DEB.
        Default value is `DEB`.
        Possible values are `DEB` and `DEB_SRC`.
        """
        return pulumi.get(self, "archive_type")

    @archive_type.setter
    def archive_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "archive_type", value)

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the key file for this repository. The agent maintains a keyring at
        /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.
        """
        return pulumi.get(self, "gpg_key")

    @gpg_key.setter
    def gpg_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpg_key", value)


@pulumi.input_type
class GuestPoliciesPackageRepositoryGooArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param pulumi.Input[str] url: The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The url of the repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class GuestPoliciesPackageRepositoryYumArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class GuestPoliciesPackageRepositoryZypperArgs:
    def __init__(__self__, *,
                 base_url: pulumi.Input[str],
                 id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 gpg_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] base_url: The location of the repository directory.
        :param pulumi.Input[str] id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param pulumi.Input[str] display_name: The display name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gpg_keys is not None:
            pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Input[str]:
        """
        The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")

    @gpg_keys.setter
    def gpg_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gpg_keys", value)


@pulumi.input_type
class GuestPoliciesRecipeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArtifactArgs']]]] = None,
                 desired_state: Optional[pulumi.Input[str]] = None,
                 install_steps: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeInstallStepArgs']]]] = None,
                 update_steps: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeUpdateStepArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
               Names are also used to identify resources which helps to determine whether guest policies have conflicts.
               This means that requests to create multiple recipes with the same name and version are rejected since they
               could potentially have conflicting assignments.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArtifactArgs']]] artifacts: Resources available to be used in the steps in the recipe.
               Structure is documented below.
        :param pulumi.Input[str] desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe.
               INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
               INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
               if a higher version of the recipe is assigned to this instance.
               REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
               Default value is `INSTALLED`.
               Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeInstallStepArgs']]] install_steps: Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation.
               Any steps taken (including partially completed steps) are not rolled back.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeUpdateStepArgs']]] update_steps: Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe.
               Any steps taken (including partially completed steps) are not rolled back.
               Structure is documented below.
        :param pulumi.Input[str] version: The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        pulumi.set(__self__, "name", name)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if install_steps is not None:
            pulumi.set(__self__, "install_steps", install_steps)
        if update_steps is not None:
            pulumi.set(__self__, "update_steps", update_steps)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
        Names are also used to identify resources which helps to determine whether guest policies have conflicts.
        This means that requests to create multiple recipes with the same name and version are rejected since they
        could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArtifactArgs']]]]:
        """
        Resources available to be used in the steps in the recipe.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeArtifactArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[str]]:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe.
        INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
        INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
        if a higher version of the recipe is assigned to this instance.
        REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        Default value is `INSTALLED`.
        Possible values are `INSTALLED`, `UPDATED`, and `REMOVED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="installSteps")
    def install_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeInstallStepArgs']]]]:
        """
        Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation.
        Any steps taken (including partially completed steps) are not rolled back.
        Structure is documented below.
        """
        return pulumi.get(self, "install_steps")

    @install_steps.setter
    def install_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeInstallStepArgs']]]]):
        pulumi.set(self, "install_steps", value)

    @property
    @pulumi.getter(name="updateSteps")
    def update_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeUpdateStepArgs']]]]:
        """
        Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe.
        Any steps taken (including partially completed steps) are not rolled back.
        Structure is documented below.
        """
        return pulumi.get(self, "update_steps")

    @update_steps.setter
    def update_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestPoliciesRecipeUpdateStepArgs']]]]):
        pulumi.set(self, "update_steps", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GuestPoliciesRecipeArtifactArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 gcs: Optional[pulumi.Input['GuestPoliciesRecipeArtifactGcsArgs']] = None,
                 remote: Optional[pulumi.Input['GuestPoliciesRecipeArtifactRemoteArgs']] = None):
        """
        :param pulumi.Input[str] id: Id of the artifact, which the installation and update steps of this recipe can reference.
               Artifacts in a recipe cannot have the same id.
        :param pulumi.Input[bool] allow_insecure: Defaults to false. When false, recipes are subject to validations based on the artifact type:
               Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
               GCS: An object generation number must be specified.
        :param pulumi.Input['GuestPoliciesRecipeArtifactGcsArgs'] gcs: A Google Cloud Storage artifact.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeArtifactRemoteArgs'] remote: A generic remote artifact.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Id of the artifact, which the installation and update steps of this recipe can reference.
        Artifacts in a recipe cannot have the same id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false. When false, recipes are subject to validations based on the artifact type:
        Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
        GCS: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['GuestPoliciesRecipeArtifactGcsArgs']]:
        """
        A Google Cloud Storage artifact.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['GuestPoliciesRecipeArtifactGcsArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['GuestPoliciesRecipeArtifactRemoteArgs']]:
        """
        A generic remote artifact.
        Structure is documented below.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['GuestPoliciesRecipeArtifactRemoteArgs']]):
        pulumi.set(self, "remote", value)


@pulumi.input_type
class GuestPoliciesRecipeArtifactGcsArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
               this value would be my-bucket.
        :param pulumi.Input[int] generation: Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
               https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.
        :param pulumi.Input[str] object: Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
               this value would be foo/bar.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
        this value would be my-bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
        https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
        this value would be foo/bar.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class GuestPoliciesRecipeArtifactRemoteArgs:
    def __init__(__self__, *,
                 check_sum: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] check_sum: Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
               If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
               of the steps.
        :param pulumi.Input[str] uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        if check_sum is not None:
            pulumi.set(__self__, "check_sum", check_sum)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="checkSum")
    def check_sum(self) -> Optional[pulumi.Input[str]]:
        """
        Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
        If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
        of the steps.
        """
        return pulumi.get(self, "check_sum")

    @check_sum.setter
    def check_sum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_sum", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepArgs:
    def __init__(__self__, *,
                 archive_extraction: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepArchiveExtractionArgs']] = None,
                 dpkg_installation: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepDpkgInstallationArgs']] = None,
                 file_copy: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileCopyArgs']] = None,
                 file_exec: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileExecArgs']] = None,
                 msi_installation: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepMsiInstallationArgs']] = None,
                 rpm_installation: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepRpmInstallationArgs']] = None,
                 script_run: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepScriptRunArgs']] = None):
        """
        :param pulumi.Input['GuestPoliciesRecipeInstallStepArchiveExtractionArgs'] archive_extraction: Extracts an archive into the specified directory.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepDpkgInstallationArgs'] dpkg_installation: Installs a deb file via dpkg.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepFileCopyArgs'] file_copy: Copies a file onto the instance.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepFileExecArgs'] file_exec: Executes an artifact or local file.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepMsiInstallationArgs'] msi_installation: Installs an MSI file.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepRpmInstallationArgs'] rpm_installation: Installs an rpm file via the rpm utility.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeInstallStepScriptRunArgs'] script_run: Runs commands in a shell.
               Structure is documented below.
        """
        if archive_extraction is not None:
            pulumi.set(__self__, "archive_extraction", archive_extraction)
        if dpkg_installation is not None:
            pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        if file_copy is not None:
            pulumi.set(__self__, "file_copy", file_copy)
        if file_exec is not None:
            pulumi.set(__self__, "file_exec", file_exec)
        if msi_installation is not None:
            pulumi.set(__self__, "msi_installation", msi_installation)
        if rpm_installation is not None:
            pulumi.set(__self__, "rpm_installation", rpm_installation)
        if script_run is not None:
            pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepArchiveExtractionArgs']]:
        """
        Extracts an archive into the specified directory.
        Structure is documented below.
        """
        return pulumi.get(self, "archive_extraction")

    @archive_extraction.setter
    def archive_extraction(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepArchiveExtractionArgs']]):
        pulumi.set(self, "archive_extraction", value)

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepDpkgInstallationArgs']]:
        """
        Installs a deb file via dpkg.
        Structure is documented below.
        """
        return pulumi.get(self, "dpkg_installation")

    @dpkg_installation.setter
    def dpkg_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepDpkgInstallationArgs']]):
        pulumi.set(self, "dpkg_installation", value)

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileCopyArgs']]:
        """
        Copies a file onto the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "file_copy")

    @file_copy.setter
    def file_copy(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileCopyArgs']]):
        pulumi.set(self, "file_copy", value)

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileExecArgs']]:
        """
        Executes an artifact or local file.
        Structure is documented below.
        """
        return pulumi.get(self, "file_exec")

    @file_exec.setter
    def file_exec(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepFileExecArgs']]):
        pulumi.set(self, "file_exec", value)

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepMsiInstallationArgs']]:
        """
        Installs an MSI file.
        Structure is documented below.
        """
        return pulumi.get(self, "msi_installation")

    @msi_installation.setter
    def msi_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepMsiInstallationArgs']]):
        pulumi.set(self, "msi_installation", value)

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepRpmInstallationArgs']]:
        """
        Installs an rpm file via the rpm utility.
        Structure is documented below.
        """
        return pulumi.get(self, "rpm_installation")

    @rpm_installation.setter
    def rpm_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepRpmInstallationArgs']]):
        pulumi.set(self, "rpm_installation", value)

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> Optional[pulumi.Input['GuestPoliciesRecipeInstallStepScriptRunArgs']]:
        """
        Runs commands in a shell.
        Structure is documented below.
        """
        return pulumi.get(self, "script_run")

    @script_run.setter
    def script_run(self, value: Optional[pulumi.Input['GuestPoliciesRecipeInstallStepScriptRunArgs']]):
        pulumi.set(self, "script_run", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepArchiveExtractionArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 destination: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] type: The type of the archive to extract.
               Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        :param pulumi.Input[str] destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "type", type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the archive to extract.
        Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepDpkgInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepFileCopyArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        :param pulumi.Input[bool] overwrite: Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
               is not overwritten and the step is considered a success. Defaults to false.
        :param pulumi.Input[str] permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
               for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
               number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
               bit corresponds to the execute permission. Default behavior is 755.
               Below are some examples of permissions and their associated values:
               read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
        is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
        for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
        number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
        bit corresponds to the execute permission. Default behavior is 755.
        Below are some examples of permissions and their associated values:
        read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepFileExecArgs:
    def __init__(__self__, *,
                 allowed_exit_codes: Optional[pulumi.Input[str]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to be passed to the provided executable.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] local_path: The absolute path of the file on the local filesystem.
        """
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[str]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepMsiInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 flags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] flags: The flags to use when installing the MSI. Defaults to the install flag.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The flags to use when installing the MSI. Defaults to the install flag.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "flags", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepRpmInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class GuestPoliciesRecipeInstallStepScriptRunArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 interpreter: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] script: The shell script to be executed.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
               which likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        """
        pulumi.set(__self__, "script", script)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        The shell script to be executed.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
        which likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepArgs:
    def __init__(__self__, *,
                 archive_extraction: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepArchiveExtractionArgs']] = None,
                 dpkg_installation: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepDpkgInstallationArgs']] = None,
                 file_copy: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileCopyArgs']] = None,
                 file_exec: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileExecArgs']] = None,
                 msi_installation: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepMsiInstallationArgs']] = None,
                 rpm_installation: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepRpmInstallationArgs']] = None,
                 script_run: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepScriptRunArgs']] = None):
        """
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepArchiveExtractionArgs'] archive_extraction: Extracts an archive into the specified directory.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepDpkgInstallationArgs'] dpkg_installation: Installs a deb file via dpkg.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepFileCopyArgs'] file_copy: Copies a file onto the instance.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepFileExecArgs'] file_exec: Executes an artifact or local file.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepMsiInstallationArgs'] msi_installation: Installs an MSI file.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepRpmInstallationArgs'] rpm_installation: Installs an rpm file via the rpm utility.
               Structure is documented below.
        :param pulumi.Input['GuestPoliciesRecipeUpdateStepScriptRunArgs'] script_run: Runs commands in a shell.
               Structure is documented below.
        """
        if archive_extraction is not None:
            pulumi.set(__self__, "archive_extraction", archive_extraction)
        if dpkg_installation is not None:
            pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        if file_copy is not None:
            pulumi.set(__self__, "file_copy", file_copy)
        if file_exec is not None:
            pulumi.set(__self__, "file_exec", file_exec)
        if msi_installation is not None:
            pulumi.set(__self__, "msi_installation", msi_installation)
        if rpm_installation is not None:
            pulumi.set(__self__, "rpm_installation", rpm_installation)
        if script_run is not None:
            pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepArchiveExtractionArgs']]:
        """
        Extracts an archive into the specified directory.
        Structure is documented below.
        """
        return pulumi.get(self, "archive_extraction")

    @archive_extraction.setter
    def archive_extraction(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepArchiveExtractionArgs']]):
        pulumi.set(self, "archive_extraction", value)

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepDpkgInstallationArgs']]:
        """
        Installs a deb file via dpkg.
        Structure is documented below.
        """
        return pulumi.get(self, "dpkg_installation")

    @dpkg_installation.setter
    def dpkg_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepDpkgInstallationArgs']]):
        pulumi.set(self, "dpkg_installation", value)

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileCopyArgs']]:
        """
        Copies a file onto the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "file_copy")

    @file_copy.setter
    def file_copy(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileCopyArgs']]):
        pulumi.set(self, "file_copy", value)

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileExecArgs']]:
        """
        Executes an artifact or local file.
        Structure is documented below.
        """
        return pulumi.get(self, "file_exec")

    @file_exec.setter
    def file_exec(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepFileExecArgs']]):
        pulumi.set(self, "file_exec", value)

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepMsiInstallationArgs']]:
        """
        Installs an MSI file.
        Structure is documented below.
        """
        return pulumi.get(self, "msi_installation")

    @msi_installation.setter
    def msi_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepMsiInstallationArgs']]):
        pulumi.set(self, "msi_installation", value)

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepRpmInstallationArgs']]:
        """
        Installs an rpm file via the rpm utility.
        Structure is documented below.
        """
        return pulumi.get(self, "rpm_installation")

    @rpm_installation.setter
    def rpm_installation(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepRpmInstallationArgs']]):
        pulumi.set(self, "rpm_installation", value)

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepScriptRunArgs']]:
        """
        Runs commands in a shell.
        Structure is documented below.
        """
        return pulumi.get(self, "script_run")

    @script_run.setter
    def script_run(self, value: Optional[pulumi.Input['GuestPoliciesRecipeUpdateStepScriptRunArgs']]):
        pulumi.set(self, "script_run", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepArchiveExtractionArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 destination: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] type: The type of the archive to extract.
               Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        :param pulumi.Input[str] destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "type", type)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the archive to extract.
        Possible values are `TAR`, `TAR_GZIP`, `TAR_BZIP`, `TAR_LZMA`, `TAR_XZ`, and `ZIP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepDpkgInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepFileCopyArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 destination: pulumi.Input[str],
                 overwrite: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] destination: Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        :param pulumi.Input[bool] overwrite: Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
               is not overwritten and the step is considered a success. Defaults to false.
        :param pulumi.Input[str] permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
               for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
               number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
               bit corresponds to the execute permission. Default behavior is 755.
               Below are some examples of permissions and their associated values:
               read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
        is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
        for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
        number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
        bit corresponds to the execute permission. Default behavior is 755.
        Below are some examples of permissions and their associated values:
        read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepFileExecArgs:
    def __init__(__self__, *,
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to be passed to the provided executable.
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[str] local_path: The absolute path of the file on the local filesystem.
        """
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepMsiInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 flags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[Sequence[pulumi.Input[str]]] flags: The flags to use when installing the MSI. Defaults to the install flag.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The flags to use when installing the MSI. Defaults to the install flag.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "flags", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepRpmInstallationArgs:
    def __init__(__self__, *,
                 artifact_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] artifact_id: The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Input[str]:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_id", value)


@pulumi.input_type
class GuestPoliciesRecipeUpdateStepScriptRunArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 allowed_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 interpreter: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] script: The shell script to be executed.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
               which likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        """
        pulumi.set(__self__, "script", script)
        if allowed_exit_codes is not None:
            pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        The shell script to be executed.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @allowed_exit_codes.setter
    def allowed_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_exit_codes", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
        which likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)


@pulumi.input_type
class PatchDeploymentInstanceFilterArgs:
    def __init__(__self__, *,
                 all: Optional[pulumi.Input[bool]] = None,
                 group_labels: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDeploymentInstanceFilterGroupLabelArgs']]]] = None,
                 instance_name_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param pulumi.Input[Sequence[pulumi.Input['PatchDeploymentInstanceFilterGroupLabelArgs']]] group_labels: Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
               VMs when targeting configs, for example prefix="prod-".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Targets any of the VM instances specified. Instances are specified by their URI in the `form zones/{{zone}}/instances/{{instance_name}}`,
               `projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`, or
               `https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> Optional[pulumi.Input[bool]]:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchDeploymentInstanceFilterGroupLabelArgs']]]]:
        """
        Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        Structure is documented below.
        """
        return pulumi.get(self, "group_labels")

    @group_labels.setter
    def group_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchDeploymentInstanceFilterGroupLabelArgs']]]]):
        pulumi.set(self, "group_labels", value)

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
        VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @instance_name_prefixes.setter
    def instance_name_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_name_prefixes", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the `form zones/{{zone}}/instances/{{instance_name}}`,
        `projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`, or
        `https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}`
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PatchDeploymentInstanceFilterGroupLabelArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class PatchDeploymentOneTimeScheduleArgs:
    def __init__(__self__, *,
                 execute_time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] execute_time: The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
               accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> pulumi.Input[str]:
        """
        The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
        accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "execute_time")

    @execute_time.setter
    def execute_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "execute_time", value)


@pulumi.input_type
class PatchDeploymentPatchConfigArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['PatchDeploymentPatchConfigAptArgs']] = None,
                 goo: Optional[pulumi.Input['PatchDeploymentPatchConfigGooArgs']] = None,
                 post_step: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepArgs']] = None,
                 pre_step: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepArgs']] = None,
                 reboot_config: Optional[pulumi.Input[str]] = None,
                 windows_update: Optional[pulumi.Input['PatchDeploymentPatchConfigWindowsUpdateArgs']] = None,
                 yum: Optional[pulumi.Input['PatchDeploymentPatchConfigYumArgs']] = None,
                 zypper: Optional[pulumi.Input['PatchDeploymentPatchConfigZypperArgs']] = None):
        """
        :param pulumi.Input['PatchDeploymentPatchConfigAptArgs'] apt: Apt update settings. Use this setting to override the default apt patch rules.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigGooArgs'] goo: goo update settings. Use this setting to override the default goo patch rules.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigPostStepArgs'] post_step: The ExecStep to run after the patch update.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigPreStepArgs'] pre_step: The ExecStep to run before the patch update.
               Structure is documented below.
        :param pulumi.Input[str] reboot_config: Post-patch reboot settings.
               Possible values are `DEFAULT`, `ALWAYS`, and `NEVER`.
        :param pulumi.Input['PatchDeploymentPatchConfigWindowsUpdateArgs'] windows_update: Windows update settings. Use this setting to override the default Windows patch rules.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigYumArgs'] yum: Yum update settings. Use this setting to override the default yum patch rules.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigZypperArgs'] zypper: zypper update settings. Use this setting to override the default zypper patch rules.
               Structure is documented below.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if post_step is not None:
            pulumi.set(__self__, "post_step", post_step)
        if pre_step is not None:
            pulumi.set(__self__, "pre_step", pre_step)
        if reboot_config is not None:
            pulumi.set(__self__, "reboot_config", reboot_config)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigAptArgs']]:
        """
        Apt update settings. Use this setting to override the default apt patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigAptArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigGooArgs']]:
        """
        goo update settings. Use this setting to override the default goo patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigGooArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepArgs']]:
        """
        The ExecStep to run after the patch update.
        Structure is documented below.
        """
        return pulumi.get(self, "post_step")

    @post_step.setter
    def post_step(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepArgs']]):
        pulumi.set(self, "post_step", value)

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepArgs']]:
        """
        The ExecStep to run before the patch update.
        Structure is documented below.
        """
        return pulumi.get(self, "pre_step")

    @pre_step.setter
    def pre_step(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepArgs']]):
        pulumi.set(self, "pre_step", value)

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> Optional[pulumi.Input[str]]:
        """
        Post-patch reboot settings.
        Possible values are `DEFAULT`, `ALWAYS`, and `NEVER`.
        """
        return pulumi.get(self, "reboot_config")

    @reboot_config.setter
    def reboot_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reboot_config", value)

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigWindowsUpdateArgs']]:
        """
        Windows update settings. Use this setting to override the default Windows patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_update")

    @windows_update.setter
    def windows_update(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigWindowsUpdateArgs']]):
        pulumi.set(self, "windows_update", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigYumArgs']]:
        """
        Yum update settings. Use this setting to override the default yum patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigYumArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigZypperArgs']]:
        """
        zypper update settings. Use this setting to override the default zypper patch rules.
        Structure is documented below.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigZypperArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class PatchDeploymentPatchConfigAptArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated.
               If these packages are not installed, they will be ignored. This field cannot be specified with
               any other patch configuration fields.
        :param pulumi.Input[str] type: By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead.
               Possible values are `DIST` and `UPGRADE`.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated.
        If these packages are not installed, they will be ignored. This field cannot be specified with
        any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead.
        Possible values are `DIST` and `UPGRADE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PatchDeploymentPatchConfigGooArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: goo update settings. Use this setting to override the default goo patch rules.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        goo update settings. Use this setting to override the default goo patch rules.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPostStepArgs:
    def __init__(__self__, *,
                 linux_exec_step_config: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs']] = None,
                 windows_exec_step_config: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs']] = None):
        """
        :param pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs'] linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs'] windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
               Structure is documented below.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @linux_exec_step_config.setter
    def linux_exec_step_config(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs']]):
        pulumi.set(self, "linux_exec_step_config", value)

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_exec_step_config")

    @windows_exec_step_config.setter
    def windows_exec_step_config(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs']]):
        pulumi.set(self, "windows_exec_step_config", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPostStepLinuxExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs'] gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs']]:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 generation_number: pulumi.Input[str],
                 object: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Bucket of the Cloud Storage object.
        :param pulumi.Input[str] generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> pulumi.Input[str]:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPostStepWindowsExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs'] gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs']]:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 generation_number: pulumi.Input[str],
                 object: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Bucket of the Cloud Storage object.
        :param pulumi.Input[str] generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> pulumi.Input[str]:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPreStepArgs:
    def __init__(__self__, *,
                 linux_exec_step_config: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs']] = None,
                 windows_exec_step_config: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs']] = None):
        """
        :param pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs'] linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs'] windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
               Structure is documented below.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @linux_exec_step_config.setter
    def linux_exec_step_config(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs']]):
        pulumi.set(self, "linux_exec_step_config", value)

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        Structure is documented below.
        """
        return pulumi.get(self, "windows_exec_step_config")

    @windows_exec_step_config.setter
    def windows_exec_step_config(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs']]):
        pulumi.set(self, "windows_exec_step_config", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPreStepLinuxExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs'] gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs']]:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 generation_number: pulumi.Input[str],
                 object: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Bucket of the Cloud Storage object.
        :param pulumi.Input[str] generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> pulumi.Input[str]:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPreStepWindowsExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs'] gcs_object: A Cloud Storage object containing the executable.
               Structure is documented below.
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will
               be executed directly, which will likely only succeed for scripts with shebang lines.
               Possible values are `SHELL` and `POWERSHELL`.
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs']]:
        """
        A Cloud Storage object containing the executable.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will
        be executed directly, which will likely only succeed for scripts with shebang lines.
        Possible values are `SHELL` and `POWERSHELL`.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class PatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 generation_number: pulumi.Input[str],
                 object: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Bucket of the Cloud Storage object.
        :param pulumi.Input[str] generation_number: Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Name of the Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> pulumi.Input[str]:
        """
        Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class PatchDeploymentPatchConfigWindowsUpdateArgs:
    def __init__(__self__, *,
                 classifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
               Each value may be one of `CRITICAL`, `SECURITY`, `DEFINITION`, `DRIVER`, `FEATURE_PACK`, `SERVICE_PACK`, `TOOL`, `UPDATE_ROLLUP`, and `UPDATE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated.
               This field must not be used with other patch configurations.
        """
        if classifications is not None:
            pulumi.set(__self__, "classifications", classifications)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        Each value may be one of `CRITICAL`, `SECURITY`, `DEFINITION`, `DRIVER`, `FEATURE_PACK`, `SERVICE_PACK`, `TOOL`, `UPDATE_ROLLUP`, and `UPDATE`.
        """
        return pulumi.get(self, "classifications")

    @classifications.setter
    def classifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifications", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated.
        This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)


@pulumi.input_type
class PatchDeploymentPatchConfigYumArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 minimal: Optional[pulumi.Input[bool]] = None,
                 security: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated.
               If these packages are not installed, they will be ignored. This field cannot be specified with
               any other patch configuration fields.
        :param pulumi.Input[bool] minimal: Will cause patch to run yum update-minimal instead.
        :param pulumi.Input[bool] security: Adds the --security flag to yum update. Not supported on all platforms.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if minimal is not None:
            pulumi.set(__self__, "minimal", minimal)
        if security is not None:
            pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated.
        If these packages are not installed, they will be ignored. This field cannot be specified with
        any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def minimal(self) -> Optional[pulumi.Input[bool]]:
        """
        Will cause patch to run yum update-minimal instead.
        """
        return pulumi.get(self, "minimal")

    @minimal.setter
    def minimal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "minimal", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the --security flag to yum update. Not supported on all platforms.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security", value)


@pulumi.input_type
class PatchDeploymentPatchConfigZypperArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 severities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 with_optional: Optional[pulumi.Input[bool]] = None,
                 with_update: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated.
               This field must not be used with other patch configurations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param pulumi.Input[bool] with_optional: Adds the --with-optional flag to zypper patch.
        :param pulumi.Input[bool] with_update: Adds the --with-update flag, to zypper patch.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)
        if with_optional is not None:
            pulumi.set(__self__, "with_optional", with_optional)
        if with_update is not None:
            pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated.
        This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)

    @property
    @pulumi.getter
    def severities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @severities.setter
    def severities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "severities", value)

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the --with-optional flag to zypper patch.
        """
        return pulumi.get(self, "with_optional")

    @with_optional.setter
    def with_optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_optional", value)

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the --with-update flag, to zypper patch.
        """
        return pulumi.get(self, "with_update")

    @with_update.setter
    def with_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_update", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleArgs:
    def __init__(__self__, *,
                 time_of_day: pulumi.Input['PatchDeploymentRecurringScheduleTimeOfDayArgs'],
                 time_zone: pulumi.Input['PatchDeploymentRecurringScheduleTimeZoneArgs'],
                 end_time: Optional[pulumi.Input[str]] = None,
                 last_execute_time: Optional[pulumi.Input[str]] = None,
                 monthly: Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyArgs']] = None,
                 next_execute_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 weekly: Optional[pulumi.Input['PatchDeploymentRecurringScheduleWeeklyArgs']] = None):
        """
        :param pulumi.Input['PatchDeploymentRecurringScheduleTimeOfDayArgs'] time_of_day: Time of the day to run a recurring deployment.
               Structure is documented below.
        :param pulumi.Input['PatchDeploymentRecurringScheduleTimeZoneArgs'] time_zone: Defines the time zone that timeOfDay is relative to. The rules for daylight saving time are
               determined by the chosen time zone.
               Structure is documented below.
        :param pulumi.Input[str] end_time: The end time at which a recurring patch deployment schedule is no longer active.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] last_execute_time: -
               The time the last patch job ran successfully.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input['PatchDeploymentRecurringScheduleMonthlyArgs'] monthly: Schedule with monthly executions.
               Structure is documented below.
        :param pulumi.Input[str] next_execute_time: -
               The time the next patch job is scheduled to run.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] start_time: The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input['PatchDeploymentRecurringScheduleWeeklyArgs'] weekly: Schedule with weekly executions.
               Structure is documented below.
        """
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if last_execute_time is not None:
            pulumi.set(__self__, "last_execute_time", last_execute_time)
        if monthly is not None:
            pulumi.set(__self__, "monthly", monthly)
        if next_execute_time is not None:
            pulumi.set(__self__, "next_execute_time", next_execute_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> pulumi.Input['PatchDeploymentRecurringScheduleTimeOfDayArgs']:
        """
        Time of the day to run a recurring deployment.
        Structure is documented below.
        """
        return pulumi.get(self, "time_of_day")

    @time_of_day.setter
    def time_of_day(self, value: pulumi.Input['PatchDeploymentRecurringScheduleTimeOfDayArgs']):
        pulumi.set(self, "time_of_day", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input['PatchDeploymentRecurringScheduleTimeZoneArgs']:
        """
        Defines the time zone that timeOfDay is relative to. The rules for daylight saving time are
        determined by the chosen time zone.
        Structure is documented below.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input['PatchDeploymentRecurringScheduleTimeZoneArgs']):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time at which a recurring patch deployment schedule is no longer active.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="lastExecuteTime")
    def last_execute_time(self) -> Optional[pulumi.Input[str]]:
        """
        -
        The time the last patch job ran successfully.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_execute_time")

    @last_execute_time.setter
    def last_execute_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_execute_time", value)

    @property
    @pulumi.getter
    def monthly(self) -> Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyArgs']]:
        """
        Schedule with monthly executions.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly")

    @monthly.setter
    def monthly(self, value: Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyArgs']]):
        pulumi.set(self, "monthly", value)

    @property
    @pulumi.getter(name="nextExecuteTime")
    def next_execute_time(self) -> Optional[pulumi.Input[str]]:
        """
        -
        The time the next patch job is scheduled to run.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_execute_time")

    @next_execute_time.setter
    def next_execute_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_execute_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def weekly(self) -> Optional[pulumi.Input['PatchDeploymentRecurringScheduleWeeklyArgs']]:
        """
        Schedule with weekly executions.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly")

    @weekly.setter
    def weekly(self, value: Optional[pulumi.Input['PatchDeploymentRecurringScheduleWeeklyArgs']]):
        pulumi.set(self, "weekly", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleMonthlyArgs:
    def __init__(__self__, *,
                 month_day: Optional[pulumi.Input[int]] = None,
                 week_day_of_month: Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs']] = None):
        """
        :param pulumi.Input[int] month_day: One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
               Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
               will not run in February, April, June, etc.
        :param pulumi.Input['PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs'] week_day_of_month: Week day in a month.
               Structure is documented below.
        """
        if month_day is not None:
            pulumi.set(__self__, "month_day", month_day)
        if week_day_of_month is not None:
            pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> Optional[pulumi.Input[int]]:
        """
        One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
        Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
        will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @month_day.setter
    def month_day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "month_day", value)

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs']]:
        """
        Week day in a month.
        Structure is documented below.
        """
        return pulumi.get(self, "week_day_of_month")

    @week_day_of_month.setter
    def week_day_of_month(self, value: Optional[pulumi.Input['PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs']]):
        pulumi.set(self, "week_day_of_month", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[str],
                 week_ordinal: pulumi.Input[int]):
        """
        :param pulumi.Input[str] day_of_week: A day of the week.
               Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        :param pulumi.Input[int] week_ordinal: Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[str]:
        """
        A day of the week.
        Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[str]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> pulumi.Input[int]:
        """
        Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")

    @week_ordinal.setter
    def week_ordinal(self, value: pulumi.Input[int]):
        pulumi.set(self, "week_ordinal", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleTimeOfDayArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23.
               An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleTimeZoneArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: IANA Time Zone Database time zone, e.g. "America/New_York".
        :param pulumi.Input[str] version: IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        IANA Time Zone Database time zone, e.g. "America/New_York".
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PatchDeploymentRecurringScheduleWeeklyArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[str]):
        """
        :param pulumi.Input[str] day_of_week: A day of the week.
               Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[str]:
        """
        A day of the week.
        Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[str]):
        pulumi.set(self, "day_of_week", value)


@pulumi.input_type
class PatchDeploymentRolloutArgs:
    def __init__(__self__, *,
                 disruption_budget: pulumi.Input['PatchDeploymentRolloutDisruptionBudgetArgs'],
                 mode: pulumi.Input[str]):
        """
        :param pulumi.Input['PatchDeploymentRolloutDisruptionBudgetArgs'] disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up.
               During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps.
               A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget.
               For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone.
               For example, if the disruption budget has a fixed value of 10, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
               Structure is documented below.
        :param pulumi.Input[str] mode: Mode of the patch rollout.
               Possible values are `ZONE_BY_ZONE` and `CONCURRENT_ZONES`.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> pulumi.Input['PatchDeploymentRolloutDisruptionBudgetArgs']:
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up.
        During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps.
        A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget.
        For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone.
        For example, if the disruption budget has a fixed value of 10, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        Structure is documented below.
        """
        return pulumi.get(self, "disruption_budget")

    @disruption_budget.setter
    def disruption_budget(self, value: pulumi.Input['PatchDeploymentRolloutDisruptionBudgetArgs']):
        pulumi.set(self, "disruption_budget", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Mode of the patch rollout.
        Possible values are `ZONE_BY_ZONE` and `CONCURRENT_ZONES`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class PatchDeploymentRolloutDisruptionBudgetArgs:
    def __init__(__self__, *,
                 fixed: Optional[pulumi.Input[int]] = None,
                 percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] fixed: Specifies a fixed value.
        :param pulumi.Input[int] percentage: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @fixed.setter
    def fixed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed", value)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percentage", value)


