# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['LiteSubscription']


class LiteSubscription(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_config: Optional[pulumi.Input[pulumi.InputType['LiteSubscriptionDeliveryConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A named resource representing the stream of messages from a single,
        specific topic, to be delivered to the subscribing application.

        To get more information about Subscription, see:

        * [API documentation](https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.subscriptions)
        * How-to Guides
            * [Managing Subscriptions](https://cloud.google.com/pubsub/docs/admin#managing_subscriptions)

        ## Example Usage
        ### Pubsub Lite Subscription Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_lite_topic = gcp.pubsub.LiteTopic("exampleLiteTopic",
            project=project.number,
            partition_config=gcp.pubsub.LiteTopicPartitionConfigArgs(
                count=1,
                capacity=gcp.pubsub.LiteTopicPartitionConfigCapacityArgs(
                    publish_mib_per_sec=4,
                    subscribe_mib_per_sec=8,
                ),
            ),
            retention_config=gcp.pubsub.LiteTopicRetentionConfigArgs(
                per_partition_bytes="32212254720",
            ))
        example_lite_subscription = gcp.pubsub.LiteSubscription("exampleLiteSubscription",
            topic=example_lite_topic.name,
            delivery_config=gcp.pubsub.LiteSubscriptionDeliveryConfigArgs(
                delivery_requirement="DELIVER_AFTER_STORED",
            ))
        ```

        ## Import

        Subscription can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:pubsub/liteSubscription:LiteSubscription default projects/{{project}}/locations/{{zone}}/subscriptions/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteSubscription:LiteSubscription default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteSubscription:LiteSubscription default {{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteSubscription:LiteSubscription default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LiteSubscriptionDeliveryConfigArgs']] delivery_config: The settings for this subscription's message delivery.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the subscription.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the pubsub lite topic.
        :param pulumi.Input[str] topic: A reference to a Topic resource.
        :param pulumi.Input[str] zone: The zone of the pubsub lite topic.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['delivery_config'] = delivery_config
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__['topic'] = topic
            __props__['zone'] = zone
        super(LiteSubscription, __self__).__init__(
            'gcp:pubsub/liteSubscription:LiteSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delivery_config: Optional[pulumi.Input[pulumi.InputType['LiteSubscriptionDeliveryConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            topic: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'LiteSubscription':
        """
        Get an existing LiteSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LiteSubscriptionDeliveryConfigArgs']] delivery_config: The settings for this subscription's message delivery.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the subscription.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the pubsub lite topic.
        :param pulumi.Input[str] topic: A reference to a Topic resource.
        :param pulumi.Input[str] zone: The zone of the pubsub lite topic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["delivery_config"] = delivery_config
        __props__["name"] = name
        __props__["project"] = project
        __props__["region"] = region
        __props__["topic"] = topic
        __props__["zone"] = zone
        return LiteSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deliveryConfig")
    def delivery_config(self) -> pulumi.Output[Optional['outputs.LiteSubscriptionDeliveryConfig']]:
        """
        The settings for this subscription's message delivery.
        Structure is documented below.
        """
        return pulumi.get(self, "delivery_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of the pubsub lite topic.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Output[str]:
        """
        A reference to a Topic resource.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[str]]:
        """
        The zone of the pubsub lite topic.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

