"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const application_1 = require("@jupyterlab/application");
const apputils_1 = require("@jupyterlab/apputils");
const coreutils_1 = require("@jupyterlab/coreutils");
const docmanager_1 = require("@jupyterlab/docmanager");
const filebrowser_1 = require("@jupyterlab/filebrowser");
const launcher_1 = require("@jupyterlab/launcher");
const mainmenu_1 = require("@jupyterlab/mainmenu");
const notebook_1 = require("@jupyterlab/notebook");
const requests_helper_1 = require("requests-helper");
require("../style/index.css");
const extension = {
    activate,
    autoStart: true,
    id: "jupyterlab_commands",
    optional: [launcher_1.ILauncher],
    requires: [docmanager_1.IDocumentManager, apputils_1.ICommandPalette, application_1.ILayoutRestorer, mainmenu_1.IMainMenu, filebrowser_1.IFileBrowserFactory, notebook_1.INotebookTracker],
};
function activate(app, docManager, palette, restorer, menu, browser, tracker, launcher) {
    function hasWidget() {
        return tracker.currentWidget !== null;
    }
    const exportPdf = "jupyterlab_commands:export-pdf";
    const exportHtml = "jupyterlab_commands:export-html";
    const services = app.serviceManager;
    function getCurrent(args) {
        const widget = tracker.currentWidget;
        const activateArg = args.activate !== false;
        if (activateArg && widget) {
            app.shell.activateById(widget.id);
        }
        return widget;
    }
    // grab templates from serverextension
    requests_helper_1.request("get", coreutils_1.PageConfig.getBaseUrl() + "commands/get").then((res) => {
        if (res.ok) {
            const commands = res.json();
            for (const command of commands) {
                app.commands.addCommand(command, {
                    execute: (args) => {
                        apputils_1.showDialog({
                            buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton({ label: "Ok" })],
                            title: "Execute " + command + "?",
                        }).then((result) => {
                            if (result.button.label === "Cancel") {
                                return;
                            }
                            const folder = browser.defaultBrowser.model.path || "";
                            // const widget = app.shell.currentWidget;
                            const context = docManager.contextForWidget(app.shell.currentWidget);
                            let path = "";
                            let model = {};
                            if (context) {
                                path = context.path;
                                model = context.model.toJSON();
                            }
                            return new Promise((resolve) => {
                                requests_helper_1.request("post", coreutils_1.PageConfig.getBaseUrl() + "commands/run?command=" + encodeURI(command), {}, JSON.stringify({ folder, path, model })).then(
                                // tslint:disable-next-line: no-shadowed-variable
                                (res) => {
                                    if (res.ok) {
                                        const resp = res.json();
                                        let body = "";
                                        if (resp) {
                                            body = resp.body;
                                        }
                                        apputils_1.showDialog({
                                            body,
                                            buttons: [apputils_1.Dialog.okButton({ label: "Ok" })],
                                            title: "Execute " + command + " succeeded",
                                        }).then(() => { resolve(); });
                                    }
                                    else {
                                        apputils_1.showDialog({
                                            buttons: [apputils_1.Dialog.okButton({ label: "Ok" })],
                                            title: "Execute " + command + " failed",
                                        }).then(() => { resolve(); });
                                    }
                                });
                            });
                        });
                    },
                    isEnabled: () => true,
                    label: command,
                });
                palette.addItem({ command, category: "Custom Commands" });
            }
        }
    });
    app.commands.addCommand(exportPdf, {
        execute: (args) => {
            const current = getCurrent(args);
            if (!current) {
                return;
            }
            const notebookPath = coreutils_1.URLExt.encodeParts(current.context.path);
            const url = coreutils_1.URLExt.join(services.serverSettings.baseUrl, "nbconvert", "pdf_hidecode", notebookPath) + "?download=true";
            const child = window.open("", "_blank");
            const { context } = current;
            if (context.model.dirty && !context.model.readOnly) {
                return context.save().then(() => { child.location.assign(url); });
            }
            return new Promise((resolve) => {
                child.location.assign(url);
                resolve(undefined);
            });
        },
        isEnabled: hasWidget,
        label: "PDF - no code",
    });
    app.commands.addCommand(exportHtml, {
        execute: (args) => {
            const current = getCurrent(args);
            if (!current) {
                return;
            }
            const notebookPath = coreutils_1.URLExt.encodeParts(current.context.path);
            const url = coreutils_1.URLExt.join(services.serverSettings.baseUrl, "nbconvert", "html_hidecode", notebookPath) + "?download=true";
            const child = window.open("", "_blank");
            const { context } = current;
            if (context.model.dirty && !context.model.readOnly) {
                return context.save().then(() => { child.location.assign(url); });
            }
            return new Promise((resolve) => {
                child.location.assign(url);
                resolve(undefined);
            });
        },
        isEnabled: hasWidget,
        label: "HTML - no code",
    });
    // Add the command to the palette.
    palette.addItem({ command: exportPdf, category: "Custom Commands" });
    palette.addItem({ command: exportHtml, category: "Custom Commands" });
    // tslint:disable-next-line: no-console
    console.log("JupyterLab extension jupyterlab_commands is activated!");
}
exports._activate = activate;
exports.default = extension;
