# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, cpln_id=None, description=None, digest=None, id=None, manifests=None, name=None, repository=None, self_link=None, tag=None, tags=None):
        if cpln_id and not isinstance(cpln_id, str):
            raise TypeError("Expected argument 'cpln_id' to be a str")
        pulumi.set(__self__, "cpln_id", cpln_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if digest and not isinstance(digest, str):
            raise TypeError("Expected argument 'digest' to be a str")
        pulumi.set(__self__, "digest", digest)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if manifests and not isinstance(manifests, list):
            raise TypeError("Expected argument 'manifests' to be a list")
        pulumi.set(__self__, "manifests", manifests)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def manifests(self) -> Sequence['outputs.GetImageManifestResult']:
        return pulumi.get(self, "manifests")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tag(self) -> builtins.str:
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            cpln_id=self.cpln_id,
            description=self.description,
            digest=self.digest,
            id=self.id,
            manifests=self.manifests,
            name=self.name,
            repository=self.repository,
            self_link=self.self_link,
            tag=self.tag,
            tags=self.tags)


def get_image(name: Optional[builtins.str] = None,
              tags: Optional[Mapping[str, builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Use this data source to access information about an [Image](https://docs.controlplane.com/reference/image) within Control Plane.

    ## Required

    - **name** (String) Name of the image. If the tag of the image is not specified, the latest image will be fetched for this data source.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the Image.
    - **name** (String) Name of the Image.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **tag** (String) Tag of the image.
    - **repository** (String) Respository name of the image.
    - **digest** (String) A unique SHA256 hash used to identify a specific image version within the image registry.
    - **manifest** (Block List, Max: 1) (see below)

    <a id="nestedblock--manifest"></a>

    ### `manifest`

     The manifest provides configuration and layers information about the image. It plays a crucial role in the Docker image distribution system, enabling image creation, verification, and replication in a consistent and secure manner.

    - **config** (Block List, Max: 1) (see below).
    - **layers** (Block List) (see below).
    - **media_type** (String) Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
    - **schema_version** (Number) The version of the Docker Image Manifest format.

    <a id="nestedblock--config--layers"></a>

    ### `config` and `layers`

    The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.

    Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.

    - **size** (Number) The size of the image or layer in bytes. This helps in estimating the space required and the download time.
    - **digest** (String) A unique SHA256 hash used to identify a specific image version within the image registry.
    - **media_type** (String) Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    # Get latest image
    image_name_only = cpln.get_image(name="IMAGE_NAME")
    # Get Specific image
    image_name_with_tag = cpln.get_image(name="IMAGE_NAME:TAG")
    pulumi.export("latestImage", image_name_only)
    pulumi.export("specificImage", image_name_with_tag)
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cpln:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        cpln_id=pulumi.get(__ret__, 'cpln_id'),
        description=pulumi.get(__ret__, 'description'),
        digest=pulumi.get(__ret__, 'digest'),
        id=pulumi.get(__ret__, 'id'),
        manifests=pulumi.get(__ret__, 'manifests'),
        name=pulumi.get(__ret__, 'name'),
        repository=pulumi.get(__ret__, 'repository'),
        self_link=pulumi.get(__ret__, 'self_link'),
        tag=pulumi.get(__ret__, 'tag'),
        tags=pulumi.get(__ret__, 'tags'))
def get_image_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Use this data source to access information about an [Image](https://docs.controlplane.com/reference/image) within Control Plane.

    ## Required

    - **name** (String) Name of the image. If the tag of the image is not specified, the latest image will be fetched for this data source.

    ## Outputs

    The following attributes are exported:

    - **cpln_id** (String) The ID, in GUID format, of the Image.
    - **name** (String) Name of the Image.
    - **tags** (Map of String) Key-value map of resource tags.
    - **self_link** (String) Full link to this resource. Can be referenced by other resources.
    - **tag** (String) Tag of the image.
    - **repository** (String) Respository name of the image.
    - **digest** (String) A unique SHA256 hash used to identify a specific image version within the image registry.
    - **manifest** (Block List, Max: 1) (see below)

    <a id="nestedblock--manifest"></a>

    ### `manifest`

     The manifest provides configuration and layers information about the image. It plays a crucial role in the Docker image distribution system, enabling image creation, verification, and replication in a consistent and secure manner.

    - **config** (Block List, Max: 1) (see below).
    - **layers** (Block List) (see below).
    - **media_type** (String) Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
    - **schema_version** (Number) The version of the Docker Image Manifest format.

    <a id="nestedblock--config--layers"></a>

    ### `config` and `layers`

    The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.

    Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.

    - **size** (Number) The size of the image or layer in bytes. This helps in estimating the space required and the download time.
    - **digest** (String) A unique SHA256 hash used to identify a specific image version within the image registry.
    - **media_type** (String) Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cpln as cpln

    # Get latest image
    image_name_only = cpln.get_image(name="IMAGE_NAME")
    # Get Specific image
    image_name_with_tag = cpln.get_image(name="IMAGE_NAME:TAG")
    pulumi.export("latestImage", image_name_only)
    pulumi.export("specificImage", image_name_with_tag)
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cpln:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        cpln_id=pulumi.get(__response__, 'cpln_id'),
        description=pulumi.get(__response__, 'description'),
        digest=pulumi.get(__response__, 'digest'),
        id=pulumi.get(__response__, 'id'),
        manifests=pulumi.get(__response__, 'manifests'),
        name=pulumi.get(__response__, 'name'),
        repository=pulumi.get(__response__, 'repository'),
        self_link=pulumi.get(__response__, 'self_link'),
        tag=pulumi.get(__response__, 'tag'),
        tags=pulumi.get(__response__, 'tags')))
