# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpSetArgs', 'IpSet']

@pulumi.input_type
class IpSetArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 link: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a IpSet resource.
        :param pulumi.Input[builtins.str] description: Description of the IP Set.
        :param pulumi.Input[builtins.str] link: The self link of a workload or a GVC.
        :param pulumi.Input[builtins.str] name: Name of the IP Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the IP Set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The self link of a workload or a GVC.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]]:
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the IP Set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IpSetState:
    def __init__(__self__, *,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 link: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetStatusArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IpSet resources.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the IP Set.
        :param pulumi.Input[builtins.str] description: Description of the IP Set.
        :param pulumi.Input[builtins.str] link: The self link of a workload or a GVC.
        :param pulumi.Input[builtins.str] name: Name of the IP Set.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Sequence[pulumi.Input['IpSetStatusArgs']]] statuses: The status of the IP Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the IP Set.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the IP Set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The self link of a workload or a GVC.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]]:
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the IP Set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSetStatusArgs']]]]:
        """
        The status of the IP Set.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSetStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/ipSet:IpSet")
class IpSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 link: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSetLocationArgs', 'IpSetLocationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an org's IpSet.

        ## Declaration

        ### Required

        - **name** (String) Name of the IpSet.

        ### Optional

        - **description** - (String) Description of the IpSet.
        - **tags** (Map of String) Key-value map of resource tags.
        - **link** (String) The self link of a workload or a GVC.
        - **location** (Block List) (see below).

        <a id="nestedblock--location"></a>

        ### `location`

        Required:

        - **name** (String) The self link of a location.
        - **retention_policy** (String) Exactly one of: `keep` and `free`.

        ## Outputs

        The following attributes are exported:

        - **cpln_id** (String) The ID, in GUID format, of the IpSet.
        - **self_link** (String) Full link to this resource. Can be referenced by other resources.
        - **status** (Block List, Max: 1) (see below).

        <a id="nestedblock--status"></a>

        ### `status`

        Status of the IpSet.

        Read-Only:

        - **ip_address** (Block List) (see below)
        - **error** (String)
        - **warning** (String)

        <a id="nestedblock--status--ip_address"></a>

        ### `status.ip_address`

        - **name** (String)
        - **ip** (String)
        - **id** (String)
        - **state** (String)
        - **created** (String)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the IP Set.
        :param pulumi.Input[builtins.str] link: The self link of a workload or a GVC.
        :param pulumi.Input[builtins.str] name: Name of the IP Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IpSetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an org's IpSet.

        ## Declaration

        ### Required

        - **name** (String) Name of the IpSet.

        ### Optional

        - **description** - (String) Description of the IpSet.
        - **tags** (Map of String) Key-value map of resource tags.
        - **link** (String) The self link of a workload or a GVC.
        - **location** (Block List) (see below).

        <a id="nestedblock--location"></a>

        ### `location`

        Required:

        - **name** (String) The self link of a location.
        - **retention_policy** (String) Exactly one of: `keep` and `free`.

        ## Outputs

        The following attributes are exported:

        - **cpln_id** (String) The ID, in GUID format, of the IpSet.
        - **self_link** (String) Full link to this resource. Can be referenced by other resources.
        - **status** (Block List, Max: 1) (see below).

        <a id="nestedblock--status"></a>

        ### `status`

        Status of the IpSet.

        Read-Only:

        - **ip_address** (Block List) (see below)
        - **error** (String)
        - **warning** (String)

        <a id="nestedblock--status--ip_address"></a>

        ### `status.ip_address`

        - **name** (String)
        - **ip** (String)
        - **id** (String)
        - **state** (String)
        - **created** (String)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param IpSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 link: Optional[pulumi.Input[builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSetLocationArgs', 'IpSetLocationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpSetArgs.__new__(IpSetArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["link"] = link
            __props__.__dict__["locations"] = locations
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
        super(IpSet, __self__).__init__(
            'cpln:index/ipSet:IpSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            link: Optional[pulumi.Input[builtins.str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSetLocationArgs', 'IpSetLocationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSetStatusArgs', 'IpSetStatusArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'IpSet':
        """
        Get an existing IpSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the IP Set.
        :param pulumi.Input[builtins.str] description: Description of the IP Set.
        :param pulumi.Input[builtins.str] link: The self link of a workload or a GVC.
        :param pulumi.Input[builtins.str] name: Name of the IP Set.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpSetStatusArgs', 'IpSetStatusArgsDict']]]] statuses: The status of the IP Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpSetState.__new__(_IpSetState)

        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["link"] = link
        __props__.__dict__["locations"] = locations
        __props__.__dict__["name"] = name
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["tags"] = tags
        return IpSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the IP Set.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the IP Set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def link(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The self link of a workload or a GVC.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence['outputs.IpSetLocation']]]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the IP Set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.IpSetStatus']]:
        """
        The status of the IP Set.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

