# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrgLoggingArgs', 'OrgLogging']

@pulumi.input_type
class OrgLoggingArgs:
    def __init__(__self__, *,
                 cloud_watch_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]] = None,
                 coralogix_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]] = None,
                 datadog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]] = None,
                 elastic_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]] = None,
                 fluentd_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]] = None,
                 logzio_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]] = None,
                 s3_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]] = None,
                 stackdriver_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]] = None,
                 syslog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]] = None):
        """
        The set of arguments for constructing a OrgLogging resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]] coralogix_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]] datadog_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]] elastic_loggings: For logging and analyzing data within an org using Elastic Logging.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]] logzio_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]] s3_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        """
        if cloud_watch_loggings is not None:
            pulumi.set(__self__, "cloud_watch_loggings", cloud_watch_loggings)
        if coralogix_loggings is not None:
            pulumi.set(__self__, "coralogix_loggings", coralogix_loggings)
        if datadog_loggings is not None:
            pulumi.set(__self__, "datadog_loggings", datadog_loggings)
        if elastic_loggings is not None:
            pulumi.set(__self__, "elastic_loggings", elastic_loggings)
        if fluentd_loggings is not None:
            pulumi.set(__self__, "fluentd_loggings", fluentd_loggings)
        if logzio_loggings is not None:
            pulumi.set(__self__, "logzio_loggings", logzio_loggings)
        if s3_loggings is not None:
            pulumi.set(__self__, "s3_loggings", s3_loggings)
        if stackdriver_loggings is not None:
            pulumi.set(__self__, "stackdriver_loggings", stackdriver_loggings)
        if syslog_loggings is not None:
            pulumi.set(__self__, "syslog_loggings", syslog_loggings)

    @property
    @pulumi.getter(name="cloudWatchLoggings")
    def cloud_watch_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]]:
        return pulumi.get(self, "cloud_watch_loggings")

    @cloud_watch_loggings.setter
    def cloud_watch_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]]):
        pulumi.set(self, "cloud_watch_loggings", value)

    @property
    @pulumi.getter(name="coralogixLoggings")
    def coralogix_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        """
        return pulumi.get(self, "coralogix_loggings")

    @coralogix_loggings.setter
    def coralogix_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]]):
        pulumi.set(self, "coralogix_loggings", value)

    @property
    @pulumi.getter(name="datadogLoggings")
    def datadog_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        """
        return pulumi.get(self, "datadog_loggings")

    @datadog_loggings.setter
    def datadog_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]]):
        pulumi.set(self, "datadog_loggings", value)

    @property
    @pulumi.getter(name="elasticLoggings")
    def elastic_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]]:
        """
        For logging and analyzing data within an org using Elastic Logging.
        """
        return pulumi.get(self, "elastic_loggings")

    @elastic_loggings.setter
    def elastic_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]]):
        pulumi.set(self, "elastic_loggings", value)

    @property
    @pulumi.getter(name="fluentdLoggings")
    def fluentd_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]]:
        return pulumi.get(self, "fluentd_loggings")

    @fluentd_loggings.setter
    def fluentd_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]]):
        pulumi.set(self, "fluentd_loggings", value)

    @property
    @pulumi.getter(name="logzioLoggings")
    def logzio_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        """
        return pulumi.get(self, "logzio_loggings")

    @logzio_loggings.setter
    def logzio_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]]):
        pulumi.set(self, "logzio_loggings", value)

    @property
    @pulumi.getter(name="s3Loggings")
    def s3_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        """
        return pulumi.get(self, "s3_loggings")

    @s3_loggings.setter
    def s3_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]]):
        pulumi.set(self, "s3_loggings", value)

    @property
    @pulumi.getter(name="stackdriverLoggings")
    def stackdriver_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]]:
        return pulumi.get(self, "stackdriver_loggings")

    @stackdriver_loggings.setter
    def stackdriver_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]]):
        pulumi.set(self, "stackdriver_loggings", value)

    @property
    @pulumi.getter(name="syslogLoggings")
    def syslog_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]]:
        return pulumi.get(self, "syslog_loggings")

    @syslog_loggings.setter
    def syslog_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]]):
        pulumi.set(self, "syslog_loggings", value)


@pulumi.input_type
class _OrgLoggingState:
    def __init__(__self__, *,
                 cloud_watch_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]] = None,
                 coralogix_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 datadog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 elastic_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]] = None,
                 fluentd_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]] = None,
                 logzio_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 s3_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 stackdriver_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]] = None,
                 syslog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OrgLogging resources.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]] coralogix_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Org.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]] datadog_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        :param pulumi.Input[builtins.str] description: Description of the Org.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]] elastic_loggings: For logging and analyzing data within an org using Elastic Logging.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]] logzio_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        :param pulumi.Input[builtins.str] name: Name of the Org.
        :param pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]] s3_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if cloud_watch_loggings is not None:
            pulumi.set(__self__, "cloud_watch_loggings", cloud_watch_loggings)
        if coralogix_loggings is not None:
            pulumi.set(__self__, "coralogix_loggings", coralogix_loggings)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if datadog_loggings is not None:
            pulumi.set(__self__, "datadog_loggings", datadog_loggings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elastic_loggings is not None:
            pulumi.set(__self__, "elastic_loggings", elastic_loggings)
        if fluentd_loggings is not None:
            pulumi.set(__self__, "fluentd_loggings", fluentd_loggings)
        if logzio_loggings is not None:
            pulumi.set(__self__, "logzio_loggings", logzio_loggings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if s3_loggings is not None:
            pulumi.set(__self__, "s3_loggings", s3_loggings)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if stackdriver_loggings is not None:
            pulumi.set(__self__, "stackdriver_loggings", stackdriver_loggings)
        if syslog_loggings is not None:
            pulumi.set(__self__, "syslog_loggings", syslog_loggings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cloudWatchLoggings")
    def cloud_watch_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]]:
        return pulumi.get(self, "cloud_watch_loggings")

    @cloud_watch_loggings.setter
    def cloud_watch_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCloudWatchLoggingArgs']]]]):
        pulumi.set(self, "cloud_watch_loggings", value)

    @property
    @pulumi.getter(name="coralogixLoggings")
    def coralogix_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        """
        return pulumi.get(self, "coralogix_loggings")

    @coralogix_loggings.setter
    def coralogix_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingCoralogixLoggingArgs']]]]):
        pulumi.set(self, "coralogix_loggings", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the Org.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter(name="datadogLoggings")
    def datadog_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        """
        return pulumi.get(self, "datadog_loggings")

    @datadog_loggings.setter
    def datadog_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingDatadogLoggingArgs']]]]):
        pulumi.set(self, "datadog_loggings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Org.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticLoggings")
    def elastic_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]]:
        """
        For logging and analyzing data within an org using Elastic Logging.
        """
        return pulumi.get(self, "elastic_loggings")

    @elastic_loggings.setter
    def elastic_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingElasticLoggingArgs']]]]):
        pulumi.set(self, "elastic_loggings", value)

    @property
    @pulumi.getter(name="fluentdLoggings")
    def fluentd_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]]:
        return pulumi.get(self, "fluentd_loggings")

    @fluentd_loggings.setter
    def fluentd_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingFluentdLoggingArgs']]]]):
        pulumi.set(self, "fluentd_loggings", value)

    @property
    @pulumi.getter(name="logzioLoggings")
    def logzio_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        """
        return pulumi.get(self, "logzio_loggings")

    @logzio_loggings.setter
    def logzio_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingLogzioLoggingArgs']]]]):
        pulumi.set(self, "logzio_loggings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Org.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="s3Loggings")
    def s3_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        """
        return pulumi.get(self, "s3_loggings")

    @s3_loggings.setter
    def s3_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingS3LoggingArgs']]]]):
        pulumi.set(self, "s3_loggings", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="stackdriverLoggings")
    def stackdriver_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]]:
        return pulumi.get(self, "stackdriver_loggings")

    @stackdriver_loggings.setter
    def stackdriver_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingStackdriverLoggingArgs']]]]):
        pulumi.set(self, "stackdriver_loggings", value)

    @property
    @pulumi.getter(name="syslogLoggings")
    def syslog_loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]]:
        return pulumi.get(self, "syslog_loggings")

    @syslog_loggings.setter
    def syslog_loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrgLoggingSyslogLoggingArgs']]]]):
        pulumi.set(self, "syslog_loggings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/orgLogging:OrgLogging")
class OrgLogging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCloudWatchLoggingArgs', 'OrgLoggingCloudWatchLoggingArgsDict']]]]] = None,
                 coralogix_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCoralogixLoggingArgs', 'OrgLoggingCoralogixLoggingArgsDict']]]]] = None,
                 datadog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingDatadogLoggingArgs', 'OrgLoggingDatadogLoggingArgsDict']]]]] = None,
                 elastic_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingElasticLoggingArgs', 'OrgLoggingElasticLoggingArgsDict']]]]] = None,
                 fluentd_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingFluentdLoggingArgs', 'OrgLoggingFluentdLoggingArgsDict']]]]] = None,
                 logzio_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingLogzioLoggingArgs', 'OrgLoggingLogzioLoggingArgsDict']]]]] = None,
                 s3_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingS3LoggingArgs', 'OrgLoggingS3LoggingArgsDict']]]]] = None,
                 stackdriver_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingStackdriverLoggingArgs', 'OrgLoggingStackdriverLoggingArgsDict']]]]] = None,
                 syslog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingSyslogLoggingArgs', 'OrgLoggingSyslogLoggingArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a OrgLogging resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCoralogixLoggingArgs', 'OrgLoggingCoralogixLoggingArgsDict']]]] coralogix_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingDatadogLoggingArgs', 'OrgLoggingDatadogLoggingArgsDict']]]] datadog_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingElasticLoggingArgs', 'OrgLoggingElasticLoggingArgsDict']]]] elastic_loggings: For logging and analyzing data within an org using Elastic Logging.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingLogzioLoggingArgs', 'OrgLoggingLogzioLoggingArgsDict']]]] logzio_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingS3LoggingArgs', 'OrgLoggingS3LoggingArgsDict']]]] s3_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrgLoggingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OrgLogging resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OrgLoggingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrgLoggingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCloudWatchLoggingArgs', 'OrgLoggingCloudWatchLoggingArgsDict']]]]] = None,
                 coralogix_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCoralogixLoggingArgs', 'OrgLoggingCoralogixLoggingArgsDict']]]]] = None,
                 datadog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingDatadogLoggingArgs', 'OrgLoggingDatadogLoggingArgsDict']]]]] = None,
                 elastic_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingElasticLoggingArgs', 'OrgLoggingElasticLoggingArgsDict']]]]] = None,
                 fluentd_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingFluentdLoggingArgs', 'OrgLoggingFluentdLoggingArgsDict']]]]] = None,
                 logzio_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingLogzioLoggingArgs', 'OrgLoggingLogzioLoggingArgsDict']]]]] = None,
                 s3_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingS3LoggingArgs', 'OrgLoggingS3LoggingArgsDict']]]]] = None,
                 stackdriver_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingStackdriverLoggingArgs', 'OrgLoggingStackdriverLoggingArgsDict']]]]] = None,
                 syslog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingSyslogLoggingArgs', 'OrgLoggingSyslogLoggingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrgLoggingArgs.__new__(OrgLoggingArgs)

            __props__.__dict__["cloud_watch_loggings"] = cloud_watch_loggings
            __props__.__dict__["coralogix_loggings"] = coralogix_loggings
            __props__.__dict__["datadog_loggings"] = datadog_loggings
            __props__.__dict__["elastic_loggings"] = elastic_loggings
            __props__.__dict__["fluentd_loggings"] = fluentd_loggings
            __props__.__dict__["logzio_loggings"] = logzio_loggings
            __props__.__dict__["s3_loggings"] = s3_loggings
            __props__.__dict__["stackdriver_loggings"] = stackdriver_loggings
            __props__.__dict__["syslog_loggings"] = syslog_loggings
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["tags"] = None
        super(OrgLogging, __self__).__init__(
            'cpln:index/orgLogging:OrgLogging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_watch_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCloudWatchLoggingArgs', 'OrgLoggingCloudWatchLoggingArgsDict']]]]] = None,
            coralogix_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCoralogixLoggingArgs', 'OrgLoggingCoralogixLoggingArgsDict']]]]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            datadog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingDatadogLoggingArgs', 'OrgLoggingDatadogLoggingArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            elastic_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingElasticLoggingArgs', 'OrgLoggingElasticLoggingArgsDict']]]]] = None,
            fluentd_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingFluentdLoggingArgs', 'OrgLoggingFluentdLoggingArgsDict']]]]] = None,
            logzio_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingLogzioLoggingArgs', 'OrgLoggingLogzioLoggingArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            s3_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingS3LoggingArgs', 'OrgLoggingS3LoggingArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            stackdriver_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingStackdriverLoggingArgs', 'OrgLoggingStackdriverLoggingArgsDict']]]]] = None,
            syslog_loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingSyslogLoggingArgs', 'OrgLoggingSyslogLoggingArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'OrgLogging':
        """
        Get an existing OrgLogging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingCoralogixLoggingArgs', 'OrgLoggingCoralogixLoggingArgsDict']]]] coralogix_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Org.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingDatadogLoggingArgs', 'OrgLoggingDatadogLoggingArgsDict']]]] datadog_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        :param pulumi.Input[builtins.str] description: Description of the Org.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingElasticLoggingArgs', 'OrgLoggingElasticLoggingArgsDict']]]] elastic_loggings: For logging and analyzing data within an org using Elastic Logging.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingLogzioLoggingArgs', 'OrgLoggingLogzioLoggingArgsDict']]]] logzio_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        :param pulumi.Input[builtins.str] name: Name of the Org.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrgLoggingS3LoggingArgs', 'OrgLoggingS3LoggingArgsDict']]]] s3_loggings: [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrgLoggingState.__new__(_OrgLoggingState)

        __props__.__dict__["cloud_watch_loggings"] = cloud_watch_loggings
        __props__.__dict__["coralogix_loggings"] = coralogix_loggings
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["datadog_loggings"] = datadog_loggings
        __props__.__dict__["description"] = description
        __props__.__dict__["elastic_loggings"] = elastic_loggings
        __props__.__dict__["fluentd_loggings"] = fluentd_loggings
        __props__.__dict__["logzio_loggings"] = logzio_loggings
        __props__.__dict__["name"] = name
        __props__.__dict__["s3_loggings"] = s3_loggings
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["stackdriver_loggings"] = stackdriver_loggings
        __props__.__dict__["syslog_loggings"] = syslog_loggings
        __props__.__dict__["tags"] = tags
        return OrgLogging(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudWatchLoggings")
    def cloud_watch_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingCloudWatchLogging']]]:
        return pulumi.get(self, "cloud_watch_loggings")

    @property
    @pulumi.getter(name="coralogixLoggings")
    def coralogix_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingCoralogixLogging']]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/coralogix)
        """
        return pulumi.get(self, "coralogix_loggings")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the Org.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter(name="datadogLoggings")
    def datadog_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingDatadogLogging']]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/datadog)
        """
        return pulumi.get(self, "datadog_loggings")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the Org.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="elasticLoggings")
    def elastic_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingElasticLogging']]]:
        """
        For logging and analyzing data within an org using Elastic Logging.
        """
        return pulumi.get(self, "elastic_loggings")

    @property
    @pulumi.getter(name="fluentdLoggings")
    def fluentd_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingFluentdLogging']]]:
        return pulumi.get(self, "fluentd_loggings")

    @property
    @pulumi.getter(name="logzioLoggings")
    def logzio_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingLogzioLogging']]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/logz-io)
        """
        return pulumi.get(self, "logzio_loggings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Org.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="s3Loggings")
    def s3_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingS3Logging']]]:
        """
        [Documentation Reference](https://docs.controlplane.com/external-logging/s3)
        """
        return pulumi.get(self, "s3_loggings")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="stackdriverLoggings")
    def stackdriver_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingStackdriverLogging']]]:
        return pulumi.get(self, "stackdriver_loggings")

    @property
    @pulumi.getter(name="syslogLoggings")
    def syslog_loggings(self) -> pulumi.Output[Optional[Sequence['outputs.OrgLoggingSyslogLogging']]]:
        return pulumi.get(self, "syslog_loggings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

