# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 target_kind: pulumi.Input[builtins.str],
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 target_links: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_query: Optional[pulumi.Input['PolicyTargetQueryArgs']] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[builtins.str] target_kind: The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        :param pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]] bindings: The association between a target kind and the bound permissions to service principals.
        :param pulumi.Input[builtins.str] description: Description of the Policy.
        :param pulumi.Input[builtins.str] gvc: The GVC for `identity`, `workload` and `volumeset` target kinds only.
        :param pulumi.Input[builtins.str] name: Name of the Policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] target: Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
               do not include the attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_links: List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        :param pulumi.Input['PolicyTargetQueryArgs'] target_query: A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        pulumi.set(__self__, "target_kind", target_kind)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gvc is not None:
            pulumi.set(__self__, "gvc", gvc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_links is not None:
            pulumi.set(__self__, "target_links", target_links)
        if target_query is not None:
            pulumi.set(__self__, "target_query", target_query)

    @property
    @pulumi.getter(name="targetKind")
    def target_kind(self) -> pulumi.Input[builtins.str]:
        """
        The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        """
        return pulumi.get(self, "target_kind")

    @target_kind.setter
    def target_kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_kind", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]]:
        """
        The association between a target kind and the bound permissions to service principals.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GVC for `identity`, `workload` and `volumeset` target kinds only.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
        do not include the attribute.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetLinks")
    def target_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        """
        return pulumi.get(self, "target_links")

    @target_links.setter
    def target_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_links", value)

    @property
    @pulumi.getter(name="targetQuery")
    def target_query(self) -> Optional[pulumi.Input['PolicyTargetQueryArgs']]:
        """
        A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        return pulumi.get(self, "target_query")

    @target_query.setter
    def target_query(self, value: Optional[pulumi.Input['PolicyTargetQueryArgs']]):
        pulumi.set(self, "target_query", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 target_kind: Optional[pulumi.Input[builtins.str]] = None,
                 target_links: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_query: Optional[pulumi.Input['PolicyTargetQueryArgs']] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]] bindings: The association between a target kind and the bound permissions to service principals.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Policy.
        :param pulumi.Input[builtins.str] description: Description of the Policy.
        :param pulumi.Input[builtins.str] gvc: The GVC for `identity`, `workload` and `volumeset` target kinds only.
        :param pulumi.Input[builtins.str] name: Name of the Policy.
        :param pulumi.Input[builtins.str] origin: Origin of the Policy. Either `builtin` or `default`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] target: Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
               do not include the attribute.
        :param pulumi.Input[builtins.str] target_kind: The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_links: List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        :param pulumi.Input['PolicyTargetQueryArgs'] target_query: A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gvc is not None:
            pulumi.set(__self__, "gvc", gvc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_kind is not None:
            pulumi.set(__self__, "target_kind", target_kind)
        if target_links is not None:
            pulumi.set(__self__, "target_links", target_links)
        if target_query is not None:
            pulumi.set(__self__, "target_query", target_query)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]]:
        """
        The association between a target kind and the bound permissions to service principals.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the Policy.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GVC for `identity`, `workload` and `volumeset` target kinds only.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Origin of the Policy. Either `builtin` or `default`.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
        do not include the attribute.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetKind")
    def target_kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        """
        return pulumi.get(self, "target_kind")

    @target_kind.setter
    def target_kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_kind", value)

    @property
    @pulumi.getter(name="targetLinks")
    def target_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        """
        return pulumi.get(self, "target_links")

    @target_links.setter
    def target_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_links", value)

    @property
    @pulumi.getter(name="targetQuery")
    def target_query(self) -> Optional[pulumi.Input['PolicyTargetQueryArgs']]:
        """
        A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        return pulumi.get(self, "target_query")

    @target_query.setter
    def target_query(self, value: Optional[pulumi.Input['PolicyTargetQueryArgs']]):
        pulumi.set(self, "target_query", value)


@pulumi.type_token("cpln:index/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyBindingArgs', 'PolicyBindingArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 target_kind: Optional[pulumi.Input[builtins.str]] = None,
                 target_links: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_query: Optional[pulumi.Input[Union['PolicyTargetQueryArgs', 'PolicyTargetQueryArgsDict']]] = None,
                 __props__=None):
        """
        Create a Policy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyBindingArgs', 'PolicyBindingArgsDict']]]] bindings: The association between a target kind and the bound permissions to service principals.
        :param pulumi.Input[builtins.str] description: Description of the Policy.
        :param pulumi.Input[builtins.str] gvc: The GVC for `identity`, `workload` and `volumeset` target kinds only.
        :param pulumi.Input[builtins.str] name: Name of the Policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] target: Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
               do not include the attribute.
        :param pulumi.Input[builtins.str] target_kind: The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_links: List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        :param pulumi.Input[Union['PolicyTargetQueryArgs', 'PolicyTargetQueryArgsDict']] target_query: A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Policy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyBindingArgs', 'PolicyBindingArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 target_kind: Optional[pulumi.Input[builtins.str]] = None,
                 target_links: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_query: Optional[pulumi.Input[Union['PolicyTargetQueryArgs', 'PolicyTargetQueryArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["bindings"] = bindings
            __props__.__dict__["description"] = description
            __props__.__dict__["gvc"] = gvc
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target"] = target
            if target_kind is None and not opts.urn:
                raise TypeError("Missing required property 'target_kind'")
            __props__.__dict__["target_kind"] = target_kind
            __props__.__dict__["target_links"] = target_links
            __props__.__dict__["target_query"] = target_query
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["origin"] = None
            __props__.__dict__["self_link"] = None
        super(Policy, __self__).__init__(
            'cpln:index/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyBindingArgs', 'PolicyBindingArgsDict']]]]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            gvc: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            origin: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target: Optional[pulumi.Input[builtins.str]] = None,
            target_kind: Optional[pulumi.Input[builtins.str]] = None,
            target_links: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_query: Optional[pulumi.Input[Union['PolicyTargetQueryArgs', 'PolicyTargetQueryArgsDict']]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyBindingArgs', 'PolicyBindingArgsDict']]]] bindings: The association between a target kind and the bound permissions to service principals.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Policy.
        :param pulumi.Input[builtins.str] description: Description of the Policy.
        :param pulumi.Input[builtins.str] gvc: The GVC for `identity`, `workload` and `volumeset` target kinds only.
        :param pulumi.Input[builtins.str] name: Name of the Policy.
        :param pulumi.Input[builtins.str] origin: Origin of the Policy. Either `builtin` or `default`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] target: Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
               do not include the attribute.
        :param pulumi.Input[builtins.str] target_kind: The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_links: List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        :param pulumi.Input[Union['PolicyTargetQueryArgs', 'PolicyTargetQueryArgsDict']] target_query: A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["bindings"] = bindings
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["gvc"] = gvc
        __props__.__dict__["name"] = name
        __props__.__dict__["origin"] = origin
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target"] = target
        __props__.__dict__["target_kind"] = target_kind
        __props__.__dict__["target_links"] = target_links
        __props__.__dict__["target_query"] = target_query
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bindings(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyBinding']]]:
        """
        The association between a target kind and the bound permissions to service principals.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the Policy.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The GVC for `identity`, `workload` and `volumeset` target kinds only.
        """
        return pulumi.get(self, "gvc")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output[builtins.str]:
        """
        Origin of the Policy. Either `builtin` or `default`.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set this value of this attribute to `all` if this policy should target all objects of the given target_kind. Otherwise,
        do not include the attribute.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="targetKind")
    def target_kind(self) -> pulumi.Output[builtins.str]:
        """
        The kind of resource to target (e.g., gvc, serviceaccount, etc.).
        """
        return pulumi.get(self, "target_kind")

    @property
    @pulumi.getter(name="targetLinks")
    def target_links(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of the targets this policy will be applied to. Not used if `target` is set to `all`.
        """
        return pulumi.get(self, "target_links")

    @property
    @pulumi.getter(name="targetQuery")
    def target_query(self) -> pulumi.Output[Optional['outputs.PolicyTargetQuery']]:
        """
        A defined set of criteria or conditions used to identify the target entities or resources to which the policy applies.
        """
        return pulumi.get(self, "target_query")

