# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['SecretAwsArgs']] = None,
                 azure_connector: Optional[pulumi.Input['SecretAzureConnectorArgs']] = None,
                 azure_sdk: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dictionary: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 docker: Optional[pulumi.Input[builtins.str]] = None,
                 ecr: Optional[pulumi.Input['SecretEcrArgs']] = None,
                 gcp: Optional[pulumi.Input[builtins.str]] = None,
                 keypair: Optional[pulumi.Input['SecretKeypairArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nats_account: Optional[pulumi.Input['SecretNatsAccountArgs']] = None,
                 opaque: Optional[pulumi.Input['SecretOpaqueArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls: Optional[pulumi.Input['SecretTlsArgs']] = None,
                 userpass: Optional[pulumi.Input['SecretUserpassArgs']] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input['SecretAwsArgs'] aws: [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        :param pulumi.Input['SecretAzureConnectorArgs'] azure_connector: [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        :param pulumi.Input[builtins.str] azure_sdk: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        :param pulumi.Input[builtins.str] description: Description of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary: List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        :param pulumi.Input[builtins.str] docker: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        :param pulumi.Input[builtins.str] gcp: JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        :param pulumi.Input['SecretKeypairArgs'] keypair: [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        :param pulumi.Input[builtins.str] name: Name of the secret.
        :param pulumi.Input['SecretNatsAccountArgs'] nats_account: [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        :param pulumi.Input['SecretOpaqueArgs'] opaque: [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input['SecretTlsArgs'] tls: [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        :param pulumi.Input['SecretUserpassArgs'] userpass: [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_connector is not None:
            pulumi.set(__self__, "azure_connector", azure_connector)
        if azure_sdk is not None:
            pulumi.set(__self__, "azure_sdk", azure_sdk)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dictionary is not None:
            pulumi.set(__self__, "dictionary", dictionary)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if keypair is not None:
            pulumi.set(__self__, "keypair", keypair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nats_account is not None:
            pulumi.set(__self__, "nats_account", nats_account)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if userpass is not None:
            pulumi.set(__self__, "userpass", userpass)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['SecretAwsArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['SecretAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> Optional[pulumi.Input['SecretAzureConnectorArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        """
        return pulumi.get(self, "azure_connector")

    @azure_connector.setter
    def azure_connector(self, value: Optional[pulumi.Input['SecretAzureConnectorArgs']]):
        pulumi.set(self, "azure_connector", value)

    @property
    @pulumi.getter(name="azureSdk")
    def azure_sdk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        """
        return pulumi.get(self, "azure_sdk")

    @azure_sdk.setter
    def azure_sdk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_sdk", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dictionary(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        """
        return pulumi.get(self, "dictionary")

    @dictionary.setter
    def dictionary(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dictionary", value)

    @property
    @pulumi.getter
    def docker(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        """
        return pulumi.get(self, "docker")

    @docker.setter
    def docker(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "docker", value)

    @property
    @pulumi.getter
    def ecr(self) -> Optional[pulumi.Input['SecretEcrArgs']]:
        return pulumi.get(self, "ecr")

    @ecr.setter
    def ecr(self, value: Optional[pulumi.Input['SecretEcrArgs']]):
        pulumi.set(self, "ecr", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter
    def keypair(self) -> Optional[pulumi.Input['SecretKeypairArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        """
        return pulumi.get(self, "keypair")

    @keypair.setter
    def keypair(self, value: Optional[pulumi.Input['SecretKeypairArgs']]):
        pulumi.set(self, "keypair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natsAccount")
    def nats_account(self) -> Optional[pulumi.Input['SecretNatsAccountArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        """
        return pulumi.get(self, "nats_account")

    @nats_account.setter
    def nats_account(self, value: Optional[pulumi.Input['SecretNatsAccountArgs']]):
        pulumi.set(self, "nats_account", value)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['SecretOpaqueArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['SecretOpaqueArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['SecretTlsArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['SecretTlsArgs']]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter
    def userpass(self) -> Optional[pulumi.Input['SecretUserpassArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        return pulumi.get(self, "userpass")

    @userpass.setter
    def userpass(self, value: Optional[pulumi.Input['SecretUserpassArgs']]):
        pulumi.set(self, "userpass", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['SecretAwsArgs']] = None,
                 azure_connector: Optional[pulumi.Input['SecretAzureConnectorArgs']] = None,
                 azure_sdk: Optional[pulumi.Input[builtins.str]] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dictionary: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 dictionary_as_envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 docker: Optional[pulumi.Input[builtins.str]] = None,
                 ecr: Optional[pulumi.Input['SecretEcrArgs']] = None,
                 gcp: Optional[pulumi.Input[builtins.str]] = None,
                 keypair: Optional[pulumi.Input['SecretKeypairArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nats_account: Optional[pulumi.Input['SecretNatsAccountArgs']] = None,
                 opaque: Optional[pulumi.Input['SecretOpaqueArgs']] = None,
                 secret_link: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls: Optional[pulumi.Input['SecretTlsArgs']] = None,
                 userpass: Optional[pulumi.Input['SecretUserpassArgs']] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input['SecretAwsArgs'] aws: [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        :param pulumi.Input['SecretAzureConnectorArgs'] azure_connector: [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        :param pulumi.Input[builtins.str] azure_sdk: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the secret.
        :param pulumi.Input[builtins.str] description: Description of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary: List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary_as_envs: If a dictionary secret is defined, this output will be a key-value map in the following format: `key =
               cpln://secret/SECRET_NAME.key`.
        :param pulumi.Input[builtins.str] docker: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        :param pulumi.Input[builtins.str] gcp: JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        :param pulumi.Input['SecretKeypairArgs'] keypair: [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        :param pulumi.Input[builtins.str] name: Name of the secret.
        :param pulumi.Input['SecretNatsAccountArgs'] nats_account: [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        :param pulumi.Input['SecretOpaqueArgs'] opaque: [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        :param pulumi.Input[builtins.str] secret_link: Output used when linking a secret to an environment variable or volume.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input['SecretTlsArgs'] tls: [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        :param pulumi.Input['SecretUserpassArgs'] userpass: [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure_connector is not None:
            pulumi.set(__self__, "azure_connector", azure_connector)
        if azure_sdk is not None:
            pulumi.set(__self__, "azure_sdk", azure_sdk)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dictionary is not None:
            pulumi.set(__self__, "dictionary", dictionary)
        if dictionary_as_envs is not None:
            pulumi.set(__self__, "dictionary_as_envs", dictionary_as_envs)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if keypair is not None:
            pulumi.set(__self__, "keypair", keypair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nats_account is not None:
            pulumi.set(__self__, "nats_account", nats_account)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if secret_link is not None:
            pulumi.set(__self__, "secret_link", secret_link)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if userpass is not None:
            pulumi.set(__self__, "userpass", userpass)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['SecretAwsArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['SecretAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> Optional[pulumi.Input['SecretAzureConnectorArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        """
        return pulumi.get(self, "azure_connector")

    @azure_connector.setter
    def azure_connector(self, value: Optional[pulumi.Input['SecretAzureConnectorArgs']]):
        pulumi.set(self, "azure_connector", value)

    @property
    @pulumi.getter(name="azureSdk")
    def azure_sdk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        """
        return pulumi.get(self, "azure_sdk")

    @azure_sdk.setter
    def azure_sdk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_sdk", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the secret.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dictionary(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        """
        return pulumi.get(self, "dictionary")

    @dictionary.setter
    def dictionary(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dictionary", value)

    @property
    @pulumi.getter(name="dictionaryAsEnvs")
    def dictionary_as_envs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        If a dictionary secret is defined, this output will be a key-value map in the following format: `key =
        cpln://secret/SECRET_NAME.key`.
        """
        return pulumi.get(self, "dictionary_as_envs")

    @dictionary_as_envs.setter
    def dictionary_as_envs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dictionary_as_envs", value)

    @property
    @pulumi.getter
    def docker(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        """
        return pulumi.get(self, "docker")

    @docker.setter
    def docker(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "docker", value)

    @property
    @pulumi.getter
    def ecr(self) -> Optional[pulumi.Input['SecretEcrArgs']]:
        return pulumi.get(self, "ecr")

    @ecr.setter
    def ecr(self, value: Optional[pulumi.Input['SecretEcrArgs']]):
        pulumi.set(self, "ecr", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        """
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter
    def keypair(self) -> Optional[pulumi.Input['SecretKeypairArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        """
        return pulumi.get(self, "keypair")

    @keypair.setter
    def keypair(self, value: Optional[pulumi.Input['SecretKeypairArgs']]):
        pulumi.set(self, "keypair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natsAccount")
    def nats_account(self) -> Optional[pulumi.Input['SecretNatsAccountArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        """
        return pulumi.get(self, "nats_account")

    @nats_account.setter
    def nats_account(self, value: Optional[pulumi.Input['SecretNatsAccountArgs']]):
        pulumi.set(self, "nats_account", value)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['SecretOpaqueArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['SecretOpaqueArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output used when linking a secret to an environment variable or volume.
        """
        return pulumi.get(self, "secret_link")

    @secret_link.setter
    def secret_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_link", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['SecretTlsArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['SecretTlsArgs']]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter
    def userpass(self) -> Optional[pulumi.Input['SecretUserpassArgs']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        return pulumi.get(self, "userpass")

    @userpass.setter
    def userpass(self, value: Optional[pulumi.Input['SecretUserpassArgs']]):
        pulumi.set(self, "userpass", value)


@pulumi.type_token("cpln:index/secret:Secret")
class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['SecretAwsArgs', 'SecretAwsArgsDict']]] = None,
                 azure_connector: Optional[pulumi.Input[Union['SecretAzureConnectorArgs', 'SecretAzureConnectorArgsDict']]] = None,
                 azure_sdk: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dictionary: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 docker: Optional[pulumi.Input[builtins.str]] = None,
                 ecr: Optional[pulumi.Input[Union['SecretEcrArgs', 'SecretEcrArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[builtins.str]] = None,
                 keypair: Optional[pulumi.Input[Union['SecretKeypairArgs', 'SecretKeypairArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nats_account: Optional[pulumi.Input[Union['SecretNatsAccountArgs', 'SecretNatsAccountArgsDict']]] = None,
                 opaque: Optional[pulumi.Input[Union['SecretOpaqueArgs', 'SecretOpaqueArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls: Optional[pulumi.Input[Union['SecretTlsArgs', 'SecretTlsArgsDict']]] = None,
                 userpass: Optional[pulumi.Input[Union['SecretUserpassArgs', 'SecretUserpassArgsDict']]] = None,
                 __props__=None):
        """
        Create a Secret resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecretAwsArgs', 'SecretAwsArgsDict']] aws: [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        :param pulumi.Input[Union['SecretAzureConnectorArgs', 'SecretAzureConnectorArgsDict']] azure_connector: [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        :param pulumi.Input[builtins.str] azure_sdk: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        :param pulumi.Input[builtins.str] description: Description of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary: List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        :param pulumi.Input[builtins.str] docker: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        :param pulumi.Input[builtins.str] gcp: JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        :param pulumi.Input[Union['SecretKeypairArgs', 'SecretKeypairArgsDict']] keypair: [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        :param pulumi.Input[builtins.str] name: Name of the secret.
        :param pulumi.Input[Union['SecretNatsAccountArgs', 'SecretNatsAccountArgsDict']] nats_account: [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        :param pulumi.Input[Union['SecretOpaqueArgs', 'SecretOpaqueArgsDict']] opaque: [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[Union['SecretTlsArgs', 'SecretTlsArgsDict']] tls: [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        :param pulumi.Input[Union['SecretUserpassArgs', 'SecretUserpassArgsDict']] userpass: [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Secret resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['SecretAwsArgs', 'SecretAwsArgsDict']]] = None,
                 azure_connector: Optional[pulumi.Input[Union['SecretAzureConnectorArgs', 'SecretAzureConnectorArgsDict']]] = None,
                 azure_sdk: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dictionary: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 docker: Optional[pulumi.Input[builtins.str]] = None,
                 ecr: Optional[pulumi.Input[Union['SecretEcrArgs', 'SecretEcrArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[builtins.str]] = None,
                 keypair: Optional[pulumi.Input[Union['SecretKeypairArgs', 'SecretKeypairArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nats_account: Optional[pulumi.Input[Union['SecretNatsAccountArgs', 'SecretNatsAccountArgsDict']]] = None,
                 opaque: Optional[pulumi.Input[Union['SecretOpaqueArgs', 'SecretOpaqueArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tls: Optional[pulumi.Input[Union['SecretTlsArgs', 'SecretTlsArgsDict']]] = None,
                 userpass: Optional[pulumi.Input[Union['SecretUserpassArgs', 'SecretUserpassArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azure_connector"] = azure_connector
            __props__.__dict__["azure_sdk"] = None if azure_sdk is None else pulumi.Output.secret(azure_sdk)
            __props__.__dict__["description"] = description
            __props__.__dict__["dictionary"] = dictionary
            __props__.__dict__["docker"] = None if docker is None else pulumi.Output.secret(docker)
            __props__.__dict__["ecr"] = ecr
            __props__.__dict__["gcp"] = None if gcp is None else pulumi.Output.secret(gcp)
            __props__.__dict__["keypair"] = keypair
            __props__.__dict__["name"] = name
            __props__.__dict__["nats_account"] = nats_account
            __props__.__dict__["opaque"] = opaque
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls"] = tls
            __props__.__dict__["userpass"] = userpass
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["dictionary_as_envs"] = None
            __props__.__dict__["secret_link"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["azureSdk", "docker", "gcp"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Secret, __self__).__init__(
            'cpln:index/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Union['SecretAwsArgs', 'SecretAwsArgsDict']]] = None,
            azure_connector: Optional[pulumi.Input[Union['SecretAzureConnectorArgs', 'SecretAzureConnectorArgsDict']]] = None,
            azure_sdk: Optional[pulumi.Input[builtins.str]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dictionary: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            dictionary_as_envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            docker: Optional[pulumi.Input[builtins.str]] = None,
            ecr: Optional[pulumi.Input[Union['SecretEcrArgs', 'SecretEcrArgsDict']]] = None,
            gcp: Optional[pulumi.Input[builtins.str]] = None,
            keypair: Optional[pulumi.Input[Union['SecretKeypairArgs', 'SecretKeypairArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nats_account: Optional[pulumi.Input[Union['SecretNatsAccountArgs', 'SecretNatsAccountArgsDict']]] = None,
            opaque: Optional[pulumi.Input[Union['SecretOpaqueArgs', 'SecretOpaqueArgsDict']]] = None,
            secret_link: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tls: Optional[pulumi.Input[Union['SecretTlsArgs', 'SecretTlsArgsDict']]] = None,
            userpass: Optional[pulumi.Input[Union['SecretUserpassArgs', 'SecretUserpassArgsDict']]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SecretAwsArgs', 'SecretAwsArgsDict']] aws: [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        :param pulumi.Input[Union['SecretAzureConnectorArgs', 'SecretAzureConnectorArgsDict']] azure_connector: [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        :param pulumi.Input[builtins.str] azure_sdk: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the secret.
        :param pulumi.Input[builtins.str] description: Description of the secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary: List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dictionary_as_envs: If a dictionary secret is defined, this output will be a key-value map in the following format: `key =
               cpln://secret/SECRET_NAME.key`.
        :param pulumi.Input[builtins.str] docker: JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        :param pulumi.Input[builtins.str] gcp: JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        :param pulumi.Input[Union['SecretKeypairArgs', 'SecretKeypairArgsDict']] keypair: [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        :param pulumi.Input[builtins.str] name: Name of the secret.
        :param pulumi.Input[Union['SecretNatsAccountArgs', 'SecretNatsAccountArgsDict']] nats_account: [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        :param pulumi.Input[Union['SecretOpaqueArgs', 'SecretOpaqueArgsDict']] opaque: [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        :param pulumi.Input[builtins.str] secret_link: Output used when linking a secret to an environment variable or volume.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[Union['SecretTlsArgs', 'SecretTlsArgsDict']] tls: [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        :param pulumi.Input[Union['SecretUserpassArgs', 'SecretUserpassArgsDict']] userpass: [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azure_connector"] = azure_connector
        __props__.__dict__["azure_sdk"] = azure_sdk
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["dictionary"] = dictionary
        __props__.__dict__["dictionary_as_envs"] = dictionary_as_envs
        __props__.__dict__["docker"] = docker
        __props__.__dict__["ecr"] = ecr
        __props__.__dict__["gcp"] = gcp
        __props__.__dict__["keypair"] = keypair
        __props__.__dict__["name"] = name
        __props__.__dict__["nats_account"] = nats_account
        __props__.__dict__["opaque"] = opaque
        __props__.__dict__["secret_link"] = secret_link
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls"] = tls
        __props__.__dict__["userpass"] = userpass
        return Secret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.SecretAws']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#aws).
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> pulumi.Output[Optional['outputs.SecretAzureConnector']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#azure-connector).
        """
        return pulumi.get(self, "azure_connector")

    @property
    @pulumi.getter(name="azureSdk")
    def azure_sdk(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#azure).
        """
        return pulumi.get(self, "azure_sdk")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the secret.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the secret.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dictionary(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        List of unique key-value pairs. [Reference Page](https://docs.controlplane.com/reference/secret#dictionary).
        """
        return pulumi.get(self, "dictionary")

    @property
    @pulumi.getter(name="dictionaryAsEnvs")
    def dictionary_as_envs(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        If a dictionary secret is defined, this output will be a key-value map in the following format: `key =
        cpln://secret/SECRET_NAME.key`.
        """
        return pulumi.get(self, "dictionary_as_envs")

    @property
    @pulumi.getter
    def docker(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        JSON string containing the Docker secret. [Reference Page](https://docs.controlplane.com/reference/secret#docker).
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter
    def ecr(self) -> pulumi.Output[Optional['outputs.SecretEcr']]:
        return pulumi.get(self, "ecr")

    @property
    @pulumi.getter
    def gcp(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        JSON string containing the GCP secret. [Reference Page](https://docs.controlplane.com/reference/secret#gcp)
        """
        return pulumi.get(self, "gcp")

    @property
    @pulumi.getter
    def keypair(self) -> pulumi.Output[Optional['outputs.SecretKeypair']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#keypair).
        """
        return pulumi.get(self, "keypair")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natsAccount")
    def nats_account(self) -> pulumi.Output[Optional['outputs.SecretNatsAccount']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#nats-account).
        """
        return pulumi.get(self, "nats_account")

    @property
    @pulumi.getter
    def opaque(self) -> pulumi.Output[Optional['outputs.SecretOpaque']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#opaque).
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> pulumi.Output[builtins.str]:
        """
        Output used when linking a secret to an environment variable or volume.
        """
        return pulumi.get(self, "secret_link")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tls(self) -> pulumi.Output[Optional['outputs.SecretTls']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#tls).
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def userpass(self) -> pulumi.Output[Optional['outputs.SecretUserpass']]:
        """
        [Reference Page](https://docs.controlplane.com/reference/secret#username).
        """
        return pulumi.get(self, "userpass")

