from typing import List, Tuple

def key_gen() -> Tuple[bytes, bytes]:
    """
    Generates a key pair for this party (SWIFT or a node), returning a tuple with `(public_key, secret_key)`. The public_key must be sent to SWIFT.
    """

def build_okvs(public_key: bytes, strings_in_each_row: List[List[str]]) -> bytes:
    """
    Builds an OKVS. This function must be called by each node twice; once for data pertaining to a query where this node is a sender, and once where this node is a receiver. A node may encode multiple banks' data in a single OKVS. This function takes the public key of this node and the data from the database, which is a list of rows. Each row is a list of the relevant columns as a `str`. The OKVS must be sent to SWIFT.
    """

def initiate_queries(sender_data: List[List[str]], receiver_data: List[List[str]], sender_okvs: bytes, receiver_okvs: bytes, swift_pk: bytes) -> bytes:
    """
    Called by SWIFT, this function takes the sender and receiver data for multiple queries at the same time. These inputs should have the same shape as when calling the `build_okvs` function. This function also takes the sender's and receiver's OKVS. The final argument is the public key of SWIFT. The returned object is a set of ciphertexts representing a batch of queries as a `bytes` object. This must be sent to the sending and receiving nodes.
    """

def randomize(ciphertexts: bytes) -> bytes:
    """
    This function is called by the sending and receiving nodes. The only argument is the set of ciphertexts that were generated by the `initiate_queries` function. The output is another bytes object representing randomized ciphertexts, which must be sent to SWIFT.
    """

def combine(sender_ciphertexts: bytes, receiver_ciphertexts: bytes) -> Tuple[bytes, bytes, bytes, bytes]:
    """
    This function for SWIFT inputs the randomized ciphertexts from the sending and receiving nodes (the order is actually not important) and outputs four sets of points as a tuple of bytes. *The order of these four sets of points is important!* Given output `(a, b, c, d)`, SWIFT must send `a` to the sending node and `b` to the receiving node. It must store `c` and `d` locally.
    """

def decrypt(points: bytes, bank_secret_key: bytes) -> bytes:
    """
    This function is called by the sending or receiving node. It inputs the points (`bytes`) from the combine function as well as the secret key of this node (also `bytes`). It outputs a set of 'decrypted' points, again as a `bytes` object. This object must be sent to SWIFT.
    """

def finish(sender_points: bytes, receiver_points: bytes, gamma_points: bytes, delta_points: bytes, swift_secret_key: bytes) -> List[bool]:
    """
    This function is called by SWIFT, and it directly returns the feature for each queried transaction as a Boolean. The order of the inputs is crucial: first the sender's points from the `decrypt` function, then the receiver's, then `c` and `d` from the `combine` function, and finally the secret key of SWIFT as a `bytes` object. The result is a list of `bool`s. The output should be correct with extremely high probability.
    """
