# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.animations
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.animations import AnimationCalcMode as AnimationCalcMode
    if hasattr(AnimationCalcMode, '_constants') and isinstance(AnimationCalcMode._constants, dict):
        AnimationCalcMode._constants['__ooo_ns__'] = 'com.sun.star.animations'
        AnimationCalcMode._constants['__ooo_full_ns__'] = 'com.sun.star.animations.AnimationCalcMode'
        AnimationCalcMode._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global AnimationCalcModeEnum
        ls = [f for f in dir(AnimationCalcMode) if not callable(getattr(AnimationCalcMode, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(AnimationCalcMode, name)
        AnimationCalcModeEnum = IntEnum('AnimationCalcModeEnum', _dict)
    build_enum()
else:
    from ...lo.animations.animation_calc_mode import AnimationCalcMode as AnimationCalcMode

    class AnimationCalcModeEnum(IntEnum):
        """
        Enum of Const Class AnimationCalcMode

        Specifies the interpolation mode for the animation.
        """
        DISCRETE = AnimationCalcMode.DISCRETE
        """
        This specifies that the animation function will jump from one value to the next without any interpolation.
        """
        LINEAR = AnimationCalcMode.LINEAR
        """
        Simple linear interpolation between values is used to calculate the animation function.
        
        This is the default.
        """
        PACED = AnimationCalcMode.PACED
        """
        Defines interpolation to produce an even pace of change across the animation.
        
        This is only supported for values that define a linear numeric range, and for which some notion of \"distance\" between points can be calculated (e.g. position, width, height, etc.).
        """
        SPLINE = AnimationCalcMode.SPLINE
        """
        Interpolates from one value in the values list to the next according to a time function defined by a cubic Bezier spline.
        
        The points of the spline are defined in the XAnimate.KeyTimes attribute, and the control points for each interval are defined in the XAnimate.TimeFilter attribute.
        """

__all__ = ['AnimationCalcMode', 'AnimationCalcModeEnum']
