# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.awt import FontFamily as FontFamily
    if hasattr(FontFamily, '_constants') and isinstance(FontFamily._constants, dict):
        FontFamily._constants['__ooo_ns__'] = 'com.sun.star.awt'
        FontFamily._constants['__ooo_full_ns__'] = 'com.sun.star.awt.FontFamily'
        FontFamily._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global FontFamilyEnum
        ls = [f for f in dir(FontFamily) if not callable(getattr(FontFamily, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(FontFamily, name)
        FontFamilyEnum = IntEnum('FontFamilyEnum', _dict)
    build_enum()
else:
    from ...lo.awt.font_family import FontFamily as FontFamily

    class FontFamilyEnum(IntEnum):
        """
        Enum of Const Class FontFamily

        These values are used to specify the general kind of font.
        
        They may be expanded in future versions.
        """
        DONTKNOW = FontFamily.DONTKNOW
        """
        specifies an unknown font family.
        """
        DECORATIVE = FontFamily.DECORATIVE
        """
        specifies the family of decorative fonts.
        """
        MODERN = FontFamily.MODERN
        """
        specifies the family of modern fonts.
        """
        ROMAN = FontFamily.ROMAN
        """
        specifies the family roman fonts (with serifs).
        """
        SCRIPT = FontFamily.SCRIPT
        """
        specifies the family of script fonts.
        """
        SWISS = FontFamily.SWISS
        """
        specifies the family roman fonts (without serifs).
        """
        SYSTEM = FontFamily.SYSTEM
        """
        specifies the family system fonts.
        """

__all__ = ['FontFamily', 'FontFamilyEnum']
