# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.i18n import TransliterationModulesExtra as TransliterationModulesExtra
    if hasattr(TransliterationModulesExtra, '_constants') and isinstance(TransliterationModulesExtra._constants, dict):
        TransliterationModulesExtra._constants['__ooo_ns__'] = 'com.sun.star.i18n'
        TransliterationModulesExtra._constants['__ooo_full_ns__'] = 'com.sun.star.i18n.TransliterationModulesExtra'
        TransliterationModulesExtra._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global TransliterationModulesExtraEnum
        ls = [f for f in dir(TransliterationModulesExtra) if not callable(getattr(TransliterationModulesExtra, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(TransliterationModulesExtra, name)
        TransliterationModulesExtraEnum = IntEnum('TransliterationModulesExtraEnum', _dict)
    build_enum()
else:
    from ...lo.i18n.transliteration_modules_extra import TransliterationModulesExtra as TransliterationModulesExtra

    class TransliterationModulesExtraEnum(IntEnum):
        """
        Enum of Const Class TransliterationModulesExtra

        Extra transliteration module enumeration to use with XTransliteration.loadModule()
        
        The values used in this group need to be different from the ones in TransliterationModules and TransliterationModulesNew!
        """
        SENTENCE_CASE = TransliterationModulesExtra.SENTENCE_CASE
        """
        The first character of the sentence is put in upper case.
        """
        TITLE_CASE = TransliterationModulesExtra.TITLE_CASE
        """
        The first character of the word is put in upper case.
        
        This one is part
        """
        TOGGLE_CASE = TransliterationModulesExtra.TOGGLE_CASE
        """
        All characters of the word are to change their case from small letters to capital letters and vice versa.
        """
        IGNORE_DIACRITICS_CTL = TransliterationModulesExtra.IGNORE_DIACRITICS_CTL
        """
        Ignore diacritics.
        
        Despite the _CTL name suffix this is not only about CTL/Arabic diacritic characters, though these are handled as well, but the transliteration decomposes and removes any diacritic from characters.
        
        Because we cannot extend the TransliterationModules enum we use TransliterationModulesExtra and it will act the same way.
        """
        IGNORE_KASHIDA_CTL = TransliterationModulesExtra.IGNORE_KASHIDA_CTL
        """
        Ignore Kashida mark.
        """
        END_OF_MODULE = TransliterationModulesExtra.END_OF_MODULE

__all__ = ['TransliterationModulesExtra', 'TransliterationModulesExtraEnum']
