# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.linguistic2
from enum import IntFlag
from typing import TYPE_CHECKING
from ooo.oenv import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.linguistic2 import DictionaryEventFlags as DictionaryEventFlags
    if hasattr(DictionaryEventFlags, '_constants') and isinstance(DictionaryEventFlags._constants, dict):
        DictionaryEventFlags._constants['__ooo_ns__'] = 'com.sun.star.linguistic2'
        DictionaryEventFlags._constants['__ooo_full_ns__'] = 'com.sun.star.linguistic2.DictionaryEventFlags'
        DictionaryEventFlags._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global DictionaryEventFlagsEnum
        ls = [f for f in dir(DictionaryEventFlags) if not callable(getattr(DictionaryEventFlags, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(DictionaryEventFlags, name)
        DictionaryEventFlagsEnum = IntFlag('DictionaryEventFlagsEnum', _dict)
    build_enum()
else:
    from ...lo.linguistic2.dictionary_event_flags import DictionaryEventFlags as DictionaryEventFlags

    class DictionaryEventFlagsEnum(IntFlag):
        """
        Enum of Const Class DictionaryEventFlags

        flags used for the event type in dictionary events.
        
        These flags represent the type of events that a dictionary may broadcast.
        """
        ADD_ENTRY = DictionaryEventFlags.ADD_ENTRY
        """
        indicates that at least one entry has been added.
        """
        DEL_ENTRY = DictionaryEventFlags.DEL_ENTRY
        """
        indicates that at least one entry has been deleted.
        """
        CHG_NAME = DictionaryEventFlags.CHG_NAME
        """
        the dictionary's name has changed.
        """
        CHG_LANGUAGE = DictionaryEventFlags.CHG_LANGUAGE
        """
        the dictionary's language has changed.
        """
        ENTRIES_CLEARED = DictionaryEventFlags.ENTRIES_CLEARED
        """
        all entries have been removed.
        """
        ACTIVATE_DIC = DictionaryEventFlags.ACTIVATE_DIC
        """
        used when the dictionary was activated.
        """
        DEACTIVATE_DIC = DictionaryEventFlags.DEACTIVATE_DIC
        """
        used when the dictionary was deactivated.
        """

__all__ = ['DictionaryEventFlags', 'DictionaryEventFlagsEnum']
