# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sdb.application
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv import UNO_ENVIRONMENT, UNO_RUNTIME
_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from com.sun.star.sdb.application import DatabaseObject as DatabaseObject
    if hasattr(DatabaseObject, '_constants') and isinstance(DatabaseObject._constants, dict):
        DatabaseObject._constants['__ooo_ns__'] = 'com.sun.star.sdb.application'
        DatabaseObject._constants['__ooo_full_ns__'] = 'com.sun.star.sdb.application.DatabaseObject'
        DatabaseObject._constants['__ooo_type_name__'] = 'const'
    def build_enum():
        global DatabaseObjectEnum
        ls = [f for f in dir(DatabaseObject) if not callable(getattr(DatabaseObject, f)) and not f.startswith('__')]
        _dict = {}
        for name in ls:
            _dict[name] = getattr(DatabaseObject, name)
        DatabaseObjectEnum = IntEnum('DatabaseObjectEnum', _dict)
    build_enum()
else:
    from ....lo.sdb.application.database_object import DatabaseObject as DatabaseObject

    class DatabaseObjectEnum(IntEnum):
        """
        Enum of Const Class DatabaseObject

        denotes different objects within a database document
        
        **since**
        
            OOo 2.2
        """
        TABLE = DatabaseObject.TABLE
        """
        denotes a table in a database
        
        Note that table here is a more general term. In OpenOffice.org Base, views are also represented as tables, since to the user, the behave pretty much as tables do.
        """
        QUERY = DatabaseObject.QUERY
        """
        denotes a query in a database document
        """
        FORM = DatabaseObject.FORM
        """
        denotes a form in a database document
        """
        REPORT = DatabaseObject.REPORT
        """
        denotes a report in a database document
        """

__all__ = ['DatabaseObject', 'DatabaseObjectEnum']
