# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .point import Point as Point_5fb2085e
from .rectangle import Rectangle as Rectangle_84b109e9


class DockingEvent(EventObject_a3d70b03):
    """
    Struct Class

    specifies a docking event.

    See Also:
        `API DockingEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1DockingEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.DockingEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.DockingEvent'
    """Literal Constant ``com.sun.star.awt.DockingEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, TrackingRectangle: typing.Optional[Rectangle_84b109e9] = UNO_NONE, MousePos: typing.Optional[Point_5fb2085e] = UNO_NONE, bLiveMode: typing.Optional[bool] = False, bInteractive: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            TrackingRectangle (Rectangle, optional): TrackingRectangle value.
            MousePos (Point, optional): MousePos value.
            bLiveMode (bool, optional): bLiveMode value.
            bInteractive (bool, optional): bInteractive value.
        """

        if isinstance(Source, DockingEvent):
            oth: DockingEvent = Source
            self.Source = oth.Source
            self.TrackingRectangle = oth.TrackingRectangle
            self.MousePos = oth.MousePos
            self.bLiveMode = oth.bLiveMode
            self.bInteractive = oth.bInteractive
            return

        kargs = {
            "Source": Source,
            "TrackingRectangle": TrackingRectangle,
            "MousePos": MousePos,
            "bLiveMode": bLiveMode,
            "bInteractive": bInteractive,
        }
        if kargs["TrackingRectangle"] is UNO_NONE:
            kargs["TrackingRectangle"] = None
        if kargs["MousePos"] is UNO_NONE:
            kargs["MousePos"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._tracking_rectangle = kwargs["TrackingRectangle"]
        self._mouse_pos = kwargs["MousePos"]
        self._b_live_mode = kwargs["bLiveMode"]
        self._b_interactive = kwargs["bInteractive"]
        inst_keys = ('TrackingRectangle', 'MousePos', 'bLiveMode', 'bInteractive')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def TrackingRectangle(self) -> Rectangle_84b109e9:
        """
        specifies the current tracking rectangle
        """
        return self._tracking_rectangle
    
    @TrackingRectangle.setter
    def TrackingRectangle(self, value: Rectangle_84b109e9) -> None:
        self._tracking_rectangle = value

    @property
    def MousePos(self) -> Point_5fb2085e:
        """
        specifies the current mouse position in frame coordinates
        """
        return self._mouse_pos
    
    @MousePos.setter
    def MousePos(self, value: Point_5fb2085e) -> None:
        self._mouse_pos = value

    @property
    def bLiveMode(self) -> bool:
        """
        specifies if the layout should be adjusted immediately
        """
        return self._b_live_mode
    
    @bLiveMode.setter
    def bLiveMode(self, value: bool) -> None:
        self._b_live_mode = value

    @property
    def bInteractive(self) -> bool:
        """
        specifies if the docking procedure is interactive which means that the user is currently dragging the window to a new position if this member is FALSE the window will be docked or undocked immediately using the returned tracking rectangle
        """
        return self._b_interactive
    
    @bInteractive.setter
    def bInteractive(self, value: bool) -> None:
        self._b_interactive = value


__all__ = ['DockingEvent']
