# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing
from .font_slant import FontSlant as FontSlant_849509ed


class FontDescriptor(object):
    """
    Struct Class

    describes the characteristics of a font.
    
    For example, this can be used to select a font.

    See Also:
        `API FontDescriptor <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1FontDescriptor.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.FontDescriptor'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.FontDescriptor'
    """Literal Constant ``com.sun.star.awt.FontDescriptor``"""

    def __init__(self, Name: typing.Optional[str] = '', Height: typing.Optional[int] = 0, Width: typing.Optional[int] = 0, StyleName: typing.Optional[str] = '', Family: typing.Optional[int] = 0, CharSet: typing.Optional[int] = 0, Pitch: typing.Optional[int] = 0, CharacterWidth: typing.Optional[float] = 0.0, Weight: typing.Optional[float] = 0.0, Slant: typing.Optional[FontSlant_849509ed] = FontSlant_849509ed.NONE, Underline: typing.Optional[int] = 0, Strikeout: typing.Optional[int] = 0, Orientation: typing.Optional[float] = 0.0, Kerning: typing.Optional[bool] = False, WordLineMode: typing.Optional[bool] = False, Type: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Height (int, optional): Height value.
            Width (int, optional): Width value.
            StyleName (str, optional): StyleName value.
            Family (int, optional): Family value.
            CharSet (int, optional): CharSet value.
            Pitch (int, optional): Pitch value.
            CharacterWidth (float, optional): CharacterWidth value.
            Weight (float, optional): Weight value.
            Slant (FontSlant, optional): Slant value.
            Underline (int, optional): Underline value.
            Strikeout (int, optional): Strikeout value.
            Orientation (float, optional): Orientation value.
            Kerning (bool, optional): Kerning value.
            WordLineMode (bool, optional): WordLineMode value.
            Type (int, optional): Type value.
        """
        super().__init__()

        if isinstance(Name, FontDescriptor):
            oth: FontDescriptor = Name
            self.Name = oth.Name
            self.Height = oth.Height
            self.Width = oth.Width
            self.StyleName = oth.StyleName
            self.Family = oth.Family
            self.CharSet = oth.CharSet
            self.Pitch = oth.Pitch
            self.CharacterWidth = oth.CharacterWidth
            self.Weight = oth.Weight
            self.Slant = oth.Slant
            self.Underline = oth.Underline
            self.Strikeout = oth.Strikeout
            self.Orientation = oth.Orientation
            self.Kerning = oth.Kerning
            self.WordLineMode = oth.WordLineMode
            self.Type = oth.Type
            return

        kargs = {
            "Name": Name,
            "Height": Height,
            "Width": Width,
            "StyleName": StyleName,
            "Family": Family,
            "CharSet": CharSet,
            "Pitch": Pitch,
            "CharacterWidth": CharacterWidth,
            "Weight": Weight,
            "Slant": Slant,
            "Underline": Underline,
            "Strikeout": Strikeout,
            "Orientation": Orientation,
            "Kerning": Kerning,
            "WordLineMode": WordLineMode,
            "Type": Type,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["Name"]
        self._height = kwargs["Height"]
        self._width = kwargs["Width"]
        self._style_name = kwargs["StyleName"]
        self._family = kwargs["Family"]
        self._char_set = kwargs["CharSet"]
        self._pitch = kwargs["Pitch"]
        self._character_width = kwargs["CharacterWidth"]
        self._weight = kwargs["Weight"]
        self._slant = kwargs["Slant"]
        self._underline = kwargs["Underline"]
        self._strikeout = kwargs["Strikeout"]
        self._orientation = kwargs["Orientation"]
        self._kerning = kwargs["Kerning"]
        self._word_line_mode = kwargs["WordLineMode"]
        self._type = kwargs["Type"]


    @property
    def Name(self) -> str:
        """
        specifies the exact name of the font.
        """
        return self._name
    
    @Name.setter
    def Name(self, value: str) -> None:
        self._name = value

    @property
    def Height(self) -> int:
        """
        specifies the height of the font in the measure of the destination.
        """
        return self._height
    
    @Height.setter
    def Height(self, value: int) -> None:
        self._height = value

    @property
    def Width(self) -> int:
        """
        specifies the width of the font in the measure of the destination.
        """
        return self._width
    
    @Width.setter
    def Width(self, value: int) -> None:
        self._width = value

    @property
    def StyleName(self) -> str:
        """
        specifies the style name of the font.
        """
        return self._style_name
    
    @StyleName.setter
    def StyleName(self, value: str) -> None:
        self._style_name = value

    @property
    def Family(self) -> int:
        """
        specifies the general style of the font.
        
        Use one value out of the constant group com.sun.star.awt.FontFamily.
        """
        return self._family
    
    @Family.setter
    def Family(self, value: int) -> None:
        self._family = value

    @property
    def CharSet(self) -> int:
        """
        specifies the character set which is supported by the font.
        
        Use one value out of the constant group com.sun.star.awt.CharSet.
        """
        return self._char_set
    
    @CharSet.setter
    def CharSet(self, value: int) -> None:
        self._char_set = value

    @property
    def Pitch(self) -> int:
        """
        specifies the pitch of the font.
        
        Use one value out of the constant group com.sun.star.awt.FontPitch.
        """
        return self._pitch
    
    @Pitch.setter
    def Pitch(self, value: int) -> None:
        self._pitch = value

    @property
    def CharacterWidth(self) -> float:
        """
        specifies the character width.
        
        Depending on the specified width, a font that supports this width may be selected.
        
        The value is expressed as a percentage.
        """
        return self._character_width
    
    @CharacterWidth.setter
    def CharacterWidth(self, value: float) -> None:
        self._character_width = value

    @property
    def Weight(self) -> float:
        """
        specifies the thickness of the line.
        
        Depending on the specified weight, a font that supports this thickness may be selected.
        
        The value is expressed as a percentage.
        """
        return self._weight
    
    @Weight.setter
    def Weight(self, value: float) -> None:
        self._weight = value

    @property
    def Slant(self) -> FontSlant_849509ed:
        """
        specifies the slant of the font.
        """
        return self._slant
    
    @Slant.setter
    def Slant(self, value: FontSlant_849509ed) -> None:
        self._slant = value

    @property
    def Underline(self) -> int:
        """
        specifies the kind of underlining.
        
        Use one value out of the constant group com.sun.star.awt.FontUnderline.
        """
        return self._underline
    
    @Underline.setter
    def Underline(self, value: int) -> None:
        self._underline = value

    @property
    def Strikeout(self) -> int:
        """
        specifies the kind of strikeout.
        
        Use one value out of the constant group com.sun.star.awt.FontStrikeout.
        """
        return self._strikeout
    
    @Strikeout.setter
    def Strikeout(self, value: int) -> None:
        self._strikeout = value

    @property
    def Orientation(self) -> float:
        """
        specifies the rotation of the font.
        
        The unit of measure is degrees; 0 is the baseline.
        """
        return self._orientation
    
    @Orientation.setter
    def Orientation(self, value: float) -> None:
        self._orientation = value

    @property
    def Kerning(self) -> bool:
        """
        For requesting, it specifies if there is a kerning table available.
        
        For selecting, it specifies if the kerning table is to be used.
        """
        return self._kerning
    
    @Kerning.setter
    def Kerning(self, value: bool) -> None:
        self._kerning = value

    @property
    def WordLineMode(self) -> bool:
        """
        specifies if only words get underlined.
        
        TRUE means that only non-space characters get underlined, FALSE means that the spacing also gets underlined.
        
        This property is only valid if the property com.sun.star.awt.FontDescriptor.Underline is not FontUnderline.NONE.
        """
        return self._word_line_mode
    
    @WordLineMode.setter
    def WordLineMode(self, value: bool) -> None:
        self._word_line_mode = value

    @property
    def Type(self) -> int:
        """
        specifies the technology of the font representation.
        
        One or more values out of the constant group com.sun.star.awt.FontType can be combined by an arithmetical or-operation.
        """
        return self._type
    
    @Type.setter
    def Type(self, value: int) -> None:
        self._type = value


__all__ = ['FontDescriptor']
