# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt


class FontWeight(object):
    """
    Const Class

    These values are used to specify whether a font is thin or bold.
    
    They may be expanded in future versions.

    See Also:
        `API FontWeight <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1FontWeight.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.FontWeight'
    __ooo_type_name__: str = 'const'

    DONTKNOW = 0.0
    """
    The font weight is not specified/known.
    """
    THIN = 50.0
    """
    specifies a 50% font weight.
    """
    ULTRALIGHT = 60.0
    """
    specifies a 60% font weight.
    """
    LIGHT = 75.0
    """
    specifies a 75% font weight.
    """
    SEMILIGHT = 90.0
    """
    specifies a 90% font weight.
    """
    NORMAL = 100.0
    """
    specifies a normal font weight.
    """
    SEMIBOLD = 110.0
    """
    specifies a 110% font weight.
    """
    BOLD = 150.0
    """
    specifies a 150% font weight.
    """
    ULTRABOLD = 175.0
    """
    specifies a 175% font weight.
    """
    BLACK = 200.0
    """
    specifies a 200% font weight.
    """

__all__ = ['FontWeight']
