# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt.grid
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
from ...lang.event_object import EventObject as EventObject_a3d70b03
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing


class GridColumnEvent(EventObject_a3d70b03):
    """
    Struct Class

    An event used by a XGridColumn to notify changes in the column.
    
    **since**
    
        OOo 3.3

    See Also:
        `API GridColumnEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1grid_1_1GridColumnEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt.grid'
    __ooo_full_ns__: str = 'com.sun.star.awt.grid.GridColumnEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.grid.GridColumnEvent'
    """Literal Constant ``com.sun.star.awt.grid.GridColumnEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, AttributeName: typing.Optional[str] = '', OldValue: typing.Optional[object] = None, NewValue: typing.Optional[object] = None, ColumnIndex: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            AttributeName (str, optional): AttributeName value.
            OldValue (object, optional): OldValue value.
            NewValue (object, optional): NewValue value.
            ColumnIndex (int, optional): ColumnIndex value.
        """

        if isinstance(Source, GridColumnEvent):
            oth: GridColumnEvent = Source
            self.Source = oth.Source
            self.AttributeName = oth.AttributeName
            self.OldValue = oth.OldValue
            self.NewValue = oth.NewValue
            self.ColumnIndex = oth.ColumnIndex
            return

        kargs = {
            "Source": Source,
            "AttributeName": AttributeName,
            "OldValue": OldValue,
            "NewValue": NewValue,
            "ColumnIndex": ColumnIndex,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._attribute_name = kwargs["AttributeName"]
        self._old_value = kwargs["OldValue"]
        self._new_value = kwargs["NewValue"]
        self._column_index = kwargs["ColumnIndex"]
        inst_keys = ('AttributeName', 'OldValue', 'NewValue', 'ColumnIndex')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def AttributeName(self) -> str:
        """
        Contains the name of the attributes whose value changed.
        """
        return self._attribute_name
    
    @AttributeName.setter
    def AttributeName(self, value: str) -> None:
        self._attribute_name = value

    @property
    def OldValue(self) -> object:
        """
        Contains the old value.
        """
        return self._old_value
    
    @OldValue.setter
    def OldValue(self, value: object) -> None:
        self._old_value = value

    @property
    def NewValue(self) -> object:
        """
        Contains the new value.
        """
        return self._new_value
    
    @NewValue.setter
    def NewValue(self, value: object) -> None:
        self._new_value = value

    @property
    def ColumnIndex(self) -> int:
        """
        Contains the index of the changed column.
        """
        return self._column_index
    
    @ColumnIndex.setter
    def ColumnIndex(self, value: int) -> None:
        self._column_index = value


__all__ = ['GridColumnEvent']
