# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class SystemDependentXWindow(object):
    """
    Struct Class

    specifies a system dependent XWindow.
    
    This is the structure returned in the XSystemDependentWindowPeer.getWindowHandle() call, if the system type is com.sun.star.lang.SystemDependent.XWINDOW.
    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API SystemDependentXWindow <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1SystemDependentXWindow.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.SystemDependentXWindow'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.SystemDependentXWindow'
    """Literal Constant ``com.sun.star.awt.SystemDependentXWindow``"""

    def __init__(self, WindowHandle: typing.Optional[int] = 0, DisplayPointer: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            WindowHandle (int, optional): WindowHandle value.
            DisplayPointer (int, optional): DisplayPointer value.
        """
        super().__init__()

        if isinstance(WindowHandle, SystemDependentXWindow):
            oth: SystemDependentXWindow = WindowHandle
            self.WindowHandle = oth.WindowHandle
            self.DisplayPointer = oth.DisplayPointer
            return

        kargs = {
            "WindowHandle": WindowHandle,
            "DisplayPointer": DisplayPointer,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._window_handle = kwargs["WindowHandle"]
        self._display_pointer = kwargs["DisplayPointer"]


    @property
    def WindowHandle(self) -> int:
        """
        The XWindow handle if possible, otherwise 0.
        """
        return self._window_handle
    
    @WindowHandle.setter
    def WindowHandle(self, value: int) -> None:
        self._window_handle = value

    @property
    def DisplayPointer(self) -> int:
        """
        The display pointer.
        """
        return self._display_pointer
    
    @DisplayPointer.setter
    def DisplayPointer(self, value: int) -> None:
        self._display_pointer = value


__all__ = ['SystemDependentXWindow']
