# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.beans
import typing
from abc import abstractmethod
from ..lang.x_event_listener import XEventListener as XEventListener_c7230c4a
if typing.TYPE_CHECKING:
    from .property_state_change_event import PropertyStateChangeEvent as PropertyStateChangeEvent_6b5010bf

class XPropertyStateChangeListener(XEventListener_c7230c4a):
    """
    receives events which get fired whenever the state of a bound property is changed.

    See Also:
        `API XPropertyStateChangeListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1beans_1_1XPropertyStateChangeListener.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.beans'
    __ooo_full_ns__: str = 'com.sun.star.beans.XPropertyStateChangeListener'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.beans.XPropertyStateChangeListener'

    @abstractmethod
    def propertyStateChange(self, aEvent: 'PropertyStateChangeEvent_6b5010bf') -> None:
        """
        is called when a bound property's state is changed.
        """

__all__ = ['XPropertyStateChangeListener']

