# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.configuration.backend
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing
from ..cannot_load_configuration_exception import CannotLoadConfigurationException as CannotLoadConfigurationException_b325176a
from ...uno.x_interface import XInterface as XInterface_8f010a43

class BackendSetupException(CannotLoadConfigurationException_b325176a):
    """
    Exception Class

    Generic exception thrown when setting up a connection to an underlying backend fails.
    
    Indicates an error that originates in the underlying access layer.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API BackendSetupException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1configuration_1_1backend_1_1BackendSetupException.html>`_
    """

    __ooo_ns__: str = 'com.sun.star.configuration.backend'
    __ooo_full_ns__: str = 'com.sun.star.configuration.backend.BackendSetupException'
    __ooo_type_name__: str = 'exception'
    __pyunointerface__: str = 'com.sun.star.configuration.backend.BackendSetupException'
    __pyunostruct__: str = 'com.sun.star.configuration.backend.BackendSetupException'

    typeName: str = 'com.sun.star.configuration.backend.BackendSetupException'
    """Literal Constant ``com.sun.star.configuration.backend.BackendSetupException``"""

    def __init__(self, Message: typing.Optional[str] = '', Context: typing.Optional[XInterface_8f010a43] = None, BackendException: typing.Optional[object] = None) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            BackendException (object, optional): BackendException value.
        """
        kargs = {
            "Message": Message,
            "Context": Context,
            "BackendException": BackendException,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._backend_exception = kwargs["BackendException"]
        inst_keys = ('BackendException',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)

    @property
    def BackendException(self) -> object:
        """
        The exception that is raised by the underlying backend implementation.
        
        May be a numeric error code, a message string or VOID, if the original exception is not represented as a com.sun.star.uno.Exception.
        """
        return self._backend_exception
    
    @BackendException.setter
    def BackendException(self, value: object) -> None:
        self._backend_exception = value


