# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.configuration.backend
from ...lang.x_initialization import XInitialization as XInitialization_d46c0cca
from ...task.x_interaction_handler import XInteractionHandler as XInteractionHandler_bf80e51

class InteractionHandler(XInitialization_d46c0cca, XInteractionHandler_bf80e51):
    """
    Service Class

    An interaction request handler that lets the user handle a number of well known requests via GUI dialogs.
    
    The well known requests handled by this service include
    
    The requests marked with an asterisk are only handled if (a) their continuations match certain restrictions (see below), and (b) the necessary resource strings are available (this can be exploited by applications that carry only a subset of all resource files with them).
    
    The continuation restrictions are as follows: Let C be the subset of the provided continuations that are of type com.sun.star.task.XInteractionApprove, com.sun.star.task.XInteractionDisapprove, com.sun.star.task.XInteractionRetry, or com.sun.star.task.XInteractionAbort (or of a derived type). All other continuations are ignored for these requests. The request is only handled if the set C is any of the following:
    
    **since**
    
        OOo 2.0

    See Also:
        `API InteractionHandler <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1configuration_1_1backend_1_1InteractionHandler.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.configuration.backend'
    __ooo_full_ns__: str = 'com.sun.star.configuration.backend.InteractionHandler'
    __ooo_type_name__: str = 'service'



__all__ = ['InteractionHandler']

