# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.datatransfer.dnd
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
from .drag_source_event import DragSourceEvent as DragSourceEvent_8ccf115c
from ...uno.x_interface import XInterface as XInterface_8f010a43
from .x_drag_source_context import XDragSourceContext as XDragSourceContext_c2661297
from .x_drag_source import XDragSource as XDragSource_49900fb2
import typing


class DragSourceDragEvent(DragSourceEvent_8ccf115c):
    """
    Struct Class

    The DragSourceDragEvent is delivered from an object that implements the XDragSourceContext to the currently registered drag source listener.
    
    It contains state regarding the current state of the operation to enable the operations initiator to provide the end user with the appropriate drag over feedback.

    See Also:
        `API DragSourceDragEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1datatransfer_1_1dnd_1_1DragSourceDragEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.datatransfer.dnd'
    __ooo_full_ns__: str = 'com.sun.star.datatransfer.dnd.DragSourceDragEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.datatransfer.dnd.DragSourceDragEvent'
    """Literal Constant ``com.sun.star.datatransfer.dnd.DragSourceDragEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, DragSourceContext: typing.Optional[XDragSourceContext_c2661297] = None, DragSource: typing.Optional[XDragSource_49900fb2] = None, DropAction: typing.Optional[int] = 0, UserAction: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            DragSourceContext (XDragSourceContext, optional): DragSourceContext value.
            DragSource (XDragSource, optional): DragSource value.
            DropAction (int, optional): DropAction value.
            UserAction (int, optional): UserAction value.
        """

        if isinstance(Source, DragSourceDragEvent):
            oth: DragSourceDragEvent = Source
            self.Source = oth.Source
            self.DragSourceContext = oth.DragSourceContext
            self.DragSource = oth.DragSource
            self.DropAction = oth.DropAction
            self.UserAction = oth.UserAction
            return

        kargs = {
            "Source": Source,
            "DragSourceContext": DragSourceContext,
            "DragSource": DragSource,
            "DropAction": DropAction,
            "UserAction": UserAction,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._drop_action = kwargs["DropAction"]
        self._user_action = kwargs["UserAction"]
        inst_keys = ('DropAction', 'UserAction')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def DropAction(self) -> int:
        """
        The drag action selected by the current drop target.
        """
        return self._drop_action
    
    @DropAction.setter
    def DropAction(self, value: int) -> None:
        self._drop_action = value

    @property
    def UserAction(self) -> int:
        """
        The user's currently selected drop action.
        """
        return self._user_action
    
    @UserAction.setter
    def UserAction(self, value: int) -> None:
        self._user_action = value


__all__ = ['DragSourceDragEvent']
