# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.form.binding
from abc import abstractproperty
from .bindable_data_aware_control_model import BindableDataAwareControlModel as BindableDataAwareControlModel_47091512
from ..component.database_check_box import DatabaseCheckBox as DatabaseCheckBox_7a5910d9

class BindableDatabaseCheckBox(BindableDataAwareControlModel_47091512, DatabaseCheckBox_7a5910d9):
    """
    Service Class

    This service specifies a check box which is data-aware and thus can be bound to a database field, and additionally supports binding to arbitrary external values.
    
    The com.sun.star.form.binding.XValueBinding instance which can be associated with a BindableDatabaseCheckBox must support exchanging boolean values. The following mapping between external values and control states apply:
    
    If the value binding associated with a BindableDatabaseCheckBox supports exchanging string values, and the com.sun.star.form.component.CheckBox.RefValue is not empty, then the radio button will exchange its value as string:

    See Also:
        `API BindableDatabaseCheckBox <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1form_1_1binding_1_1BindableDatabaseCheckBox.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.form.binding'
    __ooo_full_ns__: str = 'com.sun.star.form.binding.BindableDatabaseCheckBox'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def SecondaryRefValue(self) -> str:
        """
        specifies a value which is to be associated with the control when it's not checked.
        
        com.sun.star.form.component.CheckBox.RefValue is transferred to possible external value bindings as soon as the check box is checked. With the member SecondaryRefValue, clients of the check box can also associate a value with the not checked state of the control.
        """



__all__ = ['BindableDatabaseCheckBox']

