# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.frame
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .frame_action import FrameAction as FrameAction_aef40b5c
from .x_frame import XFrame as XFrame_7a570956


class FrameActionEvent(EventObject_a3d70b03):
    """
    Struct Class

    this event struct is broadcast for actions which can happen to components within frames

    See Also:
        `API FrameActionEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1frame_1_1FrameActionEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.frame'
    __ooo_full_ns__: str = 'com.sun.star.frame.FrameActionEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.frame.FrameActionEvent'
    """Literal Constant ``com.sun.star.frame.FrameActionEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, Frame: typing.Optional[XFrame_7a570956] = None, Action: typing.Optional[FrameAction_aef40b5c] = FrameAction_aef40b5c.COMPONENT_ATTACHED) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Frame (XFrame, optional): Frame value.
            Action (FrameAction, optional): Action value.
        """

        if isinstance(Source, FrameActionEvent):
            oth: FrameActionEvent = Source
            self.Source = oth.Source
            self.Frame = oth.Frame
            self.Action = oth.Action
            return

        kargs = {
            "Source": Source,
            "Frame": Frame,
            "Action": Action,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._frame = kwargs["Frame"]
        self._action = kwargs["Action"]
        inst_keys = ('Frame', 'Action')
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def Frame(self) -> XFrame_7a570956:
        """
        contains the frame in which the event occurred
        """
        return self._frame
    
    @Frame.setter
    def Frame(self, value: XFrame_7a570956) -> None:
        self._frame = value

    @property
    def Action(self) -> FrameAction_aef40b5c:
        """
        specifies the concrete event
        """
        return self._action
    
    @Action.setter
    def Action(self, value: FrameAction_aef40b5c) -> None:
        self._action = value


__all__ = ['FrameActionEvent']
