# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class LineBreakUserOptions(object):
    """
    Struct Class

    Line break options passed in calls to XBreakIterator.getLineBreak().

    See Also:
        `API LineBreakUserOptions <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1LineBreakUserOptions.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.LineBreakUserOptions'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.i18n.LineBreakUserOptions'
    """Literal Constant ``com.sun.star.i18n.LineBreakUserOptions``"""

    def __init__(self, forbiddenBeginCharacters: typing.Optional[str] = '', forbiddenEndCharacters: typing.Optional[str] = '', applyForbiddenRules: typing.Optional[bool] = False, allowPunctuationOutsideMargin: typing.Optional[bool] = False, allowHyphenateEnglish: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            forbiddenBeginCharacters (str, optional): forbiddenBeginCharacters value.
            forbiddenEndCharacters (str, optional): forbiddenEndCharacters value.
            applyForbiddenRules (bool, optional): applyForbiddenRules value.
            allowPunctuationOutsideMargin (bool, optional): allowPunctuationOutsideMargin value.
            allowHyphenateEnglish (bool, optional): allowHyphenateEnglish value.
        """
        super().__init__()

        if isinstance(forbiddenBeginCharacters, LineBreakUserOptions):
            oth: LineBreakUserOptions = forbiddenBeginCharacters
            self.forbiddenBeginCharacters = oth.forbiddenBeginCharacters
            self.forbiddenEndCharacters = oth.forbiddenEndCharacters
            self.applyForbiddenRules = oth.applyForbiddenRules
            self.allowPunctuationOutsideMargin = oth.allowPunctuationOutsideMargin
            self.allowHyphenateEnglish = oth.allowHyphenateEnglish
            return

        kargs = {
            "forbiddenBeginCharacters": forbiddenBeginCharacters,
            "forbiddenEndCharacters": forbiddenEndCharacters,
            "applyForbiddenRules": applyForbiddenRules,
            "allowPunctuationOutsideMargin": allowPunctuationOutsideMargin,
            "allowHyphenateEnglish": allowHyphenateEnglish,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._forbidden_begin_characters = kwargs["forbiddenBeginCharacters"]
        self._forbidden_end_characters = kwargs["forbiddenEndCharacters"]
        self._apply_forbidden_rules = kwargs["applyForbiddenRules"]
        self._allow_punctuation_outside_margin = kwargs["allowPunctuationOutsideMargin"]
        self._allow_hyphenate_english = kwargs["allowHyphenateEnglish"]


    @property
    def forbiddenBeginCharacters(self) -> str:
        """
        Characters not allowed at the beginning of a line.
        """
        return self._forbidden_begin_characters
    
    @forbiddenBeginCharacters.setter
    def forbiddenBeginCharacters(self, value: str) -> None:
        self._forbidden_begin_characters = value

    @property
    def forbiddenEndCharacters(self) -> str:
        """
        Characters not allowed at the end of a line.
        """
        return self._forbidden_end_characters
    
    @forbiddenEndCharacters.setter
    def forbiddenEndCharacters(self, value: str) -> None:
        self._forbidden_end_characters = value

    @property
    def applyForbiddenRules(self) -> bool:
        """
        If the forbidden characters rules are to be applied or not.
        """
        return self._apply_forbidden_rules
    
    @applyForbiddenRules.setter
    def applyForbiddenRules(self, value: bool) -> None:
        self._apply_forbidden_rules = value

    @property
    def allowPunctuationOutsideMargin(self) -> bool:
        """
        If punctuation characters are allowed at the end of the line if outside of the margins, resulting in a line not being wrapped if only the punctuation would wrap.
        """
        return self._allow_punctuation_outside_margin
    
    @allowPunctuationOutsideMargin.setter
    def allowPunctuationOutsideMargin(self, value: bool) -> None:
        self._allow_punctuation_outside_margin = value

    @property
    def allowHyphenateEnglish(self) -> bool:
        """
        Allow English hyphenation.
        """
        return self._allow_hyphenate_english
    
    @allowHyphenateEnglish.setter
    def allowHyphenateEnglish(self, value: bool) -> None:
        self._allow_hyphenate_english = value


__all__ = ['LineBreakUserOptions']
