# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class LocaleDataItem(object):
    """
    Struct Class

    Locale specific data, for example, separators, quotation marks.

    See Also:
        `API LocaleDataItem <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1LocaleDataItem.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.i18n'
    __ooo_full_ns__: str = 'com.sun.star.i18n.LocaleDataItem'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.i18n.LocaleDataItem'
    """Literal Constant ``com.sun.star.i18n.LocaleDataItem``"""

    def __init__(self, unoID: typing.Optional[str] = '', dateSeparator: typing.Optional[str] = '', thousandSeparator: typing.Optional[str] = '', decimalSeparator: typing.Optional[str] = '', timeSeparator: typing.Optional[str] = '', time100SecSeparator: typing.Optional[str] = '', listSeparator: typing.Optional[str] = '', quotationStart: typing.Optional[str] = '', quotationEnd: typing.Optional[str] = '', doubleQuotationStart: typing.Optional[str] = '', doubleQuotationEnd: typing.Optional[str] = '', timeAM: typing.Optional[str] = '', timePM: typing.Optional[str] = '', measurementSystem: typing.Optional[str] = '', LongDateDayOfWeekSeparator: typing.Optional[str] = '', LongDateDaySeparator: typing.Optional[str] = '', LongDateMonthSeparator: typing.Optional[str] = '', LongDateYearSeparator: typing.Optional[str] = '') -> None:
        """
        Constructor

        Arguments:
            unoID (str, optional): unoID value.
            dateSeparator (str, optional): dateSeparator value.
            thousandSeparator (str, optional): thousandSeparator value.
            decimalSeparator (str, optional): decimalSeparator value.
            timeSeparator (str, optional): timeSeparator value.
            time100SecSeparator (str, optional): time100SecSeparator value.
            listSeparator (str, optional): listSeparator value.
            quotationStart (str, optional): quotationStart value.
            quotationEnd (str, optional): quotationEnd value.
            doubleQuotationStart (str, optional): doubleQuotationStart value.
            doubleQuotationEnd (str, optional): doubleQuotationEnd value.
            timeAM (str, optional): timeAM value.
            timePM (str, optional): timePM value.
            measurementSystem (str, optional): measurementSystem value.
            LongDateDayOfWeekSeparator (str, optional): LongDateDayOfWeekSeparator value.
            LongDateDaySeparator (str, optional): LongDateDaySeparator value.
            LongDateMonthSeparator (str, optional): LongDateMonthSeparator value.
            LongDateYearSeparator (str, optional): LongDateYearSeparator value.
        """
        super().__init__()

        if isinstance(unoID, LocaleDataItem):
            oth: LocaleDataItem = unoID
            self.unoID = oth.unoID
            self.dateSeparator = oth.dateSeparator
            self.thousandSeparator = oth.thousandSeparator
            self.decimalSeparator = oth.decimalSeparator
            self.timeSeparator = oth.timeSeparator
            self.time100SecSeparator = oth.time100SecSeparator
            self.listSeparator = oth.listSeparator
            self.quotationStart = oth.quotationStart
            self.quotationEnd = oth.quotationEnd
            self.doubleQuotationStart = oth.doubleQuotationStart
            self.doubleQuotationEnd = oth.doubleQuotationEnd
            self.timeAM = oth.timeAM
            self.timePM = oth.timePM
            self.measurementSystem = oth.measurementSystem
            self.LongDateDayOfWeekSeparator = oth.LongDateDayOfWeekSeparator
            self.LongDateDaySeparator = oth.LongDateDaySeparator
            self.LongDateMonthSeparator = oth.LongDateMonthSeparator
            self.LongDateYearSeparator = oth.LongDateYearSeparator
            return

        kargs = {
            "unoID": unoID,
            "dateSeparator": dateSeparator,
            "thousandSeparator": thousandSeparator,
            "decimalSeparator": decimalSeparator,
            "timeSeparator": timeSeparator,
            "time100SecSeparator": time100SecSeparator,
            "listSeparator": listSeparator,
            "quotationStart": quotationStart,
            "quotationEnd": quotationEnd,
            "doubleQuotationStart": doubleQuotationStart,
            "doubleQuotationEnd": doubleQuotationEnd,
            "timeAM": timeAM,
            "timePM": timePM,
            "measurementSystem": measurementSystem,
            "LongDateDayOfWeekSeparator": LongDateDayOfWeekSeparator,
            "LongDateDaySeparator": LongDateDaySeparator,
            "LongDateMonthSeparator": LongDateMonthSeparator,
            "LongDateYearSeparator": LongDateYearSeparator,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._uno_id = kwargs["unoID"]
        self._date_separator = kwargs["dateSeparator"]
        self._thousand_separator = kwargs["thousandSeparator"]
        self._decimal_separator = kwargs["decimalSeparator"]
        self._time_separator = kwargs["timeSeparator"]
        self._time100_sec_separator = kwargs["time100SecSeparator"]
        self._list_separator = kwargs["listSeparator"]
        self._quotation_start = kwargs["quotationStart"]
        self._quotation_end = kwargs["quotationEnd"]
        self._double_quotation_start = kwargs["doubleQuotationStart"]
        self._double_quotation_end = kwargs["doubleQuotationEnd"]
        self._time_am = kwargs["timeAM"]
        self._time_pm = kwargs["timePM"]
        self._measurement_system = kwargs["measurementSystem"]
        self._long_date_day_of_week_separator = kwargs["LongDateDayOfWeekSeparator"]
        self._long_date_day_separator = kwargs["LongDateDaySeparator"]
        self._long_date_month_separator = kwargs["LongDateMonthSeparator"]
        self._long_date_year_separator = kwargs["LongDateYearSeparator"]


    @property
    def unoID(self) -> str:
        """
        internal ID string, not unique, not meaningful to the outer world
        """
        return self._uno_id
    
    @unoID.setter
    def unoID(self, value: str) -> None:
        self._uno_id = value

    @property
    def dateSeparator(self) -> str:
        """
        date separator, for example, \"/\" or \".\" or \"-\"
        """
        return self._date_separator
    
    @dateSeparator.setter
    def dateSeparator(self, value: str) -> None:
        self._date_separator = value

    @property
    def thousandSeparator(self) -> str:
        """
        group and thousand separator, for example, \",\" or \".\"
        """
        return self._thousand_separator
    
    @thousandSeparator.setter
    def thousandSeparator(self, value: str) -> None:
        self._thousand_separator = value

    @property
    def decimalSeparator(self) -> str:
        """
        decimal separator, for example, \".\" or \",\"
        """
        return self._decimal_separator
    
    @decimalSeparator.setter
    def decimalSeparator(self, value: str) -> None:
        self._decimal_separator = value

    @property
    def timeSeparator(self) -> str:
        """
        time separator, for example, \":\"
        """
        return self._time_separator
    
    @timeSeparator.setter
    def timeSeparator(self, value: str) -> None:
        self._time_separator = value

    @property
    def time100SecSeparator(self) -> str:
        """
        time 100th seconds separator, for example, \",\"
        """
        return self._time100_sec_separator
    
    @time100SecSeparator.setter
    def time100SecSeparator(self, value: str) -> None:
        self._time100_sec_separator = value

    @property
    def listSeparator(self) -> str:
        """
        list separator, for example, \";\"
        """
        return self._list_separator
    
    @listSeparator.setter
    def listSeparator(self, value: str) -> None:
        self._list_separator = value

    @property
    def quotationStart(self) -> str:
        """
        single quotation mark start
        """
        return self._quotation_start
    
    @quotationStart.setter
    def quotationStart(self, value: str) -> None:
        self._quotation_start = value

    @property
    def quotationEnd(self) -> str:
        """
        single quotation mark end
        """
        return self._quotation_end
    
    @quotationEnd.setter
    def quotationEnd(self, value: str) -> None:
        self._quotation_end = value

    @property
    def doubleQuotationStart(self) -> str:
        """
        double quotation mark start
        """
        return self._double_quotation_start
    
    @doubleQuotationStart.setter
    def doubleQuotationStart(self, value: str) -> None:
        self._double_quotation_start = value

    @property
    def doubleQuotationEnd(self) -> str:
        """
        double quotation mark end
        """
        return self._double_quotation_end
    
    @doubleQuotationEnd.setter
    def doubleQuotationEnd(self, value: str) -> None:
        self._double_quotation_end = value

    @property
    def timeAM(self) -> str:
        """
        time AM symbol, for example, \"AM\" or \"am\"
        """
        return self._time_am
    
    @timeAM.setter
    def timeAM(self, value: str) -> None:
        self._time_am = value

    @property
    def timePM(self) -> str:
        """
        time PM symbol, for example, \"PM\" or \"pm\"
        """
        return self._time_pm
    
    @timePM.setter
    def timePM(self, value: str) -> None:
        self._time_pm = value

    @property
    def measurementSystem(self) -> str:
        """
        measurement system, \"metric\" or \"us\"
        """
        return self._measurement_system
    
    @measurementSystem.setter
    def measurementSystem(self, value: str) -> None:
        self._measurement_system = value

    @property
    def LongDateDayOfWeekSeparator(self) -> str:
        """
        long date day of week separator, for example, \", \"
        """
        return self._long_date_day_of_week_separator
    
    @LongDateDayOfWeekSeparator.setter
    def LongDateDayOfWeekSeparator(self, value: str) -> None:
        self._long_date_day_of_week_separator = value

    @property
    def LongDateDaySeparator(self) -> str:
        """
        long date day separator, for example, \", \"
        """
        return self._long_date_day_separator
    
    @LongDateDaySeparator.setter
    def LongDateDaySeparator(self, value: str) -> None:
        self._long_date_day_separator = value

    @property
    def LongDateMonthSeparator(self) -> str:
        """
        long date month separator, for example, \" \"
        """
        return self._long_date_month_separator
    
    @LongDateMonthSeparator.setter
    def LongDateMonthSeparator(self, value: str) -> None:
        self._long_date_month_separator = value

    @property
    def LongDateYearSeparator(self) -> str:
        """
        long date year separator, for example, \" \"
        """
        return self._long_date_year_separator
    
    @LongDateYearSeparator.setter
    def LongDateYearSeparator(self, value: str) -> None:
        self._long_date_year_separator = value


__all__ = ['LocaleDataItem']
