# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.lang
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XUnoTunnel(XInterface_8f010a43):
    """
    An interface to tunnel UNO.
    
    This means providing access to data or something else, which is not specified by UNO-IDL.
    
    Common usage: Getting a C++ object pointer in the same process, thus to use an implementation directly, most often because of a design flaw.

    See Also:
        `API XUnoTunnel <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1lang_1_1XUnoTunnel.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.lang'
    __ooo_full_ns__: str = 'com.sun.star.lang.XUnoTunnel'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.lang.XUnoTunnel'

    @abstractmethod
    def getSomething(self, aIdentifier: 'typing.Tuple[int, ...]') -> int:
        """
        Call this method to get something which is not specified in UNO, e.g.
        
        an address to some C++ object.
        """

__all__ = ['XUnoTunnel']

