# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.logging
import typing
from abc import abstractmethod, abstractproperty, ABC
if typing.TYPE_CHECKING:
    from .x_log_handler import XLogHandler as XLogHandler_c7f80c27

class XLogger(ABC):
    """
    implemented by a component which is able to log events.
    
    This interface is roughly designed after the Java Logging API. However, there are some differences, the major ones being:
    
    **since**
    
        OOo 2.3

    See Also:
        `API XLogger <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1logging_1_1XLogger.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.logging'
    __ooo_full_ns__: str = 'com.sun.star.logging.XLogger'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.logging.XLogger'

    @abstractmethod
    def addLogHandler(self, LogHandler: 'XLogHandler_c7f80c27') -> None:
        """
        adds the given handler to the list of handlers.
        
        When an event is logged, the logger will create a LogRecord for this event, and pass this record to all registered handlers. Single handlers might or might not log those records at their own discretion, and depending on additional restrictions such as filters specified at handler level.
        
        Note: The log level of the given handler (XLogHandler.Level) will not be touched. In particular, it will not be set to the logger's log level. It's the responsibility of the component which knits a logger with one or more log handlers to ensure that all loggers have appropriate levels set.
        """
    @abstractmethod
    def isLoggable(self, Level: int) -> bool:
        """
        determines whether logger instance would produce any output for the given level.
        
        The method can be used to optimize performance as maybe complex parameter evaluation in the log calls can be omitted if isLoggable evaluates to false.
        """
    @abstractmethod
    def log(self, Level: int, Message: str) -> None:
        """
        logs a given message
        """
    @abstractmethod
    def logp(self, Level: int, SourceClass: str, SourceMethod: str, Message: str) -> None:
        """
        logs a given message, detailing the source class and method at which the logged event occurred.
        """
    @abstractmethod
    def removeLogHandler(self, LogHandler: 'XLogHandler_c7f80c27') -> None:
        """
        removes the given handler from the list of handlers.
        """
    @abstractproperty
    def Level(self) -> int:
        """
        specifies which log events are logged or ignored.
        """

    @abstractproperty
    def Name(self) -> str:
        """
        denotes the name of the logger.
        """


__all__ = ['XLogger']

