# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sdb
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
from .row_change_event import RowChangeEvent as RowChangeEvent_ba0c0bc1
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing


class RowsChangeEvent(RowChangeEvent_ba0c0bc1):
    """
    Struct Class

    indicates which rows have changed and the type of change action on the row set.

    See Also:
        `API RowsChangeEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sdb_1_1RowsChangeEvent.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sdb'
    __ooo_full_ns__: str = 'com.sun.star.sdb.RowsChangeEvent'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sdb.RowsChangeEvent'
    """Literal Constant ``com.sun.star.sdb.RowsChangeEvent``"""

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = None, Action: typing.Optional[int] = 0, Rows: typing.Optional[int] = 0, Bookmarks: typing.Optional[typing.Tuple[object, ...]] = UNO_NONE) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Action (int, optional): Action value.
            Rows (int, optional): Rows value.
            Bookmarks (typing.Tuple[object, ...], optional): Bookmarks value.
        """

        if isinstance(Source, RowsChangeEvent):
            oth: RowsChangeEvent = Source
            self.Source = oth.Source
            self.Action = oth.Action
            self.Rows = oth.Rows
            self.Bookmarks = oth.Bookmarks
            return

        kargs = {
            "Source": Source,
            "Action": Action,
            "Rows": Rows,
            "Bookmarks": Bookmarks,
        }
        if kargs["Bookmarks"] is UNO_NONE:
            kargs["Bookmarks"] = None
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._bookmarks = kwargs["Bookmarks"]
        inst_keys = ('Bookmarks',)
        kargs = kwargs.copy()
        for key in inst_keys:
            del kargs[key]
        super()._init(**kargs)


    @property
    def Bookmarks(self) -> typing.Tuple[object, ...]:
        return self._bookmarks
    
    @Bookmarks.setter
    def Bookmarks(self, value: typing.Tuple[object, ...]) -> None:
        self._bookmarks = value


__all__ = ['RowsChangeEvent']
