# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.sheet
import typing
from abc import abstractproperty
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
from ..container.x_named import XNamed as XNamed_a6520b08
from .x_cell_range_referrer import XCellRangeReferrer as XCellRangeReferrer_91c0e23
from .x_database_range import XDatabaseRange as XDatabaseRange_d37b0c7b
from ..util.x_refreshable import XRefreshable as XRefreshable_b0d60b81
if typing.TYPE_CHECKING:
    from ..table.cell_range_address import CellRangeAddress as CellRangeAddress_ec450d43

class DatabaseRange(XPropertySet_bc180bfa, XNamed_a6520b08, XCellRangeReferrer_91c0e23, XDatabaseRange_d37b0c7b, XRefreshable_b0d60b81):
    """
    Service Class

    represents a database range in a spreadsheet document.
    
    A database range is a name for a cell range that also stores filtering, sorting, subtotal and data import settings and options.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API DatabaseRange <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1sheet_1_1DatabaseRange.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.DatabaseRange'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def AutoFilter(self) -> bool:
        """
        specifies whether the AutoFilter is enabled or not.
        
        **since**
        
            OOo 1.1.2
        """

    @abstractproperty
    def ContainsHeader(self) -> bool:
        """
        specifies whether this range includes a top row of headers.
        
        **since**
        
            LibreOffice 5.0
        """

    @abstractproperty
    def FilterCriteriaSource(self) -> 'CellRangeAddress_ec450d43':
        """
        specifies the range where the filter can find the filter criteria.
        
        This is only used if SheetFilterDescriptor.UseFilterCriteriaSource is TRUE.
        
        **since**
        
            OOo 1.1.2
        """

    @abstractproperty
    def FromSelection(self) -> bool:
        """
        specifies whether the imported data is only a selection of the database.
        
        **since**
        
            OOo 2.0
        """

    @abstractproperty
    def KeepFormats(self) -> bool:
        """
        if this property is set, cell formats are extended when the size of the range is changed by an update operation.
        """

    @abstractproperty
    def MoveCells(self) -> bool:
        """
        if this property is set, columns or rows are inserted or deleted when the size of the range is changed by an update operation.
        """

    @abstractproperty
    def RefreshPeriod(self) -> int:
        """
        specifies the time between two refresh actions in seconds.
        
        **since**
        
            OOo 2.0
        """

    @abstractproperty
    def StripData(self) -> bool:
        """
        if this property is set, the cell contents within the database range are left out when the document is saved.
        """

    @abstractproperty
    def TokenIndex(self) -> int:
        """
        returns the index used to refer to this range in token arrays.
        
        A token describing a database range shall contain the op-code obtained from the FormulaMapGroupSpecialOffset.DB_AREA and this index as data part.
        
        **since**
        
            OOo 3.0
        """

    @abstractproperty
    def TotalsRow(self) -> bool:
        """
        specifies whether this range includes a bottom row of totals.
        
        **since**
        
            LibreOffice 5.0
        """

    @abstractproperty
    def UseFilterCriteriaSource(self) -> bool:
        """
        specifies whether the filter criteria should be taken from a CellRange.
        
        **since**
        
            OOo 1.1.2
        """



__all__ = ['DatabaseRange']

