# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class MemberResult(object):
    """
    Struct Class

    describes a result of a DataPilot member.
    
    **since**
    
        LibreOffice 5.3

    See Also:
        `API MemberResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1MemberResult.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.sheet'
    __ooo_full_ns__: str = 'com.sun.star.sheet.MemberResult'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.sheet.MemberResult'
    """Literal Constant ``com.sun.star.sheet.MemberResult``"""

    def __init__(self, Name: typing.Optional[str] = '', Caption: typing.Optional[str] = '', Flags: typing.Optional[int] = 0, Value: typing.Optional[float] = 0.0) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Caption (str, optional): Caption value.
            Flags (int, optional): Flags value.
            Value (float, optional): Value value.
        """
        super().__init__()

        if isinstance(Name, MemberResult):
            oth: MemberResult = Name
            self.Name = oth.Name
            self.Caption = oth.Caption
            self.Flags = oth.Flags
            self.Value = oth.Value
            return

        kargs = {
            "Name": Name,
            "Caption": Caption,
            "Flags": Flags,
            "Value": Value,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["Name"]
        self._caption = kwargs["Caption"]
        self._flags = kwargs["Flags"]
        self._value = kwargs["Value"]


    @property
    def Name(self) -> str:
        """
        the internal name of the field.
        """
        return self._name
    
    @Name.setter
    def Name(self, value: str) -> None:
        self._name = value

    @property
    def Caption(self) -> str:
        """
        the visible name of the field.
        """
        return self._caption
    
    @Caption.setter
    def Caption(self, value: str) -> None:
        self._caption = value

    @property
    def Flags(self) -> int:
        """
        contains flags describing the result.
        """
        return self._flags
    
    @Flags.setter
    def Flags(self, value: int) -> None:
        self._flags = value

    @property
    def Value(self) -> float:
        """
        the underlying numeric value of the field if Flags indicate so by having com.sun.star.sheet.MemberResultFlags.NUMERIC set.
        
        May be NaN if value is not available or unknown.
        
        **since**
        
            LibreOffice 5.3
        """
        return self._value
    
    @Value.setter
    def Value(self, value: float) -> None:
        self._value = value


__all__ = ['MemberResult']
