# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.style
import typing
from abc import abstractproperty
from ..beans.x_multi_property_set import XMultiPropertySet as XMultiPropertySet_fd880e05
from ..beans.x_multi_property_states import XMultiPropertyStates as XMultiPropertyStates_2a3e0f4d
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
from .x_style import XStyle as XStyle_7c7f09a2
from ..xml.user_defined_attributes_supplier import UserDefinedAttributesSupplier as UserDefinedAttributesSupplier_9fbe1222
if typing.TYPE_CHECKING:
    from ..beans.named_value import NamedValue as NamedValue_a37a0af3
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73

class Style(UserDefinedAttributesSupplier_9fbe1222, XMultiPropertySet_fd880e05, XMultiPropertyStates_2a3e0f4d, XPropertySet_bc180bfa, XStyle_7c7f09a2):
    """
    Service Class

    This service specifies a single style sheet.
    
    **since**
    
        OOo 2.0.1

    See Also:
        `API Style <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1style_1_1Style.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.style'
    __ooo_full_ns__: str = 'com.sun.star.style.Style'
    __ooo_type_name__: str = 'service'

    @abstractproperty
    def ParaStyleConditions(self) -> 'typing.Tuple[NamedValue_a37a0af3, ...]':
        """
        defines the context and styles for conditional paragraphs.
        
        This property is only available if the style is a conditional paragraph style.
        
        The sequence consists of pairs where the name part of the pair defines the context where it should be applied and the value part is a string naming the style to be used in that context.
        
        Assigning an empty string to the style name will disable the conditional style for that context.
        
        The allowed strings (contexts) for the name part of an entry of the sequence are:
        
        **since**
        
            OOo 2.0.1
        """

    @abstractproperty
    def StyleInteropGrabBag(self) -> 'typing.Tuple[PropertyValue_c9610c73, ...]':
        """
        Grab bag of style properties, used as a string-any map for interim interop purposes.
        
        This property is intentionally not handled by the ODF filter. Any member that should be handled there should be first moved out from this grab bag to a separate property.
        
        **since**
        
            LibreOffice 4.2
        """

    @abstractproperty
    def DisplayName(self) -> str:
        """
        contains the name of the style as it is displayed in the user interface.
        
        The names of the styles at the API are language independent. The user interface names are localized.
        """

    @abstractproperty
    def FollowStyle(self) -> str:
        """
        contains the name of the style that is applied to the next paragraph.
        
        This property is usually available at paragraph styles only.
        """

    @abstractproperty
    def Hidden(self) -> bool:
        """
        Flag indicating whether to hide the style in the UI.
        
        **since**
        
            LibreOffice 4.0
        """

    @abstractproperty
    def IsAutoUpdate(self) -> str:
        """
        determines if a style is automatically updated, if the properties of an object that the style is applied to are changed.
        
        For example, if the style is applied to a paragraph and the properties of the paragraph are changed then the style will be updated accordingly.
        """

    @abstractproperty
    def IsPhysical(self) -> bool:
        """
        determines if a style is physically created.
        
        Built in styles may not be created until they are needed. To prevent standard style properties from being exported, it may be useful to check if the style is created first.
        """



__all__ = ['Style']

