# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class CellRangeAddress(object):
    """
    Struct Class

    contains a cell range address within a spreadsheet document.

    See Also:
        `API CellRangeAddress <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1CellRangeAddress.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.table'
    __ooo_full_ns__: str = 'com.sun.star.table.CellRangeAddress'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.table.CellRangeAddress'
    """Literal Constant ``com.sun.star.table.CellRangeAddress``"""

    def __init__(self, Sheet: typing.Optional[int] = 0, StartColumn: typing.Optional[int] = 0, StartRow: typing.Optional[int] = 0, EndColumn: typing.Optional[int] = 0, EndRow: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Sheet (int, optional): Sheet value.
            StartColumn (int, optional): StartColumn value.
            StartRow (int, optional): StartRow value.
            EndColumn (int, optional): EndColumn value.
            EndRow (int, optional): EndRow value.
        """
        super().__init__()

        if isinstance(Sheet, CellRangeAddress):
            oth: CellRangeAddress = Sheet
            self.Sheet = oth.Sheet
            self.StartColumn = oth.StartColumn
            self.StartRow = oth.StartRow
            self.EndColumn = oth.EndColumn
            self.EndRow = oth.EndRow
            return

        kargs = {
            "Sheet": Sheet,
            "StartColumn": StartColumn,
            "StartRow": StartRow,
            "EndColumn": EndColumn,
            "EndRow": EndRow,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._sheet = kwargs["Sheet"]
        self._start_column = kwargs["StartColumn"]
        self._start_row = kwargs["StartRow"]
        self._end_column = kwargs["EndColumn"]
        self._end_row = kwargs["EndRow"]


    @property
    def Sheet(self) -> int:
        """
        is the index of the sheet that contains the cell range.
        """
        return self._sheet
    
    @Sheet.setter
    def Sheet(self, value: int) -> None:
        self._sheet = value

    @property
    def StartColumn(self) -> int:
        """
        is the index of the column of the left edge of the range.
        """
        return self._start_column
    
    @StartColumn.setter
    def StartColumn(self, value: int) -> None:
        self._start_column = value

    @property
    def StartRow(self) -> int:
        """
        is the index of the row of the top edge of the range.
        """
        return self._start_row
    
    @StartRow.setter
    def StartRow(self, value: int) -> None:
        self._start_row = value

    @property
    def EndColumn(self) -> int:
        """
        is the index of the column of the right edge of the range.
        """
        return self._end_column
    
    @EndColumn.setter
    def EndColumn(self, value: int) -> None:
        self._end_column = value

    @property
    def EndRow(self) -> int:
        """
        is the index of the row of the bottom edge of the range.
        """
        return self._end_row
    
    @EndRow.setter
    def EndRow(self, value: int) -> None:
        self._end_row = value


__all__ = ['CellRangeAddress']
