# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.text


class TemplateDisplayFormat(object):
    """
    Const Class

    These constants are used to specify which information about a template is displayed in a field.

    See Also:
        `API TemplateDisplayFormat <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1text_1_1TemplateDisplayFormat.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.text'
    __ooo_full_ns__: str = 'com.sun.star.text.TemplateDisplayFormat'
    __ooo_type_name__: str = 'const'

    FULL = 0
    PATH = 1
    NAME = 2
    """
    Only the file name, without file extension, of the template file will be displayed.
    """
    NAME_AND_EXT = 3
    """
    The file name and the file extension of the template file will be displayed.
    """
    AREA = 4
    """
    The name of the template area is displayed.
    """
    TITLE = 5
    """
    The title of the template file is displayed.
    """

__all__ = ['TemplateDisplayFormat']
