# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.text
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class TextPosition(object):
    """
    Struct Class


    See Also:
        `API TextPosition <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1text_1_1TextPosition.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.text'
    __ooo_full_ns__: str = 'com.sun.star.text.TextPosition'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.text.TextPosition'
    """Literal Constant ``com.sun.star.text.TextPosition``"""

    def __init__(self, Paragraph: typing.Optional[int] = 0, PositionInParagraph: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Paragraph (int, optional): Paragraph value.
            PositionInParagraph (int, optional): PositionInParagraph value.
        """
        super().__init__()

        if isinstance(Paragraph, TextPosition):
            oth: TextPosition = Paragraph
            self.Paragraph = oth.Paragraph
            self.PositionInParagraph = oth.PositionInParagraph
            return

        kargs = {
            "Paragraph": Paragraph,
            "PositionInParagraph": PositionInParagraph,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._paragraph = kwargs["Paragraph"]
        self._position_in_paragraph = kwargs["PositionInParagraph"]


    @property
    def Paragraph(self) -> int:
        return self._paragraph
    
    @Paragraph.setter
    def Paragraph(self, value: int) -> None:
        self._paragraph = value

    @property
    def PositionInParagraph(self) -> int:
        return self._position_in_paragraph
    
    @PositionInParagraph.setter
    def PositionInParagraph(self, value: int) -> None:
        self._position_in_paragraph = value


__all__ = ['TextPosition']
