# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.2
from ooo.oenv import UNO_NONE
import typing


class SortingInfo(object):
    """
    Struct Class

    contains a sorting info.

    See Also:
        `API SortingInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1SortingInfo.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.ucb'
    __ooo_full_ns__: str = 'com.sun.star.ucb.SortingInfo'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.ucb.SortingInfo'
    """Literal Constant ``com.sun.star.ucb.SortingInfo``"""

    def __init__(self, PropertyName: typing.Optional[str] = '', Ascending: typing.Optional[bool] = False) -> None:
        """
        Constructor

        Arguments:
            PropertyName (str, optional): PropertyName value.
            Ascending (bool, optional): Ascending value.
        """
        super().__init__()

        if isinstance(PropertyName, SortingInfo):
            oth: SortingInfo = PropertyName
            self.PropertyName = oth.PropertyName
            self.Ascending = oth.Ascending
            return

        kargs = {
            "PropertyName": PropertyName,
            "Ascending": Ascending,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._property_name = kwargs["PropertyName"]
        self._ascending = kwargs["Ascending"]


    @property
    def PropertyName(self) -> str:
        """
        specifies the name of a property to use for sorting ( e.g.
        
        \"Title\" ).
        """
        return self._property_name
    
    @PropertyName.setter
    def PropertyName(self, value: str) -> None:
        self._property_name = value

    @property
    def Ascending(self) -> bool:
        """
        contains a flag indicating the sort mode (ascending or descending).
        """
        return self._ascending
    
    @Ascending.setter
    def Ascending(self, value: bool) -> None:
        self._ascending = value


__all__ = ['SortingInfo']
