import { Construct } from 'constructs';
import { StreamingConfig } from './appInstance';
/**
 * Props for `PutAppInstanceStreamingConfigurations`.
 * See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_PutAppInstanceStreamingConfigurations.html
 */
export interface StreamingConfigurationProps {
    /**
     * The ARN of the App Instance
     *
     * @default - None
     */
    readonly appInstanceArn: string;
    /**
     * The AppInstanceStreamingConfigurations
     *
     * @default - None
     */
    readonly streamingConfigs: Array<StreamingConfig>;
}
export declare class AppInstanceStreamingConfigurations extends Construct {
    readonly streamingConfigs: Array<StreamingConfig>;
    constructor(scope: Construct, id: string, props: StreamingConfigurationProps);
}
