from setuptools import setup

setup(
    name="brunnhilde",
    version="1.9.5",
    url="https://github.com/tw4l/brunnhilde",
    author="Tessa Walsh",
    author_email="tessa@bitarchivist.net",
    py_modules=["brunnhilde"],
    scripts=["brunnhilde.py"],
    description="A Siegfried-based digital archives reporting tool for directories and disk images",
    keywords="archives reporting characterization identification diskimages",
    platforms=["POSIX", "Windows"],
    install_requires=[],
    test_suite="test",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved :: MIT License",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: Developers",
        "Natural Language :: English",
        "Operating System :: MacOS",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: POSIX :: Linux",
        "Operating System :: Microsoft :: Windows",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Topic :: System :: Archiving",
        "Topic :: System :: Filesystems",
        "Topic :: Utilities",
    ],
)
