import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BranchConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name for this branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch#name Branch#name}
    */
    readonly name: string;
    /**
    * The ID or full path of the project which the branch is created against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch#project Branch#project}
    */
    readonly project: string;
    /**
    * The ref which the branch is created from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch#ref Branch#ref}
    */
    readonly ref: string;
}
export interface BranchCommit {
}
export declare function branchCommitToTerraform(struct?: BranchCommit): any;
export declare class BranchCommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BranchCommit | undefined;
    set internalValue(value: BranchCommit | undefined);
    get authorEmail(): string;
    get authorName(): string;
    get authoredDate(): string;
    get committedDate(): string;
    get committerEmail(): string;
    get committerName(): string;
    get id(): string;
    get message(): string;
    get parentIds(): string[];
    get shortId(): string;
    get title(): string;
}
export declare class BranchCommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BranchCommitOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch gitlab_branch}
*/
export declare class Branch extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_branch";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/branch gitlab_branch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BranchConfig
    */
    constructor(scope: Construct, id: string, config: BranchConfig);
    get canPush(): cdktf.IResolvable;
    private _commit;
    get commit(): BranchCommitList;
    get default(): cdktf.IResolvable;
    get developerCanMerge(): cdktf.IResolvable;
    get developerCanPush(): cdktf.IResolvable;
    get id(): string;
    get merged(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get protected(): cdktf.IResolvable;
    private _ref?;
    get ref(): string;
    set ref(value: string);
    get refInput(): string | undefined;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=branch.d.ts.map