import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership#access_level DataGitlabGroupMembership#access_level}
    */
    readonly accessLevel?: string;
    /**
    * The full path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership#full_path DataGitlabGroupMembership#full_path}
    */
    readonly fullPath?: string;
    /**
    * The ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership#group_id DataGitlabGroupMembership#group_id}
    */
    readonly groupId?: number;
}
export interface DataGitlabGroupMembershipMembers {
}
export declare function dataGitlabGroupMembershipMembersToTerraform(struct?: DataGitlabGroupMembershipMembers): any;
export declare class DataGitlabGroupMembershipMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabGroupMembershipMembers | undefined;
    set internalValue(value: DataGitlabGroupMembershipMembers | undefined);
    get accessLevel(): string;
    get avatarUrl(): string;
    get expiresAt(): string;
    get id(): number;
    get name(): string;
    get state(): string;
    get username(): string;
    get webUrl(): string;
}
export declare class DataGitlabGroupMembershipMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabGroupMembershipMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership gitlab_group_membership}
*/
export declare class DataGitlabGroupMembership extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership gitlab_group_membership} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupMembershipConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabGroupMembershipConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _fullPath?;
    get fullPath(): string;
    set fullPath(value: string);
    resetFullPath(): void;
    get fullPathInput(): string | undefined;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    get id(): string;
    private _members;
    get members(): DataGitlabGroupMembershipMembersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-gitlab-group-membership.d.ts.map