import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#environment_scope GroupVariable#environment_scope}
    */
    readonly environmentScope?: string;
    /**
    * The name or id of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#group GroupVariable#group}
    */
    readonly group: string;
    /**
    * The name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#key GroupVariable#key}
    */
    readonly key: string;
    /**
    * If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#masked GroupVariable#masked}
    */
    readonly masked?: boolean | cdktf.IResolvable;
    /**
    * If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#protected GroupVariable#protected}
    */
    readonly protected?: boolean | cdktf.IResolvable;
    /**
    * The value of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#value GroupVariable#value}
    */
    readonly value: string;
    /**
    * The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable#variable_type GroupVariable#variable_type}
    */
    readonly variableType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable gitlab_group_variable}
*/
export declare class GroupVariable extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_variable gitlab_group_variable} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupVariableConfig
    */
    constructor(scope: Construct, id: string, config: GroupVariableConfig);
    private _environmentScope?;
    get environmentScope(): string;
    set environmentScope(value: string);
    resetEnvironmentScope(): void;
    get environmentScopeInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _masked?;
    get masked(): boolean | cdktf.IResolvable;
    set masked(value: boolean | cdktf.IResolvable);
    resetMasked(): void;
    get maskedInput(): boolean | cdktf.IResolvable | undefined;
    private _protected?;
    get protected(): boolean | cdktf.IResolvable;
    set protected(value: boolean | cdktf.IResolvable);
    resetProtected(): void;
    get protectedInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _variableType?;
    get variableType(): string;
    set variableType(value: string);
    resetVariableType(): void;
    get variableTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group-variable.d.ts.map