import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceSlackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Branches to send notifications for. Valid options are "all", "default", "protected", and "default_and_protected".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#branches_to_be_notified ServiceSlack#branches_to_be_notified}
    */
    readonly branchesToBeNotified?: string;
    /**
    * The name of the channel to receive confidential issue events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#confidential_issue_channel ServiceSlack#confidential_issue_channel}
    */
    readonly confidentialIssueChannel?: string;
    /**
    * Enable notifications for confidential issues events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#confidential_issues_events ServiceSlack#confidential_issues_events}
    */
    readonly confidentialIssuesEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for confidential note events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#confidential_note_events ServiceSlack#confidential_note_events}
    */
    readonly confidentialNoteEvents?: boolean | cdktf.IResolvable;
    /**
    * The name of the channel to receive issue events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#issue_channel ServiceSlack#issue_channel}
    */
    readonly issueChannel?: string;
    /**
    * Enable notifications for issues events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#issues_events ServiceSlack#issues_events}
    */
    readonly issuesEvents?: boolean | cdktf.IResolvable;
    /**
    * The name of the channel to receive merge request events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#merge_request_channel ServiceSlack#merge_request_channel}
    */
    readonly mergeRequestChannel?: string;
    /**
    * Enable notifications for merge requests events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#merge_requests_events ServiceSlack#merge_requests_events}
    */
    readonly mergeRequestsEvents?: boolean | cdktf.IResolvable;
    /**
    * The name of the channel to receive note events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#note_channel ServiceSlack#note_channel}
    */
    readonly noteChannel?: string;
    /**
    * Enable notifications for note events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#note_events ServiceSlack#note_events}
    */
    readonly noteEvents?: boolean | cdktf.IResolvable;
    /**
    * Send notifications for broken pipelines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#notify_only_broken_pipelines ServiceSlack#notify_only_broken_pipelines}
    */
    readonly notifyOnlyBrokenPipelines?: boolean | cdktf.IResolvable;
    /**
    * This parameter has been replaced with `branches_to_be_notified`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#notify_only_default_branch ServiceSlack#notify_only_default_branch}
    */
    readonly notifyOnlyDefaultBranch?: boolean | cdktf.IResolvable;
    /**
    * The name of the channel to receive pipeline events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#pipeline_channel ServiceSlack#pipeline_channel}
    */
    readonly pipelineChannel?: string;
    /**
    * Enable notifications for pipeline events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#pipeline_events ServiceSlack#pipeline_events}
    */
    readonly pipelineEvents?: boolean | cdktf.IResolvable;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#project ServiceSlack#project}
    */
    readonly project: string;
    /**
    * The name of the channel to receive push events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#push_channel ServiceSlack#push_channel}
    */
    readonly pushChannel?: string;
    /**
    * Enable notifications for push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#push_events ServiceSlack#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * The name of the channel to receive tag push events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#tag_push_channel ServiceSlack#tag_push_channel}
    */
    readonly tagPushChannel?: string;
    /**
    * Enable notifications for tag push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#tag_push_events ServiceSlack#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
    /**
    * Username to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#username ServiceSlack#username}
    */
    readonly username?: string;
    /**
    * Webhook URL (ex.: https://hooks.slack.com/services/...)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#webhook ServiceSlack#webhook}
    */
    readonly webhook: string;
    /**
    * The name of the channel to receive wiki page events notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#wiki_page_channel ServiceSlack#wiki_page_channel}
    */
    readonly wikiPageChannel?: string;
    /**
    * Enable notifications for wiki page events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack#wiki_page_events ServiceSlack#wiki_page_events}
    */
    readonly wikiPageEvents?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack}
*/
export declare class ServiceSlack extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_slack";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceSlackConfig
    */
    constructor(scope: Construct, id: string, config: ServiceSlackConfig);
    private _branchesToBeNotified?;
    get branchesToBeNotified(): string;
    set branchesToBeNotified(value: string);
    resetBranchesToBeNotified(): void;
    get branchesToBeNotifiedInput(): string | undefined;
    private _confidentialIssueChannel?;
    get confidentialIssueChannel(): string;
    set confidentialIssueChannel(value: string);
    resetConfidentialIssueChannel(): void;
    get confidentialIssueChannelInput(): string | undefined;
    private _confidentialIssuesEvents?;
    get confidentialIssuesEvents(): boolean | cdktf.IResolvable;
    set confidentialIssuesEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialIssuesEvents(): void;
    get confidentialIssuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _confidentialNoteEvents?;
    get confidentialNoteEvents(): boolean | cdktf.IResolvable;
    set confidentialNoteEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialNoteEvents(): void;
    get confidentialNoteEventsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _issueChannel?;
    get issueChannel(): string;
    set issueChannel(value: string);
    resetIssueChannel(): void;
    get issueChannelInput(): string | undefined;
    private _issuesEvents?;
    get issuesEvents(): boolean | cdktf.IResolvable;
    set issuesEvents(value: boolean | cdktf.IResolvable);
    resetIssuesEvents(): void;
    get issuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    get jobEvents(): cdktf.IResolvable;
    private _mergeRequestChannel?;
    get mergeRequestChannel(): string;
    set mergeRequestChannel(value: string);
    resetMergeRequestChannel(): void;
    get mergeRequestChannelInput(): string | undefined;
    private _mergeRequestsEvents?;
    get mergeRequestsEvents(): boolean | cdktf.IResolvable;
    set mergeRequestsEvents(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEvents(): void;
    get mergeRequestsEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _noteChannel?;
    get noteChannel(): string;
    set noteChannel(value: string);
    resetNoteChannel(): void;
    get noteChannelInput(): string | undefined;
    private _noteEvents?;
    get noteEvents(): boolean | cdktf.IResolvable;
    set noteEvents(value: boolean | cdktf.IResolvable);
    resetNoteEvents(): void;
    get noteEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyOnlyBrokenPipelines?;
    get notifyOnlyBrokenPipelines(): boolean | cdktf.IResolvable;
    set notifyOnlyBrokenPipelines(value: boolean | cdktf.IResolvable);
    resetNotifyOnlyBrokenPipelines(): void;
    get notifyOnlyBrokenPipelinesInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyOnlyDefaultBranch?;
    get notifyOnlyDefaultBranch(): boolean | cdktf.IResolvable;
    set notifyOnlyDefaultBranch(value: boolean | cdktf.IResolvable);
    resetNotifyOnlyDefaultBranch(): void;
    get notifyOnlyDefaultBranchInput(): boolean | cdktf.IResolvable | undefined;
    private _pipelineChannel?;
    get pipelineChannel(): string;
    set pipelineChannel(value: string);
    resetPipelineChannel(): void;
    get pipelineChannelInput(): string | undefined;
    private _pipelineEvents?;
    get pipelineEvents(): boolean | cdktf.IResolvable;
    set pipelineEvents(value: boolean | cdktf.IResolvable);
    resetPipelineEvents(): void;
    get pipelineEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _pushChannel?;
    get pushChannel(): string;
    set pushChannel(value: string);
    resetPushChannel(): void;
    get pushChannelInput(): string | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagPushChannel?;
    get tagPushChannel(): string;
    set tagPushChannel(value: string);
    resetTagPushChannel(): void;
    get tagPushChannelInput(): string | undefined;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    get webhookInput(): string | undefined;
    private _wikiPageChannel?;
    get wikiPageChannel(): string;
    set wikiPageChannel(value: string);
    resetWikiPageChannel(): void;
    get wikiPageChannelInput(): string | undefined;
    private _wikiPageEvents?;
    get wikiPageEvents(): boolean | cdktf.IResolvable;
    set wikiPageEvents(value: boolean | cdktf.IResolvable);
    resetWikiPageEvents(): void;
    get wikiPageEventsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=service-slack.d.ts.map