import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
 *
 * @experimental
 */
export declare class Clouddirectory extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Adds a new Facet to an object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AddFacetToObject.html
     *
     * @experimental
     */
    toAddFacetToObject(): this;
    /**
     * (experimental) Copies input published schema into Directory with same name and version as that of published schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ApplySchema.html
     *
     * @experimental
     */
    toApplySchema(): this;
    /**
     * (experimental) Attaches an existing object to another existing object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachObject.html
     *
     * @experimental
     */
    toAttachObject(): this;
    /**
     * (experimental) Attaches a policy object to any other object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachPolicy.html
     *
     * @experimental
     */
    toAttachPolicy(): this;
    /**
     * (experimental) Attaches the specified object to the specified index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachToIndex.html
     *
     * @experimental
     */
    toAttachToIndex(): this;
    /**
     * (experimental) Attaches a typed link b/w a source & target object reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachTypedLink.html
     *
     * @experimental
     */
    toAttachTypedLink(): this;
    /**
     * (experimental) Performs all the read operations in a batch. Each individual operation inside BatchRead needs to be granted permissions explicitly.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchRead.html
     *
     * @experimental
     */
    toBatchRead(): this;
    /**
     * (experimental) Performs all the write operations in a batch. Each individual operation inside BatchWrite needs to be granted permissions explicitly.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchWrite.html
     *
     * @experimental
     */
    toBatchWrite(): this;
    /**
     * (experimental) Creates a Directory by copying the published schema into the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateDirectory.html
     *
     * @experimental
     */
    toCreateDirectory(): this;
    /**
     * (experimental) Creates a new Facet in a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateFacet.html
     *
     * @experimental
     */
    toCreateFacet(): this;
    /**
     * (experimental) Creates an index object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateIndex.html
     *
     * @experimental
     */
    toCreateIndex(): this;
    /**
     * (experimental) Creates an object in a Directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateObject.html
     *
     * @experimental
     */
    toCreateObject(): this;
    /**
     * (experimental) Creates a new schema in a development state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateSchema.html
     *
     * @experimental
     */
    toCreateSchema(): this;
    /**
     * (experimental) Creates a new Typed Link facet in a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateTypedLinkFacet.html
     *
     * @experimental
     */
    toCreateTypedLinkFacet(): this;
    /**
     * (experimental) Deletes a directory. Only disabled directories can be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteDirectory.html
     *
     * @experimental
     */
    toDeleteDirectory(): this;
    /**
     * (experimental) Deletes a given Facet. All attributes and Rules associated with the facet will be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteFacet.html
     *
     * @experimental
     */
    toDeleteFacet(): this;
    /**
     * (experimental) Deletes an object and its associated attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteObject.html
     *
     * @experimental
     */
    toDeleteObject(): this;
    /**
     * (experimental) Deletes a given schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteSchema.html
     *
     * @experimental
     */
    toDeleteSchema(): this;
    /**
     * (experimental) Deletes a given TypedLink Facet. All attributes and Rules associated with the facet will be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteTypedLinkFacet.html
     *
     * @experimental
     */
    toDeleteTypedLinkFacet(): this;
    /**
     * (experimental) Detaches the specified object from the specified index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachFromIndex.html
     *
     * @experimental
     */
    toDetachFromIndex(): this;
    /**
     * (experimental) Detaches a given object from the parent object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachObject.html
     *
     * @experimental
     */
    toDetachObject(): this;
    /**
     * (experimental) Detaches a policy from an object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachPolicy.html
     *
     * @experimental
     */
    toDetachPolicy(): this;
    /**
     * (experimental) Detaches a given typed link b/w given source and target object reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachTypedLink.html
     *
     * @experimental
     */
    toDetachTypedLink(): this;
    /**
     * (experimental) Disables the specified directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DisableDirectory.html
     *
     * @experimental
     */
    toDisableDirectory(): this;
    /**
     * (experimental) Enables the specified directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_EnableDirectory.html
     *
     * @experimental
     */
    toEnableDirectory(): this;
    /**
     * (experimental) Retrieves metadata about a directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetDirectory.html
     *
     * @experimental
     */
    toGetDirectory(): this;
    /**
     * (experimental) Gets details of the Facet, such as Facet Name, Attributes, Rules, or ObjectType.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetFacet.html
     *
     * @experimental
     */
    toGetFacet(): this;
    /**
     * (experimental) Retrieves attributes that are associated with a typed link.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetLinkAttributes.html
     *
     * @experimental
     */
    toGetLinkAttributes(): this;
    /**
     * (experimental) Retrieves attributes within a facet that are associated with an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectAttributes.html
     *
     * @experimental
     */
    toGetObjectAttributes(): this;
    /**
     * (experimental) Retrieves metadata about an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectInformation.html
     *
     * @experimental
     */
    toGetObjectInformation(): this;
    /**
     * (experimental) Retrieves a JSON representation of the schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetSchemaAsJson.html
     *
     * @experimental
     */
    toGetSchemaAsJson(): this;
    /**
     * (experimental) Returns identity attributes order information associated with a given typed link facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetTypedLinkFacetInformation.html
     *
     * @experimental
     */
    toGetTypedLinkFacetInformation(): this;
    /**
     * (experimental) Lists schemas applied to a directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAppliedSchemaArns.html
     *
     * @experimental
     */
    toListAppliedSchemaArns(): this;
    /**
     * (experimental) Lists indices attached to an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAttachedIndices.html
     *
     * @experimental
     */
    toListAttachedIndices(): this;
    /**
     * (experimental) Retrieves the ARNs of schemas in the development state.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDevelopmentSchemaArns.html
     *
     * @experimental
     */
    toListDevelopmentSchemaArns(): this;
    /**
     * (experimental) Lists directories created within an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDirectories.html
     *
     * @experimental
     */
    toListDirectories(): this;
    /**
     * (experimental) Retrieves attributes attached to the facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetAttributes.html
     *
     * @experimental
     */
    toListFacetAttributes(): this;
    /**
     * (experimental) Retrieves the names of facets that exist in a schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetNames.html
     *
     * @experimental
     */
    toListFacetNames(): this;
    /**
     * (experimental) Returns a paginated list of all incoming TypedLinks for a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIncomingTypedLinks.html
     *
     * @experimental
     */
    toListIncomingTypedLinks(): this;
    /**
     * (experimental) Lists objects attached to the specified index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIndex.html
     *
     * @experimental
     */
    toListIndex(): this;
    /**
     * (experimental) Lists the major version families of each managed schema.
     *
     * If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListManagedSchemaArns.html
     *
     * @experimental
     */
    toListManagedSchemaArns(): this;
    /**
     * (experimental) Lists all attributes associated with an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectAttributes.html
     *
     * @experimental
     */
    toListObjectAttributes(): this;
    /**
     * (experimental) Returns a paginated list of child objects associated with a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectChildren.html
     *
     * @experimental
     */
    toListObjectChildren(): this;
    /**
     * (experimental) Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParentPaths.html
     *
     * @experimental
     */
    toListObjectParentPaths(): this;
    /**
     * (experimental) Lists parent objects associated with a given object in pagination fashion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParents.html
     *
     * @experimental
     */
    toListObjectParents(): this;
    /**
     * (experimental) Returns policies attached to an object in pagination fashion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectPolicies.html
     *
     * @experimental
     */
    toListObjectPolicies(): this;
    /**
     * (experimental) Returns a paginated list of all outgoing TypedLinks for a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListOutgoingTypedLinks.html
     *
     * @experimental
     */
    toListOutgoingTypedLinks(): this;
    /**
     * (experimental) Returns all of the ObjectIdentifiers to which a given policy is attached.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPolicyAttachments.html
     *
     * @experimental
     */
    toListPolicyAttachments(): this;
    /**
     * (experimental) Retrieves published schema ARNs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPublishedSchemaArns.html
     *
     * @experimental
     */
    toListPublishedSchemaArns(): this;
    /**
     * (experimental) Returns tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Returns a paginated list of attributes associated with typed link facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetAttributes.html
     *
     * @experimental
     */
    toListTypedLinkFacetAttributes(): this;
    /**
     * (experimental) Returns a paginated list of typed link facet names that exist in a schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetNames.html
     *
     * @experimental
     */
    toListTypedLinkFacetNames(): this;
    /**
     * (experimental) Lists all policies from the root of the Directory to the object specified.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_LookupPolicy.html
     *
     * @experimental
     */
    toLookupPolicy(): this;
    /**
     * (experimental) Publishes a development schema with a version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PublishSchema.html
     *
     * @experimental
     */
    toPublishSchema(): this;
    /**
     * (experimental) Allows a schema to be updated using JSON upload. Only available for development schemas.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PutSchemaFromJson.html
     *
     * @experimental
     */
    toPutSchemaFromJson(): this;
    /**
     * (experimental) Removes the specified facet from the specified object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_RemoveFacetFromObject.html
     *
     * @experimental
     */
    toRemoveFacetFromObject(): this;
    /**
     * (experimental) Adds tags to a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Removes tags from a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Adds/Updates/Deletes existing Attributes, Rules, or ObjectType of a Facet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateFacet.html
     *
     * @experimental
     */
    toUpdateFacet(): this;
    /**
     * (experimental) Updates a given typed link’s attributes.
     *
     * Attributes to be updated must not contribute to the typed link’s identity, as defined by its IdentityAttributeOrder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateLinkAttributes.html
     *
     * @experimental
     */
    toUpdateLinkAttributes(): this;
    /**
     * (experimental) Updates a given object's attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateObjectAttributes.html
     *
     * @experimental
     */
    toUpdateObjectAttributes(): this;
    /**
     * (experimental) Updates the schema name with a new name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateSchema.html
     *
     * @experimental
     */
    toUpdateSchema(): this;
    /**
     * (experimental) Adds/Updates/Deletes existing Attributes, Rules, identity attribute order of a TypedLink Facet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateTypedLinkFacet.html
     *
     * @experimental
     */
    toUpdateTypedLinkFacet(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type appliedSchema to the statement.
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAppliedSchema(directoryId: string, schemaName: string, version: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type developmentSchema to the statement.
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDevelopmentSchema(schemaName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type directory to the statement.
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDirectory(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type publishedSchema to the statement.
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPublishedSchema(schemaName: string, version: string, account?: string, region?: string, partition?: string): this;
}
