import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
 *
 * @experimental
 */
export declare class Cloudformation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel an update on the specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html
     *
     * @experimental
     */
    toCancelUpdateStack(): this;
    /**
     * (experimental) Grants permission to continue rolling back a stack that is in the UPDATE_ROLLBACK_FAILED state to the UPDATE_ROLLBACK_COMPLETE state.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ContinueUpdateRollback.html
     *
     * @experimental
     */
    toContinueUpdateRollback(): this;
    /**
     * (experimental) Grants permission to create a list of changes for a stack.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     * - .ifResourceTypes()
     * - .ifImportResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html
     *
     * @experimental
     */
    toCreateChangeSet(): this;
    /**
     * (experimental) Grants permission to create a stack as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     *
     * @experimental
     */
    toCreateStack(): this;
    /**
     * (experimental) Grants permission to create stack instances for the specified accounts, within the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html
     *
     * @experimental
     */
    toCreateStackInstances(): this;
    /**
     * (experimental) Grants permission to create a stackset as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackSet.html
     *
     * @experimental
     */
    toCreateStackSet(): this;
    /**
     * (experimental) Grants permission to upload templates to Amazon S3 buckets.
     *
     * Used only by the AWS CloudFormation console and is not documented in the API reference
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateUploadBucket(): this;
    /**
     * (experimental) Grants permission to delete the specified change set.
     *
     * Deleting change sets ensures that no one executes the wrong change set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteChangeSet.html
     *
     * @experimental
     */
    toDeleteChangeSet(): this;
    /**
     * (experimental) Grants permission to delete a specified stack.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStack.html
     *
     * @experimental
     */
    toDeleteStack(): this;
    /**
     * (experimental) Grants permission to delete stack instances for the specified accounts, in the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackInstances.html
     *
     * @experimental
     */
    toDeleteStackInstances(): this;
    /**
     * (experimental) Grants permission to delete a specified stackset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackSet.html
     *
     * @experimental
     */
    toDeleteStackSet(): this;
    /**
     * (experimental) Grants permission to deregister an existing CloudFormation type or type version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html
     *
     * @experimental
     */
    toDeregisterType(): this;
    /**
     * (experimental) Grants permission to retrieve your account's AWS CloudFormation limits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeAccountLimits.html
     *
     * @experimental
     */
    toDescribeAccountLimits(): this;
    /**
     * (experimental) Grants permission to return the description for the specified change set.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeChangeSet.html
     *
     * @experimental
     */
    toDescribeChangeSet(): this;
    /**
     * (experimental) Grants permission to return information about a stack drift detection operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackDriftDetectionStatus.html
     *
     * @experimental
     */
    toDescribeStackDriftDetectionStatus(): this;
    /**
     * (experimental) Grants permission to return all stack related events for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackEvents.html
     *
     * @experimental
     */
    toDescribeStackEvents(): this;
    /**
     * (experimental) Grants permission to return the stack instance that's associated with the specified stack set, AWS account, and region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackInstance.html
     *
     * @experimental
     */
    toDescribeStackInstance(): this;
    /**
     * (experimental) Grants permission to return a description of the specified resource in the specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResource.html
     *
     * @experimental
     */
    toDescribeStackResource(): this;
    /**
     * (experimental) Grants permission to return drift information for the resources that have been checked for drift in the specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResourceDrifts.html
     *
     * @experimental
     */
    toDescribeStackResourceDrifts(): this;
    /**
     * (experimental) Grants permission to return AWS resource descriptions for running and deleted stacks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResources.html
     *
     * @experimental
     */
    toDescribeStackResources(): this;
    /**
     * (experimental) Grants permission to return the description of the specified stack set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSet.html
     *
     * @experimental
     */
    toDescribeStackSet(): this;
    /**
     * (experimental) Grants permission to return the description of the specified stack set operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSetOperation.html
     *
     * @experimental
     */
    toDescribeStackSetOperation(): this;
    /**
     * (experimental) Grants permission to return the description for the specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStacks.html
     *
     * @experimental
     */
    toDescribeStacks(): this;
    /**
     * (experimental) Grants permission to return information about the CloudFormation type requested.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html
     *
     * @experimental
     */
    toDescribeType(): this;
    /**
     * (experimental) Grants permission to return information about the registration process for a CloudFormation type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeTypeRegistration.html
     *
     * @experimental
     */
    toDescribeTypeRegistration(): this;
    /**
     * (experimental) Grants permission to detects whether a stack's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackDrift.html
     *
     * @experimental
     */
    toDetectStackDrift(): this;
    /**
     * (experimental) Grants permission to return information about whether a resource's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackResourceDrift.html
     *
     * @experimental
     */
    toDetectStackResourceDrift(): this;
    /**
     * (experimental) Grants permission to enable users to detect drift on a stack set and the stack instances that belong to that stack set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackSetDrift.html
     *
     * @experimental
     */
    toDetectStackSetDrift(): this;
    /**
     * (experimental) Grants permission to return the estimated monthly cost of a template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_EstimateTemplateCost.html
     *
     * @experimental
     */
    toEstimateTemplateCost(): this;
    /**
     * (experimental) Grants permission to update a stack using the input information that was provided when the specified change set was created.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html
     *
     * @experimental
     */
    toExecuteChangeSet(): this;
    /**
     * (experimental) Grants permission to return the stack policy for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetStackPolicy.html
     *
     * @experimental
     */
    toGetStackPolicy(): this;
    /**
     * (experimental) Grants permission to return the template body for a specified stack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplate.html
     *
     * @experimental
     */
    toGetTemplate(): this;
    /**
     * (experimental) Grants permission to return information about a new or existing template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplateSummary.html
     *
     * @experimental
     */
    toGetTemplateSummary(): this;
    /**
     * (experimental) Grants permission to return the ID and status of each active change set for a stack.
     *
     * For example, AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or CREATE_PENDING state
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListChangeSets.html
     *
     * @experimental
     */
    toListChangeSets(): this;
    /**
     * (experimental) Grants permission to list all exported output values in the account and region in which you call this action.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListExports.html
     *
     * @experimental
     */
    toListExports(): this;
    /**
     * (experimental) Grants permission to list all stacks that are importing an exported output value.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListImports.html
     *
     * @experimental
     */
    toListImports(): this;
    /**
     * (experimental) Grants permission to return summary information about stack instances that are associated with the specified stack set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     *
     * @experimental
     */
    toListStackInstances(): this;
    /**
     * (experimental) Grants permission to return descriptions of all resources of the specified stack.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackResources.html
     *
     * @experimental
     */
    toListStackResources(): this;
    /**
     * (experimental) Grants permission to return summary information about the results of a stack set operation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperationResults.html
     *
     * @experimental
     */
    toListStackSetOperationResults(): this;
    /**
     * (experimental) Grants permission to return summary information about operations performed on a stack set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperations.html
     *
     * @experimental
     */
    toListStackSetOperations(): this;
    /**
     * (experimental) Grants permission to return summary information about stack sets that are associated with the user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     *
     * @experimental
     */
    toListStackSets(): this;
    /**
     * (experimental) Grants permission to return the summary information for stacks whose status matches the specified StackStatusFilter.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStacks.html
     *
     * @experimental
     */
    toListStacks(): this;
    /**
     * (experimental) Grants permission to list CloudFormation type registration attempts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeRegistrations.html
     *
     * @experimental
     */
    toListTypeRegistrations(): this;
    /**
     * (experimental) Grants permission to list versions of a particular CloudFormation type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeVersions.html
     *
     * @experimental
     */
    toListTypeVersions(): this;
    /**
     * (experimental) Grants permission to list available CloudFormation types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html
     *
     * @experimental
     */
    toListTypes(): this;
    /**
     * (experimental) Grants permission to record the handler progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RecordHandlerProgress.html
     *
     * @experimental
     */
    toRecordHandlerProgress(): this;
    /**
     * (experimental) Grants permission to register a new CloudFormation type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html
     *
     * @experimental
     */
    toRegisterType(): this;
    /**
     * (experimental) Grants permission to set a stack policy for a specified stack.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifStackPolicyUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetStackPolicy.html
     *
     * @experimental
     */
    toSetStackPolicy(): this;
    /**
     * (experimental) Grants permission to set which version of a CloudFormation type applies to CloudFormation operations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeDefaultVersion.html
     *
     * @experimental
     */
    toSetTypeDefaultVersion(): this;
    /**
     * (experimental) Grants permission to send a signal to the specified resource with a success or failure status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SignalResource.html
     *
     * @experimental
     */
    toSignalResource(): this;
    /**
     * (experimental) Grants permission to stop an in-progress operation on a stack set and its associated stack instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StopStackSetOperation.html
     *
     * @experimental
     */
    toStopStackSetOperation(): this;
    /**
     * (experimental) Grants permission to tag cloudformation resources.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag cloudformation resources.
     *
     * Access Level: Tagging
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a stack as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStack.html
     *
     * @experimental
     */
    toUpdateStack(): this;
    /**
     * (experimental) Grants permission to update the parameter values for stack instances for the specified accounts, within the specified regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackInstances.html
     *
     * @experimental
     */
    toUpdateStackInstances(): this;
    /**
     * (experimental) Grants permission to update a stackset as specified in the template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html
     *
     * @experimental
     */
    toUpdateStackSet(): this;
    /**
     * (experimental) Grants permission to update termination protection for the specified stack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateTerminationProtection.html
     *
     * @experimental
     */
    toUpdateTerminationProtection(): this;
    /**
     * (experimental) Grants permission to validate a specified template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ValidateTemplate.html
     *
     * @experimental
     */
    toValidateTemplate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type changeset to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15c11
     *
     * @param changeSetName - Identifier for the changeSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onChangeset(changeSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type stack to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15b9
     *
     * @param stackName - Identifier for the stackName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStack(stackName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type stackset to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stacksets-concepts-stackset
     *
     * @param stackSetName - Identifier for the stackSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStackset(stackSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type stackset-target to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html
     *
     * @param stackSetTarget - Identifier for the stackSetTarget.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onStacksetTarget(stackSetTarget: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type type to the statement.
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html
     *
     * @param type - Identifier for the type.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onType(type: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters actions based on an AWS CloudFormation change set name.
     *
     * Use to control which change sets IAM users can execute or delete
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toDeleteChangeSet()
     * - .toDescribeChangeSet()
     * - .toExecuteChangeSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifChangeSetName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the template resource types, such as AWS::EC2::Instance.
     *
     * Use to control which resource types IAM users can work with when they want to import a resource into a stack
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifImportResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the template resource types, such as AWS::EC2::Instance.
     *
     * Use to control which resource types IAM users can work with when they create or update a stack
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the ARN of an IAM service role.
     *
     * Use to control which service role IAM users can use to work with stacks or change sets
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toContinueUpdateRollback()
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toDeleteStack()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifRoleArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on an Amazon S3 stack policy URL.
     *
     * Use to control which stack policies IAM users can associate with a stack during a create or update stack action
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toSetStackPolicy()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifStackPolicyUrl(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on an Amazon S3 template URL.
     *
     * Use to control which templates IAM users can use when they create or update stacks
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTemplateUrl(value: string | string[], operator?: Operator | string): this;
}
