/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "2.4.0-rc.3");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
484: function _(t,e,o,r,s){r();const _=(0,t(1).__importStar)(t(485));o.Tables=_;(0,t(7).register_models)(_)},
485: function _(g,a,r,e,t){e();const o=g(1);(0,o.__exportStar)(g(486),r),(0,o.__exportStar)(g(489),r),t("DataTable",g(492).DataTable),t("TableColumn",g(510).TableColumn),t("TableWidget",g(509).TableWidget);var n=g(512);t("AvgAggregator",n.AvgAggregator),t("MinAggregator",n.MinAggregator),t("MaxAggregator",n.MaxAggregator),t("SumAggregator",n.SumAggregator);var A=g(513);t("GroupingInfo",A.GroupingInfo),t("DataCube",A.DataCube)},
486: function _(e,t,i,s,a){s();const r=e(1);var l,n,u,d,o,p,_,c,h;const E=e(43),V=e(226),m=e(53),f=e(487),v=(0,r.__importStar)(e(488));class w extends V.DOMView{constructor(e){const{model:t,parent:i}=e.column;super(Object.assign({model:t,parent:i},e)),this.args=e,this.initialize(),this.render()}get emptyValue(){return null}initialize(){super.initialize(),this.inputEl=this._createInput(),this.defaultValue=null}async lazy_initialize(){throw new Error("unsupported")}css_classes(){return super.css_classes().concat(v.cell_editor)}render(){super.render(),this.args.container.append(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()}renderEditor(){}disableNavigation(){this.inputEl.addEventListener("keydown",(e=>{switch(e.keyCode){case E.Keys.Left:case E.Keys.Right:case E.Keys.Up:case E.Keys.Down:case E.Keys.PageUp:case E.Keys.PageDown:e.stopImmediatePropagation()}}))}destroy(){this.remove()}focus(){this.inputEl.focus()}show(){}hide(){}position(){}getValue(){return this.inputEl.value}setValue(e){this.inputEl.value=e}serializeValue(){return this.getValue()}isValueChanged(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue}applyValue(e,t){const i=this.args.grid.getData(),s=i.index.indexOf(e[f.DTINDEX_NAME]);i.setField(s,this.args.column.field,t)}loadValue(e){const t=e[this.args.column.field];this.defaultValue=null!=t?t:this.emptyValue,this.setValue(this.defaultValue)}validateValue(e){if(this.args.column.validator){const t=this.args.column.validator(e);if(!t.valid)return t}return{valid:!0,msg:null}}validate(){return this.validateValue(this.getValue())}}i.CellEditorView=w,w.__name__="CellEditorView";class g extends m.Model{}i.CellEditor=g,g.__name__="CellEditor";class x extends w{get emptyValue(){return""}_createInput(){return(0,E.input)({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}}i.StringEditorView=x,x.__name__="StringEditorView";class y extends g{}i.StringEditor=y,l=y,y.__name__="StringEditor",l.prototype.default_view=x,l.define((({String:e,Array:t})=>({completions:[t(e),[]]})));class I extends w{_createInput(){return(0,E.textarea)()}renderEditor(){this.inputEl.focus(),this.inputEl.select()}}i.TextEditorView=I,I.__name__="TextEditorView";class b extends g{}i.TextEditor=b,n=b,b.__name__="TextEditor",n.prototype.default_view=I;class N extends w{_createInput(){return(0,E.select)()}renderEditor(){for(const e of this.model.options)this.inputEl.appendChild((0,E.option)({value:e},e));this.focus()}}i.SelectEditorView=N,N.__name__="SelectEditorView";class C extends g{}i.SelectEditor=C,u=C,C.__name__="SelectEditor",u.prototype.default_view=N,u.define((({String:e,Array:t})=>({options:[t(e),[]]})));class D extends w{_createInput(){return(0,E.input)({type:"text"})}}i.PercentEditorView=D,D.__name__="PercentEditorView";class S extends g{}i.PercentEditor=S,d=S,S.__name__="PercentEditor",d.prototype.default_view=D;class k extends w{_createInput(){return(0,E.input)({type:"checkbox"})}renderEditor(){this.focus()}loadValue(e){this.defaultValue=!!e[this.args.column.field],this.inputEl.checked=this.defaultValue}serializeValue(){return this.inputEl.checked}}i.CheckboxEditorView=k,k.__name__="CheckboxEditorView";class z extends g{}i.CheckboxEditor=z,o=z,z.__name__="CheckboxEditor",o.prototype.default_view=k;class P extends w{_createInput(){return(0,E.input)({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}remove(){super.remove()}serializeValue(){var e;return null!==(e=parseInt(this.getValue(),10))&&void 0!==e?e:0}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}validateValue(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid integer"}:super.validateValue(e)}}i.IntEditorView=P,P.__name__="IntEditorView";class T extends g{}i.IntEditor=T,p=T,T.__name__="IntEditor",p.prototype.default_view=P,p.define((({Int:e})=>({step:[e,1]})));class K extends w{_createInput(){return(0,E.input)({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}remove(){super.remove()}serializeValue(){var e;return null!==(e=parseFloat(this.getValue()))&&void 0!==e?e:0}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}validateValue(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid number"}:super.validateValue(e)}}i.NumberEditorView=K,K.__name__="NumberEditorView";class A extends g{}i.NumberEditor=A,_=A,A.__name__="NumberEditor",_.prototype.default_view=K,_.define((({Number:e})=>({step:[e,.01]})));class M extends w{_createInput(){return(0,E.input)({type:"text"})}}i.TimeEditorView=M,M.__name__="TimeEditorView";class O extends g{}i.TimeEditor=O,c=O,O.__name__="TimeEditor",c.prototype.default_view=M;class F extends w{_createInput(){return(0,E.input)({type:"text"})}get emptyValue(){return new Date}renderEditor(){this.inputEl.focus(),this.inputEl.select()}destroy(){super.destroy()}show(){super.show()}hide(){super.hide()}position(){return super.position()}getValue(){}setValue(e){}}i.DateEditorView=F,F.__name__="DateEditorView";class L extends g{}i.DateEditor=L,h=L,L.__name__="DateEditor",h.prototype.default_view=F},
487: function _(_,n,i,t,d){t(),i.DTINDEX_NAME="__bkdt_internal_index__"},
488: function _(e,l,o,t,r){t(),o.root="bk-root",o.data_table="bk-data-table",o.cell_special_defaults="bk-cell-special-defaults",o.cell_select="bk-cell-select",o.cell_index="bk-cell-index",o.header_index="bk-header-index",o.cell_editor="bk-cell-editor",o.cell_editor_completion="bk-cell-editor-completion",o.default='.bk-root .bk-data-table{box-sizing:content-box;font-size:11px;}.bk-root .bk-data-table input[type="checkbox"]{margin-left:4px;margin-right:4px;}.bk-root .bk-cell-special-defaults{border-right-color:silver;border-right-style:solid;background:#f5f5f5;}.bk-root .bk-cell-select{border-right-color:silver;border-right-style:solid;background:#f5f5f5;}.bk-root .slick-cell.bk-cell-index{border-right-color:silver;border-right-style:solid;background:#f5f5f5;text-align:right;background:#f0f0f0;color:#909090;}.bk-root .bk-header-index .slick-column-name{float:right;}.bk-root .slick-row.selected .bk-cell-index{background-color:transparent;}.bk-root .slick-row.odd{background:#f0f0f0;}.bk-root .slick-cell{padding-left:4px;padding-right:4px;border-right-color:transparent;border:0.25px solid transparent;}.bk-root .slick-cell .bk{line-height:inherit;}.bk-root .slick-cell.active{border-style:dashed;}.bk-root .slick-cell.selected{background-color:#F0F8FF;}.bk-root .slick-cell.editable{padding-left:0;padding-right:0;}.bk-root .bk-cell-editor{display:contents;}.bk-root .bk-cell-editor input,.bk-root .bk-cell-editor select{width:100%;height:100%;border:0;margin:0;padding:0;outline:0;background:transparent;vertical-align:baseline;}.bk-root .bk-cell-editor input{padding-left:4px;padding-right:4px;}.bk-root .bk-cell-editor-completion{font-size:11px;}'},
489: function _(t,e,r,n,a){n();const o=t(1);var l,s,i,c,u,m;const _=(0,o.__importDefault)(t(151)),d=(0,o.__importStar)(t(153)),f=t(490),g=t(43),h=t(20),F=t(8),p=t(34),b=t(22),S=t(53);class x extends S.Model{constructor(t){super(t)}doFormat(t,e,r,n,a){return null==r?"":`${r}`.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}}r.CellFormatter=x,x.__name__="CellFormatter";class M extends x{constructor(t){super(t)}doFormat(t,e,r,n,a){const{font_style:o,text_align:l,text_color:s}=this,i=(0,g.div)(null==r?"":`${r}`);switch(o){case"bold":i.style.fontWeight="bold";break;case"italic":i.style.fontStyle="italic"}return null!=l&&(i.style.textAlign=l),null!=s&&(i.style.color=(0,b.color2css)(s)),i.outerHTML}}r.StringFormatter=M,l=M,M.__name__="StringFormatter",l.define((({Color:t,Nullable:e})=>({font_style:[h.FontStyle,"normal"],text_align:[h.TextAlign,"left"],text_color:[e(t),null]})));class N extends M{constructor(t){super(t)}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}doFormat(t,e,r,n,a){const o=Math.abs(r)<=this.scientific_limit_low||Math.abs(r)>=this.scientific_limit_high;let l=this.precision;return l<1&&(l=1),r=null!=r&&!isNaN(r)||null==this.nan_format?0==r?(0,p.to_fixed)(r,1):o?r.toExponential(l):(0,p.to_fixed)(r,l):this.nan_format,super.doFormat(t,e,r,n,a)}}r.ScientificFormatter=N,s=N,N.__name__="ScientificFormatter",s.define((({Number:t,String:e,Nullable:r})=>({nan_format:[r(e),null],precision:[t,10],power_limit_high:[t,5],power_limit_low:[t,-3]})));class w extends M{constructor(t){super(t)}doFormat(t,e,r,n,a){const{format:o,language:l,nan_format:s}=this,i=(()=>{switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}})();return r=null!=r&&!isNaN(r)||null==s?d.format(r,o,l,i):s,super.doFormat(t,e,r,n,a)}}r.NumberFormatter=w,i=w,w.__name__="NumberFormatter",i.define((({String:t,Nullable:e})=>({format:[t,"0,0"],language:[t,"en"],rounding:[h.RoundingFunction,"round"],nan_format:[e(t),null]})));class C extends x{constructor(t){super(t)}doFormat(t,e,r,n,a){return r?(0,g.i)({class:this.icon}).outerHTML:""}}r.BooleanFormatter=C,c=C,C.__name__="BooleanFormatter",c.define((({String:t})=>({icon:[t,"check"]})));class y extends M{constructor(t){super(t)}getFormat(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}}doFormat(t,e,r,n,a){const{nan_format:o}=this;let l;return l=null!=(r=(0,F.isString)(r)?parseInt(r,10):r)&&!isNaN(r)&&-9223372036854776!==r||null==o?null==r?"":(0,_.default)(r,this.getFormat()):o,super.doFormat(t,e,l,n,a)}}r.DateFormatter=y,u=y,y.__name__="DateFormatter",u.define((({String:t,Nullable:e})=>({format:[t,"ISO-8601"],nan_format:[e(t),null]})));class T extends x{constructor(t){super(t)}doFormat(t,e,r,n,a){const{template:o}=this;if(null==r)return"";return f._.template(o)(Object.assign(Object.assign({},a),{value:r}))}}r.HTMLTemplateFormatter=T,m=T,T.__name__="HTMLTemplateFormatter",m.define((({String:t})=>({template:[t,"<%= value %>"]})))},
490: function _(e,n,t,f,i){var o=e(491),d=o.template;function r(e,n,t){return d(e,n,t)}r._=o,n.exports=r,"function"==typeof define&&define.amd?define((function(){return r})):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=r)},
491: function _(r,e,n,t,a){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var u={},c=Array.prototype,o=Object.prototype,l=c.slice,i=o.toString,f=o.hasOwnProperty,s=c.forEach,p=Object.keys,_=Array.isArray,h=function(){},v=h.each=h.forEach=function(r,e,n){if(null!=r)if(s&&r.forEach===s)r.forEach(e,n);else if(r.length===+r.length){for(var t=0,a=r.length;t<a;t++)if(e.call(n,r[t],t,r)===u)return}else{var c=h.keys(r);for(t=0,a=c.length;t<a;t++)if(e.call(n,r[c[t]],c[t],r)===u)return}};h.keys=p||function(r){if(r!==Object(r))throw new TypeError("Invalid object");var e=[];for(var n in r)h.has(r,n)&&e.push(n);return e},h.defaults=function(r){return v(l.call(arguments,1),(function(e){if(e)for(var n in e)void 0===r[n]&&(r[n]=e[n])})),r},h.isArray=_||function(r){return"[object Array]"===i.call(r)},h.has=function(r,e){if(!h.isArray(e))return null!=r&&f.call(r,e);for(var n=e.length,t=0;t<n;t++){var a=e[t];if(null==r||!f.call(r,a))return!1;r=r[a]}return!!n};var g={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},y={escape:new RegExp("["+h.keys(g.escape).join("")+"]","g")};h.each(["escape"],(function(r){h[r]=function(e){return null==e?"":(""+e).replace(y[r],(function(e){return g[r][e]}))}})),h.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var j=/(.)^/,b={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},w=/\\|'|\r|\n|\t|\u2028|\u2029/g;h.template=function(r,e,n){var t;n=h.defaults({},n,h.templateSettings);var a=new RegExp([(n.escape||j).source,(n.interpolate||j).source,(n.evaluate||j).source].join("|")+"|$","g"),u=0,c="__p+='";r.replace(a,(function(e,n,t,a,o){return c+=r.slice(u,o).replace(w,(function(r){return"\\"+b[r]})),n&&(c+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'"),t&&(c+="'+\n((__t=("+t+"))==null?'':__t)+\n'"),a&&(c+="';\n"+a+"\n__p+='"),u=o+e.length,e})),c+="';\n",n.variable||(c="with(obj||{}){\n"+c+"}\n"),c="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+c+"return __p;\n";try{t=new Function(n.variable||"obj","_",c)}catch(r){throw r.source=c,r}if(e)return t(e,h);var o=function(r){return t.call(this,r,h)};return o.source="function("+(n.variable||"obj")+"){\n"+c+"}",o},e.exports=h},
492: function _(e,t,i,s,o){s();const n=e(1);var l;const r=e(493),d=e(497),a=e(498),h=e(499),u=e(34),c=e(8),_=e(9),m=e(13),g=e(19),p=e(508),f=e(487),b=e(509),w=e(510),x=(0,n.__importStar)(e(488)),C=x,v=(0,n.__importDefault)(e(511));i.AutosizeModes={fit_columns:"FCV",fit_viewport:"FVC",force_fit:"LFF",none:"NOA"};let z=!1;class A{constructor(e,t){this.init(e,t)}init(e,t){if(f.DTINDEX_NAME in e.data)throw new Error(`special name ${f.DTINDEX_NAME} cannot be used as a data table column`);this.source=e,this.view=t,this.index=[...this.view.indices]}getLength(){return this.index.length}getItem(e){const t={};for(const i of(0,m.keys)(this.source.data))t[i]=this.source.data[i][this.index[e]];return t[f.DTINDEX_NAME]=this.index[e],t}getField(e,t){return t==f.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]}setField(e,t,i){const s=this.index[e];this.source.patch({[t]:[[s,i]]})}getRecords(){return(0,_.range)(0,this.getLength()).map((e=>this.getItem(e)))}getItems(){return this.getRecords()}slice(e,t,i){return e=null!=e?e:0,t=null!=t?t:this.getLength(),i=null!=i?i:1,(0,_.range)(e,t,i).map((e=>this.getItem(e)))}sort(e){let t=e.map((e=>[e.sortCol.field,e.sortAsc?1:-1]));0==t.length&&(t=[[f.DTINDEX_NAME,1]]);const i=this.getRecords(),s=this.index.slice();this.index.sort(((e,o)=>{for(const[n,l]of t){const t=i[s.indexOf(e)][n],r=i[s.indexOf(o)][n];if(t!==r)return(0,c.isNumber)(t)&&(0,c.isNumber)(r)?l*(t-r||+isNaN(t)-+isNaN(r)):`${t}`>`${r}`?l:-l}return 0}))}}i.TableDataProvider=A,A.__name__="TableDataProvider";class M extends p.WidgetView{constructor(){super(...arguments),this._in_selection_update=!1,this._width=null}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render())),this.connect(this.model.source.streaming,(()=>this.updateGrid())),this.connect(this.model.source.patching,(()=>this.updateGrid())),this.connect(this.model.source.change,(()=>this.updateGrid())),this.connect(this.model.source.properties.data.change,(()=>this.updateGrid())),this.connect(this.model.source.selected.change,(()=>this.updateSelection())),this.connect(this.model.source.selected.properties.indices.change,(()=>this.updateSelection()));for(const e of this.model.columns)this.connect(e.change,(()=>{this.invalidate_layout(),this.render()}))}remove(){var e;null===(e=this.grid)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),v.default,x.default]}update_position(){super.update_position(),this.grid.resizeCanvas()}after_layout(){super.after_layout(),this.updateLayout(!0,!1)}box_sizing(){const e=super.box_sizing();return"fit_viewport"===this.model.autosize_mode&&null!=this._width&&(e.width=this._width),e}updateLayout(e,t){const s=this.autosize;s===i.AutosizeModes.fit_columns||s===i.AutosizeModes.force_fit?(e||this.grid.resizeCanvas(),this.grid.autosizeColumns()):e&&t&&s===i.AutosizeModes.fit_viewport&&this.invalidate_layout()}updateGrid(){if(this.model.view.compute_indices(),this.data.init(this.model.source,this.model.view),this.model.sortable){const e=this.grid.getColumns(),t=this.grid.getSortColumns().map((t=>({sortCol:{field:e[this.grid.getColumnIndex(t.columnId)].field},sortAsc:t.sortAsc})));this.data.sort(t)}this.grid.invalidate(),this.updateLayout(!0,!0)}updateSelection(){if(this._in_selection_update)return;const{selected:e}=this.model.source,t=e.indices.map((e=>this.data.index.indexOf(e))).sort();this._in_selection_update=!0,this.grid.setSelectedRows(t),this._in_selection_update=!1;const i=this.grid.getViewport(),s=this.model.get_scroll_index(i,t);null!=s&&this.grid.scrollRowToTop(s)}newIndexColumn(){return{id:(0,u.uniqueId)(),name:this.model.index_header,field:f.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:C.cell_index,headerCssClass:C.header_index}}css_classes(){return super.css_classes().concat(C.data_table)}get autosize(){let e;return e=!0===this.model.fit_columns?i.AutosizeModes.force_fit:!1===this.model.fit_columns?i.AutosizeModes.none:i.AutosizeModes[this.model.autosize_mode],e}render(){var e;const t=this.model.columns.filter((e=>e.visible)).map((e=>Object.assign(Object.assign({},e.toColumn()),{parent:this})));let s=null;if("checkbox"==this.model.selectable&&(s=new d.CheckboxSelectColumn({cssClass:C.cell_select}),t.unshift(s.getColumnDefinition())),null!=this.model.index_position){const e=this.model.index_position,i=this.newIndexColumn();-1==e?t.push(i):e<-1?t.splice(e+1,0,i):t.splice(e,0,i)}let{reorderable:o}=this.model;!o||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(z||(g.logger.warn("jquery-ui is required to enable DataTable.reorderable"),z=!0),o=!1);let n=-1,l=!1;const{frozen_rows:u,frozen_columns:_}=this.model,m=null==_?-1:_-1;null!=u&&(l=u<0,n=Math.abs(u));const p={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:o,autosizeColsMode:this.autosize,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:this.model.auto_edit,autoHeight:!1,rowHeight:this.model.row_height,frozenColumn:m,frozenRow:n,frozenBottom:l},f=null!=this.grid;if(this.data=new A(this.model.source,this.model.view),this.grid=new h.Grid(this.el,this.data,t,p),this.autosize==i.AutosizeModes.fit_viewport){this.grid.autosizeColumns();let i=0;for(const s of t)i+=null!==(e=s.width)&&void 0!==e?e:0;this._width=Math.ceil(i)}if(this.grid.onSort.subscribe(((e,t)=>{if(!this.model.sortable)return;const i=t.sortCols;null!=i&&(this.data.sort(i),this.grid.invalidate(),this.updateSelection(),this.grid.render(),this.model.header_row||this._hide_header(),this.model.update_sort_columns(i))})),!1!==this.model.selectable){this.grid.setSelectionModel(new r.RowSelectionModel({selectActiveRow:null==s})),null!=s&&this.grid.registerPlugin(s);const e={dataItemColumnValueExtractor(e,t){let i=e[t.field];return(0,c.isString)(i)&&(i=i.replace(/\n/g,"\\n")),i},includeHeaderWhenCopying:!1};this.grid.registerPlugin(new a.CellExternalCopyManager(e)),this.grid.onSelectedRowsChanged.subscribe(((e,t)=>{this._in_selection_update||(this.model.source.selected.indices=t.rows.map((e=>this.data.index[e])))})),this.updateSelection(),this.model.header_row||this._hide_header()}f&&this.updateLayout(f,!1)}_hide_header(){for(const e of this.el.querySelectorAll(".slick-header-columns"))e.style.height="0px";this.grid.resizeCanvas()}}i.DataTableView=M,M.__name__="DataTableView";class D extends b.TableWidget{constructor(e){super(e),this._sort_columns=[]}get sort_columns(){return this._sort_columns}update_sort_columns(e){this._sort_columns=e.map((({sortCol:e,sortAsc:t})=>({field:e.field,sortAsc:t})))}get_scroll_index(e,t){return this.scroll_to_selection&&0!=t.length?(0,_.some)(t,(t=>e.top<=t&&t<=e.bottom))?null:Math.max(0,Math.min(...t)-1):null}}i.DataTable=D,l=D,D.__name__="DataTable",l.prototype.default_view=M,l.define((({Array:e,Boolean:t,Int:i,Ref:s,String:o,Enum:n,Or:l,Nullable:r})=>({autosize_mode:[n("fit_columns","fit_viewport","none","force_fit"),"force_fit"],auto_edit:[t,!1],columns:[e(s(w.TableColumn)),[]],fit_columns:[r(t),null],frozen_columns:[r(i),null],frozen_rows:[r(i),null],sortable:[t,!0],reorderable:[t,!0],editable:[t,!1],selectable:[l(t,n("checkbox")),!0],index_position:[r(i),0],index_header:[o,"#"],index_width:[i,40],scroll_to_selection:[t,!0],header_row:[t,!0],row_height:[i,25]}))),l.override({width:600,height:400})},
493: function _(e,t,n,o,r){var l=e(494),i=e(496);t.exports={RowSelectionModel:function(e){var t,n,o,r=[],c=this,u=new i.EventHandler,s={selectActiveRow:!0};function a(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function f(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function h(e){for(var n=[],o=t.getColumns().length-1,r=0;r<e.length;r++)n.push(new i.Range(e[r],0,e[r],o));return n}function w(){return f(r)}function g(e){(r&&0!==r.length||e&&0!==e.length)&&(r=e,c.onSelectedRangesChanged.notify(r))}function v(e,n){o.selectActiveRow&&null!=n.row&&g([new i.Range(n.row,0,n.row,t.getColumns().length-1)])}function p(e){var n=t.getActiveCell();if(t.getOptions().multiSelect&&n&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.which==i.keyCode.UP||e.which==i.keyCode.DOWN)){var o=w();o.sort((function(e,t){return e-t})),o.length||(o=[n.row]);var r,l=o[0],c=o[o.length-1];if((r=e.which==i.keyCode.DOWN?n.row<c||l==c?++c:++l:n.row<c?--c:--l)>=0&&r<t.getDataLength())t.scrollRowIntoView(r),g(h(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(l,c)));e.preventDefault(),e.stopPropagation()}}function y(e){var n=t.getCellFromEvent(e);if(!n||!t.canCellBeActive(n.row,n.cell))return!1;if(!t.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var o=f(r),i=l.inArray(n.row,o);if(-1===i&&(e.ctrlKey||e.metaKey))o.push(n.row),t.setActiveCell(n.row,n.cell);else if(-1!==i&&(e.ctrlKey||e.metaKey))o=l.grep(o,(function(e,t){return e!==n.row})),t.setActiveCell(n.row,n.cell);else if(o.length&&e.shiftKey){var c=o.pop(),u=Math.min(n.row,c),s=Math.max(n.row,c);o=[];for(var a=u;a<=s;a++)a!==c&&o.push(a);o.push(c),t.setActiveCell(n.row,n.cell)}return g(h(o)),e.stopImmediatePropagation(),!0}l.extend(this,{getSelectedRows:w,setSelectedRows:function(e){g(h(e))},getSelectedRanges:function(){return r},setSelectedRanges:g,init:function(n){o=l.extend(!0,{},s,e),t=n,u.subscribe(t.onActiveCellChanged,a(v)),u.subscribe(t.onKeyDown,a(p)),u.subscribe(t.onClick,a(y))},destroy:function(){u.unsubscribeAll()},pluginName:"RowSelectionModel",onSelectedRangesChanged:new i.Event})}}},
494: function _(e,n,f,o,t){n.exports="undefined"!=typeof $?$:e(495)},
495: function _(e,t,n,r,i){
/*!
     * jQuery JavaScript Library v3.6.0
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright OpenJS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2021-03-02T17:08Z
     */
!function(e,n){"use strict";"object"==typeof t&&"object"==typeof t.exports?t.exports=e.document?n(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return n(e)}:n(e)}("undefined"!=typeof window?window:this,(function(e,t){"use strict";var n=[],r=Object.getPrototypeOf,i=n.slice,o=n.flat?function(e){return n.flat.call(e)}:function(e){return n.concat.apply([],e)},a=n.push,s=n.indexOf,u={},l=u.toString,c=u.hasOwnProperty,f=c.toString,p=f.call(Object),d={},h=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType&&"function"!=typeof e.item},g=function(e){return null!=e&&e===e.window},v=e.document,y={type:!0,src:!0,nonce:!0,noModule:!0};function m(e,t,n){var r,i,o=(n=n||v).createElement("script");if(o.text=e,t)for(r in y)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function x(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?u[l.call(e)]||"object":typeof e}var b="3.6.0",w=function(e,t){return new w.fn.init(e,t)};function T(e){var t=!!e&&"length"in e&&e.length,n=x(e);return!h(e)&&!g(e)&&("array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e)}w.fn=w.prototype={jquery:b,constructor:w,length:0,toArray:function(){return i.call(this)},get:function(e){return null==e?i.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=w.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return w.each(this,e)},map:function(e){return this.pushStack(w.map(this,(function(t,n){return e.call(t,n,t)})))},slice:function(){return this.pushStack(i.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(w.grep(this,(function(e,t){return(t+1)%2})))},odd:function(){return this.pushStack(w.grep(this,(function(e,t){return t%2})))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:a,sort:n.sort,splice:n.splice},w.extend=w.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||h(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(w.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||w.isPlainObject(n)?n:{},i=!1,a[t]=w.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},w.extend({expando:"jQuery"+(b+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==l.call(e))&&(!(t=r(e))||"function"==typeof(n=c.call(t,"constructor")&&t.constructor)&&f.call(n)===p)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){m(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(T(e))for(n=e.length;r<n&&!1!==t.call(e[r],r,e[r]);r++);else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(T(Object(e))?w.merge(n,"string"==typeof e?[e]:e):a.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:s.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,a=0,s=[];if(T(e))for(r=e.length;a<r;a++)null!=(i=t(e[a],a,n))&&s.push(i);else for(a in e)null!=(i=t(e[a],a,n))&&s.push(i);return o(s)},guid:1,support:d}),"function"==typeof Symbol&&(w.fn[Symbol.iterator]=n[Symbol.iterator]),w.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),(function(e,t){u["[object "+t+"]"]=t.toLowerCase()}));var C=
/*!
         * Sizzle CSS Selector Engine v2.3.6
         * https://sizzlejs.com/
         *
         * Copyright JS Foundation and other contributors
         * Released under the MIT license
         * https://js.foundation/
         *
         * Date: 2021-02-16
         */
function(e){var t,n,r,i,o,a,s,u,l,c,f,p,d,h,g,v,y,m,x,b="sizzle"+1*new Date,w=e.document,T=0,C=0,E=ue(),S=ue(),k=ue(),A=ue(),N=function(e,t){return e===t&&(f=!0),0},j={}.hasOwnProperty,D=[],q=D.pop,L=D.push,H=D.push,O=D.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\[[\\x20\\t\\r\\n\\f]*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^[\\x20\\t\\r\\n\\f]+|((?:^|[^\\\\])(?:\\\\.)*)[\\x20\\t\\r\\n\\f]+$","g"),_=new RegExp("^[\\x20\\t\\r\\n\\f]*,[\\x20\\t\\r\\n\\f]*"),z=new RegExp("^[\\x20\\t\\r\\n\\f]*([>+~]|[\\x20\\t\\r\\n\\f])[\\x20\\t\\r\\n\\f]*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\([\\x20\\t\\r\\n\\f]*(even|odd|(([+-]|)(\\d*)n|)[\\x20\\t\\r\\n\\f]*(?:([+-]|)[\\x20\\t\\r\\n\\f]*(\\d+)|))[\\x20\\t\\r\\n\\f]*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^[\\x20\\t\\r\\n\\f]*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\([\\x20\\t\\r\\n\\f]*((?:-\\d)?\\d*)[\\x20\\t\\r\\n\\f]*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}[\\x20\\t\\r\\n\\f]?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){p()},ae=be((function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()}),{dir:"parentNode",next:"legend"});try{H.apply(D=O.call(w.childNodes),w.childNodes),D[w.childNodes.length].nodeType}catch(e){H={apply:D.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){for(var n=e.length,r=0;e[n++]=t[r++];);e.length=n-1}}}function se(e,t,r,i){var o,s,l,c,f,h,y,m=t&&t.ownerDocument,w=t?t.nodeType:9;if(r=r||[],"string"!=typeof e||!e||1!==w&&9!==w&&11!==w)return r;if(!i&&(p(t),t=t||d,g)){if(11!==w&&(f=Z.exec(e)))if(o=f[1]){if(9===w){if(!(l=t.getElementById(o)))return r;if(l.id===o)return r.push(l),r}else if(m&&(l=m.getElementById(o))&&x(t,l)&&l.id===o)return r.push(l),r}else{if(f[2])return H.apply(r,t.getElementsByTagName(e)),r;if((o=f[3])&&n.getElementsByClassName&&t.getElementsByClassName)return H.apply(r,t.getElementsByClassName(o)),r}if(n.qsa&&!A[e+" "]&&(!v||!v.test(e))&&(1!==w||"object"!==t.nodeName.toLowerCase())){if(y=e,m=t,1===w&&(U.test(e)||z.test(e))){for((m=ee.test(e)&&ye(t.parentNode)||t)===t&&n.scope||((c=t.getAttribute("id"))?c=c.replace(re,ie):t.setAttribute("id",c=b)),s=(h=a(e)).length;s--;)h[s]=(c?"#"+c:":scope")+" "+xe(h[s]);y=h.join(",")}try{return H.apply(r,m.querySelectorAll(y)),r}catch(t){A(e,!0)}finally{c===b&&t.removeAttribute("id")}}}return u(e.replace($,"$1"),t,r,i)}function ue(){var e=[];return function t(n,i){return e.push(n+" ")>r.cacheLength&&delete t[e.shift()],t[n+" "]=i}}function le(e){return e[b]=!0,e}function ce(e){var t=d.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){for(var n=e.split("|"),i=n.length;i--;)r.attrHandle[n[i]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function de(e){return function(t){return"input"===t.nodeName.toLowerCase()&&t.type===e}}function he(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function ge(e){return function(t){return"form"in t?t.parentNode&&!1===t.disabled?"label"in t?"label"in t.parentNode?t.parentNode.disabled===e:t.disabled===e:t.isDisabled===e||t.isDisabled!==!e&&ae(t)===e:t.disabled===e:"label"in t&&t.disabled===e}}function ve(e){return le((function(t){return t=+t,le((function(n,r){for(var i,o=e([],n.length,t),a=o.length;a--;)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))}))}))}function ye(e){return e&&void 0!==e.getElementsByTagName&&e}for(t in n=se.support={},o=se.isXML=function(e){var t=e&&e.namespaceURI,n=e&&(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},p=se.setDocument=function(e){var t,i,a=e?e.ownerDocument||e:w;return a!=d&&9===a.nodeType&&a.documentElement?(h=(d=a).documentElement,g=!o(d),w!=d&&(i=d.defaultView)&&i.top!==i&&(i.addEventListener?i.addEventListener("unload",oe,!1):i.attachEvent&&i.attachEvent("onunload",oe)),n.scope=ce((function(e){return h.appendChild(e).appendChild(d.createElement("div")),void 0!==e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length})),n.attributes=ce((function(e){return e.className="i",!e.getAttribute("className")})),n.getElementsByTagName=ce((function(e){return e.appendChild(d.createComment("")),!e.getElementsByTagName("*").length})),n.getElementsByClassName=K.test(d.getElementsByClassName),n.getById=ce((function(e){return h.appendChild(e).id=b,!d.getElementsByName||!d.getElementsByName(b).length})),n.getById?(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n=t.getElementById(e);return n?[n]:[]}}):(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){var n=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];for(i=t.getElementsByName(e),r=0;o=i[r++];)if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),r.find.TAG=n.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):n.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){for(;n=o[i++];)1===n.nodeType&&r.push(n);return r}return o},r.find.CLASS=n.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&g)return t.getElementsByClassName(e)},y=[],v=[],(n.qsa=K.test(d.querySelectorAll))&&(ce((function(e){var t;h.appendChild(e).innerHTML="<a id='"+b+"'></a><select id='"+b+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]=[\\x20\\t\\r\\n\\f]*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\[[\\x20\\t\\r\\n\\f]*(?:value|"+R+")"),e.querySelectorAll("[id~="+b+"-]").length||v.push("~="),(t=d.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\[[\\x20\\t\\r\\n\\f]*name[\\x20\\t\\r\\n\\f]*=[\\x20\\t\\r\\n\\f]*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+b+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")})),ce((function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=d.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name[\\x20\\t\\r\\n\\f]*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),h.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")}))),(n.matchesSelector=K.test(m=h.matches||h.webkitMatchesSelector||h.mozMatchesSelector||h.oMatchesSelector||h.msMatchesSelector))&&ce((function(e){n.disconnectedMatch=m.call(e,"*"),m.call(e,"[s!='']:x"),y.push("!=",F)})),v=v.length&&new RegExp(v.join("|")),y=y.length&&new RegExp(y.join("|")),t=K.test(h.compareDocumentPosition),x=t||K.test(h.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},N=t?function(e,t){if(e===t)return f=!0,0;var r=!e.compareDocumentPosition-!t.compareDocumentPosition;return r||(1&(r=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!n.sortDetached&&t.compareDocumentPosition(e)===r?e==d||e.ownerDocument==w&&x(w,e)?-1:t==d||t.ownerDocument==w&&x(w,t)?1:c?P(c,e)-P(c,t):0:4&r?-1:1)}:function(e,t){if(e===t)return f=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==d?-1:t==d?1:i?-1:o?1:c?P(c,e)-P(c,t):0;if(i===o)return pe(e,t);for(n=e;n=n.parentNode;)a.unshift(n);for(n=t;n=n.parentNode;)s.unshift(n);for(;a[r]===s[r];)r++;return r?pe(a[r],s[r]):a[r]==w?-1:s[r]==w?1:0},d):d},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(p(e),n.matchesSelector&&g&&!A[t+" "]&&(!y||!y.test(t))&&(!v||!v.test(t)))try{var r=m.call(e,t);if(r||n.disconnectedMatch||e.document&&11!==e.document.nodeType)return r}catch(e){A(t,!0)}return se(t,d,null,[e]).length>0},se.contains=function(e,t){return(e.ownerDocument||e)!=d&&p(e),x(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=d&&p(e);var i=r.attrHandle[t.toLowerCase()],o=i&&j.call(r.attrHandle,t.toLowerCase())?i(e,t,!g):void 0;return void 0!==o?o:n.attributes||!g?e.getAttribute(t):(o=e.getAttributeNode(t))&&o.specified?o.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,r=[],i=0,o=0;if(f=!n.detectDuplicates,c=!n.sortStable&&e.slice(0),e.sort(N),f){for(;t=e[o++];)t===e[o]&&(i=r.push(o));for(;i--;)e.splice(r[i],1)}return c=null,e},i=se.getText=function(e){var t,n="",r=0,o=e.nodeType;if(o){if(1===o||9===o||11===o){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=i(e)}else if(3===o||4===o)return e.nodeValue}else for(;t=e[r++];)n+=i(t);return n},(r=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=a(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=E[e+" "];return t||(t=new RegExp("(^|[\\x20\\t\\r\\n\\f])"+e+"("+M+"|$)"))&&E(e,(function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")}))},ATTR:function(e,t,n){return function(r){var i=se.attr(r,e);return null==i?"!="===t:!t||(i+="","="===t?i===n:"!="===t?i!==n:"^="===t?n&&0===i.indexOf(n):"*="===t?n&&i.indexOf(n)>-1:"$="===t?n&&i.slice(-n.length)===n:"~="===t?(" "+i.replace(B," ")+" ").indexOf(n)>-1:"|="===t&&(i===n||i.slice(0,n.length+1)===n+"-"))}},CHILD:function(e,t,n,r,i){var o="nth"!==e.slice(0,3),a="last"!==e.slice(-4),s="of-type"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,f,p,d,h,g=o!==a?"nextSibling":"previousSibling",v=t.parentNode,y=s&&t.nodeName.toLowerCase(),m=!u&&!s,x=!1;if(v){if(o){for(;g;){for(p=t;p=p[g];)if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[a?v.firstChild:v.lastChild],a&&m){for(x=(d=(l=(c=(f=(p=v)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1])&&l[2],p=d&&v.childNodes[d];p=++d&&p&&p[g]||(x=d=0)||h.pop();)if(1===p.nodeType&&++x&&p===t){c[e]=[T,d,x];break}}else if(m&&(x=d=(l=(c=(f=(p=t)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1]),!1===x)for(;(p=++d&&p&&p[g]||(x=d=0)||h.pop())&&((s?p.nodeName.toLowerCase()!==y:1!==p.nodeType)||!++x||(m&&((c=(f=p[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]=[T,x]),p!==t)););return(x-=i)===r||x%r==0&&x/r>=0}}},PSEUDO:function(e,t){var n,i=r.pseudos[e]||r.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return i[b]?i(t):i.length>1?(n=[e,e,"",t],r.setFilters.hasOwnProperty(e.toLowerCase())?le((function(e,n){for(var r,o=i(e,t),a=o.length;a--;)e[r=P(e,o[a])]=!(n[r]=o[a])})):function(e){return i(e,0,n)}):i}},pseudos:{not:le((function(e){var t=[],n=[],r=s(e.replace($,"$1"));return r[b]?le((function(e,t,n,i){for(var o,a=r(e,null,i,[]),s=e.length;s--;)(o=a[s])&&(e[s]=!(t[s]=o))})):function(e,i,o){return t[0]=e,r(t,null,o,n),t[0]=null,!n.pop()}})),has:le((function(e){return function(t){return se(e,t).length>0}})),contains:le((function(e){return e=e.replace(te,ne),function(t){return(t.textContent||i(t)).indexOf(e)>-1}})),lang:le((function(e){return V.test(e||"")||se.error("unsupported lang: "+e),e=e.replace(te,ne).toLowerCase(),function(t){var n;do{if(n=g?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return(n=n.toLowerCase())===e||0===n.indexOf(e+"-")}while((t=t.parentNode)&&1===t.nodeType);return!1}})),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===h},focus:function(e){return e===d.activeElement&&(!d.hasFocus||d.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!r.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve((function(){return[0]})),last:ve((function(e,t){return[t-1]})),eq:ve((function(e,t,n){return[n<0?n+t:n]})),even:ve((function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e})),odd:ve((function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e})),lt:ve((function(e,t,n){for(var r=n<0?n+t:n>t?t:n;--r>=0;)e.push(r);return e})),gt:ve((function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e}))}}).pseudos.nth=r.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})r.pseudos[t]=de(t);for(t in{submit:!0,reset:!0})r.pseudos[t]=he(t);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(e,t,n){var r=t.dir,i=t.next,o=i||r,a=n&&"parentNode"===o,s=C++;return t.first?function(t,n,i){for(;t=t[r];)if(1===t.nodeType||a)return e(t,n,i);return!1}:function(t,n,u){var l,c,f,p=[T,s];if(u){for(;t=t[r];)if((1===t.nodeType||a)&&e(t,n,u))return!0}else for(;t=t[r];)if(1===t.nodeType||a)if(c=(f=t[b]||(t[b]={}))[t.uniqueID]||(f[t.uniqueID]={}),i&&i===t.nodeName.toLowerCase())t=t[r]||t;else{if((l=c[o])&&l[0]===T&&l[1]===s)return p[2]=l[2];if(c[o]=p,p[2]=e(t,n,u))return!0}return!1}}function we(e){return e.length>1?function(t,n,r){for(var i=e.length;i--;)if(!e[i](t,n,r))return!1;return!0}:e[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(e,t,n,r,i,o){return r&&!r[b]&&(r=Ce(r)),i&&!i[b]&&(i=Ce(i,o)),le((function(o,a,s,u){var l,c,f,p=[],d=[],h=a.length,g=o||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(t||"*",s.nodeType?[s]:s,[]),v=!e||!o&&t?g:Te(g,p,e,s,u),y=n?i||(o?e:h||r)?[]:a:v;if(n&&n(v,y,s,u),r)for(l=Te(y,d),r(l,[],s,u),c=l.length;c--;)(f=l[c])&&(y[d[c]]=!(v[d[c]]=f));if(o){if(i||e){if(i){for(l=[],c=y.length;c--;)(f=y[c])&&l.push(v[c]=f);i(null,y=[],l,u)}for(c=y.length;c--;)(f=y[c])&&(l=i?P(o,f):p[c])>-1&&(o[l]=!(a[l]=f))}}else y=Te(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)}))}function Ee(e){for(var t,n,i,o=e.length,a=r.relative[e[0].type],s=a||r.relative[" "],u=a?1:0,c=be((function(e){return e===t}),s,!0),f=be((function(e){return P(t,e)>-1}),s,!0),p=[function(e,n,r){var i=!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):f(e,n,r));return t=null,i}];u<o;u++)if(n=r.relative[e[u].type])p=[be(we(p),n)];else{if((n=r.filter[e[u].type].apply(null,e[u].matches))[b]){for(i=++u;i<o&&!r.relative[e[i].type];i++);return Ce(u>1&&we(p),u>1&&xe(e.slice(0,u-1).concat({value:" "===e[u-2].type?"*":""})).replace($,"$1"),n,u<i&&Ee(e.slice(u,i)),i<o&&Ee(e=e.slice(i)),i<o&&xe(e))}p.push(n)}return we(p)}return me.prototype=r.filters=r.pseudos,r.setFilters=new me,a=se.tokenize=function(e,t){var n,i,o,a,s,u,l,c=S[e+" "];if(c)return t?0:c.slice(0);for(s=e,u=[],l=r.preFilter;s;){for(a in n&&!(i=_.exec(s))||(i&&(s=s.slice(i[0].length)||s),u.push(o=[])),n=!1,(i=z.exec(s))&&(n=i.shift(),o.push({value:n,type:i[0].replace($," ")}),s=s.slice(n.length)),r.filter)!(i=G[a].exec(s))||l[a]&&!(i=l[a](i))||(n=i.shift(),o.push({value:n,type:a,matches:i}),s=s.slice(n.length));if(!n)break}return t?s.length:s?se.error(e):S(e,u).slice(0)},s=se.compile=function(e,t){var n,i=[],o=[],s=k[e+" "];if(!s){for(t||(t=a(e)),n=t.length;n--;)(s=Ee(t[n]))[b]?i.push(s):o.push(s);(s=k(e,function(e,t){var n=t.length>0,i=e.length>0,o=function(o,a,s,u,c){var f,h,v,y=0,m="0",x=o&&[],b=[],w=l,C=o||i&&r.find.TAG("*",c),E=T+=null==w?1:Math.random()||.1,S=C.length;for(c&&(l=a==d||a||c);m!==S&&null!=(f=C[m]);m++){if(i&&f){for(h=0,a||f.ownerDocument==d||(p(f),s=!g);v=e[h++];)if(v(f,a||d,s)){u.push(f);break}c&&(T=E)}n&&((f=!v&&f)&&y--,o&&x.push(f))}if(y+=m,n&&m!==y){for(h=0;v=t[h++];)v(x,b,a,s);if(o){if(y>0)for(;m--;)x[m]||b[m]||(b[m]=q.call(u));b=Te(b)}H.apply(u,b),c&&!o&&b.length>0&&y+t.length>1&&se.uniqueSort(u)}return c&&(T=E,l=w),x};return n?le(o):o}(o,i))).selector=e}return s},u=se.select=function(e,t,n,i){var o,u,l,c,f,p="function"==typeof e&&e,d=!i&&a(e=p.selector||e);if(n=n||[],1===d.length){if((u=d[0]=d[0].slice(0)).length>2&&"ID"===(l=u[0]).type&&9===t.nodeType&&g&&r.relative[u[1].type]){if(!(t=(r.find.ID(l.matches[0].replace(te,ne),t)||[])[0]))return n;p&&(t=t.parentNode),e=e.slice(u.shift().value.length)}for(o=G.needsContext.test(e)?0:u.length;o--&&(l=u[o],!r.relative[c=l.type]);)if((f=r.find[c])&&(i=f(l.matches[0].replace(te,ne),ee.test(u[0].type)&&ye(t.parentNode)||t))){if(u.splice(o,1),!(e=i.length&&xe(u)))return H.apply(n,i),n;break}}return(p||s(e,d))(i,t,!g,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},n.sortStable=b.split("").sort(N).join("")===b,n.detectDuplicates=!!f,p(),n.sortDetached=ce((function(e){return 1&e.compareDocumentPosition(d.createElement("fieldset"))})),ce((function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")}))||fe("type|href|height|width",(function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)})),n.attributes&&ce((function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")}))||fe("value",(function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue})),ce((function(e){return null==e.getAttribute("disabled")}))||fe(R,(function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null})),se}(e);w.find=C,w.expr=C.selectors,w.expr[":"]=w.expr.pseudos,w.uniqueSort=w.unique=C.uniqueSort,w.text=C.getText,w.isXMLDoc=C.isXML,w.contains=C.contains,w.escapeSelector=C.escape;var E=function(e,t,n){for(var r=[],i=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(i&&w(e).is(n))break;r.push(e)}return r},S=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},k=w.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var N=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function j(e,t,n){return h(t)?w.grep(e,(function(e,r){return!!t.call(e,r,e)!==n})):t.nodeType?w.grep(e,(function(e){return e===t!==n})):"string"!=typeof t?w.grep(e,(function(e){return s.call(t,e)>-1!==n})):w.filter(t,e,n)}w.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?w.find.matchesSelector(r,e)?[r]:[]:w.find.matches(e,w.grep(t,(function(e){return 1===e.nodeType})))},w.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(w(e).filter((function(){for(t=0;t<r;t++)if(w.contains(i[t],this))return!0})));for(n=this.pushStack([]),t=0;t<r;t++)w.find(e,i[t],n);return r>1?w.uniqueSort(n):n},filter:function(e){return this.pushStack(j(this,e||[],!1))},not:function(e){return this.pushStack(j(this,e||[],!0))},is:function(e){return!!j(this,"string"==typeof e&&k.test(e)?w(e):e||[],!1).length}});var D,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(w.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||D,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:q.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof w?t[0]:t,w.merge(this,w.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:v,!0)),N.test(r[1])&&w.isPlainObject(t))for(r in t)h(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=v.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):h(e)?void 0!==n.ready?n.ready(e):e(w):w.makeArray(e,this)}).prototype=w.fn,D=w(v);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}w.fn.extend({has:function(e){var t=w(e,this),n=t.length;return this.filter((function(){for(var e=0;e<n;e++)if(w.contains(this,t[e]))return!0}))},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&w(e);if(!k.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?a.index(n)>-1:1===n.nodeType&&w.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(o.length>1?w.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?s.call(w(e),this[0]):s.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(w.uniqueSort(w.merge(this.get(),w(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),w.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return E(e,"parentNode")},parentsUntil:function(e,t,n){return E(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return E(e,"nextSibling")},prevAll:function(e){return E(e,"previousSibling")},nextUntil:function(e,t,n){return E(e,"nextSibling",n)},prevUntil:function(e,t,n){return E(e,"previousSibling",n)},siblings:function(e){return S((e.parentNode||{}).firstChild,e)},children:function(e){return S(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(A(e,"template")&&(e=e.content||e),w.merge([],e.childNodes))}},(function(e,t){w.fn[e]=function(n,r){var i=w.map(this,t,n);return"Until"!==e.slice(-5)&&(r=n),r&&"string"==typeof r&&(i=w.filter(r,i)),this.length>1&&(H[e]||w.uniqueSort(i),L.test(e)&&i.reverse()),this.pushStack(i)}}));var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&h(i=e.promise)?i.call(e).done(t).fail(n):e&&h(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}w.Callbacks=function(e){e="string"==typeof e?function(e){var t={};return w.each(e.match(P)||[],(function(e,n){t[n]=!0})),t}(e):w.extend({},e);var t,n,r,i,o=[],a=[],s=-1,u=function(){for(i=i||e.once,r=t=!0;a.length;s=-1)for(n=a.shift();++s<o.length;)!1===o[s].apply(n[0],n[1])&&e.stopOnFalse&&(s=o.length,n=!1);e.memory||(n=!1),t=!1,i&&(o=n?[]:"")},l={add:function(){return o&&(n&&!t&&(s=o.length-1,a.push(n)),function t(n){w.each(n,(function(n,r){h(r)?e.unique&&l.has(r)||o.push(r):r&&r.length&&"string"!==x(r)&&t(r)}))}(arguments),n&&!t&&u()),this},remove:function(){return w.each(arguments,(function(e,t){for(var n;(n=w.inArray(t,o,n))>-1;)o.splice(n,1),n<=s&&s--})),this},has:function(e){return e?w.inArray(e,o)>-1:o.length>0},empty:function(){return o&&(o=[]),this},disable:function(){return i=a=[],o=n="",this},disabled:function(){return!o},lock:function(){return i=a=[],n||t||(o=n=""),this},locked:function(){return!!i},fireWith:function(e,n){return i||(n=[e,(n=n||[]).slice?n.slice():n],a.push(n),t||u()),this},fire:function(){return l.fireWith(this,arguments),this},fired:function(){return!!r}};return l},w.extend({Deferred:function(t){var n=[["notify","progress",w.Callbacks("memory"),w.Callbacks("memory"),2],["resolve","done",w.Callbacks("once memory"),w.Callbacks("once memory"),0,"resolved"],["reject","fail",w.Callbacks("once memory"),w.Callbacks("once memory"),1,"rejected"]],r="pending",i={state:function(){return r},always:function(){return o.done(arguments).fail(arguments),this},catch:function(e){return i.then(null,e)},pipe:function(){var e=arguments;return w.Deferred((function(t){w.each(n,(function(n,r){var i=h(e[r[4]])&&e[r[4]];o[r[1]]((function(){var e=i&&i.apply(this,arguments);e&&h(e.promise)?e.promise().progress(t.notify).done(t.resolve).fail(t.reject):t[r[0]+"With"](this,i?[e]:arguments)}))})),e=null})).promise()},then:function(t,r,i){var o=0;function a(t,n,r,i){return function(){var s=this,u=arguments,l=function(){var e,l;if(!(t<o)){if((e=r.apply(s,u))===n.promise())throw new TypeError("Thenable self-resolution");l=e&&("object"==typeof e||"function"==typeof e)&&e.then,h(l)?i?l.call(e,a(o,n,R,i),a(o,n,M,i)):(o++,l.call(e,a(o,n,R,i),a(o,n,M,i),a(o,n,R,n.notifyWith))):(r!==R&&(s=void 0,u=[e]),(i||n.resolveWith)(s,u))}},c=i?l:function(){try{l()}catch(e){w.Deferred.exceptionHook&&w.Deferred.exceptionHook(e,c.stackTrace),t+1>=o&&(r!==M&&(s=void 0,u=[e]),n.rejectWith(s,u))}};t?c():(w.Deferred.getStackHook&&(c.stackTrace=w.Deferred.getStackHook()),e.setTimeout(c))}}return w.Deferred((function(e){n[0][3].add(a(0,e,h(i)?i:R,e.notifyWith)),n[1][3].add(a(0,e,h(t)?t:R)),n[2][3].add(a(0,e,h(r)?r:M))})).promise()},promise:function(e){return null!=e?w.extend(e,i):i}},o={};return w.each(n,(function(e,t){var a=t[2],s=t[5];i[t[1]]=a.add,s&&a.add((function(){r=s}),n[3-e][2].disable,n[3-e][3].disable,n[0][2].lock,n[0][3].lock),a.add(t[3].fire),o[t[0]]=function(){return o[t[0]+"With"](this===o?void 0:this,arguments),this},o[t[0]+"With"]=a.fireWith})),i.promise(o),t&&t.call(o,o),o},when:function(e){var t=arguments.length,n=t,r=Array(n),o=i.call(arguments),a=w.Deferred(),s=function(e){return function(n){r[e]=this,o[e]=arguments.length>1?i.call(arguments):n,--t||a.resolveWith(r,o)}};if(t<=1&&(I(e,a.done(s(n)).resolve,a.reject,!t),"pending"===a.state()||h(o[n]&&o[n].then)))return a.then();for(;n--;)I(o[n],s(n),a.reject);return a.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;w.Deferred.exceptionHook=function(t,n){e.console&&e.console.warn&&t&&W.test(t.name)&&e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)},w.readyException=function(t){e.setTimeout((function(){throw t}))};var F=w.Deferred();function B(){v.removeEventListener("DOMContentLoaded",B),e.removeEventListener("load",B),w.ready()}w.fn.ready=function(e){return F.then(e).catch((function(e){w.readyException(e)})),this},w.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--w.readyWait:w.isReady)||(w.isReady=!0,!0!==e&&--w.readyWait>0||F.resolveWith(v,[w]))}}),w.ready.then=F.then,"complete"===v.readyState||"loading"!==v.readyState&&!v.documentElement.doScroll?e.setTimeout(w.ready):(v.addEventListener("DOMContentLoaded",B),e.addEventListener("load",B));var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===x(n))for(s in i=!0,n)$(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,h(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(w(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=w.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;for(;n--;)delete r[t[n]]}(void 0===t||w.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!w.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n=function(e){return"true"===e||"false"!==e&&("null"===e?null:e===+e+""?+e:J.test(e)?JSON.parse(e):e)}(n)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}w.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),w.fn.extend({data:function(e,t){var n,r,i,o=this[0],a=o&&o.attributes;if(void 0===e){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){for(n=a.length;n--;)a[n]&&0===(r=a[n].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof e?this.each((function(){Q.set(this,e)})):$(this,(function(t){var n;if(o&&void 0===t)return void 0!==(n=Q.get(o,e))||void 0!==(n=Z(o,e))?n:void 0;this.each((function(){Q.set(this,e,t)}))}),null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each((function(){Q.remove(this,e)}))}}),w.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,w.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=w.queue(e,t),r=n.length,i=n.shift(),o=w._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,(function(){w.dequeue(e,t)}),o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:w.Callbacks("once memory").add((function(){Y.remove(e,[t+"queue",n])}))})}}),w.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?w.queue(this[0],e):void 0===t?this:this.each((function(){var n=w.queue(this,e,t);w._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&w.dequeue(this,e)}))},dequeue:function(e){return this.each((function(){w.dequeue(this,e)}))},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=w.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";a--;)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=v.documentElement,ie=function(e){return w.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return w.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===w.css(e,"display")};function se(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return w.css(e,t,"")},u=s(),l=n&&n[3]||(w.cssNumber[t]?"":"px"),c=e.nodeType&&(w.cssNumber[t]||"px"!==l&&+u)&&te.exec(w.css(e,t));if(c&&c[3]!==l){for(u/=2,l=l||c[3],c=+u||1;a--;)w.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,w.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ue={};function le(e){var t,n=e.ownerDocument,r=e.nodeName,i=ue[r];return i||(t=n.body.appendChild(n.createElement(r)),i=w.css(t,"display"),t.parentNode.removeChild(t),"none"===i&&(i="block"),ue[r]=i,i)}function ce(e,t){for(var n,r,i=[],o=0,a=e.length;o<a;o++)(r=e[o]).style&&(n=r.style.display,t?("none"===n&&(i[o]=Y.get(r,"display")||null,i[o]||(r.style.display="")),""===r.style.display&&ae(r)&&(i[o]=le(r))):"none"!==n&&(i[o]="none",Y.set(r,"display",n)));for(o=0;o<a;o++)null!=i[o]&&(e[o].style.display=i[o]);return e}w.fn.extend({show:function(){return ce(this,!0)},hide:function(){return ce(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each((function(){ae(this)?w(this).show():w(this).hide()}))}});var fe,pe,de=/^(?:checkbox|radio)$/i,he=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,ge=/^$|^module$|\/(?:java|ecma)script/i;fe=v.createDocumentFragment().appendChild(v.createElement("div")),(pe=v.createElement("input")).setAttribute("type","radio"),pe.setAttribute("checked","checked"),pe.setAttribute("name","t"),fe.appendChild(pe),d.checkClone=fe.cloneNode(!0).cloneNode(!0).lastChild.checked,fe.innerHTML="<textarea>x</textarea>",d.noCloneChecked=!!fe.cloneNode(!0).lastChild.defaultValue,fe.innerHTML="<option></option>",d.option=!!fe.lastChild;var ve={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ye(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?w.merge([e],n):n}function me(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ve.tbody=ve.tfoot=ve.colgroup=ve.caption=ve.thead,ve.th=ve.td,d.option||(ve.optgroup=ve.option=[1,"<select multiple='multiple'>","</select>"]);var xe=/<|&#?\w+;/;function be(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===x(o))w.merge(p,o.nodeType?[o]:o);else if(xe.test(o)){for(a=a||f.appendChild(t.createElement("div")),s=(he.exec(o)||["",""])[1].toLowerCase(),u=ve[s]||ve._default,a.innerHTML=u[1]+w.htmlPrefilter(o)+u[2],c=u[0];c--;)a=a.lastChild;w.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));for(f.textContent="",d=0;o=p[d++];)if(r&&w.inArray(o,r)>-1)i&&i.push(o);else if(l=ie(o),a=ye(f.appendChild(o),"script"),l&&me(a),n)for(c=0;o=a[c++];)ge.test(o.type||"")&&n.push(o);return f}var we=/^([^.]*)(?:\.(.+)|)/;function Te(){return!0}function Ce(){return!1}function Ee(e,t){return e===function(){try{return v.activeElement}catch(e){}}()==("focus"===t)}function Se(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)Se(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Ce;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return w().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=w.guid++)),e.each((function(){w.event.add(this,t,i,r,n)}))}function ke(e,t,n){n?(Y.set(e,t,!1),w.event.add(e,t,{namespace:!1,handler:function(e){var r,o,a=Y.get(this,t);if(1&e.isTrigger&&this[t]){if(a.length)(w.event.special[t]||{}).delegateType&&e.stopPropagation();else if(a=i.call(arguments),Y.set(this,t,a),r=n(this,t),this[t](),a!==(o=Y.get(this,t))||r?Y.set(this,t,!1):o={},a!==o)return e.stopImmediatePropagation(),e.preventDefault(),o&&o.value}else a.length&&(Y.set(this,t,{value:w.event.trigger(w.extend(a[0],w.Event.prototype),a.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,t)&&w.event.add(e,t,Te)}w.event={global:{},add:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(e);if(V(e))for(n.handler&&(n=(o=n).handler,i=o.selector),i&&w.find.matchesSelector(re,i),n.guid||(n.guid=w.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(t){return void 0!==w&&w.event.triggered!==t.type?w.event.dispatch.apply(e,arguments):void 0}),l=(t=(t||"").match(P)||[""]).length;l--;)d=g=(s=we.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=w.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=w.event.special[d]||{},c=w.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&w.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(e,r,h,a)||e.addEventListener&&e.addEventListener(d,a)),f.add&&(f.add.call(e,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),w.event.global[d]=!0)},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){for(l=(t=(t||"").match(P)||[""]).length;l--;)if(d=g=(s=we.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){for(f=w.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;o--;)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||w.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)w.event.remove(e,d+t[l],n,r,!0);w.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=w.event.fix(e),l=(Y.get(this,"events")||Object.create(null))[u.type]||[],c=w.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){for(a=w.event.handlers.call(this,u,l),t=0;(i=a[t++])&&!u.isPropagationStopped();)for(u.currentTarget=i.elem,n=0;(o=i.handlers[n++])&&!u.isImmediatePropagationStopped();)u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((w.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()));return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&e.button>=1))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?w(i,this).index(l)>-1:w.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(e,t){Object.defineProperty(w.Event.prototype,e,{enumerable:!0,configurable:!0,get:h(t)?function(){if(this.originalEvent)return t(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[e]},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})},fix:function(e){return e[w.expando]?e:new w.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return de.test(t.type)&&t.click&&A(t,"input")&&ke(t,"click",Te),!1},trigger:function(e){var t=this||e;return de.test(t.type)&&t.click&&A(t,"input")&&ke(t,"click"),!0},_default:function(e){var t=e.target;return de.test(t.type)&&t.click&&A(t,"input")&&Y.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},w.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},w.Event=function(e,t){if(!(this instanceof w.Event))return new w.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Te:Ce,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&w.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[w.expando]=!0},w.Event.prototype={constructor:w.Event,isDefaultPrevented:Ce,isPropagationStopped:Ce,isImmediatePropagationStopped:Ce,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Te,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Te,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Te,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},w.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:!0},w.event.addProp),w.each({focus:"focusin",blur:"focusout"},(function(e,t){w.event.special[e]={setup:function(){return ke(this,e,Ee),!1},trigger:function(){return ke(this,e),!0},_default:function(){return!0},delegateType:t}})),w.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},(function(e,t){w.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;return i&&(i===r||w.contains(r,i))||(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}})),w.fn.extend({on:function(e,t,n,r){return Se(this,e,t,n,r)},one:function(e,t,n,r){return Se(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,w(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Ce),this.each((function(){w.event.remove(this,e,n,t)}))}});var Ae=/<script|<style|<link/i,Ne=/checked\s*(?:[^=]|=\s*.checked.)/i,je=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function De(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&w(e).children("tbody")[0]||e}function qe(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function Le(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function He(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(Y.hasData(e)&&(s=Y.get(e).events))for(i in Y.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)w.event.add(t,i,s[i][n]);Q.hasData(e)&&(o=Q.access(e),a=w.extend({},o),Q.set(t,a))}}function Oe(e,t){var n=t.nodeName.toLowerCase();"input"===n&&de.test(e.type)?t.checked=e.checked:"input"!==n&&"textarea"!==n||(t.defaultValue=e.defaultValue)}function Pe(e,t,n,r){t=o(t);var i,a,s,u,l,c,f=0,p=e.length,g=p-1,v=t[0],y=h(v);if(y||p>1&&"string"==typeof v&&!d.checkClone&&Ne.test(v))return e.each((function(i){var o=e.eq(i);y&&(t[0]=v.call(this,i,o.html())),Pe(o,t,n,r)}));if(p&&(a=(i=be(t,e[0].ownerDocument,!1,e,r)).firstChild,1===i.childNodes.length&&(i=a),a||r)){for(u=(s=w.map(ye(i,"script"),qe)).length;f<p;f++)l=i,f!==g&&(l=w.clone(l,!0,!0),u&&w.merge(s,ye(l,"script"))),n.call(e[f],l,f);if(u)for(c=s[s.length-1].ownerDocument,w.map(s,Le),f=0;f<u;f++)l=s[f],ge.test(l.type||"")&&!Y.access(l,"globalEval")&&w.contains(c,l)&&(l.src&&"module"!==(l.type||"").toLowerCase()?w._evalUrl&&!l.noModule&&w._evalUrl(l.src,{nonce:l.nonce||l.getAttribute("nonce")},c):m(l.textContent.replace(je,""),l,c))}return e}function Re(e,t,n){for(var r,i=t?w.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||w.cleanData(ye(r)),r.parentNode&&(n&&ie(r)&&me(ye(r,"script")),r.parentNode.removeChild(r));return e}w.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s=e.cloneNode(!0),u=ie(e);if(!(d.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||w.isXMLDoc(e)))for(a=ye(s),r=0,i=(o=ye(e)).length;r<i;r++)Oe(o[r],a[r]);if(t)if(n)for(o=o||ye(e),a=a||ye(s),r=0,i=o.length;r<i;r++)He(o[r],a[r]);else He(e,s);return(a=ye(s,"script")).length>0&&me(a,!u&&ye(e,"script")),s},cleanData:function(e){for(var t,n,r,i=w.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?w.event.remove(n,r):w.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),w.fn.extend({detach:function(e){return Re(this,e,!0)},remove:function(e){return Re(this,e)},text:function(e){return $(this,(function(e){return void 0===e?w.text(this):this.empty().each((function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)}))}),null,e,arguments.length)},append:function(){return Pe(this,arguments,(function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||De(this,e).appendChild(e)}))},prepend:function(){return Pe(this,arguments,(function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=De(this,e);t.insertBefore(e,t.firstChild)}}))},before:function(){return Pe(this,arguments,(function(e){this.parentNode&&this.parentNode.insertBefore(e,this)}))},after:function(){return Pe(this,arguments,(function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)}))},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(w.cleanData(ye(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map((function(){return w.clone(this,e,t)}))},html:function(e){return $(this,(function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Ae.test(e)&&!ve[(he.exec(e)||["",""])[1].toLowerCase()]){e=w.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(w.cleanData(ye(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)}),null,e,arguments.length)},replaceWith:function(){var e=[];return Pe(this,arguments,(function(t){var n=this.parentNode;w.inArray(this,e)<0&&(w.cleanData(ye(this)),n&&n.replaceChild(t,this))}),e)}}),w.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},(function(e,t){w.fn[e]=function(e){for(var n,r=[],i=w(e),o=i.length-1,s=0;s<=o;s++)n=s===o?this:this.clone(!0),w(i[s])[t](n),a.apply(r,n.get());return this.pushStack(r)}}));var Me=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Ie=function(t){var n=t.ownerDocument.defaultView;return n&&n.opener||(n=e),n.getComputedStyle(t)},We=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Fe=new RegExp(ne.join("|"),"i");function Be(e,t,n){var r,i,o,a,s=e.style;return(n=n||Ie(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=w.style(e,t)),!d.pixelBoxStyles()&&Me.test(a)&&Fe.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function $e(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function t(){if(c){l.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",c.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(l).appendChild(c);var t=e.getComputedStyle(c);r="1%"!==t.top,u=12===n(t.marginLeft),c.style.right="60%",a=36===n(t.right),i=36===n(t.width),c.style.position="absolute",o=12===n(c.offsetWidth/3),re.removeChild(l),c=null}}function n(e){return Math.round(parseFloat(e))}var r,i,o,a,s,u,l=v.createElement("div"),c=v.createElement("div");c.style&&(c.style.backgroundClip="content-box",c.cloneNode(!0).style.backgroundClip="",d.clearCloneStyle="content-box"===c.style.backgroundClip,w.extend(d,{boxSizingReliable:function(){return t(),i},pixelBoxStyles:function(){return t(),a},pixelPosition:function(){return t(),r},reliableMarginLeft:function(){return t(),u},scrollboxSize:function(){return t(),o},reliableTrDimensions:function(){var t,n,r,i;return null==s&&(t=v.createElement("table"),n=v.createElement("tr"),r=v.createElement("div"),t.style.cssText="position:absolute;left:-11111px;border-collapse:separate",n.style.cssText="border:1px solid",n.style.height="1px",r.style.height="9px",r.style.display="block",re.appendChild(t).appendChild(n).appendChild(r),i=e.getComputedStyle(n),s=parseInt(i.height,10)+parseInt(i.borderTopWidth,10)+parseInt(i.borderBottomWidth,10)===n.offsetHeight,re.removeChild(t)),s}}))}();var _e=["Webkit","Moz","ms"],ze=v.createElement("div").style,Ue={};function Xe(e){var t=w.cssProps[e]||Ue[e];return t||(e in ze?e:Ue[e]=function(e){for(var t=e[0].toUpperCase()+e.slice(1),n=_e.length;n--;)if((e=_e[n]+t)in ze)return e}(e)||e)}var Ve=/^(none|table(?!-c[ea]).+)/,Ge=/^--/,Ye={position:"absolute",visibility:"hidden",display:"block"},Qe={letterSpacing:"0",fontWeight:"400"};function Je(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Ke(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=w.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=w.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=w.css(e,"border"+ne[a]+"Width",!0,i))):(u+=w.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=w.css(e,"border"+ne[a]+"Width",!0,i):s+=w.css(e,"border"+ne[a]+"Width",!0,i));return!r&&o>=0&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function Ze(e,t,n){var r=Ie(e),i=(!d.boxSizingReliable()||n)&&"border-box"===w.css(e,"boxSizing",!1,r),o=i,a=Be(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Me.test(a)){if(!n)return a;a="auto"}return(!d.boxSizingReliable()&&i||!d.reliableTrDimensions()&&A(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===w.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===w.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Ke(e,t,n||(i?"border":"content"),o,r,a)+"px"}function et(e,t,n,r,i){return new et.prototype.init(e,t,n,r,i)}w.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Be(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Ge.test(t),l=e.style;if(u||(t=Xe(s)),a=w.cssHooks[t]||w.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=se(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(w.cssNumber[s]?"":"px")),d.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Ge.test(t)||(t=Xe(s)),(a=w.cssHooks[t]||w.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=Be(e,t,r)),"normal"===i&&t in Qe&&(i=Qe[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),w.each(["height","width"],(function(e,t){w.cssHooks[t]={get:function(e,n,r){if(n)return!Ve.test(w.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Ze(e,t,r):We(e,Ye,(function(){return Ze(e,t,r)}))},set:function(e,n,r){var i,o=Ie(e),a=!d.scrollboxSize()&&"absolute"===o.position,s=(a||r)&&"border-box"===w.css(e,"boxSizing",!1,o),u=r?Ke(e,t,r,s,o):0;return s&&a&&(u-=Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-parseFloat(o[t])-Ke(e,t,"border",!1,o)-.5)),u&&(i=te.exec(n))&&"px"!==(i[3]||"px")&&(e.style[t]=n,n=w.css(e,t)),Je(0,n,u)}}})),w.cssHooks.marginLeft=$e(d.reliableMarginLeft,(function(e,t){if(t)return(parseFloat(Be(e,"marginLeft"))||e.getBoundingClientRect().left-We(e,{marginLeft:0},(function(){return e.getBoundingClientRect().left})))+"px"})),w.each({margin:"",padding:"",border:"Width"},(function(e,t){w.cssHooks[e+t]={expand:function(n){for(var r=0,i={},o="string"==typeof n?n.split(" "):[n];r<4;r++)i[e+ne[r]+t]=o[r]||o[r-2]||o[0];return i}},"margin"!==e&&(w.cssHooks[e+t].set=Je)})),w.fn.extend({css:function(e,t){return $(this,(function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Ie(e),i=t.length;a<i;a++)o[t[a]]=w.css(e,t[a],!1,r);return o}return void 0!==n?w.style(e,t,n):w.css(e,t)}),e,t,arguments.length>1)}}),w.Tween=et,et.prototype={constructor:et,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||w.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(w.cssNumber[n]?"":"px")},cur:function(){var e=et.propHooks[this.prop];return e&&e.get?e.get(this):et.propHooks._default.get(this)},run:function(e){var t,n=et.propHooks[this.prop];return this.options.duration?this.pos=t=w.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):et.propHooks._default.set(this),this}},et.prototype.init.prototype=et.prototype,et.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=w.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){w.fx.step[e.prop]?w.fx.step[e.prop](e):1!==e.elem.nodeType||!w.cssHooks[e.prop]&&null==e.elem.style[Xe(e.prop)]?e.elem[e.prop]=e.now:w.style(e.elem,e.prop,e.now+e.unit)}}},et.propHooks.scrollTop=et.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},w.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},w.fx=et.prototype.init,w.fx.step={};var tt,nt,rt=/^(?:toggle|show|hide)$/,it=/queueHooks$/;function ot(){nt&&(!1===v.hidden&&e.requestAnimationFrame?e.requestAnimationFrame(ot):e.setTimeout(ot,w.fx.interval),w.fx.tick())}function at(){return e.setTimeout((function(){tt=void 0})),tt=Date.now()}function st(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ut(e,t,n){for(var r,i=(lt.tweeners[t]||[]).concat(lt.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function lt(e,t,n){var r,i,o=0,a=lt.prefilters.length,s=w.Deferred().always((function(){delete u.elem})),u=function(){if(i)return!1;for(var t=tt||at(),n=Math.max(0,l.startTime+l.duration-t),r=1-(n/l.duration||0),o=0,a=l.tweens.length;o<a;o++)l.tweens[o].run(r);return s.notifyWith(e,[l,r,n]),r<1&&a?n:(a||s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:w.extend({},t),opts:w.extend(!0,{specialEasing:{},easing:w.easing._default},n),originalProperties:t,originalOptions:n,startTime:tt||at(),duration:n.duration,tweens:[],createTween:function(t,n){var r=w.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;n<r;n++)l.tweens[n].run(1);return t?(s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l,t])):s.rejectWith(e,[l,t]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=w.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);o<a;o++)if(r=lt.prefilters[o].call(l,e,c,l.opts))return h(r.stop)&&(w._queueHooks(l.elem,l.opts.queue).stop=r.stop.bind(r)),r;return w.map(c,ut,l),h(l.opts.start)&&l.opts.start.call(e,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),w.fx.timer(w.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l}w.Animation=w.extend(lt,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return se(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){h(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],lt.tweeners[n]=lt.tweeners[n]||[],lt.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=w._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always((function(){p.always((function(){a.unqueued--,w.queue(e,"fx").length||a.empty.fire()}))}))),t)if(i=t[r],rt.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||w.style(e,r)}if((u=!w.isEmptyObject(t))||!w.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=w.css(e,"display"))&&(l?c=l:(ce([e],!0),l=e.style.display||l,c=w.css(e,"display"),ce([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===w.css(e,"float")&&(u||(p.done((function(){h.display=l})),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always((function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]}))),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&ce([e],!0),p.done((function(){for(r in g||ce([e]),Y.remove(e,"fxshow"),d)w.style(e,r,d[r])}))),u=ut(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?lt.prefilters.unshift(e):lt.prefilters.push(e)}}),w.speed=function(e,t,n){var r=e&&"object"==typeof e?w.extend({},e):{complete:n||!n&&t||h(e)&&e,duration:e,easing:n&&t||t&&!h(t)&&t};return w.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in w.fx.speeds?r.duration=w.fx.speeds[r.duration]:r.duration=w.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){h(r.old)&&r.old.call(this),r.queue&&w.dequeue(this,r.queue)},r},w.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=w.isEmptyObject(e),o=w.speed(t,n,r),a=function(){var t=lt(this,w.extend({},e),o);(i||Y.get(this,"finish"))&&t.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(e,t,n){var r=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&this.queue(e||"fx",[]),this.each((function(){var t=!0,i=null!=e&&e+"queueHooks",o=w.timers,a=Y.get(this);if(i)a[i]&&a[i].stop&&r(a[i]);else for(i in a)a[i]&&a[i].stop&&it.test(i)&&r(a[i]);for(i=o.length;i--;)o[i].elem!==this||null!=e&&o[i].queue!==e||(o[i].anim.stop(n),t=!1,o.splice(i,1));!t&&n||w.dequeue(this,e)}))},finish:function(e){return!1!==e&&(e=e||"fx"),this.each((function(){var t,n=Y.get(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=w.timers,a=r?r.length:0;for(n.finish=!0,w.queue(this,e,[]),i&&i.stop&&i.stop.call(this,!0),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;t<a;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish}))}}),w.each(["toggle","show","hide"],(function(e,t){var n=w.fn[t];w.fn[t]=function(e,r,i){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(st(t,!0),e,r,i)}})),w.each({slideDown:st("show"),slideUp:st("hide"),slideToggle:st("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},(function(e,t){w.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}})),w.timers=[],w.fx.tick=function(){var e,t=0,n=w.timers;for(tt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||w.fx.stop(),tt=void 0},w.fx.timer=function(e){w.timers.push(e),w.fx.start()},w.fx.interval=13,w.fx.start=function(){nt||(nt=!0,ot())},w.fx.stop=function(){nt=null},w.fx.speeds={slow:600,fast:200,_default:400},w.fn.delay=function(t,n){return t=w.fx&&w.fx.speeds[t]||t,n=n||"fx",this.queue(n,(function(n,r){var i=e.setTimeout(n,t);r.stop=function(){e.clearTimeout(i)}}))},function(){var e=v.createElement("input"),t=v.createElement("select").appendChild(v.createElement("option"));e.type="checkbox",d.checkOn=""!==e.value,d.optSelected=t.selected,(e=v.createElement("input")).value="t",e.type="radio",d.radioValue="t"===e.value}();var ct,ft=w.expr.attrHandle;w.fn.extend({attr:function(e,t){return $(this,w.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each((function(){w.removeAttr(this,e)}))}}),w.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return void 0===e.getAttribute?w.prop(e,t,n):(1===o&&w.isXMLDoc(e)||(i=w.attrHooks[t.toLowerCase()]||(w.expr.match.bool.test(t)?ct:void 0)),void 0!==n?null===n?void w.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=w.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!d.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)for(;n=i[r++];)e.removeAttribute(n)}}),ct={set:function(e,t,n){return!1===t?w.removeAttr(e,n):e.setAttribute(n,n),n}},w.each(w.expr.match.bool.source.match(/\w+/g),(function(e,t){var n=ft[t]||w.find.attr;ft[t]=function(e,t,r){var i,o,a=t.toLowerCase();return r||(o=ft[a],ft[a]=i,i=null!=n(e,t,r)?a:null,ft[a]=o),i}}));var pt=/^(?:input|select|textarea|button)$/i,dt=/^(?:a|area)$/i;function ht(e){return(e.match(P)||[]).join(" ")}function gt(e){return e.getAttribute&&e.getAttribute("class")||""}function vt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}w.fn.extend({prop:function(e,t){return $(this,w.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each((function(){delete this[w.propFix[e]||e]}))}}),w.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&w.isXMLDoc(e)||(t=w.propFix[t]||t,i=w.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=w.find.attr(e,"tabindex");return t?parseInt(t,10):pt.test(e.nodeName)||dt.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),d.optSelected||(w.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),w.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],(function(){w.propFix[this.toLowerCase()]=this})),w.fn.extend({addClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e))return this.each((function(t){w(this).addClass(e.call(this,t,gt(this)))}));if((t=vt(e)).length)for(;n=this[u++];)if(i=gt(n),r=1===n.nodeType&&" "+ht(i)+" "){for(a=0;o=t[a++];)r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=ht(r))&&n.setAttribute("class",s)}return this},removeClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e))return this.each((function(t){w(this).removeClass(e.call(this,t,gt(this)))}));if(!arguments.length)return this.attr("class","");if((t=vt(e)).length)for(;n=this[u++];)if(i=gt(n),r=1===n.nodeType&&" "+ht(i)+" "){for(a=0;o=t[a++];)for(;r.indexOf(" "+o+" ")>-1;)r=r.replace(" "+o+" "," ");i!==(s=ht(r))&&n.setAttribute("class",s)}return this},toggleClass:function(e,t){var n=typeof e,r="string"===n||Array.isArray(e);return"boolean"==typeof t&&r?t?this.addClass(e):this.removeClass(e):h(e)?this.each((function(n){w(this).toggleClass(e.call(this,n,gt(this),t),t)})):this.each((function(){var t,i,o,a;if(r)for(i=0,o=w(this),a=vt(e);t=a[i++];)o.hasClass(t)?o.removeClass(t):o.addClass(t);else void 0!==e&&"boolean"!==n||((t=gt(this))&&Y.set(this,"__className__",t),this.setAttribute&&this.setAttribute("class",t||!1===e?"":Y.get(this,"__className__")||""))}))},hasClass:function(e){var t,n,r=0;for(t=" "+e+" ";n=this[r++];)if(1===n.nodeType&&(" "+ht(gt(n))+" ").indexOf(t)>-1)return!0;return!1}});var yt=/\r/g;w.fn.extend({val:function(e){var t,n,r,i=this[0];return arguments.length?(r=h(e),this.each((function(n){var i;1===this.nodeType&&(null==(i=r?e.call(this,n,w(this).val()):e)?i="":"number"==typeof i?i+="":Array.isArray(i)&&(i=w.map(i,(function(e){return null==e?"":e+""}))),(t=w.valHooks[this.type]||w.valHooks[this.nodeName.toLowerCase()])&&"set"in t&&void 0!==t.set(this,i,"value")||(this.value=i))}))):i?(t=w.valHooks[i.type]||w.valHooks[i.nodeName.toLowerCase()])&&"get"in t&&void 0!==(n=t.get(i,"value"))?n:"string"==typeof(n=i.value)?n.replace(yt,""):null==n?"":n:void 0}}),w.extend({valHooks:{option:{get:function(e){var t=w.find.attr(e,"value");return null!=t?t:ht(w.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=w(n).val(),a)return t;s.push(t)}return s},set:function(e,t){for(var n,r,i=e.options,o=w.makeArray(t),a=i.length;a--;)((r=i[a]).selected=w.inArray(w.valHooks.option.get(r),o)>-1)&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),w.each(["radio","checkbox"],(function(){w.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=w.inArray(w(e).val(),t)>-1}},d.checkOn||(w.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})})),d.focusin="onfocusin"in e;var mt=/^(?:focusinfocus|focusoutblur)$/,xt=function(e){e.stopPropagation()};w.extend(w.event,{trigger:function(t,n,r,i){var o,a,s,u,l,f,p,d,y=[r||v],m=c.call(t,"type")?t.type:t,x=c.call(t,"namespace")?t.namespace.split("."):[];if(a=d=s=r=r||v,3!==r.nodeType&&8!==r.nodeType&&!mt.test(m+w.event.triggered)&&(m.indexOf(".")>-1&&(x=m.split("."),m=x.shift(),x.sort()),l=m.indexOf(":")<0&&"on"+m,(t=t[w.expando]?t:new w.Event(m,"object"==typeof t&&t)).isTrigger=i?2:3,t.namespace=x.join("."),t.rnamespace=t.namespace?new RegExp("(^|\\.)"+x.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=r),n=null==n?[t]:w.makeArray(n,[t]),p=w.event.special[m]||{},i||!p.trigger||!1!==p.trigger.apply(r,n))){if(!i&&!p.noBubble&&!g(r)){for(u=p.delegateType||m,mt.test(u+m)||(a=a.parentNode);a;a=a.parentNode)y.push(a),s=a;s===(r.ownerDocument||v)&&y.push(s.defaultView||s.parentWindow||e)}for(o=0;(a=y[o++])&&!t.isPropagationStopped();)d=a,t.type=o>1?u:p.bindType||m,(f=(Y.get(a,"events")||Object.create(null))[t.type]&&Y.get(a,"handle"))&&f.apply(a,n),(f=l&&a[l])&&f.apply&&V(a)&&(t.result=f.apply(a,n),!1===t.result&&t.preventDefault());return t.type=m,i||t.isDefaultPrevented()||p._default&&!1!==p._default.apply(y.pop(),n)||!V(r)||l&&h(r[m])&&!g(r)&&((s=r[l])&&(r[l]=null),w.event.triggered=m,t.isPropagationStopped()&&d.addEventListener(m,xt),r[m](),t.isPropagationStopped()&&d.removeEventListener(m,xt),w.event.triggered=void 0,s&&(r[l]=s)),t.result}},simulate:function(e,t,n){var r=w.extend(new w.Event,n,{type:e,isSimulated:!0});w.event.trigger(r,null,t)}}),w.fn.extend({trigger:function(e,t){return this.each((function(){w.event.trigger(e,t,this)}))},triggerHandler:function(e,t){var n=this[0];if(n)return w.event.trigger(e,t,n,!0)}}),d.focusin||w.each({focus:"focusin",blur:"focusout"},(function(e,t){var n=function(e){w.event.simulate(t,e.target,w.event.fix(e))};w.event.special[t]={setup:function(){var r=this.ownerDocument||this.document||this,i=Y.access(r,t);i||r.addEventListener(e,n,!0),Y.access(r,t,(i||0)+1)},teardown:function(){var r=this.ownerDocument||this.document||this,i=Y.access(r,t)-1;i?Y.access(r,t,i):(r.removeEventListener(e,n,!0),Y.remove(r,t))}}}));var bt=e.location,wt={guid:Date.now()},Tt=/\?/;w.parseXML=function(t){var n,r;if(!t||"string"!=typeof t)return null;try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){}return r=n&&n.getElementsByTagName("parsererror")[0],n&&!r||w.error("Invalid XML: "+(r?w.map(r.childNodes,(function(e){return e.textContent})).join("\n"):t)),n};var Ct=/\[\]$/,Et=/\r?\n/g,St=/^(?:submit|button|image|reset|file)$/i,kt=/^(?:input|select|textarea|keygen)/i;function At(e,t,n,r){var i;if(Array.isArray(t))w.each(t,(function(t,i){n||Ct.test(e)?r(e,i):At(e+"["+("object"==typeof i&&null!=i?t:"")+"]",i,n,r)}));else if(n||"object"!==x(t))r(e,t);else for(i in t)At(e+"["+i+"]",t[i],n,r)}w.param=function(e,t){var n,r=[],i=function(e,t){var n=h(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!w.isPlainObject(e))w.each(e,(function(){i(this.name,this.value)}));else for(n in e)At(n,e[n],t,i);return r.join("&")},w.fn.extend({serialize:function(){return w.param(this.serializeArray())},serializeArray:function(){return this.map((function(){var e=w.prop(this,"elements");return e?w.makeArray(e):this})).filter((function(){var e=this.type;return this.name&&!w(this).is(":disabled")&&kt.test(this.nodeName)&&!St.test(e)&&(this.checked||!de.test(e))})).map((function(e,t){var n=w(this).val();return null==n?null:Array.isArray(n)?w.map(n,(function(e){return{name:t.name,value:e.replace(Et,"\r\n")}})):{name:t.name,value:n.replace(Et,"\r\n")}})).get()}});var Nt=/%20/g,jt=/#.*$/,Dt=/([?&])_=[^&]*/,qt=/^(.*?):[ \t]*([^\r\n]*)$/gm,Lt=/^(?:GET|HEAD)$/,Ht=/^\/\//,Ot={},Pt={},Rt="*/".concat("*"),Mt=v.createElement("a");function It(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var r,i=0,o=t.toLowerCase().match(P)||[];if(h(n))for(;r=o[i++];)"+"===r[0]?(r=r.slice(1)||"*",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function Wt(e,t,n,r){var i={},o=e===Pt;function a(s){var u;return i[s]=!0,w.each(e[s]||[],(function(e,s){var l=s(t,n,r);return"string"!=typeof l||o||i[l]?o?!(u=l):void 0:(t.dataTypes.unshift(l),a(l),!1)})),u}return a(t.dataTypes[0])||!i["*"]&&a("*")}function Ft(e,t){var n,r,i=w.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&w.extend(!0,e,r),e}Mt.href=bt.href,w.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:bt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(bt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Rt,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":w.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Ft(Ft(e,w.ajaxSettings),t):Ft(w.ajaxSettings,e)},ajaxPrefilter:It(Ot),ajaxTransport:It(Pt),ajax:function(t,n){"object"==typeof t&&(n=t,t=void 0),n=n||{};var r,i,o,a,s,u,l,c,f,p,d=w.ajaxSetup({},n),h=d.context||d,g=d.context&&(h.nodeType||h.jquery)?w(h):w.event,y=w.Deferred(),m=w.Callbacks("once memory"),x=d.statusCode||{},b={},T={},C="canceled",E={readyState:0,getResponseHeader:function(e){var t;if(l){if(!a)for(a={};t=qt.exec(o);)a[t[1].toLowerCase()+" "]=(a[t[1].toLowerCase()+" "]||[]).concat(t[2]);t=a[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return l?o:null},setRequestHeader:function(e,t){return null==l&&(e=T[e.toLowerCase()]=T[e.toLowerCase()]||e,b[e]=t),this},overrideMimeType:function(e){return null==l&&(d.mimeType=e),this},statusCode:function(e){var t;if(e)if(l)E.always(e[E.status]);else for(t in e)x[t]=[x[t],e[t]];return this},abort:function(e){var t=e||C;return r&&r.abort(t),S(0,t),this}};if(y.promise(E),d.url=((t||d.url||bt.href)+"").replace(Ht,bt.protocol+"//"),d.type=n.method||n.type||d.method||d.type,d.dataTypes=(d.dataType||"*").toLowerCase().match(P)||[""],null==d.crossDomain){u=v.createElement("a");try{u.href=d.url,u.href=u.href,d.crossDomain=Mt.protocol+"//"+Mt.host!=u.protocol+"//"+u.host}catch(e){d.crossDomain=!0}}if(d.data&&d.processData&&"string"!=typeof d.data&&(d.data=w.param(d.data,d.traditional)),Wt(Ot,d,n,E),l)return E;for(f in(c=w.event&&d.global)&&0==w.active++&&w.event.trigger("ajaxStart"),d.type=d.type.toUpperCase(),d.hasContent=!Lt.test(d.type),i=d.url.replace(jt,""),d.hasContent?d.data&&d.processData&&0===(d.contentType||"").indexOf("application/x-www-form-urlencoded")&&(d.data=d.data.replace(Nt,"+")):(p=d.url.slice(i.length),d.data&&(d.processData||"string"==typeof d.data)&&(i+=(Tt.test(i)?"&":"?")+d.data,delete d.data),!1===d.cache&&(i=i.replace(Dt,"$1"),p=(Tt.test(i)?"&":"?")+"_="+wt.guid+++p),d.url=i+p),d.ifModified&&(w.lastModified[i]&&E.setRequestHeader("If-Modified-Since",w.lastModified[i]),w.etag[i]&&E.setRequestHeader("If-None-Match",w.etag[i])),(d.data&&d.hasContent&&!1!==d.contentType||n.contentType)&&E.setRequestHeader("Content-Type",d.contentType),E.setRequestHeader("Accept",d.dataTypes[0]&&d.accepts[d.dataTypes[0]]?d.accepts[d.dataTypes[0]]+("*"!==d.dataTypes[0]?", "+Rt+"; q=0.01":""):d.accepts["*"]),d.headers)E.setRequestHeader(f,d.headers[f]);if(d.beforeSend&&(!1===d.beforeSend.call(h,E,d)||l))return E.abort();if(C="abort",m.add(d.complete),E.done(d.success),E.fail(d.error),r=Wt(Pt,d,n,E)){if(E.readyState=1,c&&g.trigger("ajaxSend",[E,d]),l)return E;d.async&&d.timeout>0&&(s=e.setTimeout((function(){E.abort("timeout")}),d.timeout));try{l=!1,r.send(b,S)}catch(e){if(l)throw e;S(-1,e)}}else S(-1,"No Transport");function S(t,n,a,u){var f,p,v,b,T,C=n;l||(l=!0,s&&e.clearTimeout(s),r=void 0,o=u||"",E.readyState=t>0?4:0,f=t>=200&&t<300||304===t,a&&(b=function(e,t,n){for(var r,i,o,a,s=e.contents,u=e.dataTypes;"*"===u[0];)u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(d,E,a)),!f&&w.inArray("script",d.dataTypes)>-1&&w.inArray("json",d.dataTypes)<0&&(d.converters["text script"]=function(){}),b=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];for(o=c.shift();o;)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e.throws)t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(d,b,E,f),f?(d.ifModified&&((T=E.getResponseHeader("Last-Modified"))&&(w.lastModified[i]=T),(T=E.getResponseHeader("etag"))&&(w.etag[i]=T)),204===t||"HEAD"===d.type?C="nocontent":304===t?C="notmodified":(C=b.state,p=b.data,f=!(v=b.error))):(v=C,!t&&C||(C="error",t<0&&(t=0))),E.status=t,E.statusText=(n||C)+"",f?y.resolveWith(h,[p,C,E]):y.rejectWith(h,[E,C,v]),E.statusCode(x),x=void 0,c&&g.trigger(f?"ajaxSuccess":"ajaxError",[E,d,f?p:v]),m.fireWith(h,[E,C]),c&&(g.trigger("ajaxComplete",[E,d]),--w.active||w.event.trigger("ajaxStop")))}return E},getJSON:function(e,t,n){return w.get(e,t,n,"json")},getScript:function(e,t){return w.get(e,void 0,t,"script")}}),w.each(["get","post"],(function(e,t){w[t]=function(e,n,r,i){return h(n)&&(i=i||r,r=n,n=void 0),w.ajax(w.extend({url:e,type:t,dataType:i,data:n,success:r},w.isPlainObject(e)&&e))}})),w.ajaxPrefilter((function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")})),w._evalUrl=function(e,t,n){return w.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){w.globalEval(e,t,n)}})},w.fn.extend({wrapAll:function(e){var t;return this[0]&&(h(e)&&(e=e.call(this[0])),t=w(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map((function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e})).append(this)),this},wrapInner:function(e){return h(e)?this.each((function(t){w(this).wrapInner(e.call(this,t))})):this.each((function(){var t=w(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)}))},wrap:function(e){var t=h(e);return this.each((function(n){w(this).wrapAll(t?e.call(this,n):e)}))},unwrap:function(e){return this.parent(e).not("body").each((function(){w(this).replaceWith(this.childNodes)})),this}}),w.expr.pseudos.hidden=function(e){return!w.expr.pseudos.visible(e)},w.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},w.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var Bt={0:200,1223:204},$t=w.ajaxSettings.xhr();d.cors=!!$t&&"withCredentials"in $t,d.ajax=$t=!!$t,w.ajaxTransport((function(t){var n,r;if(d.cors||$t&&!t.crossDomain)return{send:function(i,o){var a,s=t.xhr();if(s.open(t.type,t.url,t.async,t.username,t.password),t.xhrFields)for(a in t.xhrFields)s[a]=t.xhrFields[a];for(a in t.mimeType&&s.overrideMimeType&&s.overrideMimeType(t.mimeType),t.crossDomain||i["X-Requested-With"]||(i["X-Requested-With"]="XMLHttpRequest"),i)s.setRequestHeader(a,i[a]);n=function(e){return function(){n&&(n=r=s.onload=s.onerror=s.onabort=s.ontimeout=s.onreadystatechange=null,"abort"===e?s.abort():"error"===e?"number"!=typeof s.status?o(0,"error"):o(s.status,s.statusText):o(Bt[s.status]||s.status,s.statusText,"text"!==(s.responseType||"text")||"string"!=typeof s.responseText?{binary:s.response}:{text:s.responseText},s.getAllResponseHeaders()))}},s.onload=n(),r=s.onerror=s.ontimeout=n("error"),void 0!==s.onabort?s.onabort=r:s.onreadystatechange=function(){4===s.readyState&&e.setTimeout((function(){n&&r()}))},n=n("abort");try{s.send(t.hasContent&&t.data||null)}catch(e){if(n)throw e}},abort:function(){n&&n()}}})),w.ajaxPrefilter((function(e){e.crossDomain&&(e.contents.script=!1)})),w.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return w.globalEval(e),e}}}),w.ajaxPrefilter("script",(function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")})),w.ajaxTransport("script",(function(e){var t,n;if(e.crossDomain||e.scriptAttrs)return{send:function(r,i){t=w("<script>").attr(e.scriptAttrs||{}).prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&i("error"===e.type?404:200,e.type)}),v.head.appendChild(t[0])},abort:function(){n&&n()}}}));var _t,zt=[],Ut=/(=)\?(?=&|$)|\?\?/;w.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=zt.pop()||w.expando+"_"+wt.guid++;return this[e]=!0,e}}),w.ajaxPrefilter("json jsonp",(function(t,n,r){var i,o,a,s=!1!==t.jsonp&&(Ut.test(t.url)?"url":"string"==typeof t.data&&0===(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Ut.test(t.data)&&"data");if(s||"jsonp"===t.dataTypes[0])return i=t.jsonpCallback=h(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,s?t[s]=t[s].replace(Ut,"$1"+i):!1!==t.jsonp&&(t.url+=(Tt.test(t.url)?"&":"?")+t.jsonp+"="+i),t.converters["script json"]=function(){return a||w.error(i+" was not called"),a[0]},t.dataTypes[0]="json",o=e[i],e[i]=function(){a=arguments},r.always((function(){void 0===o?w(e).removeProp(i):e[i]=o,t[i]&&(t.jsonpCallback=n.jsonpCallback,zt.push(i)),a&&h(o)&&o(a[0]),a=o=void 0})),"script"})),d.createHTMLDocument=((_t=v.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===_t.childNodes.length),w.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(d.createHTMLDocument?((r=(t=v.implementation.createHTMLDocument("")).createElement("base")).href=v.location.href,t.head.appendChild(r)):t=v),o=!n&&[],(i=N.exec(e))?[t.createElement(i[1])]:(i=be([e],t,o),o&&o.length&&w(o).remove(),w.merge([],i.childNodes)));var r,i,o},w.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return s>-1&&(r=ht(e.slice(s)),e=e.slice(0,s)),h(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),a.length>0&&w.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done((function(e){o=arguments,a.html(r?w("<div>").append(w.parseHTML(e)).find(r):e)})).always(n&&function(e,t){a.each((function(){n.apply(this,o||[e.responseText,t,e])}))}),this},w.expr.pseudos.animated=function(e){return w.grep(w.timers,(function(t){return e===t.elem})).length},w.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=w.css(e,"position"),c=w(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=w.css(e,"top"),u=w.css(e,"left"),("absolute"===l||"fixed"===l)&&(o+u).indexOf("auto")>-1?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),h(t)&&(t=t.call(e,n,w.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):c.css(f)}},w.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each((function(t){w.offset.setOffset(this,e,t)}));var t,n,r=this[0];return r?r.getClientRects().length?(t=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:t.top+n.pageYOffset,left:t.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===w.css(r,"position"))t=r.getBoundingClientRect();else{for(t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;e&&(e===n.body||e===n.documentElement)&&"static"===w.css(e,"position");)e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=w(e).offset()).top+=w.css(e,"borderTopWidth",!0),i.left+=w.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-w.css(r,"marginTop",!0),left:t.left-i.left-w.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map((function(){for(var e=this.offsetParent;e&&"static"===w.css(e,"position");)e=e.offsetParent;return e||re}))}}),w.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},(function(e,t){var n="pageYOffset"===t;w.fn[e]=function(r){return $(this,(function(e,r,i){var o;if(g(e)?o=e:9===e.nodeType&&(o=e.defaultView),void 0===i)return o?o[t]:e[r];o?o.scrollTo(n?o.pageXOffset:i,n?i:o.pageYOffset):e[r]=i}),e,r,arguments.length)}})),w.each(["top","left"],(function(e,t){w.cssHooks[t]=$e(d.pixelPosition,(function(e,n){if(n)return n=Be(e,t),Me.test(n)?w(e).position()[t]+"px":n}))})),w.each({Height:"height",Width:"width"},(function(e,t){w.each({padding:"inner"+e,content:t,"":"outer"+e},(function(n,r){w.fn[r]=function(i,o){var a=arguments.length&&(n||"boolean"!=typeof i),s=n||(!0===i||!0===o?"margin":"border");return $(this,(function(t,n,i){var o;return g(t)?0===r.indexOf("outer")?t["inner"+e]:t.document.documentElement["client"+e]:9===t.nodeType?(o=t.documentElement,Math.max(t.body["scroll"+e],o["scroll"+e],t.body["offset"+e],o["offset"+e],o["client"+e])):void 0===i?w.css(t,n,s):w.style(t,n,i,s)}),t,a?i:void 0,a)}}))})),w.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],(function(e,t){w.fn[t]=function(e){return this.on(t,e)}})),w.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),w.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),(function(e,t){w.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}));var Xt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;w.proxy=function(e,t){var n,r,o;if("string"==typeof t&&(n=e[t],t=e,e=n),h(e))return r=i.call(arguments,2),(o=function(){return e.apply(t||this,r.concat(i.call(arguments)))}).guid=e.guid=e.guid||w.guid++,o},w.holdReady=function(e){e?w.readyWait++:w.ready(!0)},w.isArray=Array.isArray,w.parseJSON=JSON.parse,w.nodeName=A,w.isFunction=h,w.isWindow=g,w.camelCase=X,w.type=x,w.now=Date.now,w.isNumeric=function(e){var t=w.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},w.trim=function(e){return null==e?"":(e+"").replace(Xt,"")},"function"==typeof define&&define.amd&&define("jquery",[],(function(){return w}));var Vt=e.jQuery,Gt=e.$;return w.noConflict=function(t){return e.$===w&&(e.$=Gt),t&&e.jQuery===w&&(e.jQuery=Vt),w},void 0===t&&(e.jQuery=e.$=w),w}))},
496: function _(t,n,i,o,e){var r=t(494);function u(){var t=!1,n=!1;this.stopPropagation=function(){t=!0},this.isPropagationStopped=function(){return t},this.stopImmediatePropagation=function(){n=!0},this.isImmediatePropagationStopped=function(){return n}}function s(){this.__nonDataRow=!0}function l(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function c(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function h(){var t=null;this.isActive=function(n){return n?t===n:null!==t},this.activate=function(n){if(n!==t){if(null!==t)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!n.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!n.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");t=n}},this.deactivate=function(n){if(t!==n)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");t=null},this.commitCurrentEdit=function(){return!t||t.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!t||t.cancelCurrentEdit()}}l.prototype=new s,l.prototype.equals=function(t){return this.value===t.value&&this.count===t.count&&this.collapsed===t.collapsed&&this.title===t.title},c.prototype=new s,n.exports={Event:function(){var t=[];this.subscribe=function(n){t.push(n)},this.unsubscribe=function(n){for(var i=t.length-1;i>=0;i--)t[i]===n&&t.splice(i,1)},this.notify=function(n,i,o){var e;i=i||new u,o=o||this;for(var r=0;r<t.length&&!i.isPropagationStopped()&&!i.isImmediatePropagationStopped();r++)e=t[r].call(o,i,n);return e}},EventData:u,EventHandler:function(){var t=[];this.subscribe=function(n,i){return t.push({event:n,handler:i}),n.subscribe(i),this},this.unsubscribe=function(n,i){for(var o=t.length;o--;)if(t[o].event===n&&t[o].handler===i)return t.splice(o,1),void n.unsubscribe(i);return this},this.unsubscribeAll=function(){for(var n=t.length;n--;)t[n].event.unsubscribe(t[n].handler);return t=[],this}},Range:function(t,n,i,o){void 0===i&&void 0===o&&(i=t,o=n),this.fromRow=Math.min(t,i),this.fromCell=Math.min(n,o),this.toRow=Math.max(t,i),this.toCell=Math.max(n,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(t,n){return t>=this.fromRow&&t<=this.toRow&&n>=this.fromCell&&n<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:s,Group:l,GroupTotals:c,EditorLock:h,GlobalEditorLock:new h,TreeColumns:function(t){var n={};function i(t){t.forEach((function(t){n[t.id]=t,t.columns&&i(t.columns)}))}function o(t,n){return t.filter((function(t){var i=n.call(t);return i&&t.columns&&(t.columns=o(t.columns,n)),i&&(!t.columns||t.columns.length)}))}function e(t,n){t.sort((function(t,i){return u(n.getColumnIndex(t.id))-u(n.getColumnIndex(i.id))})).forEach((function(t){t.columns&&e(t.columns,n)}))}function u(t){return void 0===t?-1:t}function s(t){if(!t.length)return t.columns?1+s(t.columns):1;for(var n in t)return s(t[n])}function l(t,n,i){var o=[];if(n==(i=i||0))return t.length&&t.forEach((function(t){t.columns&&(t.extractColumns=function(){return c(t)})})),t;for(var e in t)t[e].columns&&(o=o.concat(l(t[e].columns,n,i+1)));return o}function c(t){var n=[];if(t.hasOwnProperty("length"))for(var i=0;i<t.length;i++)n=n.concat(c(t[i]));else{if(!t.hasOwnProperty("columns"))return t;n=n.concat(c(t.columns))}return n}function h(){return r.extend(!0,[],t)}i(t),this.hasDepth=function(){for(var n in t)if(t[n].hasOwnProperty("columns"))return!0;return!1},this.getTreeColumns=function(){return t},this.extractColumns=function(){return this.hasDepth()?c(t):t},this.getDepth=function(){return s(t)},this.getColumnsInDepth=function(n){return l(t,n)},this.getColumnsInGroup=function(t){return c(t)},this.visibleColumns=function(){return o(h(),(function(){return this.visible}))},this.filter=function(t){return o(h(),t)},this.reOrder=function(n){return e(t,n)},this.getById=function(t){return n[t]},this.getInIds=function(t){return t.map((function(t){return n[t]}))}},keyCode:{SPACE:8,BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,A:65,C:67,V:86},preClickClassName:"slick-edit-preclick",GridAutosizeColsMode:{None:"NOA",LegacyOff:"LOF",LegacyForceFit:"LFF",IgnoreViewport:"IGV",FitColsToViewport:"FCV",FitViewportToCols:"FVC"},ColAutosizeMode:{Locked:"LCK",Guide:"GUI",Content:"CON",ContentIntelligent:"CTI"},RowSelectionMode:{FirstRow:"FS1",FirstNRows:"FSN",AllRows:"ALL",LastRow:"LS1"},ValueFilterMode:{None:"NONE",DeDuplicate:"DEDP",GetGreatestAndSub:"GR8T",GetLongestTextAndSub:"LNSB",GetLongestText:"LNSC"},WidthEvalMode:{CanvasTextSize:"CANV",HTML:"HTML"}}},
497: function _(e,t,o,l,n){var i=e(494),c=e(496);t.exports={CheckboxSelectColumn:function(e){var t,o=null,l=k(),n=new c.EventHandler,r={},d=!1,a=i.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,hideSelectAllCheckbox:!1,toolTip:"Select/Deselect All",width:30,hideInColumnTitleRow:!1,hideInFilterHeaderRow:!0},e);function s(){t.updateColumnHeader(a.columnId,"","")}function u(){i("#filter-checkbox-selectall-container").hide()}function h(e,n){var c,s,u,h=t.getSelectedRows(),f={},p=0;if("function"==typeof o)for(u=0;u<t.getDataLength();u++){C(s,t.getDataItem(u),t)||p++}var b=[];for(s=0;s<h.length;s++){c=h[s],C(s,t.getDataItem(c),t)?(f[c]=!0,f[c]!==r[c]&&(t.invalidateRow(c),delete r[c])):b.push(c)}for(s in r)t.invalidateRow(s);(r=f,t.render(),d=h.length&&h.length+p>=t.getDataLength(),a.hideInColumnTitleRow||a.hideSelectAllCheckbox||R(d),a.hideInFilterHeaderRow)||i("#header-filter-selector"+l).prop("checked",d);if(b.length>0){for(s=0;s<b.length;s++){var m=h.indexOf(b[s]);h.splice(m,1)}t.setSelectedRows(h)}}function f(e,o){32==e.which&&t.getColumns()[o.cell].id===a.columnId&&(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit()||b(o.row),e.preventDefault(),e.stopImmediatePropagation())}function p(e,o){if(t.getColumns()[o.cell].id===a.columnId&&i(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();b(o.row),e.stopPropagation(),e.stopImmediatePropagation()}}function b(e){var o=t.getDataItem(e);C(e,o,t)&&(r[e]?t.setSelectedRows(i.grep(t.getSelectedRows(),(function(t){return t!=e}))):t.setSelectedRows(t.getSelectedRows().concat(e)),t.setActiveCell(e,function(){if(null===g){g=0;for(var e=t.getColumns(),o=0;o<e.length;o++)e[o].id==a.columnId&&(g=o)}return g}()))}function m(e,o){if(o.column.id==a.columnId&&i(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(i(e.target).is(":checked")){for(var l=[],n=0;n<t.getDataLength();n++){C(n,t.getDataItem(n),t)&&l.push(n)}t.setSelectedRows(l)}else t.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}"function"==typeof a.selectableOverride&&v(a.selectableOverride);var g=null;function k(){return Math.round(1e7*Math.random())}function w(e,t,o,l,n,i){var c=k()+e;return n&&C(e,n,i)?r[e]?"<input id='selector"+c+"' type='checkbox' checked='checked'><label for='selector"+c+"'></label>":"<input id='selector"+c+"' type='checkbox'><label for='selector"+c+"'></label>":null}function C(e,t,l){return"function"!=typeof o||o(e,t,l)}function R(e){e?t.updateColumnHeader(a.columnId,"<input id='header-selector"+l+"' type='checkbox' checked='checked'><label for='header-selector"+l+"'></label>",a.toolTip):t.updateColumnHeader(a.columnId,"<input id='header-selector"+l+"' type='checkbox'><label for='header-selector"+l+"'></label>",a.toolTip)}function v(e){o=e}i.extend(this,{init:function(e){t=e,n.subscribe(t.onSelectedRowsChanged,h).subscribe(t.onClick,p).subscribe(t.onKeyDown,f),a.hideInFilterHeaderRow||function(e){e.onHeaderRowCellRendered.subscribe((function(e,t){"sel"===t.column.field&&(i(t.node).empty(),i("<span id='filter-checkbox-selectall-container'><input id='header-filter-selector"+l+"' type='checkbox'><label for='header-filter-selector"+l+"'></label></span>").appendTo(t.node).on("click",(function(e){m(e,t)})))}))}(e),a.hideInColumnTitleRow||n.subscribe(t.onHeaderClick,m)},destroy:function(){n.unsubscribeAll()},pluginName:"CheckboxSelectColumn",deSelectRows:function(e){var o,l=e.length,n=[];for(o=0;o<l;o++)r[e[o]]&&(n[n.length]=e[o]);t.setSelectedRows(i.grep(t.getSelectedRows(),(function(e){return n.indexOf(e)<0})))},selectRows:function(e){var o,l=e.length,n=[];for(o=0;o<l;o++)r[e[o]]||(n[n.length]=e[o]);t.setSelectedRows(t.getSelectedRows().concat(n))},getColumnDefinition:function(){return{id:a.columnId,name:a.hideSelectAllCheckbox||a.hideInColumnTitleRow?"":"<input id='header-selector"+l+"' type='checkbox'><label for='header-selector"+l+"'></label>",toolTip:a.hideSelectAllCheckbox||a.hideInColumnTitleRow?"":a.toolTip,field:"sel",width:a.width,resizable:!1,sortable:!1,cssClass:a.cssClass,hideSelectAllCheckbox:a.hideSelectAllCheckbox,formatter:w}},getOptions:function(){return a},selectableOverride:v,setOptions:function(e){if((a=i.extend(!0,{},a,e)).hideSelectAllCheckbox)s(),u();else if(a.hideInColumnTitleRow?s():(R(d),n.subscribe(t.onHeaderClick,m)),a.hideInFilterHeaderRow)u();else{var o=i("#filter-checkbox-selectall-container");o.show(),o.find('input[type="checkbox"]').prop("checked",d)}}})}}},
498: function _(e,t,o,l,n){var a=e(494),r=e(496),i=r.keyCode;t.exports={CellExternalCopyManager:function(e){var t,o,l=this,n=e||{},s=n.copiedCellStyleLayerKey||"copy-manager",u=n.copiedCellStyle||"copied",c=0,d=n.bodyElement||document.body,f=n.onCopyInit||null,h=n.onCopySuccess||null;function C(e){if(n.headerColumnValueExtractor){var t=n.headerColumnValueExtractor(e);if(t)return t}return e.name}function m(e,o,l){if(n.dataItemColumnValueExtractor){var r=n.dataItemColumnValueExtractor(e,o);if(r)return r}var i="";if(o.editor){var s={container:a("<p>"),column:o,position:{top:0,left:0},grid:t,event:l},u=new o.editor(s);u.loadValue(e),i=u.serializeValue(),u.destroy()}else i=e[o.field];return i}function g(e,o,l){if(o.denyPaste)return null;if(n.dataItemColumnValueSetter)return n.dataItemColumnValueSetter(e,o,l);if(o.editor){var r={container:a("body"),column:o,position:{top:0,left:0},grid:t},i=new o.editor(r);i.loadValue(e),i.applyValue(e,l),i.destroy()}else e[o.field]=l}function p(e){var t=document.createElement("textarea");return t.style.position="absolute",t.style.left="-1000px",t.style.top=document.body.scrollTop+"px",t.value=e,d.appendChild(t),t.select(),t}function y(e,a){var r;if(!t.getEditorLock().isActive()||t.getOptions().autoEdit){if(e.which==i.ESC&&o&&(e.preventDefault(),w(),l.onCopyCancelled.notify({ranges:o}),o=null),(e.which===i.C||e.which===i.INSERT)&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&(f&&f.call(),0!==(r=t.getSelectionModel().getSelectedRanges()).length)){o=r,v(r),l.onCopyCells.notify({ranges:r});for(var s=t.getColumns(),u="",c=0;c<r.length;c++){for(var y=r[c],D=[],S=y.fromRow;S<y.toRow+1;S++){var R=[],x=t.getDataItem(S);if(0===D.length&&n.includeHeaderWhenCopying){for(var E=[],V=y.fromCell;V<y.toCell+1;V++)s[V].name.length>0&&E.push(C(s[V]));D.push(E.join("\t"))}for(V=y.fromCell;V<y.toCell+1;V++)R.push(m(x,s[V],e));D.push(R.join("\t"))}u+=D.join("\r\n")+"\r\n"}if(window.clipboardData)return window.clipboardData.setData("Text",u),!0;var b=document.activeElement;if((M=p(u)).focus(),setTimeout((function(){d.removeChild(M),b?b.focus():console.log("Not element to restore focus to after copy?")}),100),h){var I=0;I=1===r.length?r[0].toRow+1-r[0].fromRow:r.length,h.call(this,I)}return!1}if(!n.readOnlyMode&&(e.which===i.V&&(e.ctrlKey||e.metaKey)&&!e.shiftKey||e.which===i.INSERT&&e.shiftKey&&!e.ctrlKey)){var M=p("");return setTimeout((function(){!function(e,t){var o=e.getColumns(),a=t.value.split(/[\n\f\r]/);""===a[a.length-1]&&a.pop();var r=[],i=0;d.removeChild(t);for(var s=0;s<a.length;s++)""!==a[s]?r[i++]=a[s].split("\t"):r[i++]=[""];var u=e.getActiveCell(),c=e.getSelectionModel().getSelectedRanges(),f=c&&c.length?c[0]:null,h=null,C=null;if(f)h=f.fromRow,C=f.fromCell;else{if(!u)return;h=u.row,C=u.cell}var m=!1,p=r.length,y=r.length?r[0].length:0;1==r.length&&1==r[0].length&&f&&(m=!0,p=f.toRow-f.fromRow+1,y=f.toCell-f.fromCell+1);var w=e.getData().length-h,D=0;if(w<p&&n.newRowCreator){var S=e.getData();for(D=1;D<=p-w;D++)S.push({});e.setData(S),e.render()}var R=h+p>e.getDataLength();if(n.newRowCreator&&R){var x=h+p-e.getDataLength();n.newRowCreator(x)}var E={isClipboardCommand:!0,clippedRange:r,oldValues:[],cellExternalCopyManager:l,_options:n,setDataItemValueForColumn:g,markCopySelection:v,oneCellToMultiple:m,activeRow:h,activeCell:C,destH:p,destW:y,maxDestY:e.getDataLength(),maxDestX:e.getColumns().length,h:0,w:0,execute:function(){this.h=0;for(var t=0;t<this.destH;t++){this.oldValues[t]=[],this.w=0,this.h++;for(var l=0;l<this.destW;l++){this.w++;var n=h+t,a=C+l;if(n<this.maxDestY&&a<this.maxDestX){e.getCellNode(n,a);var i=e.getDataItem(n);this.oldValues[t][l]=i[o[a].field],m?this.setDataItemValueForColumn(i,o[a],r[0][0]):this.setDataItemValueForColumn(i,o[a],r[t]?r[t][l]:""),e.updateCell(n,a),e.onCellChange.notify({row:n,cell:a,item:i,grid:e})}}}var s={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};this.markCopySelection([s]),e.getSelectionModel().setSelectedRanges([s]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[s]})},undo:function(){for(var t=0;t<this.destH;t++)for(var l=0;l<this.destW;l++){var n=h+t,a=C+l;if(n<this.maxDestY&&a<this.maxDestX){e.getCellNode(n,a);var r=e.getDataItem(n);m?this.setDataItemValueForColumn(r,o[a],this.oldValues[0][0]):this.setDataItemValueForColumn(r,o[a],this.oldValues[t][l]),e.updateCell(n,a),e.onCellChange.notify({row:n,cell:a,item:r,grid:e})}}var i={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};if(this.markCopySelection([i]),e.getSelectionModel().setSelectedRanges([i]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[i]}),D>1){for(var s=e.getData();D>1;D--)s.splice(s.length-1,1);e.setData(s),e.render()}}};n.clipboardCommandHandler?n.clipboardCommandHandler(E):E.execute()}(t,M)}),100),!1}}}function v(e){w();for(var o=t.getColumns(),n={},a=0;a<e.length;a++)for(var r=e[a].fromRow;r<=e[a].toRow;r++){n[r]={};for(var i=e[a].fromCell;i<=e[a].toCell&&i<o.length;i++)n[r][o[i].id]=u}t.setCellCssStyles(s,n),clearTimeout(c),c=setTimeout((function(){l.clearCopySelection()}),2e3)}function w(){t.removeCellCssStyles(s)}a.extend(this,{init:function(e){(t=e).onKeyDown.subscribe(y);var o=e.getSelectionModel();if(!o)throw new Error("Selection model is mandatory for this plugin. Please set a selection model on the grid before adding this plugin: grid.setSelectionModel(new Slick.CellSelectionModel())");o.onSelectedRangesChanged.subscribe((function(e,o){t.focus()}))},destroy:function(){t.onKeyDown.unsubscribe(y)},pluginName:"CellExternalCopyManager",clearCopySelection:w,handleKeyDown:y,onCopyCells:new r.Event,onCopyCancelled:new r.Event,onPasteCells:new r.Event,setIncludeHeaderWhenCopying:function(e){n.includeHeaderWhenCopying=e}})}}},
499: function _(r,t,o,_,e){var p=r(1);p.__exportStar(r(496),t.exports),p.__exportStar(r(500),t.exports),p.__exportStar(r(503),t.exports),p.__exportStar(r(504),t.exports),p.__exportStar(r(505),t.exports),p.__exportStar(r(506),t.exports),p.__exportStar(r(507),t.exports)},
500: function _(require,module,exports,__esModule,__esExport){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.4
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(494),Slick=require(496),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(501),$.fn.drop||require(502);var defaults={alwaysShowVerticalScroll:!1,alwaysAllowHorizontalScroll:!1,explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,suppressActiveCellChangeOnEdit:!1,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showColumnHeader:!0,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,frozenBottom:!1,frozenColumn:-1,frozenRow:-1,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,sortColNumberInSeparateSpan:!1,defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0,viewportClass:null,minRowBuffer:3,emulatePagingWhenScrolling:!0,editorCellNavOnLRKeys:!1,doPaging:!0,autosizeColsMode:Slick.GridAutosizeColsMode.LegacyOff,autosizeColPaddingPx:4,autosizeTextAvgToMWidthRatio:.75,viewportSwitchToScrollModeWidthPercent:void 0,viewportMinWidthPx:void 0,viewportMaxWidthPx:void 0},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,maxWidth:void 0,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},columnAutosizeDefaults={ignoreHeaderText:!1,colValueArray:void 0,allowAddlPercent:void 0,formatterOverride:void 0,autosizeMode:Slick.ColAutosizeMode.ContentIntelligent,rowSelectionModeOnInit:void 0,rowSelectionMode:Slick.RowSelectionMode.FirstNRows,rowSelectionCount:100,valueFilterMode:Slick.ValueFilterMode.None,widthEvalMode:Slick.WidthEvalMode.CanvasTextSize,sizeToRemaining:void 0,widthPx:void 0,colDataTypeOf:void 0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$groupHeaders=$(),$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacerL,$headerRowSpacerR,$footerRow,$footerRowScroller,$footerRowSpacerL,$footerRowSpacerR,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$preHeaderPanelR,$preHeaderPanelScrollerR,$preHeaderPanelSpacerR,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,treeColumns,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,canvasWidthL,canvasWidthR,headersWidth,headersWidthL,headersWidthR,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,hasFrozenRows=!1,frozenRowsHeight=0,actualFrozenRow=-1,paneTopH=0,paneBottomH=0,viewportTopH=0,viewportBottomH=0,topPanelH=0,headerRowH=0,footerRowH=0,tabbingDirection=1,$activeCanvasNode,$activeViewportNode,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows=0,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,scrollThrottle=ActionThrottle(render,50),h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,$paneHeaderL,$paneHeaderR,$paneTopL,$paneTopR,$paneBottomL,$paneBottomR,$headerScrollerL,$headerScrollerR,$headerL,$headerR,$groupHeadersL,$groupHeadersR,$headerRowScrollerL,$headerRowScrollerR,$footerRowScrollerL,$footerRowScrollerR,$headerRowL,$headerRowR,$footerRowL,$footerRowR,$topPanelScrollerL,$topPanelScrollerR,$topPanelL,$topPanelR,$viewportTopL,$viewportTopR,$viewportBottomL,$viewportBottomR,$canvasTopL,$canvasTopR,$canvasBottomL,$canvasBottomR,$viewportScrollContainerX,$viewportScrollContainerY,$headerScrollContainer,$headerRowScrollContainer,$footerRowScrollContainer,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[],columnResizeDragging=!1;function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");if(cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,treeColumns=new Slick.TreeColumns(columns),columns=treeColumns.extractColumns(),updateColumnProps(),options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");if(editController={commitCurrentEdit,cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),$paneHeaderL=$("<div class='slick-pane slick-pane-header slick-pane-left' tabIndex='0' />").appendTo($container),$paneHeaderR=$("<div class='slick-pane slick-pane-header slick-pane-right' tabIndex='0' />").appendTo($container),$paneTopL=$("<div class='slick-pane slick-pane-top slick-pane-left' tabIndex='0' />").appendTo($container),$paneTopR=$("<div class='slick-pane slick-pane-top slick-pane-right' tabIndex='0' />").appendTo($container),$paneBottomL=$("<div class='slick-pane slick-pane-bottom slick-pane-left' tabIndex='0' />").appendTo($container),$paneBottomR=$("<div class='slick-pane slick-pane-bottom slick-pane-right' tabIndex='0' />").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($paneHeaderL),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScroller),$preHeaderPanelScrollerR=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($paneHeaderR),$preHeaderPanelR=$("<div />").appendTo($preHeaderPanelScrollerR),$preHeaderPanelSpacerR=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScrollerR),options.showPreHeaderPanel||($preHeaderPanelScroller.hide(),$preHeaderPanelScrollerR.hide())),$headerScrollerL=$("<div class='slick-header ui-state-default slick-header-left' />").appendTo($paneHeaderL),$headerScrollerR=$("<div class='slick-header ui-state-default slick-header-right' />").appendTo($paneHeaderR),$headerScroller=$().add($headerScrollerL).add($headerScrollerR),treeColumns.hasDepth()){$groupHeadersL=[],$groupHeadersR=[];for(var e=0;e<treeColumns.getDepth()-1;e++)$groupHeadersL[e]=$("<div class='slick-group-header-columns slick-group-header-columns-left' style='left:-1000px' />").appendTo($headerScrollerL),$groupHeadersR[e]=$("<div class='slick-group-header-columns slick-group-header-columns-right' style='left:-1000px' />").appendTo($headerScrollerR);$groupHeaders=$().add($groupHeadersL).add($groupHeadersR)}$headerL=$("<div class='slick-header-columns slick-header-columns-left' style='left:-1000px' />").appendTo($headerScrollerL),$headerR=$("<div class='slick-header-columns slick-header-columns-right' style='left:-1000px' />").appendTo($headerScrollerR),$headers=$().add($headerL).add($headerR),$headerRowScrollerL=$("<div class='slick-headerrow ui-state-default' />").appendTo($paneTopL),$headerRowScrollerR=$("<div class='slick-headerrow ui-state-default' />").appendTo($paneTopR),$headerRowScroller=$().add($headerRowScrollerL).add($headerRowScrollerR),$headerRowSpacerL=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScrollerL),$headerRowSpacerR=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScrollerR),$headerRowL=$("<div class='slick-headerrow-columns slick-headerrow-columns-left' />").appendTo($headerRowScrollerL),$headerRowR=$("<div class='slick-headerrow-columns slick-headerrow-columns-right' />").appendTo($headerRowScrollerR),$headerRow=$().add($headerRowL).add($headerRowR),$topPanelScrollerL=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($paneTopL),$topPanelScrollerR=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($paneTopR),$topPanelScroller=$().add($topPanelScrollerL).add($topPanelScrollerR),$topPanelL=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScrollerL),$topPanelR=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScrollerR),$topPanel=$().add($topPanelL).add($topPanelR),options.showColumnHeader||$headerScroller.hide(),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),$viewportTopL=$("<div class='slick-viewport slick-viewport-top slick-viewport-left' tabIndex='0' hideFocus />").appendTo($paneTopL),$viewportTopR=$("<div class='slick-viewport slick-viewport-top slick-viewport-right' tabIndex='0' hideFocus />").appendTo($paneTopR),$viewportBottomL=$("<div class='slick-viewport slick-viewport-bottom slick-viewport-left' tabIndex='0' hideFocus />").appendTo($paneBottomL),$viewportBottomR=$("<div class='slick-viewport slick-viewport-bottom slick-viewport-right' tabIndex='0' hideFocus />").appendTo($paneBottomR),$viewport=$().add($viewportTopL).add($viewportTopR).add($viewportBottomL).add($viewportBottomR),$activeViewportNode=$viewportTopL,$canvasTopL=$("<div class='grid-canvas grid-canvas-top grid-canvas-left' tabIndex='0' hideFocus />").appendTo($viewportTopL),$canvasTopR=$("<div class='grid-canvas grid-canvas-top grid-canvas-right' tabIndex='0' hideFocus />").appendTo($viewportTopR),$canvasBottomL=$("<div class='grid-canvas grid-canvas-bottom grid-canvas-left' tabIndex='0' hideFocus />").appendTo($viewportBottomL),$canvasBottomR=$("<div class='grid-canvas grid-canvas-bottom grid-canvas-right' tabIndex='0' hideFocus />").appendTo($viewportBottomR),options.viewportClass&&$viewport.toggleClass(options.viewportClass,!0),$canvas=$().add($canvasTopL).add($canvasTopR).add($canvasBottomL).add($canvasBottomR),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),$activeCanvasNode=$canvasTopL,$preHeaderPanelSpacer&&$preHeaderPanelSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headers.width(getHeadersWidth()),$headerRowSpacerL.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headerRowSpacerR.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),options.createFooterRow&&($footerRowScrollerR=$("<div class='slick-footerrow ui-state-default' />").appendTo($paneTopR),$footerRowScrollerL=$("<div class='slick-footerrow ui-state-default' />").appendTo($paneTopL),$footerRowScroller=$().add($footerRowScrollerL).add($footerRowScrollerR),$footerRowSpacerL=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScrollerL),$footerRowSpacerR=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScrollerR),$footerRowL=$("<div class='slick-footerrow-columns slick-footerrow-columns-left' />").appendTo($footerRowScrollerL),$footerRowR=$("<div class='slick-footerrow-columns slick-footerrow-columns-right' />").appendTo($footerRowScrollerR),$footerRow=$().add($footerRowL).add($footerRowR),options.showFooterRow||$footerRowScroller.hide()),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,getViewportWidth(),getViewportHeight(),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",(function(e){return $(e.target).is("input,textarea")})),setFrozenOptions(),setPaneVisibility(),setScroller(),setOverflow(),updateColumnCaches(),createColumnHeaders(),createColumnGroupHeaders(),createColumnFooter(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$.fn.mousewheel&&$viewport.on("mousewheel",handleMouseWheel),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&($footerRow.on("contextmenu",handleFooterContextMenu).on("click",handleFooterClick),$footerRowScroller.on("scroll",handleFooterRowScroll)),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each((function(){var e={};for(var o in cssShow)e[o]=this.style[o],this.style[o]=cssShow[o];oldProps.push(e)}))}function restoreCssFromHiddenInit(){$hiddenParents.each((function(e){var o=oldProps[e];for(var t in cssShow)this.style[t]=o[t]}))}function hasFrozenColumns(){return options.frozenColumn>-1}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var o=plugins.length;o>=0;o--)if(plugins[o]===e){plugins[o].destroy&&plugins[o].destroy(),plugins.splice(o,1);break}}function getPluginByName(e){for(var o=plugins.length-1;o>=0;o--)if(plugins[o].pluginName===e)return plugins[o]}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(e,o){e||(e=0),o||(o=0);var t="number"==typeof e?e:getColumnIndex(e);return hasFrozenRows&&o>=actualFrozenRow+(options.frozenBottom?0:1)?hasFrozenColumns()&&t>options.frozenColumn?$canvasBottomR[0]:$canvasBottomL[0]:hasFrozenColumns()&&t>options.frozenColumn?$canvasTopR[0]:$canvasTopL[0]}function getActiveCanvasNode(e){return setActiveCanvasNode(e),$activeCanvasNode[0]}function getCanvases(){return $canvas}function setActiveCanvasNode(e){e&&($activeCanvasNode=$(e.target).closest(".grid-canvas"))}function getViewportNode(){return $viewport[0]}function getActiveViewportNode(e){return setActiveViewPortNode(e),$activeViewportNode[0]}function setActiveViewportNode(e){e&&($activeViewportNode=$(e.target).closest(".slick-viewport"))}function measureScrollbar(){var e=$('<div class="'+$viewport.className+'" style="position:absolute; top:-10000px; left:-10000px; overflow:auto; width:100px; height:100px;"></div>').appendTo("body"),o=$('<div style="width:200px; height:200px; overflow:auto;"></div>').appendTo(e),t={width:e[0].offsetWidth-e[0].clientWidth,height:e[0].offsetHeight-e[0].clientHeight};return o.remove(),e.remove(),t}function getHeadersWidth(){headersWidth=headersWidthL=headersWidthR=0;for(var e=!options.autoHeight,o=0,t=columns.length;o<t;o++){var n=columns[o].width;options.frozenColumn>-1&&o>options.frozenColumn?headersWidthR+=n:headersWidthL+=n}return e&&(options.frozenColumn>-1&&o>options.frozenColumn?headersWidthR+=scrollbarDimensions.width:headersWidthL+=scrollbarDimensions.width),hasFrozenColumns()?(headersWidthL+=1e3,headersWidthR=Math.max(headersWidthR,viewportW)+headersWidthL,headersWidthR+=scrollbarDimensions.width):(headersWidthL+=scrollbarDimensions.width,headersWidthL=Math.max(headersWidthL,viewportW)+1e3),headersWidth=headersWidthL+headersWidthR,Math.max(headersWidth,viewportW)+1e3}function getHeadersWidthL(){return headersWidthL=0,columns.forEach((function(e,o){options.frozenColumn>-1&&o>options.frozenColumn||(headersWidthL+=e.width)})),hasFrozenColumns()?headersWidthL+=1e3:(headersWidthL+=scrollbarDimensions.width,headersWidthL=Math.max(headersWidthL,viewportW)+1e3),headersWidthL}function getHeadersWidthR(){return headersWidthR=0,columns.forEach((function(e,o){options.frozenColumn>-1&&o>options.frozenColumn&&(headersWidthR+=e.width)})),hasFrozenColumns()&&(headersWidthR=Math.max(headersWidthR,viewportW)+getHeadersWidthL(),headersWidthR+=scrollbarDimensions.width),headersWidthR}function getCanvasWidth(){var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,o=columns.length;for(canvasWidthL=canvasWidthR=0;o--;)hasFrozenColumns()&&o>options.frozenColumn?canvasWidthR+=columns[o].width:canvasWidthL+=columns[o].width;var t=canvasWidthL+canvasWidthR;return options.fullWidthRows?Math.max(t,e):t}function updateCanvasWidth(e){var o,t=canvasWidth,n=canvasWidthL,l=canvasWidthR;((o=(canvasWidth=getCanvasWidth())!==t||canvasWidthL!==n||canvasWidthR!==l)||hasFrozenColumns()||hasFrozenRows)&&($canvasTopL.width(canvasWidthL),getHeadersWidth(),$headerL.width(headersWidthL),$headerR.width(headersWidthR),hasFrozenColumns()?($canvasTopR.width(canvasWidthR),$paneHeaderL.width(canvasWidthL),$paneHeaderR.css("left",canvasWidthL),$paneHeaderR.css("width",viewportW-canvasWidthL),$paneTopL.width(canvasWidthL),$paneTopR.css("left",canvasWidthL),$paneTopR.css("width",viewportW-canvasWidthL),$headerRowScrollerL.width(canvasWidthL),$headerRowScrollerR.width(viewportW-canvasWidthL),$headerRowL.width(canvasWidthL),$headerRowR.width(canvasWidthR),options.createFooterRow&&($footerRowScrollerL.width(canvasWidthL),$footerRowScrollerR.width(viewportW-canvasWidthL),$footerRowL.width(canvasWidthL),$footerRowR.width(canvasWidthR)),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$viewportTopL.width(canvasWidthL),$viewportTopR.width(viewportW-canvasWidthL),hasFrozenRows&&($paneBottomL.width(canvasWidthL),$paneBottomR.css("left",canvasWidthL),$viewportBottomL.width(canvasWidthL),$viewportBottomR.width(viewportW-canvasWidthL),$canvasBottomL.width(canvasWidthL),$canvasBottomR.width(canvasWidthR))):($paneHeaderL.width("100%"),$paneTopL.width("100%"),$headerRowScrollerL.width("100%"),$headerRowL.width(canvasWidth),options.createFooterRow&&($footerRowScrollerL.width("100%"),$footerRowL.width(canvasWidth)),options.createPreHeaderPanel&&($preHeaderPanel.width("100%"),$preHeaderPanel.width(canvasWidth)),$viewportTopL.width("100%"),hasFrozenRows&&($viewportBottomL.width("100%"),$canvasBottomL.width(canvasWidthL))),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width),$headerRowSpacerL.width(canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0)),$headerRowSpacerR.width(canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0)),options.createFooterRow&&($footerRowSpacerL.width(canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0)),$footerRowSpacerR.width(canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0))),(o||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",(function(){return!1}))}function getMaxSupportedCssHeight(){for(var e=1e6,o=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,t=$("<div style='display:none' />").appendTo(document.body);;){var n=2*e;if(t.css("height",n),n>o||t.height()!==n)break;e=n}return t.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=hasFrozenRows&&!options.frozenBottom?$canvasBottomL[0]:$canvasTopL[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewportTopL[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var o=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(o):o,o.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,o,t){if(initialized){var n=getColumnIndex(e);if(null!=n){var l=columns[n],r=$headers.children().eq(n);r&&(void 0!==o&&(columns[n].name=o),void 0!==t&&(columns[n].toolTip=t),trigger(self.onBeforeHeaderCellDestroy,{node:r[0],column:l,grid:self}),r.attr("title",t||"").children().eq(0).html(o),trigger(self.onHeaderCellRendered,{node:r[0],column:l,grid:self}))}}}function getHeader(e){if(!e)return hasFrozenColumns()?$headers:$headerL;var o=getColumnIndex(e.id);return hasFrozenColumns()?o<=options.frozenColumn?$headerL:$headerR:$headerL}function getHeaderColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=hasFrozenColumns()?o<=options.frozenColumn?$headerL:$headerR:$headerL,n=hasFrozenColumns()?o<=options.frozenColumn?o:o-options.frozenColumn-1:o,l=t.children().eq(n);return l&&l[0]}function getHeaderRow(){return hasFrozenColumns()?$headerRow:$headerRow[0]}function getFooterRow(){return hasFrozenColumns()?$footerRow:$footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getPreHeaderPanelRight(){return $preHeaderPanelR[0]}function getHeaderRowColumn(e){var o,t="number"==typeof e?e:getColumnIndex(e);hasFrozenColumns()?t<=options.frozenColumn?o=$headerRowL:(o=$headerRowR,t-=options.frozenColumn+1):o=$headerRowL;var n=o.children().eq(t);return n&&n[0]}function getFooterRowColumn(e){var o,t="number"==typeof e?e:getColumnIndex(e);hasFrozenColumns()?t<=options.frozenColumn?o=$footerRowL:(o=$footerRowR,t-=options.frozenColumn+1):o=$footerRowL;var n=o&&o.children().eq(t);return n&&n[0]}function createColumnFooter(){if(options.createFooterRow){$footerRow.find(".slick-footerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e,grid:self})})),$footerRowL.empty(),$footerRowR.empty();for(var e=0;e<columns.length;e++){var o=columns[e],t=$("<div class='ui-state-default slick-footerrow-column l"+e+" r"+e+"'></div>").data("column",o).addClass(hasFrozenColumns()&&e<=options.frozenColumn?"frozen":"").appendTo(hasFrozenColumns()&&e>options.frozenColumn?$footerRowR:$footerRowL);trigger(self.onFooterRowCellRendered,{node:t[0],column:o,grid:self})}}}function createColumnGroupHeaders(){var e=0,o=!1;if(treeColumns.hasDepth()){for(var t=0;t<$groupHeadersL.length;t++){$groupHeadersL[t].empty(),$groupHeadersR[t].empty();var n=treeColumns.getColumnsInDepth(t);for(var l in n){var r=n[l];e+=r.extractColumns().length,hasFrozenColumns()&&0===t&&e-1===options.frozenColumn&&(o=!0),$("<div class='ui-state-default slick-group-header-column' />").html("<span class='slick-column-name'>"+r.name+"</span>").attr("id",""+uid+r.id).attr("title",r.toolTip||"").data("column",r).addClass(r.headerCssClass||"").addClass(hasFrozenColumns()&&e-1>options.frozenColumn?"frozen":"").appendTo(hasFrozenColumns()&&e-1>options.frozenColumn?$groupHeadersR[t]:$groupHeadersL[t])}if(hasFrozenColumns()&&0===t&&!o){$groupHeadersL[t].empty(),$groupHeadersR[t].empty(),alert("All columns of group should to be grouped!");break}}applyColumnGroupHeaderWidths()}}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function o(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})})),$headerL.empty(),$headerR.empty(),getHeadersWidth(),$headerL.width(headersWidthL),$headerR.width(headersWidthR),$headerRow.find(".slick-headerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})})),$headerRowL.empty(),$headerRowR.empty(),options.createFooterRow&&($footerRowL.find(".slick-footerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e,grid:self})})),$footerRowL.empty(),hasFrozenColumns()&&($footerRowR.find(".slick-footerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e,grid:self})})),$footerRowR.empty()));for(var t=0;t<columns.length;t++){var n=columns[t],l=hasFrozenColumns()?t<=options.frozenColumn?$headerL:$headerR:$headerL,r=hasFrozenColumns()?t<=options.frozenColumn?$headerRowL:$headerRowR:$headerRowL,i=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+n.name+"</span>").width(n.width-headerColumnWidthDiff).attr("id",""+uid+n.id).attr("title",n.toolTip||"").data("column",n).addClass(n.headerCssClass||"").addClass(hasFrozenColumns()&&t<=options.frozenColumn?"frozen":"").appendTo(l);if((options.enableColumnReorder||n.sortable)&&i.on("mouseenter",e).on("mouseleave",o),n.hasOwnProperty("headerCellAttrs")&&n.headerCellAttrs instanceof Object)for(var a in n.headerCellAttrs)n.headerCellAttrs.hasOwnProperty(a)&&i.attr(a,n.headerCellAttrs[a]);if(n.sortable&&(i.addClass("slick-header-sortable"),i.append("<span class='slick-sort-indicator"+(options.numberedMultiColumnSort&&!options.sortColNumberInSeparateSpan?" slick-sort-indicator-numbered":"")+"' />"),options.numberedMultiColumnSort&&options.sortColNumberInSeparateSpan&&i.append("<span class='slick-sort-indicator-numbered' />")),trigger(self.onHeaderCellRendered,{node:i[0],column:n,grid:self}),options.showHeaderRow){var s=$("<div class='ui-state-default slick-headerrow-column l"+t+" r"+t+"'></div>").data("column",n).addClass(hasFrozenColumns()&&t<=options.frozenColumn?"frozen":"").appendTo(r);trigger(self.onHeaderRowCellRendered,{node:s[0],column:n,grid:self})}if(options.createFooterRow&&options.showFooterRow){var d=$("<div class='ui-state-default slick-footerrow-column l"+t+" r"+t+"'></div>").data("column",n).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:d[0],column:n,grid:self})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click((function(e){if(!columnResizeDragging&&(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle"))){var o=$(e.target).closest(".slick-header-column");if(o.length){var t=o.data("column");if(t.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var n=null,l=0;l<sortColumns.length;l++)if(sortColumns[l].columnId==t.id){(n=sortColumns[l]).sortAsc=!n.sortAsc;break}var r=!!n;options.tristateMultiColumnSort?(n||(n={columnId:t.id,sortAsc:t.defaultSortAsc}),r&&n.sortAsc&&(sortColumns.splice(l,1),n=null),options.multiColumnSort||(sortColumns=[]),!n||r&&options.multiColumnSort||sortColumns.push(n)):e.metaKey&&options.multiColumnSort?n&&sortColumns.splice(l,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),n?0===sortColumns.length&&sortColumns.push(n):(n={columnId:t.id,sortAsc:t.defaultSortAsc},sortColumns.push(n))),setSortColumns(sortColumns),options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,(function(e){return{columnId:columns[getColumnIndex(e.columnId)].id,sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}}))},e):trigger(self.onSort,{multiColumnSort:!1,columnId:sortColumns.length>0?t.id:null,sortCol:sortColumns.length>0?t:null,sortAsc:!(sortColumns.length>0)||sortColumns[0].sortAsc},e)}}}}))}function currentPositionInHeader(e){var o=0;return $headers.find(".slick-header-column").each((function(t){if(this.id==e)return o=t,!1})),o}function limitPositionInGroup(e){var o,t=0,n=0;return treeColumns.getColumnsInDepth($groupHeadersL.length-1).some((function(l){return t=n,n+=l.columns.length,l.columns.some((function(t){return t.id===e&&(o=l),o})),o})),n--,{start:t,end:n,group:o}}function remove(e,o){var t=e.lastIndexOf(o);t>-1&&(e.splice(t,1),remove(e,o))}function columnPositionValidInGroup(e){var o=currentPositionInHeader(e[0].id),t=limitPositionInGroup(e.data("column").id),n=t.start<=o&&o<=t.end;return{limit:t,valid:n,message:n?"":'Column "'.concat(e.text(),'" can be reordered only within the "',t.group.name,'" group!')}}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy");var e,o=null;function t(){$viewportScrollContainerX[0].scrollLeft=$viewportScrollContainerX[0].scrollLeft+10}function n(){$viewportScrollContainerX[0].scrollLeft=$viewportScrollContainerX[0].scrollLeft-10}$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(o,t){t.placeholder.width(t.helper.outerWidth()-headerColumnWidthDiff),e=!hasFrozenColumns()||t.placeholder.offset().left+t.placeholder.width()>$viewportScrollContainerX.offset().left,$(t.helper).addClass("slick-header-column-active")},beforeStop:function(e,o){$(o.helper).removeClass("slick-header-column-active")},sort:function(l,r){e&&l.originalEvent.pageX>$container[0].clientWidth?o||(o=setInterval(t,100)):e&&l.originalEvent.pageX<$viewportScrollContainerX.offset().left?o||(o=setInterval(n,100)):(clearInterval(o),o=null)},stop:function(e,t){var n=!1;clearInterval(o),o=null;var l=null;if(treeColumns.hasDepth()){var r=columnPositionValidInGroup(t.item);l=r.limit,(n=!r.valid)&&alert(r.message)}if(!n&&getEditorLock().commitCurrentEdit()){var i=$headerL.sortable("toArray");i=i.concat($headerR.sortable("toArray"));for(var a=[],s=0;s<i.length;s++)a.push(columns[getColumnIndex(i[s].replace(uid,""))]);setColumns(a),trigger(self.onColumnsReordered,{impactedColumns:getImpactedColumns(l)}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function getImpactedColumns(e){var o=[];if(e)for(var t=e.start;t<=e.end;t++)o.push(columns[t]);else o=columns;return o}function setupColumnResize(){var e,o,t,n,l,r,i,a,s;(l=$headers.children()).find(".slick-resizable-handle").remove(),l.each((function(e,o){e>=columns.length||columns[e].resizable&&(void 0===a&&(a=e),s=e)})),void 0!==a&&l.each((function(d,c){d>=columns.length||d<a||options.forceFitColumns&&d>=s||($(c),$("<div class='slick-resizable-handle' />").appendTo(c).on("dragstart",(function(o,a){if(!getEditorLock().commitCurrentEdit())return!1;n=o.pageX,$(this).parent().addClass("slick-header-column-active");var s=null,c=null;if(l.each((function(e,o){e>=columns.length||(columns[e].previousWidth=$(o).outerWidth())})),options.forceFitColumns)for(s=0,c=0,e=d+1;e<columns.length;e++)(t=columns[e]).resizable&&(null!==c&&(t.maxWidth?c+=t.maxWidth-t.previousWidth:c=null),s+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));var u=0,h=0;for(e=0;e<=d;e++)(t=columns[e]).resizable&&(null!==h&&(t.maxWidth?h+=t.maxWidth-t.previousWidth:h=null),u+=t.previousWidth-Math.max(t.minWidth||0,absoluteColumnMinWidth));null===s&&(s=1e5),null===u&&(u=1e5),null===c&&(c=1e5),null===h&&(h=1e5),i=n+Math.min(s,h),r=n-Math.min(u,c)})).on("drag",(function(l,a){columnResizeDragging=!0;var s,c,u=Math.min(i,Math.max(r,l.pageX))-n,h=0;if(u<0){for(c=u,e=d;e>=0;e--)(t=columns[e]).resizable&&(s=Math.max(t.minWidth||0,absoluteColumnMinWidth),c&&t.previousWidth+c<s?(c+=t.previousWidth-s,t.width=s):(t.width=t.previousWidth+c,c=0));for(o=0;o<=d;o++)t=columns[o],hasFrozenColumns()&&o>options.frozenColumn?t.width:h+=t.width;if(options.forceFitColumns)for(c=-u,e=d+1;e<columns.length;e++)(t=columns[e]).resizable&&(c&&t.maxWidth&&t.maxWidth-t.previousWidth<c?(c-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+c,c=0),hasFrozenColumns()&&e>options.frozenColumn?t.width:h+=t.width);else for(e=d+1;e<columns.length;e++)t=columns[e],hasFrozenColumns()&&e>options.frozenColumn?t.width:h+=t.width;if(options.forceFitColumns)for(c=-u,e=d+1;e<columns.length;e++)(t=columns[e]).resizable&&(c&&t.maxWidth&&t.maxWidth-t.previousWidth<c?(c-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+c,c=0))}else{for(c=u,h=0,0,e=d;e>=0;e--)(t=columns[e]).resizable&&(c&&t.maxWidth&&t.maxWidth-t.previousWidth<c?(c-=t.maxWidth-t.previousWidth,t.width=t.maxWidth):(t.width=t.previousWidth+c,c=0));for(o=0;o<=d;o++)t=columns[o],hasFrozenColumns()&&o>options.frozenColumn?t.width:h+=t.width;if(options.forceFitColumns)for(c=-u,e=d+1;e<columns.length;e++)(t=columns[e]).resizable&&(s=Math.max(t.minWidth||0,absoluteColumnMinWidth),c&&t.previousWidth+c<s?(c+=t.previousWidth-s,t.width=s):(t.width=t.previousWidth+c,c=0),hasFrozenColumns()&&e>options.frozenColumn?t.width:h+=t.width);else for(e=d+1;e<columns.length;e++)t=columns[e],hasFrozenColumns()&&e>options.frozenColumn?t.width:h+=t.width}hasFrozenColumns()&&h!=canvasWidthL&&($headerL.width(h+1e3),$paneHeaderR.css("left",h)),applyColumnHeaderWidths(),applyColumnGroupHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths(),trigger(self.onColumnsDrag,{triggeredByColumn:$(this).parent().attr("id").replace(uid,""),resizeHandle:$(this)})})).on("dragend",(function(o,n){$(this).parent().removeClass("slick-header-column-active");var r,i=$(this).parent().attr("id").replace(uid,"");for(!0===trigger(self.onBeforeColumnsResize,{triggeredByColumn:i})&&(applyColumnHeaderWidths(),applyColumnGroupHeaderWidths()),e=0;e<columns.length;e++)t=columns[e],r=$(l[e]).outerWidth(),t.previousWidth!==r&&t.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{triggeredByColumn:i}),setTimeout((function(){columnResizeDragging=!1}),300)})))}))}function getVBoxDelta(e){var o=0;return e&&"function"==typeof e.css&&$.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],(function(t,n){o+=parseFloat(e.css(n))||0})),o}function setFrozenOptions(){if(options.frozenColumn=options.frozenColumn>=0&&options.frozenColumn<columns.length?parseInt(options.frozenColumn):-1,options.frozenRow>-1){hasFrozenRows=!0,frozenRowsHeight=options.frozenRow*options.rowHeight;var e=getDataLength();actualFrozenRow=options.frozenBottom?e-options.frozenRow:options.frozenRow}else hasFrozenRows=!1}function setPaneVisibility(){hasFrozenColumns()?($paneHeaderR.show(),$paneTopR.show(),hasFrozenRows?($paneBottomL.show(),$paneBottomR.show()):($paneBottomR.hide(),$paneBottomL.hide())):($paneHeaderR.hide(),$paneTopR.hide(),$paneBottomR.hide(),hasFrozenRows?$paneBottomL.show():($paneBottomR.hide(),$paneBottomL.hide()))}function setOverflow(){$viewportTopL.css({"overflow-x":hasFrozenColumns()?hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"hidden":"scroll":hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"hidden":"auto","overflow-y":options.alwaysShowVerticalScroll?"scroll":hasFrozenColumns()?"hidden":hasFrozenRows?"scroll":"auto"}),$viewportTopR.css({"overflow-x":hasFrozenColumns()?hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"hidden":"scroll":hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"hidden":"auto","overflow-y":options.alwaysShowVerticalScroll?"scroll":(hasFrozenColumns(),hasFrozenRows?"scroll":"auto")}),$viewportBottomL.css({"overflow-x":hasFrozenColumns()?hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"scroll":"auto":(hasFrozenRows&&options.alwaysAllowHorizontalScroll,"auto"),"overflow-y":options.alwaysShowVerticalScroll?"scroll":hasFrozenColumns()?"hidden":hasFrozenRows?"scroll":"auto"}),$viewportBottomR.css({"overflow-x":hasFrozenColumns()?hasFrozenRows&&!options.alwaysAllowHorizontalScroll?"scroll":"auto":(hasFrozenRows&&options.alwaysAllowHorizontalScroll,"auto"),"overflow-y":options.alwaysShowVerticalScroll?"scroll":(hasFrozenColumns(),"auto")}),options.viewportClass&&($viewportTopL.toggleClass(options.viewportClass,!0),$viewportTopR.toggleClass(options.viewportClass,!0),$viewportBottomL.toggleClass(options.viewportClass,!0),$viewportBottomR.toggleClass(options.viewportClass,!0))}function setScroller(){hasFrozenColumns()?($headerScrollContainer=$headerScrollerR,$headerRowScrollContainer=$headerRowScrollerR,$footerRowScrollContainer=$footerRowScrollerR,hasFrozenRows?options.frozenBottom?($viewportScrollContainerX=$viewportBottomR,$viewportScrollContainerY=$viewportTopR):$viewportScrollContainerX=$viewportScrollContainerY=$viewportBottomR:$viewportScrollContainerX=$viewportScrollContainerY=$viewportTopR):($headerScrollContainer=$headerScrollerL,$headerRowScrollContainer=$headerRowScrollerL,$footerRowScrollContainer=$footerRowScrollerL,hasFrozenRows?options.frozenBottom?($viewportScrollContainerX=$viewportBottomL,$viewportScrollContainerY=$viewportTopL):$viewportScrollContainerX=$viewportScrollContainerY=$viewportBottomL:$viewportScrollContainerX=$viewportScrollContainerY=$viewportTopL)}function measureCellPaddingAndBorder(){var e,o=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],t=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],n=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==n[0]&&n[1]>=8||n[0]>=2,e=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,(function(o,t){headerColumnWidthDiff+=parseFloat(e.css(t))||0})),$.each(t,(function(o,t){headerColumnHeightDiff+=parseFloat(e.css(t))||0}))),e.remove();var l=$("<div class='slick-row' />").appendTo($canvas);e=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(l),cellWidthDiff=cellHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,(function(o,t){cellWidthDiff+=parseFloat(e.css(t))||0})),$.each(t,(function(o,t){cellHeightDiff+=parseFloat(e.css(t))||0}))),l.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,o=["."+uid+" .slick-group-header-column { left: 1000px; }","."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],t=0;t<columns.length;t++)o.push("."+uid+" .l"+t+" { }"),o.push("."+uid+" .r"+t+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=o.join(" "):$style[0].appendChild(document.createTextNode(o.join(" ")))}function getColumnCssRules(e){var o;if(!stylesheet){var t=document.styleSheets;for(o=0;o<t.length;o++)if((t[o].ownerNode||t[o].owningElement)==$style[0]){stylesheet=t[o];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var n,l,r=stylesheet.cssRules||stylesheet.rules;for(o=0;o<r.length;o++){var i=r[o].selectorText;(n=/\.l\d+/.exec(i))?(l=parseInt(n[0].substr(2,n[0].length-2),10),columnCssRulesL[l]=r[o]):(n=/\.r\d+/.exec(i))&&(l=parseInt(n[0].substr(2,n[0].length-2),10),columnCssRulesR[l]=r[o])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}var canvas=null,canvas_context=null;function autosizeColumn(e,o){var t=e;if("number"==typeof e)t=columns[e];else if("string"==typeof e)for(var n=0;n<columns.length;n++)columns[n].Id===e&&(t=columns[n]);getColAutosizeWidth(t,$(getCanvasNode(0,0)),o)}function autosizeColumns(e,o){if((e=e||options.autosizeColsMode)!==Slick.GridAutosizeColsMode.LegacyForceFit&&e!==Slick.GridAutosizeColsMode.LegacyOff){if(e!==Slick.GridAutosizeColsMode.None){(canvas=document.createElement("canvas"))&&canvas.getContext&&(canvas_context=canvas.getContext("2d"));var t,n,l,r,i=$(getCanvasNode(0,0)),a=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,s=0,d=0,c=0,u=0,h=0;for(t=0;t<columns.length;t++)getColAutosizeWidth(n=columns[t],i,o),h+=n.autoSize.autosizeMode===Slick.ColAutosizeMode.Locked?n.width:0,u+=n.autoSize.autosizeMode===Slick.ColAutosizeMode.Locked?n.width:n.minWidth,s+=n.autoSize.widthPx,d+=n.autoSize.sizeToRemaining?0:n.autoSize.widthPx,c+=n.autoSize.sizeToRemaining&&n.minWidth||0;var p=s-d;if(e===Slick.GridAutosizeColsMode.FitViewportToCols){var m=s+scrollbarDimensions.width;e=Slick.GridAutosizeColsMode.IgnoreViewport,options.viewportMaxWidthPx&&m>options.viewportMaxWidthPx?(m=options.viewportMaxWidthPx,e=Slick.GridAutosizeColsMode.FitColsToViewport):options.viewportMinWidthPx&&m<options.viewportMinWidthPx&&(m=options.viewportMinWidthPx,e=Slick.GridAutosizeColsMode.FitColsToViewport),$container.width(m)}if(e===Slick.GridAutosizeColsMode.FitColsToViewport)if(p>0&&d<a-c)for(t=0;t<columns.length;t++){var w=a-d;l=(n=columns[t]).autoSize.sizeToRemaining?w*n.autoSize.widthPx/p:n.autoSize.widthPx,n.rerenderOnResize&&n.width!=l&&(r=!0),n.width=l}else if(options.viewportSwitchToScrollModeWidthPercent&&d+c>a*options.viewportSwitchToScrollModeWidthPercent/100||u>a)e=Slick.GridAutosizeColsMode.IgnoreViewport;else{var v=d-h,f=a-h-c;for(t=0;t<columns.length;t++)l=(n=columns[t]).width,n.autoSize.autosizeMode!==Slick.ColAutosizeMode.Locked&&(n.autoSize.sizeToRemaining?l=n.minWidth:((l=f/v*n.autoSize.widthPx)<n.minWidth&&(l=n.minWidth),v-=n.autoSize.widthPx,f-=l)),n.rerenderOnResize&&n.width!=l&&(r=!0),n.width=l}if(e===Slick.GridAutosizeColsMode.IgnoreViewport)for(t=0;t<columns.length;t++)l=columns[t].autoSize.widthPx,columns[t].rerenderOnResize&&columns[t].width!=l&&(r=!0),columns[t].width=l;reRenderColumns(r)}}else legacyAutosizeColumns()}function LogColWidths(){for(var e="Col Widths:",o=0;o<columns.length;o++)e+=" "+columns[o].width;console.log(e)}function getColAutosizeWidth(e,o,t){var n=e.autoSize;if(n.widthPx=e.width,n.autosizeMode!==Slick.ColAutosizeMode.Locked&&n.autosizeMode!==Slick.ColAutosizeMode.Guide){var l=getDataLength();if(n.autosizeMode===Slick.ColAutosizeMode.ContentIntelligent){var r,i=n.colDataTypeOf;if(l>0){var a=getDataItem(0);a&&"object"===(i=typeof(r=a[e.field]))&&(r instanceof Date&&(i="date"),"undefined"!=typeof moment&&r instanceof moment&&(i="moment"))}"boolean"===i&&(n.colValueArray=[!0,!1]),"number"===i&&(n.valueFilterMode=Slick.ValueFilterMode.GetGreatestAndSub,n.rowSelectionMode=Slick.RowSelectionMode.AllRows),"string"===i&&(n.valueFilterMode=Slick.ValueFilterMode.GetLongestText,n.rowSelectionMode=Slick.RowSelectionMode.AllRows,n.allowAddlPercent=5),"date"===i&&(n.colValueArray=[new Date(2009,8,30,12,20,20)]),"moment"===i&&"undefined"!=typeof moment&&(n.colValueArray=[moment([2009,8,30,12,20,20])])}var s=getColContentSize(e,o,t);s=s*(n.allowAddlPercent?1+n.allowAddlPercent/100:1)+options.autosizeColPaddingPx,e.minWidth&&s<e.minWidth&&(s=e.minWidth),e.maxWidth&&s>e.maxWidth&&(s=e.maxWidth),n.widthPx=s}}function getColContentSize(e,o,t){var n,l=e.autoSize,r=1,i=0,a=0;if(l.ignoreHeaderText||(a=getColHeaderWidth(e)),l.colValueArray)return i=getColWidth(e,o,l.colValueArray),Math.max(a,i);var s=getData();s.getItems&&(s=s.getItems());var d=(t?l.rowSelectionModeOnInit:void 0)||l.rowSelectionMode;if(d===Slick.RowSelectionMode.FirstRow&&(s=s.slice(0,1)),d===Slick.RowSelectionMode.LastRow&&(s=s.slice(s.length-1,s.length)),d===Slick.RowSelectionMode.FirstNRows&&(s=s.slice(0,l.rowSelectionCount)),l.valueFilterMode===Slick.ValueFilterMode.DeDuplicate){var c={};for(u=0,n=s.length;u<n;u++)c[s[u][e.field]]=!0;if(Object.keys)s=Object.keys(c);else for(var u in s=[],c)s.push(u)}if(l.valueFilterMode===Slick.ValueFilterMode.GetGreatestAndSub){var h,p=0;for(u=0,n=s.length;u<n;u++)w=s[u][e.field],Math.abs(w)>p&&(h=w,p=Math.abs(w));h=""+h,s=[h=+(h=Array(h.length+1).join("9"))]}if(l.valueFilterMode===Slick.ValueFilterMode.GetLongestTextAndSub){var m=0;for(u=0,n=s.length;u<n;u++)((w=s[u][e.field])||"").length>m&&(m=w.length);w=Array(m+1).join("m"),r=options.autosizeTextAvgToMWidthRatio,s=[w]}if(l.valueFilterMode===Slick.ValueFilterMode.GetLongestText){m=0;var w,v=0;for(u=0,n=s.length;u<n;u++)((w=s[u][e.field])||"").length>m&&(m=w.length,v=u);s=[w=s[v][e.field]]}return i=getColWidth(e,o,s)*r,Math.max(a,i)}function getColWidth(e,o,t){var n=getColumnIndex(e.id),l=$('<div class="slick-row ui-widget-content"></div>'),r=$('<div class="slick-cell"></div>');r.css({position:"absolute",visibility:"hidden","text-overflow":"initial","white-space":"nowrap"}),l.append(r),o.append(l);var i,a,s,d,c=0;return canvas_context&&e.autoSize.widthEvalMode===Slick.WidthEvalMode.CanvasTextSize?(canvas_context.font=r.css("font-size")+" "+r.css("font-family"),$(t).each((function(o,t){d=Array.isArray(t)?t[e.field]:t,(i=(a=""+d)?canvas_context.measureText(a).width:0)>c&&(c=i,s=a)})),r.html(s),i=r.outerWidth(),l.remove(),i):($(t).each((function(o,t){d=Array.isArray(t)?t[e.field]:t,applyFormatResultToCellNode(e.formatterOverride?e.formatterOverride(o,n,d,e,t):e.formatter?e.formatter(o,n,d,e,t):""+d,r[0]),(i=r.outerWidth())>c&&(c=i)})),l.remove(),c)}function getColHeaderWidth(e){var o=0,t=getUID()+e.id,n=document.getElementById(t),l=t+"_";if(n){var r=n.cloneNode(!0);r.id=l,r.style.cssText="position: absolute; visibility: hidden;right: auto;text-overflow: initial;white-space: nowrap;",n.parentNode.insertBefore(r,n),o=r.offsetWidth,r.parentNode.removeChild(r)}else{var i=getHeader(e);o=(n=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+e.name+"</span>").attr("id",l).css({position:"absolute",visibility:"hidden",right:"auto","text-overflow:":"initial","white-space":"nowrap"}).addClass(e.headerCssClass||"").appendTo(i))[0].offsetWidth,i[0].removeChild(n[0])}return o}function legacyAutosizeColumns(){var e,o,t,n=[],l=0,r=0,i=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)o=columns[e],n.push(o.width),r+=o.width,o.resizable&&(l+=o.width-Math.max(o.minWidth,absoluteColumnMinWidth));for(t=r;r>i&&l;){var a=(r-i)/l;for(e=0;e<columns.length&&r>i;e++){o=columns[e];var s=n[e];if(!(!o.resizable||s<=o.minWidth||s<=absoluteColumnMinWidth)){var d=Math.max(o.minWidth,absoluteColumnMinWidth),c=Math.floor(a*(s-d))||1;r-=c=Math.min(c,s-d),l-=c,n[e]-=c}}if(t<=r)break;t=r}for(t=r;r<i;){var u=i/r;for(e=0;e<columns.length&&r<i;e++){o=columns[e];var h,p=n[e];r+=h=!o.resizable||o.maxWidth<=p?0:Math.min(Math.floor(u*p)-p,o.maxWidth-p||1e6)||1,n[e]+=r<=i?h:0}if(t>=r)break;t=r}var m=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=n[e]&&(m=!0),columns[e].width=n[e];reRenderColumns(m)}function reRenderColumns(e){applyColumnHeaderWidths(),applyColumnGroupHeaderWidths(),updateCanvasWidth(!0),trigger(self.onAutosizeColumns,{columns}),e&&(invalidateAllRows(),render())}function trigger(e,o,t){return t=t||new Slick.EventData,(o=o||{}).grid=self,e.notify(o,t,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function applyColumnGroupHeaderWidths(){if(treeColumns.hasDepth())for(var e=$groupHeadersL.length-1;e>=0;e--){treeColumns.getColumnsInDepth(e);$().add($groupHeadersL[e]).add($groupHeadersR[e]).each((function(e){var o=$(this),t=0;o.width(0===e?getHeadersWidthL():getHeadersWidthR()),o.children().each((function(){var e=$(this),n=$(this).data("column");n.width=0,n.columns.forEach((function(){var e=o.next().children(":eq("+t+++")");n.width+=e.outerWidth()})),e.width(n.width-headerColumnWidthDiff)}))}))}}function applyColumnHeaderWidths(){if(initialized){for(var e,o=0,t=$headers.children(),n=columns.length;o<n;o++)e=$(t[o]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[o].width&&e.outerWidth(columns[o].width):e.width()!==columns[o].width-headerColumnWidthDiff&&e.width(columns[o].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,o,t=0,n=0;n<columns.length;n++)e=columns[n].width,(o=getColumnCssRules(n)).left.style.left=t+"px",o.right.style.right=(-1!=options.frozenColumn&&n>options.frozenColumn?canvasWidthR:canvasWidthL)-t-e+"px",options.frozenColumn==n?t=0:t+=columns[n].width}function setSortColumn(e,o){setSortColumns([{columnId:e,sortAsc:o}])}function setSortColumns(e){sortColumns=e;var o=options.numberedMultiColumnSort&&sortColumns.length>1,t=$headers.children();t.removeClass("slick-header-column-sorted").find(".slick-sort-indicator").removeClass("slick-sort-indicator-asc slick-sort-indicator-desc"),t.find(".slick-sort-indicator-numbered").text(""),$.each(sortColumns,(function(e,n){null==n.sortAsc&&(n.sortAsc=!0);var l=getColumnIndex(n.columnId);null!=l&&(t.eq(l).addClass("slick-header-column-sorted").find(".slick-sort-indicator").addClass(n.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),o&&t.eq(l).find(".slick-sort-indicator-numbered").text(e+1))}))}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,o){var t=selectedRows.slice(0);selectedRows=[];for(var n={},l=0;l<o.length;l++)for(var r=o[l].fromRow;r<=o[l].toRow;r++){n[r]||(selectedRows.push(r),n[r]={});for(var i=o[l].fromCell;i<=o[l].toCell;i++)canCellBeSelected(r,i)&&(n[r][columns[i].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,n),simpleArrayEquals(t,selectedRows)||trigger(self.onSelectedRowsChanged,{rows:getSelectedRows(),previousSelectedRows:t},e)}function simpleArrayEquals(e,o){if(!Array.isArray(e)||!Array.isArray(o))return!0;const t=new Set(e),n=new Set(o);if(t.size!=n.size)return!1;for(const e of t)if(!n.has(e))return!1;return!0}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,o=0,t=columns.length;o<t;o++)columnPosLeft[o]=e,columnPosRight[o]=e+columns[o].width,options.frozenColumn==o?e=0:e+=columns[o].width}function updateColumnProps(){columnsById={};for(var e=0;e<columns.length;e++){columns[e].width&&(columns[e].widthRequest=columns[e].width);var o=columns[e]=$.extend({},columnDefaults,columns[e]);o.autoSize=$.extend({},columnAutosizeDefaults,o.autoSize),columnsById[o.id]=e,o.minWidth&&o.width<o.minWidth&&(o.width=o.minWidth),o.maxWidth&&o.width>o.maxWidth&&(o.width=o.maxWidth),o.resizable}}function setColumns(e){var o=new Slick.TreeColumns(e);columns=o.hasDepth()?(treeColumns=o).extractColumns():e,updateColumnProps(),updateColumnCaches(),initialized&&(setPaneVisibility(),setOverflow(),invalidateAllRows(),createColumnHeaders(),createColumnGroupHeaders(),createColumnFooter(),removeCssRules(),createCssRules(),resizeCanvas(),updateCanvasWidth(),applyColumnHeaderWidths(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,o){if(getEditorLock().commitCurrentEdit()){makeActiveCellNormal(),void 0!==e.showColumnHeader&&setColumnHeaderVisibility(e.showColumnHeader),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength());var t=$.extend(!0,{},options);options=$.extend(options,e),trigger(self.onSetOptions,{optionsBefore:t,optionsAfter:options}),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),o||render(),setFrozenOptions(),setScroller(),zombieRowNodeFromLastMouseWheelEvent=null,setColumns(treeColumns.extractColumns())}}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1),options.forceFitColumns&&(options.autosizeColsMode=Slick.GridAutosizeColsMode.LegacyForceFit,console.log("forceFitColumns option is deprecated - use autosizeColsMode"))}function setData(e,o){data=e,invalidateAllRows(),updateRowCount(),o&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data&&data.length||0}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e,o){var t=!1!==o;options.showTopPanel!=e&&(options.showTopPanel=e,e?t?$topPanelScroller.slideDown("fast",resizeCanvas):($topPanelScroller.show(),resizeCanvas()):t?$topPanelScroller.slideUp("fast",resizeCanvas):($topPanelScroller.hide(),resizeCanvas()))}function setHeaderRowVisibility(e,o){var t=!1!==o;options.showHeaderRow!=e&&(options.showHeaderRow=e,e?t?$headerRowScroller.slideDown("fast",resizeCanvas):($headerRowScroller.show(),resizeCanvas()):t?$headerRowScroller.slideUp("fast",resizeCanvas):($headerRowScroller.hide(),resizeCanvas()))}function setColumnHeaderVisibility(e,o){options.showColumnHeader!=e&&(options.showColumnHeader=e,e?o?$headerScroller.slideDown("fast",resizeCanvas):($headerScroller.show(),resizeCanvas()):o?$headerScroller.slideUp("fast",resizeCanvas):($headerScroller.hide(),resizeCanvas()))}function setFooterRowVisibility(e,o){var t=!1!==o;options.showFooterRow!=e&&(options.showFooterRow=e,e?t?$footerRowScroller.slideDown("fast",resizeCanvas):($footerRowScroller.show(),resizeCanvas()):t?$footerRowScroller.slideUp("fast",resizeCanvas):($footerRowScroller.hide(),resizeCanvas()))}function setPreHeaderPanelVisibility(e,o){var t=!1!==o;options.showPreHeaderPanel!=e&&(options.showPreHeaderPanel=e,e?t?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):($preHeaderPanelScroller.show(),resizeCanvas()):t?$preHeaderPanelScroller.slideUp("fast",resizeCanvas):($preHeaderPanelScroller.hide(),resizeCanvas()))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-$viewportScrollContainerY.height()+(viewportHasHScroll||hasFrozenColumns()?scrollbarDimensions.height:0));var o=offset;page=Math.min(n-1,Math.floor(e/ph));var t=e-(offset=Math.round(page*cj));offset!=o&&(cleanupRows(getVisibleRange(t)),updateRowPositions());prevScrollTop!=t&&(vScrollDir=prevScrollTop+o<t+offset?1:-1,lastRenderedScrollTop=scrollTop=prevScrollTop=t,hasFrozenColumns()&&($viewportTopL[0].scrollTop=t),hasFrozenRows&&($viewportBottomL[0].scrollTop=$viewportBottomR[0].scrollTop=t),$viewportScrollContainerY[0].scrollTop=t,trigger(self.onViewportChanged,{}))}function defaultFormatter(e,o,t,n,l,r){return null==t?"":(t+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e),n=t&&t.columns&&(t.columns[o.id]||t.columns[getColumnIndex(o.id)]);return n&&n.formatter||t&&t.formatter||o.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(o)||options.defaultFormatter}function callFormatter(e,o,t,n,l,r){var i,a=data.getItemMetadata&&data.getItemMetadata(e);if(a=a&&a.columns){var s=a[n.id]||a[o];i=getFormatter(e,n)(e,o,t,n,l,s)}else i=getFormatter(e,n)(e,o,t,n,l);return i}function getEditor(e,o){var t=columns[o],n=data.getItemMetadata&&data.getItemMetadata(e),l=n&&n.columns;return l&&l[t.id]&&void 0!==l[t.id].editor?l[t.id].editor:l&&l[o]&&void 0!==l[o].editor?l[o].editor:t.editor||options.editorFactory&&options.editorFactory.getEditor(t)}function getDataItemValueForColumn(e,o){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,o):e[o.field]}function appendRowHtml(e,o,t,n,l){var r=getDataItem(t),i=t<l&&!r,a="slick-row"+(hasFrozenRows&&t<=options.frozenRow?" frozen":"")+(i?" loading":"")+(t===activeRow&&options.showCellSelection?" active":"")+(t%2==1?" odd":" even");r||(a+=" "+options.addNewRowCssClass);var s=data.getItemMetadata&&data.getItemMetadata(t);s&&s.cssClasses&&(a+=" "+s.cssClasses);var d,c,u=getFrozenRowOffset(t),h="<div class='ui-widget-content "+a+"' style='top:"+(getRowTop(t)-u)+"px'>";e.push(h),hasFrozenColumns()&&o.push(h);for(var p=0,m=columns.length;p<m;p++){if(c=columns[p],d=1,s&&s.columns){var w=s.columns[c.id]||s.columns[p];"*"===(d=w&&w.colspan||1)&&(d=m-p)}if(columnPosRight[Math.min(m-1,p+d-1)]>n.leftPx){if(!c.alwaysRenderColumn&&columnPosLeft[p]>n.rightPx)break;hasFrozenColumns()&&p>options.frozenColumn?appendCellHtml(o,t,p,d,r):appendCellHtml(e,t,p,d,r)}else(c.alwaysRenderColumn||hasFrozenColumns()&&p<=options.frozenColumn)&&appendCellHtml(e,t,p,d,r);d>1&&(p+=d-1)}e.push("</div>"),hasFrozenColumns()&&o.push("</div>")}function appendCellHtml(e,o,t,n,l){var r=columns[t],i="slick-cell l"+t+" r"+Math.min(columns.length-1,t+n-1)+(r.cssClass?" "+r.cssClass:"");for(var a in hasFrozenColumns()&&t<=options.frozenColumn&&(i+=" frozen"),o===activeRow&&t===activeCell&&options.showCellSelection&&(i+=" active"),cellCssClasses)cellCssClasses[a][o]&&cellCssClasses[a][o][r.id]&&(i+=" "+cellCssClasses[a][o][r.id]);var s=null,d="";l&&(s=getDataItemValueForColumn(l,r),null==(d=getFormatter(o,r)(o,t,s,r,l,self))&&(d=""));var c=trigger(self.onBeforeAppendCell,{row:o,cell:t,value:s,dataContext:l})||"";c+=d&&d.addClasses?(c?" ":"")+d.addClasses:"";var u=d&&d.toolTip?"title='"+d.toolTip+"'":"",h="";if(r.hasOwnProperty("cellAttrs")&&r.cellAttrs instanceof Object)for(var a in r.cellAttrs)r.cellAttrs.hasOwnProperty(a)&&(h+=" "+a+'="'+r.cellAttrs[a]+'" ');e.push("<div class='"+i+(c?" "+c:"")+"' "+u+h+">"),l&&e.push("[object Object]"!==Object.prototype.toString.call(d)?d:d.text),e.push("</div>"),rowsCache[o].cellRenderQueue.push(t),rowsCache[o].cellColSpans[t]=n}function cleanupRows(e){for(var o in rowsCache){var t=!0;hasFrozenRows&&(options.frozenBottom&&o>=actualFrozenRow||!options.frozenBottom&&o<=actualFrozenRow)&&(t=!1),(o=parseInt(o,10))!==activeRow&&(o<e.top||o>e.bottom)&&t&&removeRowFromCache(o)}options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,o,t){for(var n in postProcessgroupId++,o)o.hasOwnProperty(n)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|n],columnIdx:0|n,rowIdx:t});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,o,t){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:o,rowIdx:t}),$(e).detach()}function removeRowFromCache(e){var o=rowsCache[e];o&&(rowNodeFromLastMouseWheelEvent==o.rowNode[0]||hasFrozenColumns()&&rowNodeFromLastMouseWheelEvent==o.rowNode[1]?(o.rowNode.hide(),zombieRowNodeFromLastMouseWheelEvent=o.rowNode):o.rowNode.each((function(){this.parentElement.removeChild(this)})),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var o,t;if(e&&e.length){for(vScrollDir=0,t=e.length,o=0;o<t;o++)currentEditor&&activeRow===e[o]&&makeActiveCellNormal(),rowsCache[e[o]]&&removeRowFromCache(e[o]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){(e||0===e)&&invalidateRows([e])}function applyFormatResultToCellNode(e,o,t){null==e&&(e=""),"[object Object]"===Object.prototype.toString.call(e)?(o.innerHTML=e.text,e.removeClasses&&!t&&$(o).removeClass(e.removeClasses),e.addClasses&&$(o).addClass(e.addClasses),e.toolTip&&$(o).attr("title",e.toolTip)):o.innerHTML=e}function updateCell(e,o){var t=getCellNode(e,o);if(t){var n=columns[o],l=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===o)currentEditor.loadValue(l);else applyFormatResultToCellNode(l?getFormatter(e,n)(e,o,getDataItemValueForColumn(l,n),n,l,self):"",t),invalidatePostProcessingResults(e)}}function updateRow(e){var o=rowsCache[e];if(o){ensureCellNodesInRowsCache(e);var t=getDataItem(e);for(var n in o.cellNodesByColumnIdx)if(o.cellNodesByColumnIdx.hasOwnProperty(n)){var l=columns[n|=0],r=o.cellNodesByColumnIdx[n][0];e===activeRow&&n===activeCell&&currentEditor?currentEditor.loadValue(t):t?applyFormatResultToCellNode(getFormatter(e,l)(e,n,getDataItemValueForColumn(t,l),l,t,self),r):r.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){if(options.autoHeight&&-1==options.frozenColumn||(topPanelH=options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0,headerRowH=options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0,footerRowH=options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0),options.autoHeight){var e=$paneHeaderL.outerHeight();e+=options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0,e+=options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0,e+=getCanvasWidth()>viewportW?scrollbarDimensions.height:0,viewportH=options.rowHeight*getDataLengthIncludingAddNew()+(-1==options.frozenColumn?e:0)}else{var o=options.showColumnHeader?parseFloat($.css($headerScroller[0],"height"))+getVBoxDelta($headerScroller):0,t=options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0;viewportH=parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-o-topPanelH-headerRowH-footerRowH-t}return numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportH}function getViewportWidth(){viewportW=parseFloat($container.width())}function resizeCanvas(){if(initialized){paneTopH=0,paneBottomH=0,viewportTopH=0,viewportBottomH=0,getViewportWidth(),getViewportHeight(),hasFrozenRows?options.frozenBottom?(paneTopH=viewportH-frozenRowsHeight-scrollbarDimensions.height,paneBottomH=frozenRowsHeight+scrollbarDimensions.height):(paneTopH=frozenRowsHeight,paneBottomH=viewportH-frozenRowsHeight):paneTopH=viewportH,paneTopH+=topPanelH+headerRowH+footerRowH,hasFrozenColumns()&&options.autoHeight&&(paneTopH+=scrollbarDimensions.height),viewportTopH=paneTopH-topPanelH-headerRowH-footerRowH,options.autoHeight&&(hasFrozenColumns()&&$container.height(paneTopH+parseFloat($.css($headerScrollerL[0],"height"))),$paneTopL.css("position","relative")),$paneTopL.css({top:$paneHeaderL.height(),height:paneTopH});var e=$paneTopL.position().top+paneTopH;options.autoHeight||$viewportTopL.height(viewportTopH),hasFrozenColumns()?($paneTopR.css({top:$paneHeaderL.height(),height:paneTopH}),$viewportTopR.height(viewportTopH),hasFrozenRows&&($paneBottomL.css({top:e,height:paneBottomH}),$paneBottomR.css({top:e,height:paneBottomH}),$viewportBottomR.height(paneBottomH))):hasFrozenRows&&($paneBottomL.css({width:"100%",height:paneBottomH}),$paneBottomL.css("top",e)),hasFrozenRows?($viewportBottomL.height(paneBottomH),options.frozenBottom?($canvasBottomL.height(frozenRowsHeight),hasFrozenColumns()&&$canvasBottomR.height(frozenRowsHeight)):($canvasTopL.height(frozenRowsHeight),hasFrozenColumns()&&$canvasTopR.height(frozenRowsHeight))):$viewportTopR.height(viewportTopH),scrollbarDimensions&&scrollbarDimensions.width||(scrollbarDimensions=measureScrollbar()),options.autosizeColsMode===Slick.GridAutosizeColsMode.LegacyForceFit&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render()}}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),o=getDataLengthIncludingAddNew(),t=0,l=hasFrozenRows&&!options.frozenBottom?$canvasBottomL.height():$canvasTopL.height();if(hasFrozenRows)t=getDataLength()-options.frozenRow;else t=o+(options.leaveSpaceForNewRows?numVisibleRows-1:0);var r=$viewportScrollContainerY.height(),i=viewportHasVScroll;viewportHasVScroll=options.alwaysShowVerticalScroll||!options.autoHeight&&t*options.rowHeight>r,makeActiveCellNormal();var a=e-1;for(var s in rowsCache)s>a&&removeRowFromCache(s);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&activeRow>a&&resetActiveCell();l=h;options.autoHeight?h=options.rowHeight*t:(th=Math.max(options.rowHeight*t,r-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==l&&(hasFrozenRows&&!options.frozenBottom?($canvasBottomL.css("height",h),hasFrozenColumns()&&$canvasBottomR.css("height",h)):($canvasTopL.css("height",h),$canvasTopR.css("height",h)),scrollTop=$viewportScrollContainerY[0].scrollTop);var d=scrollTop+offset<=th-r;0==th||0==scrollTop?page=offset=0:scrollTo(d?scrollTop+offset:th-r),h!=l&&options.autoHeight&&resizeCanvas(),options.autosizeColsMode===Slick.GridAutosizeColsMode.LegacyForceFit&&i!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,o){return null==e&&(e=scrollTop),null==o&&(o=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:o,rightPx:o+viewportW}}function getRenderedRange(e,o){var t=getVisibleRange(e,o),n=Math.round(viewportH/options.rowHeight),l=options.minRowBuffer;return-1==vScrollDir?(t.top-=n,t.bottom+=l):1==vScrollDir?(t.top-=l,t.bottom+=n):(t.top-=l,t.bottom+=l),t.top=Math.max(0,t.top),t.bottom=Math.min(getDataLengthIncludingAddNew()-1,t.bottom),t.leftPx-=viewportW,t.rightPx+=viewportW,t.leftPx=Math.max(0,t.leftPx),t.rightPx=Math.min(canvasWidth,t.rightPx),t}function ensureCellNodesInRowsCache(e){var o=rowsCache[e];if(o&&o.cellRenderQueue.length)for(var t=o.rowNode.children().last();o.cellRenderQueue.length;){var n=o.cellRenderQueue.pop();o.cellNodesByColumnIdx[n]=t,0===(t=t.prev()).length&&(t=$(o.rowNode[0]).children().last())}}function cleanUpCells(e,o){if(!hasFrozenRows||!(options.frozenBottom&&o>actualFrozenRow||o<=actualFrozenRow)){var t,n=rowsCache[o],l=[];for(var r in n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(r)&&!((r|=0)<=options.frozenColumn||Array.isArray(columns)&&columns[r]&&columns[r].alwaysRenderColumn)){var i=n.cellColSpans[r];(columnPosLeft[r]>e.rightPx||columnPosRight[Math.min(columns.length-1,r+i-1)]<e.leftPx)&&(o==activeRow&&r==activeCell||l.push(r))}for(;null!=(t=l.pop());)n.cellNodesByColumnIdx[t][0].parentElement.removeChild(n.cellNodesByColumnIdx[t][0]),delete n.cellColSpans[t],delete n.cellNodesByColumnIdx[t],postProcessedRows[o]&&delete postProcessedRows[o][t]}}function cleanUpAndRenderCells(e){for(var o,t,n,l=[],r=[],i=e.top,a=e.bottom;i<=a;i++)if(o=rowsCache[i]){ensureCellNodesInRowsCache(i),cleanUpCells(e,i),t=0;var s=data.getItemMetadata&&data.getItemMetadata(i);s=s&&s.columns;for(var d=getDataItem(i),c=0,u=columns.length;c<u&&!(columnPosLeft[c]>e.rightPx);c++)if(null==(n=o.cellColSpans[c])){if(n=1,s){var h=s[columns[c].id]||s[c];"*"===(n=h&&h.colspan||1)&&(n=u-c)}columnPosRight[Math.min(u-1,c+n-1)]>e.leftPx&&(appendCellHtml(l,i,c,n,d),t++),c+=n>1?n-1:0}else c+=n>1?n-1:0;t&&(t,r.push(i))}if(l.length){var p,m,w=document.createElement("div");for(w.innerHTML=l.join("");null!=(p=r.pop());){var v;for(o=rowsCache[p];null!=(v=o.cellRenderQueue.pop());)m=w.lastChild,hasFrozenColumns()&&v>options.frozenColumn?o.rowNode[1].appendChild(m):o.rowNode[0].appendChild(m),o.cellNodesByColumnIdx[v]=$(m)}}}function renderRows(e){for(var o=[],t=[],n=[],l=!1,r=getDataLength(),i=e.top,a=e.bottom;i<=a;i++)rowsCache[i]||hasFrozenRows&&options.frozenBottom&&i==getDataLength()||(renderedRows++,n.push(i),rowsCache[i]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(o,t,i,e,r),activeCellNode&&activeRow===i&&(l=!0),counter_rows_rendered++);if(n.length){var s=document.createElement("div"),d=document.createElement("div");s.innerHTML=o.join(""),d.innerHTML=t.join("");for(i=0,a=n.length;i<a;i++)hasFrozenRows&&n[i]>=actualFrozenRow?hasFrozenColumns()?rowsCache[n[i]].rowNode=$().add($(s.firstChild).appendTo($canvasBottomL)).add($(d.firstChild).appendTo($canvasBottomR)):rowsCache[n[i]].rowNode=$().add($(s.firstChild).appendTo($canvasBottomL)):hasFrozenColumns()?rowsCache[n[i]].rowNode=$().add($(s.firstChild).appendTo($canvasTopL)).add($(d.firstChild).appendTo($canvasTopR)):rowsCache[n[i]].rowNode=$().add($(s.firstChild).appendTo($canvasTopL));l&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var o in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(o)&&(postProcessedRows[e][o]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache){var o=e?parseInt(e):0;rowsCache[o].rowNode[0].style.top=getRowTop(o)+"px"}}function render(){if(initialized){scrollThrottle.dequeue();var e=getVisibleRange(),o=getRenderedRange();if(cleanupRows(o),lastRenderedScrollLeft!=scrollLeft){if(hasFrozenRows){var t=$.extend(!0,{},o);options.frozenBottom?(t.top=actualFrozenRow,t.bottom=getDataLength()):(t.top=0,t.bottom=options.frozenRow),cleanUpAndRenderCells(t)}cleanUpAndRenderCells(o)}renderRows(o),hasFrozenRows&&(options.frozenBottom?renderRows({top:actualFrozenRow,bottom:getDataLength()-1,leftPx:o.leftPx,rightPx:o.rightPx}):renderRows({top:0,bottom:options.frozenRow-1,leftPx:o.leftPx,rightPx:o.rightPx})),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null,trigger(self.onRendered,{startRow:e.top,endRow:e.bottom,grid:self})}}function handleHeaderScroll(){handleElementScroll($headerScrollContainer[0])}function handleHeaderRowScroll(){var e=$headerRowScrollContainer[0].scrollLeft;e!=$viewportScrollContainerX[0].scrollLeft&&($viewportScrollContainerX[0].scrollLeft=e)}function handleFooterRowScroll(){var e=$footerRowScrollContainer[0].scrollLeft;e!=$viewportScrollContainerX[0].scrollLeft&&($viewportScrollContainerX[0].scrollLeft=e)}function handlePreHeaderPanelScroll(){handleElementScroll($preHeaderPanelScroller[0])}function handleElementScroll(e){var o=e.scrollLeft;o!=$viewportScrollContainerX[0].scrollLeft&&($viewportScrollContainerX[0].scrollLeft=o)}function handleScroll(){return scrollTop=$viewportScrollContainerY[0].scrollTop,scrollLeft=$viewportScrollContainerX[0].scrollLeft,_handleScroll(!1)}function _handleScroll(e){var o=$viewportScrollContainerY[0].scrollHeight-$viewportScrollContainerY[0].clientHeight,t=$viewportScrollContainerY[0].scrollWidth-$viewportScrollContainerY[0].clientWidth;o=Math.max(0,o),t=Math.max(0,t),scrollTop>o&&(scrollTop=o),scrollLeft>t&&(scrollLeft=t);var l=Math.abs(scrollTop-prevScrollTop),r=Math.abs(scrollLeft-prevScrollLeft);if(r&&(prevScrollLeft=scrollLeft,$viewportScrollContainerX[0].scrollLeft=scrollLeft,$headerScrollContainer[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScrollContainer[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScrollContainer[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&(hasFrozenColumns()?$preHeaderPanelScrollerR[0].scrollLeft=scrollLeft:$preHeaderPanelScroller[0].scrollLeft=scrollLeft),hasFrozenColumns()?hasFrozenRows&&($viewportTopR[0].scrollLeft=scrollLeft):hasFrozenRows&&($viewportTopL[0].scrollLeft=scrollLeft)),l)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e&&($viewportScrollContainerY[0].scrollTop=scrollTop),hasFrozenColumns()&&(hasFrozenRows&&!options.frozenBottom?$viewportBottomL[0].scrollTop=scrollTop:$viewportTopL[0].scrollTop=scrollTop),l<viewportH)scrollTo(scrollTop+offset);else{var i=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),i!=(offset=Math.round(page*cj))&&invalidateAllRows()}if(r||l){var a=Math.abs(lastRenderedScrollLeft-scrollLeft),s=Math.abs(lastRenderedScrollTop-scrollTop);(a>20||s>20)&&(options.forceSyncScrolling||s<viewportH&&a<viewportW?render():scrollThrottle.enqueue(),trigger(self.onViewportChanged,{}))}return trigger(self.onScroll,{scrollLeft,scrollTop}),!(!r&&!l)}function ActionThrottle(e,o){var t=!1,n=!1;function l(){n=!1}function r(){t=!0,setTimeout(i,o),e()}function i(){n?(l(),r()):t=!1}return{enqueue:function(){t?n=!0:r()},dequeue:l}}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var o=vScrollDir>=0?postProcessFromRow++:postProcessToRow--,t=rowsCache[o];if(t&&!(o>=e)){for(var n in postProcessedRows[o]||(postProcessedRows[o]={}),ensureCellNodesInRowsCache(o),t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(n)){var l=columns[n|=0],r=postProcessedRows[o][n];if(l.asyncPostRender&&"R"!==r){var i=t.cellNodesByColumnIdx[n];i&&l.asyncPostRender(i,o,getDataItem(o),l,"C"===r),postProcessedRows[o][n]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(postProcessedCleanupQueue.length>0){for(var e=postProcessedCleanupQueue[0].groupId;postProcessedCleanupQueue.length>0&&postProcessedCleanupQueue[0].groupId==e;){var o=postProcessedCleanupQueue.shift();if("R"==o.actionType&&$(o.node).remove(),"C"==o.actionType){var t=columns[o.columnIdx];t.asyncPostRenderCleanup&&o.node&&t.asyncPostRenderCleanup(o.node,o.rowIdx,t)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,o){var t,n,l,r;for(var i in rowsCache){if(r=o&&o[i],l=e&&e[i],r)for(n in r)l&&r[n]==l[n]||(t=getCellNode(i,getColumnIndex(n)))&&$(t).removeClass(r[n]);if(l)for(n in l)r&&r[n]==l[n]||(t=getCellNode(i,getColumnIndex(n)))&&$(t).addClass(l[n])}}function addCellCssStyles(e,o){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,null),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,o){var t=cellCssClasses[e];cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,t),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,o,t){(t=t||100,rowsCache[e])&&function e(o,n){n&&setTimeout((function(){o.queue((function(){o.toggleClass(options.cellFlashingCssClass).dequeue(),e(o,n-1)}))}),t)}($(getCellNode(e,o)),4)}function handleMouseWheel(e,o,t,n){var l=$(e.target).closest(".slick-row"),r=l[0];if(r!=rowNodeFromLastMouseWheelEvent){var i=l.parents(".grid-canvas").hasClass("grid-canvas-left");if(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent[i?0:1]!=r){var a=zombieRowNodeFromLastMouseWheelEvent[i||1==zombieRowNodeFromLastMouseWheelEvent.length?0:1];a.parentElement.removeChild(a),zombieRowNodeFromLastMouseWheelEvent=null}rowNodeFromLastMouseWheelEvent=r}scrollTop=Math.max(0,$viewportScrollContainerY[0].scrollTop-n*options.rowHeight),scrollLeft=$viewportScrollContainerX[0].scrollLeft+10*t,_handleScroll(!0)&&e.preventDefault()}function handleDragInit(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var n=trigger(self.onDragInit,o,e);return!!e.isImmediatePropagationStopped()&&n}function handleDragStart(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var n=trigger(self.onDragStart,o,e);return!!e.isImmediatePropagationStopped()&&n}function handleDrag(e,o){return trigger(self.onDrag,o,e)}function handleDragEnd(e,o){trigger(self.onDragEnd,o,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell},e);var o=e.isImmediatePropagationStopped(),t=Slick.keyCode;if(!o&&!e.shiftKey&&!e.altKey){if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;e.which==t.HOME?o=e.ctrlKey?navigateTop():navigateRowStart():e.which==t.END&&(o=e.ctrlKey?navigateBottom():navigateRowEnd())}if(!o)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=t.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(o=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;if(e.which==t.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==t.PAGE_DOWN?(navigatePageDown(),o=!0):e.which==t.PAGE_UP?(navigatePageUp(),o=!0):e.which==t.LEFT?o=navigateLeft():e.which==t.RIGHT?o=navigateRight():e.which==t.UP?o=navigateUp():e.which==t.DOWN?o=navigateDown():e.which==t.TAB?o=navigateNext():e.which==t.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable(void 0,void 0,e)),o=!0)}if(o){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var o=getCellFromEvent(e);if(o&&(null===currentEditor||activeRow!=o.row||activeCell!=o.cell)&&(trigger(self.onClick,{row:o.row,cell:o.cell},e),!e.isImmediatePropagationStopped()&&canCellBeActive(o.row,o.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(o.row,!1);var t=e.target&&e.target.className===Slick.preClickClassName,n=columns[o.cell],l=!!(options.editable&&n&&n.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(getCellNode(o.row,o.cell),null,t,l,e)}}function handleContextMenu(e){var o=$(e.target).closest(".slick-cell",$canvas);0!==o.length&&(activeCellNode===o[0]&&null!==currentEditor||trigger(self.onContextMenu,{},e))}function handleDblClick(e){var o=getCellFromEvent(e);!o||null!==currentEditor&&activeRow==o.row&&activeCell==o.cell||(trigger(self.onDblClick,{row:o.row,cell:o.cell},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(o.row,o.cell,!0,e))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");trigger(self.onHeaderContextMenu,{column:t},e)}function handleHeaderClick(e){if(!columnResizeDragging){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");t&&trigger(self.onHeaderClick,{column:t},e)}}function handleFooterContextMenu(e){var o=$(e.target).closest(".slick-footerrow-column",".slick-footerrow-columns"),t=o&&o.data("column");trigger(self.onFooterContextMenu,{column:t},e)}function handleFooterClick(e){var o=$(e.target).closest(".slick-footerrow-column",".slick-footerrow-columns"),t=o&&o.data("column");trigger(self.onFooterClick,{column:t},e)}function handleMouseEnter(e){trigger(self.onMouseEnter,{},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{},e)}function cellExists(e,o){return!(e<0||e>=getDataLength()||o<0||o>=columns.length)}function getCellFromPoint(e,o){for(var t=getRowFromPosition(o),n=0,l=0,r=0;r<columns.length&&l<e;r++)l+=columns[r].width,n++;return n<0&&(n=0),{row:t,cell:n-1}}function getCellFromNode(e){var o=/l\d+/.exec(e.className);if(!o)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(o[0].substr(1,o[0].length-1),10)}function getRowFromNode(e){for(var o in rowsCache)for(var t in rowsCache[o].rowNode)if(rowsCache[o].rowNode[t]===e)return o?parseInt(o):0;return null}function getFrozenRowOffset(e){return hasFrozenRows?options.frozenBottom?e>=actualFrozenRow?h<viewportTopH?actualFrozenRow*options.rowHeight:h:0:e>=actualFrozenRow?frozenRowsHeight:0:0}function getCellFromEvent(e){var o,t,n=$(e.target).closest(".slick-cell",$canvas);if(!n.length)return null;if(o=getRowFromNode(n[0].parentNode),hasFrozenRows){var l=n.parents(".grid-canvas").offset(),r=0;n.parents(".grid-canvas-bottom").length&&(r=options.frozenBottom?$canvasTopL.height():frozenRowsHeight),o=getCellFromPoint(e.clientX-l.left,e.clientY-l.top+r+$(document).scrollTop()).row}return t=getCellFromNode(n[0]),null==o||null==t?null:{row:o,cell:t}}function getCellNodeBox(e,o){if(!cellExists(e,o))return null;for(var t=getFrozenRowOffset(e),n=getRowTop(e)-t,l=n+options.rowHeight-1,r=0,i=0;i<o;i++)r+=columns[i].width,options.frozenColumn==i&&(r=0);return{top:n,left:r,bottom:l,right:r+columns[o].width}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,o,t){if(scrollRowIntoView(e,t),!(o<=options.frozenColumn)){var n=getColspan(e,o);internalScrollColumnIntoView(columnPosLeft[o],columnPosRight[o+(n>1?n-1:0)])}}function internalScrollColumnIntoView(e,o){var t=scrollLeft+$viewportScrollContainerX.width();e<scrollLeft?($viewportScrollContainerX.scrollLeft(e),handleScroll(),render()):o>t&&($viewportScrollContainerX.scrollLeft(Math.min(e,o-$viewportScrollContainerX[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,o,t,n,l){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));if(null!=(activeCellNode=e)){var r=$(activeCellNode),i=r.offset(),a=Math.floor(r.parents(".grid-canvas").offset().top),s=r.parents(".grid-canvas-bottom").length;hasFrozenRows&&s&&(a-=options.frozenBottom?$canvasTopL.height():frozenRowsHeight);var d=getCellFromPoint(i.left,Math.ceil(i.top)-a);activeRow=d.row,activeCell=activePosX=activeCell=activePosX=getCellFromNode(activeCellNode),null==o&&(o=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&(r.addClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&o&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout((function(){makeActiveCellEditable(void 0,t,l)}),options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,t,l))}else activeRow=activeCell=null;n||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,o){var t=getDataLength();return!(e<t&&!getDataItem(e))&&(!(columns[o].cannotTriggerInsert&&e>=t)&&!!getEditor(e,o))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var o=columns[activeCell];applyFormatResultToCellNode(getFormatter(activeRow,o)(activeRow,activeCell,getDataItemValueForColumn(e,o),o,e,self),activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,o,t){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var n=columns[activeCell],l=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:l,column:n})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var r=e||getEditor(activeRow,activeCell);e||r.suppressClearOnEdit||(activeCellNode.innerHTML="");var i=data.getItemMetadata&&data.getItemMetadata(activeRow),a=(i=i&&i.columns)&&(i[n.id]||i[activeCell]);currentEditor=new r({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:n,columnMetaData:a,item:l||{},event:t,commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),l&&(currentEditor.loadValue(l),o&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var o={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};o.bottom=o.top+o.height,o.right=o.left+o.width;for(var t=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)o.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(o.visible=o.bottom>e.scrollTop&&o.top<e.scrollTop+e.clientHeight),o.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(o.visible=o.right>e.scrollLeft&&o.left<e.scrollLeft+e.clientWidth),o.left-=e.scrollLeft,o.top-=e.scrollTop,e===t&&(o.left+=e.offsetLeft,o.top+=e.offsetTop,t=e.offsetParent),o.bottom=o.top+o.height,o.right=o.left+o.width;return o}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,o){if(!hasFrozenRows||!options.frozenBottom&&e>actualFrozenRow-1||options.frozenBottom&&e<actualFrozenRow-1){var t=$viewportScrollContainerY.height(),n=hasFrozenRows&&!options.frozenBottom?e-options.frozenRow:e,l=n*options.rowHeight,r=(n+1)*options.rowHeight-t+(viewportHasHScroll?scrollbarDimensions.height:0);(n+1)*options.rowHeight>scrollTop+t+offset?(scrollTo(o?l:r),render()):n*options.rowHeight<scrollTop+offset&&(scrollTo(o?r:l),render())}}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var o=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop+options.rowHeight-1)+o)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var t=activeRow+o,n=getDataLengthIncludingAddNew();t>=n&&(t=n-1),t<0&&(t=0);for(var l=0,r=null,i=activePosX;l<=activePosX;)canCellBeActive(t,l)&&(r=l),l+=getColspan(t,l);null!==r?(setActiveCellInternal(getCellNode(t,r)),activePosX=i):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function navigateTop(){navigateToRow(0)}function navigateBottom(){navigateToRow(getDataLength()-1)}function navigateToRow(e){var o=getDataLength();if(!o)return!0;if(e<0?e=0:e>=o&&(e=o-1),scrollCellIntoView(e,0,!0),options.enableCellNavigation&&null!=activeRow){for(var t=0,n=null,l=activePosX;t<=activePosX;)canCellBeActive(e,t)&&(n=t),t+=getColspan(e,t);null!==n?(setActiveCellInternal(getCellNode(e,n)),activePosX=l):resetActiveCell()}return!0}function getColspan(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e);if(!t||!t.columns)return 1;var n=t.columns[columns[o].id]||t.columns[o],l=n&&n.colspan;return l="*"===l?columns.length-o:l||1}function findFirstFocusableCell(e){for(var o=0;o<columns.length;){if(canCellBeActive(e,o))return o;o+=getColspan(e,o)}return null}function findLastFocusableCell(e){for(var o=0,t=null;o<columns.length;)canCellBeActive(e,o)&&(t=o),o+=getColspan(e,o);return t}function gotoRight(e,o,t){if(o>=columns.length)return null;do{o+=getColspan(e,o)}while(o<columns.length&&!canCellBeActive(e,o));return o<columns.length?{row:e,cell:o,posX:o}:null}function gotoLeft(e,o,t){if(o<=0)return null;var n=findFirstFocusableCell(e);if(null===n||n>=o)return null;for(var l,r={row:e,cell:n,posX:n};;){if(!(l=gotoRight(r.row,r.cell,r.posX)))return null;if(l.cell>=o)return r;r=l}}function gotoDown(e,o,t){for(var n,l=getDataLengthIncludingAddNew();;){if(++e>=l)return null;for(n=o=0;o<=t;)n=o,o+=getColspan(e,o);if(canCellBeActive(e,n))return{row:e,cell:n,posX:t}}}function gotoUp(e,o,t){for(var n;;){if(--e<0)return null;for(n=o=0;o<=t;)n=o,o+=getColspan(e,o);if(canCellBeActive(e,n))return{row:e,cell:n,posX:t}}}function gotoNext(e,o,t){if(null==e&&null==o&&canCellBeActive(e=o=t=0,o))return{row:e,cell:o,posX:o};var n=gotoRight(e,o,t);if(n)return n;var l=null,r=getDataLengthIncludingAddNew();for(e===r-1&&e--;++e<r;)if(null!==(l=findFirstFocusableCell(e)))return{row:e,cell:l,posX:l};return null}function gotoPrev(e,o,t){if(null==e&&null==o&&canCellBeActive(e=getDataLengthIncludingAddNew()-1,o=t=columns.length-1))return{row:e,cell:o,posX:o};for(var n,l;!n&&!(n=gotoLeft(e,o,t));){if(--e<0)return null;o=0,null!==(l=findLastFocusableCell(e))&&(n={row:e,cell:l,posX:l})}return n}function gotoRowStart(e,o,t){var n=findFirstFocusableCell(e);return null===n?null:{row:e,cell:n,posX:n}}function gotoRowEnd(e,o,t){var n=findLastFocusableCell(e);return null===n?null:{row:e,cell:n,posX:n}}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigateRowStart(){return navigate("home")}function navigateRowEnd(){return navigate("end")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1,home:-1,end:1}[e];var o=(0,{up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext,home:gotoRowStart,end:gotoRowEnd}[e])(activeRow,activeCell,activePosX);if(o){if(hasFrozenRows&&options.frozenBottom&o.row==getDataLength())return;var t=o.row==getDataLength();return(!options.frozenBottom&&o.row>=actualFrozenRow||options.frozenBottom&&o.row<actualFrozenRow)&&scrollCellIntoView(o.row,o.cell,!t&&options.emulatePagingWhenScrolling),setActiveCellInternal(getCellNode(o.row,o.cell)),activePosX=o.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,o){if(rowsCache[e]){ensureCellNodesInRowsCache(e);try{return rowsCache[e].cellNodesByColumnIdx.length>o?rowsCache[e].cellNodesByColumnIdx[o][0]:null}catch(t){return rowsCache[e].cellNodesByColumnIdx[o]}}return null}function setActiveCell(e,o,t,n,l){initialized&&(e>getDataLength()||e<0||o>=columns.length||o<0||options.enableCellNavigation&&(scrollCellIntoView(e,o,!1),setActiveCellInternal(getCellNode(e,o),t,n,l)))}function canCellBeActive(e,o){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.focusable)return!!t.focusable;var n=t&&t.columns;return n&&n[columns[o].id]&&void 0!==n[columns[o].id].focusable?!!n[columns[o].id].focusable:n&&n[o]&&void 0!==n[o].focusable?!!n[o].focusable:!!columns[o].focusable}function canCellBeSelected(e,o){if(e>=getDataLength()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.selectable)return!!t.selectable;var n=t&&t.columns&&(t.columns[columns[o].id]||t.columns[o]);return n&&void 0!==n.selectable?!!n.selectable:!!columns[o].selectable}function gotoCell(e,o,t,n){if(initialized&&canCellBeActive(e,o)&&getEditorLock().commitCurrentEdit()){scrollCellIntoView(e,o,!1);var l=getCellNode(e,o),r=columns[o],i=!!(options.editable&&r&&r.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(l,t||e===getDataLength()||options.autoEdit,null,i,n),currentEditor||setFocus()}}function commitCurrentEdit(){var e=getDataItem(activeRow),o=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var t=currentEditor.validate();if(t.valid){if(activeRow<getDataLength()){var n={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,o,n)):(n.execute(),makeActiveCellNormal())}else{var l={};currentEditor.applyValue(l,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:l,column:o})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:t,row:activeRow,cell:activeCell,column:o}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var o=[],t=columns.length-1,n=0;n<e.length;n++)o.push(new Slick.Range(e[n],0,e[n],t));return o}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows.slice(0)}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");self&&self.getEditorLock&&!self.getEditorLock().isActive()&&selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.4.27",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onFooterContextMenu:new Slick.Event,onFooterClick:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsDrag:new Slick.Event,onColumnsResized:new Slick.Event,onBeforeColumnsResize:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,onAutosizeColumns:new Slick.Event,onRendered:new Slick.Event,onSetOptions:new Slick.Event,registerPlugin,unregisterPlugin,getPluginByName,getColumns,setColumns,getColumnIndex,updateColumnHeader,setSortColumn,setSortColumns,getSortColumns,autosizeColumns,autosizeColumn,getOptions,setOptions,getData,getDataLength,getDataItem,setData,getSelectionModel,setSelectionModel,getSelectedRows,setSelectedRows,getContainerNode,updatePagingStatusFromView,applyFormatResultToCellNode,render,invalidate,invalidateRow,invalidateRows,invalidateAllRows,updateCell,updateRow,getViewport:getVisibleRange,getRenderedRange,resizeCanvas,updateRowCount,scrollRowIntoView,scrollRowToTop,scrollCellIntoView,scrollColumnIntoView,getCanvasNode,getUID,getHeaderColumnWidthDiff,getScrollbarDimensions,getHeadersWidth,getCanvasWidth,getCanvases,getActiveCanvasNode,setActiveCanvasNode,getViewportNode,getActiveViewportNode,setActiveViewportNode,focus:setFocus,scrollTo,getCellFromPoint,getCellFromEvent,getActiveCell,setActiveCell,getActiveCellNode,getActiveCellPosition,resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor,getCellNode,getCellNodeBox,canCellBeSelected,canCellBeActive,navigatePrev,navigateNext,navigateUp,navigateDown,navigateLeft,navigateRight,navigatePageUp,navigatePageDown,navigateTop,navigateBottom,navigateRowStart,navigateRowEnd,gotoCell,getTopPanel,setTopPanelVisibility,getPreHeaderPanel,getPreHeaderPanelLeft:getPreHeaderPanel,getPreHeaderPanelRight,setPreHeaderPanelVisibility,getHeader,getHeaderColumn,setHeaderRowVisibility,getHeaderRow,getHeaderRowColumn,setFooterRowVisibility,getFooterRow,getFooterRowColumn,getGridPosition,flashCell,addCellCssStyles,setCellCssStyles,removeCellCssStyles,getCellCssStyles,getFrozenRowOffset,setColumnHeaderVisibility,init:finishInitialization,destroy,getEditorLock,getEditController}),init()}module.exports={Grid:SlickGrid}},
501: function _(t,e,a,n,r){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=t(494);o.fn.drag=function(t,e,a){var n="string"==typeof t?t:"",r=o.isFunction(t)?t:o.isFunction(e)?e:null;return 0!==n.indexOf("drag")&&(n="drag"+n),a=(t==r?e:a)||{},r?this.on(n,a,r):this.trigger(n)};var i=o.event,d=i.special,s=d.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(t){var e=o.data(this,s.datakey),a=t.data||{};e.related+=1,o.each(s.defaults,(function(t,n){void 0!==a[t]&&(e[t]=a[t])}))},remove:function(){o.data(this,s.datakey).related-=1},setup:function(){if(!o.data(this,s.datakey)){var t=o.extend({related:0},s.defaults);o.data(this,s.datakey,t),i.add(this,"touchstart mousedown",s.init,t),this.attachEvent&&this.attachEvent("ondragstart",s.dontstart)}},teardown:function(){(o.data(this,s.datakey)||{}).related||(o.removeData(this,s.datakey),i.remove(this,"touchstart mousedown",s.init),s.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",s.dontstart))},init:function(t){if(!s.touched){var e,a=t.data;if(!(0!=t.which&&a.which>0&&t.which!=a.which)){var n=o(t.target).attr("class")||"";if(!o(t.target).is(a.not)&&n&&-1!==n.toString().indexOf("slick")&&(!a.handle||o(t.target).closest(a.handle,t.currentTarget).length)&&(s.touched="touchstart"==t.type?this:null,a.propagates=1,a.mousedown=this,a.interactions=[s.interaction(this,a)],a.target=t.target,a.pageX=t.pageX,a.pageY=t.pageY,a.dragging=null,e=s.hijack(t,"draginit",a),a.propagates))return(e=s.flatten(e))&&e.length&&(a.interactions=[],o.each(e,(function(){a.interactions.push(s.interaction(this,a))}))),a.propagates=a.interactions.length,!1!==a.drop&&d.drop&&d.drop.handler(t,a),s.textselect(!1),s.touched?i.add(s.touched,"touchmove touchend",s.handler,a):i.add(document,"mousemove mouseup",s.handler,a),!(!s.touched||a.live)&&void 0}}},interaction:function(t,e){var a=t&&t.ownerDocument&&o(t)[e.relative?"position":"offset"]()||{top:0,left:0};return{drag:t,callback:new s.callback,droppable:[],offset:a}},handler:function(t){var e=t.data;switch(t.type){case!e.dragging&&"touchmove":t.preventDefault();case!e.dragging&&"mousemove":if(Math.pow(t.pageX-e.pageX,2)+Math.pow(t.pageY-e.pageY,2)<Math.pow(e.distance,2))break;t.target=e.target,s.hijack(t,"dragstart",e),e.propagates&&(e.dragging=!0);case"touchmove":t.preventDefault();case"mousemove":if(e.dragging){if(s.hijack(t,"drag",e),e.propagates){!1!==e.drop&&d.drop&&d.drop.handler(t,e);break}t.type="mouseup"}case"touchend":case"mouseup":default:s.touched?i.remove(s.touched,"touchmove touchend",s.handler):i.remove(document,"mousemove mouseup",s.handler),e.dragging&&(!1!==e.drop&&d.drop&&d.drop.handler(t,e),s.hijack(t,"dragend",e)),s.textselect(!0),!1===e.click&&e.dragging&&o.data(e.mousedown,"suppress.click",(new Date).getTime()+5),e.dragging=s.touched=!1}},hijack:function(t,e,a,n,r){if(a){var d,c,l,p={event:t.originalEvent,type:t.type},u=e.indexOf("drop")?"drag":"drop",g=n||0,h=isNaN(n)?a.interactions.length:n;t.type=e;var f=function(){};t.originalEvent=new o.Event(p.event,{preventDefault:f,stopPropagation:f,stopImmediatePropagation:f}),a.results=[];do{if(c=a.interactions[g]){if("dragend"!==e&&c.cancelled)continue;l=s.properties(t,a,c),c.results=[],o(r||c[u]||a.droppable).each((function(n,r){if(l.target=r,t.isPropagationStopped=function(){return!1},!1===(d=r?i.dispatch.call(r,t,l):null)?("drag"==u&&(c.cancelled=!0,a.propagates-=1),"drop"==e&&(c[u][n]=null)):"dropinit"==e&&c.droppable.push(s.element(d)||r),"dragstart"==e&&(c.proxy=o(s.element(d)||c.drag)[0]),c.results.push(d),delete t.result,"dropinit"!==e)return d})),a.results[g]=s.flatten(c.results),"dropinit"==e&&(c.droppable=s.flatten(c.droppable)),"dragstart"!=e||c.cancelled||l.update()}}while(++g<h);return t.type=p.type,t.originalEvent=p.event,s.flatten(a.results)}},properties:function(t,e,a){var n=a.callback;return n.drag=a.drag,n.proxy=a.proxy||a.drag,n.startX=e.pageX,n.startY=e.pageY,n.deltaX=t.pageX-e.pageX,n.deltaY=t.pageY-e.pageY,n.originalX=a.offset.left,n.originalY=a.offset.top,n.offsetX=n.originalX+n.deltaX,n.offsetY=n.originalY+n.deltaY,n.drop=s.flatten((a.drop||[]).slice()),n.available=s.flatten((a.droppable||[]).slice()),n},element:function(t){if(t&&(t.jquery||1==t.nodeType))return t},flatten:function(t){return o.map(t,(function(t){return t&&t.jquery?o.makeArray(t):t&&t.length?s.flatten(t):t}))},textselect:function(t){o(document)[t?"off":"on"]("selectstart",s.dontstart).css("MozUserSelect",t?"":"none"),document.unselectable=t?"off":"on"},dontstart:function(){return!1},callback:function(){}};s.callback.prototype={update:function(){d.drop&&this.available.length&&o.each(this.available,(function(t){d.drop.locate(this,t)}))}};var c=i.dispatch;i.dispatch=function(t){if(!(o.data(this,"suppress."+t.type)-(new Date).getTime()>0))return c.apply(this,arguments);o.removeData(this,"suppress."+t.type)},d.draginit=d.dragstart=d.dragend=s},
502: function _(t,e,a,n,i){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var o=t(494);o.fn.drop=function(t,e,a){var n="string"==typeof t?t:"",i=o.isFunction(t)?t:o.isFunction(e)?e:null;return 0!==n.indexOf("drop")&&(n="drop"+n),a=(t==i?e:a)||{},i?this.on(n,a,i):this.trigger(n)},o.drop=function(t){t=t||{},d.multi=!0===t.multi?1/0:!1===t.multi?1:isNaN(t.multi)?d.multi:t.multi,d.delay=t.delay||d.delay,d.tolerance=o.isFunction(t.tolerance)?t.tolerance:null===t.tolerance?null:d.tolerance,d.mode=t.mode||d.mode||"intersect"};var r=o.event.special,d=o.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(t){o.data(this,d.datakey).related+=1},remove:function(){o.data(this,d.datakey).related-=1},setup:function(){if(!o.data(this,d.datakey)){o.data(this,d.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),d.targets.push(this)}},teardown:function(){if(!(o.data(this,d.datakey)||{}).related){o.removeData(this,d.datakey);var t=this;d.targets=o.grep(d.targets,(function(e){return e!==t}))}},handler:function(t,e){var a;if(e)switch(t.type){case"mousedown":case"touchstart":a=o(d.targets),"string"==typeof e.drop&&(a=a.filter(e.drop)),a.each((function(){var t=o.data(this,d.datakey);t.active=[],t.anyactive=0,t.winner=0})),e.droppable=a,r.drag.hijack(t,"dropinit",e);break;case"mousemove":case"touchmove":d.event=t,d.timer||d.tolerate(e);break;case"mouseup":case"touchend":d.timer=clearTimeout(d.timer),e.propagates&&(r.drag.hijack(t,"drop",e),r.drag.hijack(t,"dropend",e))}},locate:function(t,e){var a=o.data(t,d.datakey),n=o(t),i=n.length&&!n.is(document)?n.offset():{},r=n.outerHeight(),l=n.outerWidth(),c={elem:t,width:l,height:r,top:i.top,left:i.left,right:i.left+l,bottom:i.top+r};return a&&(a.location=c,a.index=e,a.elem=t),c},contains:function(t,e){return(e[0]||e.left)>=t.left&&(e[0]||e.right)<=t.right&&(e[1]||e.top)>=t.top&&(e[1]||e.bottom)<=t.bottom},modes:{intersect:function(t,e,a){return this.contains(a,[t.pageX,t.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(t,e,a){return Math.max(0,Math.min(a.bottom,e.bottom)-Math.max(a.top,e.top))*Math.max(0,Math.min(a.right,e.right)-Math.max(a.left,e.left))},fit:function(t,e,a){return this.contains(a,e)?1:0},middle:function(t,e,a){return this.contains(a,[e.left+.5*e.width,e.top+.5*e.height])?1:0}},sort:function(t,e){return e.winner-t.winner||t.index-e.index},tolerate:function(t){var e,a,n,i,l,c,s,u,p=0,h=t.interactions.length,m=[d.event.pageX,d.event.pageY],f=d.tolerance||d.modes[d.mode];do{if(u=t.interactions[p]){if(!u)return;u.drop=[],l=[],c=u.droppable.length,f&&(n=d.locate(u.proxy)),e=0;do{if(s=u.droppable[e]){if(!(a=(i=o.data(s,d.datakey)).location))continue;i.winner=f?f.call(d,d.event,n,a):d.contains(a,m)?1:0,l.push(i)}}while(++e<c);l.sort(d.sort),e=0;do{(i=l[e])&&(i.winner&&u.drop.length<d.multi?(i.active[p]||i.anyactive||(!1!==r.drag.hijack(d.event,"dropstart",t,p,i.elem)[0]?(i.active[p]=1,i.anyactive+=1):i.winner=0),i.winner&&u.drop.push(i.elem)):i.active[p]&&1==i.anyactive&&(r.drag.hijack(d.event,"dropend",t,p,i.elem),i.active[p]=0,i.anyactive-=1))}while(++e<c)}}while(++p<h);d.last&&m[0]==d.last.pageX&&m[1]==d.last.pageY?delete d.timer:d.timer=setTimeout((function(){d.tolerate(t)}),d.delay),d.last=d.event}};r.dropinit=r.dropstart=r.dropend=d},
503: function _(e,t,n,r,o){var i=e(494),l=e(496);var a={Avg:function(e){this.field_=e,this.init=function(){this.count_=0,this.nonNullCount_=0,this.sum_=0},this.accumulate=function(e){var t=e[this.field_];this.count_++,null==t||""===t||isNaN(t)||(this.nonNullCount_++,this.sum_+=parseFloat(t))},this.storeResult=function(e){e.avg||(e.avg={}),0!==this.nonNullCount_&&(e.avg[this.field_]=this.sum_/this.nonNullCount_)}},Min:function(e){this.field_=e,this.init=function(){this.min_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(null==this.min_||t<this.min_)&&(this.min_=t)},this.storeResult=function(e){e.min||(e.min={}),e.min[this.field_]=this.min_}},Max:function(e){this.field_=e,this.init=function(){this.max_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(null==this.max_||t>this.max_)&&(this.max_=t)},this.storeResult=function(e){e.max||(e.max={}),e.max[this.field_]=this.max_}},Sum:function(e){this.field_=e,this.init=function(){this.sum_=null},this.accumulate=function(e){var t=e[this.field_];null==t||""===t||isNaN(t)||(this.sum_+=parseFloat(t))},this.storeResult=function(e){e.sum||(e.sum={}),e.sum[this.field_]=this.sum_}},Count:function(e){this.field_=e,this.init=function(){},this.storeResult=function(e){e.count||(e.count={}),e.count[this.field_]=e.group.rows.length}}};t.exports={DataView:function(e){var t,n,r,o,a,u=this,s="id",g=[],c=[],f={},h=null,p=null,d=null,m=!1,v=!0,_={},w={},y=[],$=[],C={getter:null,formatter:null,comparer:function(e,t){return e.value===t.value?0:e.value>t.value?1:-1},predefinedValues:[],aggregators:[],aggregateEmpty:!1,aggregateCollapsed:!1,aggregateChildGroups:!1,collapsed:!1,displayTotalsRow:!0,lazyTotalsCalculation:!1},I=[],R=[],x=[],E=":|:",M=0,S=0,b=0,F=new l.Event,A=new l.Event,N=new l.Event,G=new l.Event,T=new l.Event,O=new l.Event,P=new l.Event,D=new l.Event;function K(e){for(var t,n=e=e||0,r=g.length;n<r;n++){if(void 0===(t=g[n][s]))throw new Error("Each data element must implement a unique 'id' property");f[t]=n}}function j(){var e=M?Math.max(1,Math.ceil(b/M)):1;return{pageSize:M,pageNum:S,totalRows:b,totalPages:e,dataView:u}}function B(e,r){v=r,n=e,t=null,!1===r&&g.reverse(),g.sort(e),!1===r&&g.reverse(),f={},K(),se()}function z(e,r){v=r,t=e,n=null;var o=Object.prototype.toString;Object.prototype.toString="function"==typeof e?e:function(){return this[e]},!1===r&&g.reverse(),g.sort(),Object.prototype.toString=o,!1===r&&g.reverse(),f={},K(),se()}function V(t){e.groupItemMetadataProvider||(e.groupItemMetadataProvider=new l.Data.GroupItemMetadataProvider),R=[],x=[],I=(t=t||[])instanceof Array?t:[t];for(var n=0;n<I.length;n++){var r=I[n]=i.extend(!0,{},C,I[n]);r.getterIsAFn="function"==typeof r.getter,r.compiledAccumulators=[];for(var o=r.aggregators.length;o--;)r.compiledAccumulators[o]=re(r.aggregators[o]);x[n]={}}se()}function q(){if(!h){h={};for(var e=0,t=c.length;e<t;e++)h[c[e][s]]=e}}function U(e){return g[f[e]]}function L(e,t){if(void 0===f[e])throw new Error("Invalid id");if(e!==t[s]){var n=t[s];if(null==n)throw new Error("Cannot update item to associate with a null id");if(void 0!==f[n])throw new Error("Cannot update item to associate with a non-unique id");f[n]=f[e],delete f[e],d&&d[e]&&delete d[e],e=n}g[f[e]]=t,d||(d={}),d[e]=!0,se()}function k(e,t){g.splice(e,0,t),K(e),se()}function H(e){var t=f[e];if(void 0===t)throw new Error("Invalid id");delete f[e],g.splice(t,1),K(t),se()}function W(e){if(!n)throw new Error("sortedAddItem() requires a sort comparer, use sort()");k(function(e){var t=0,r=g.length;for(;t<r;){var o=t+r>>>1;-1===n(g[o],e)?t=o+1:r=o}return t}(e),e)}function J(e,t){if(null==e)for(var n=0;n<I.length;n++)x[n]={},I[n].collapsed=t,!0===t?D.notify({level:n,groupingKey:null}):P.notify({level:n,groupingKey:null});else x[e]={},I[e].collapsed=t,!0===t?D.notify({level:e,groupingKey:null}):P.notify({level:e,groupingKey:null});se()}function Q(e,t,n){x[e][t]=I[e].collapsed^n,se()}function X(e,t){for(var n,r,o,i=[],a={},u=t?t.level+1:0,s=I[u],g=0,c=s.predefinedValues.length;g<c;g++)(n=a[r=s.predefinedValues[g]])||((n=new l.Group).value=r,n.level=u,n.groupingKey=(t?t.groupingKey+E:"")+r,i[i.length]=n,a[r]=n);for(g=0,c=e.length;g<c;g++)o=e[g],(n=a[r=s.getterIsAFn?s.getter(o):o[s.getter]])||((n=new l.Group).value=r,n.level=u,n.groupingKey=(t?t.groupingKey+E:"")+r,i[i.length]=n,a[r]=n),n.rows[n.count++]=o;if(u<I.length-1)for(g=0;g<i.length;g++)(n=i[g]).groups=X(n.rows,n);return i.length&&ee(i,u),i.sort(I[u].comparer),i}function Y(e){var t,n=e.group,r=I[n.level],o=n.level==I.length,i=r.aggregators.length;if(!o&&r.aggregateChildGroups)for(var l=n.groups.length;l--;)n.groups[l].totals.initialized||Y(n.groups[l].totals);for(;i--;)(t=r.aggregators[i]).init(),!o&&r.aggregateChildGroups?r.compiledAccumulators[i].call(t,n.groups):r.compiledAccumulators[i].call(t,n.rows),t.storeResult(e);e.initialized=!0}function Z(e){var t=I[e.level],n=new l.GroupTotals;n.group=e,e.totals=n,t.lazyTotalsCalculation||Y(n)}function ee(e,t){for(var n,r=I[t=t||0],o=r.collapsed,i=x[t],l=e.length;l--;)(n=e[l]).collapsed&&!r.aggregateCollapsed||(n.groups&&ee(n.groups,t+1),r.aggregators.length&&(r.aggregateEmpty||n.rows.length||n.groups&&n.groups.length)&&Z(n),n.collapsed=o^i[n.groupingKey],n.title=r.formatter?r.formatter(n):n.value)}function te(e,t){for(var n,r,o=I[t=t||0],i=[],l=0,a=0,u=e.length;a<u;a++){if(r=e[a],i[l++]=r,!r.collapsed)for(var s=0,g=(n=r.groups?te(r.groups,t+1):r.rows).length;s<g;s++)i[l++]=n[s];r.totals&&o.displayTotalsRow&&(!r.collapsed||o.aggregateCollapsed)&&(i[l++]=r.totals)}return i}function ne(e){var t=e.toString().indexOf("function")>=0?/^function[^(]*\(([^)]*)\)\s*{([\s\S]*)}$/:/^[^(]*\(([^)]*)\)\s*{([\s\S]*)}$/,n=e.toString().match(t);return{params:n[1].split(","),body:n[2]}}function re(e){if(e.accumulate){var t=ne(e.accumulate),n=new Function("_items","for (var "+t.params[0]+", _i=0, _il=_items.length; _i<_il; _i++) {"+t.params[0]+" = _items[_i]; "+t.body+"}"),r="compiledAccumulatorLoop";return n.displayName=r,n.name=oe(n,r),n}return function(){}}function oe(e,t){try{Object.defineProperty(e,"name",{writable:!0,value:t})}catch(n){e.name=t}}function ie(e,t){for(var n=[],r=0,o=0,i=e.length;o<i;o++)p(e[o],t)&&(n[r++]=e[o]);return n}function le(e,t,n){for(var r,o=[],i=0,l=0,a=e.length;l<a;l++)r=e[l],n[l]?o[i++]=r:p(r,t)&&(o[i++]=r,n[l]=!0);return o}function ae(t){if(p){var n=e.inlineFilters?o:ie,i=e.inlineFilters?a:le;_.isFilterNarrowing?y=n(y,r):_.isFilterExpanding?y=i(t,r,$):_.isFilterUnchanged||(y=n(t,r))}else y=M?t:t.concat();var l;return M?(y.length<=S*M&&(S=0===y.length?0:Math.floor((y.length-1)/M)),l=y.slice(M*S,M*S+M)):l=y,{totalRows:y.length,rows:l}}function ue(e){h=null,_.isFilterNarrowing==w.isFilterNarrowing&&_.isFilterExpanding==w.isFilterExpanding||($=[]);var t=ae(e);b=t.totalRows;var n=t.rows;R=[],I.length&&(R=X(n)).length&&(n=te(R));var r=function(e,t){var n,r,o,i=[],l=0,a=Math.max(t.length,e.length);_&&_.ignoreDiffsBefore&&(l=Math.max(0,Math.min(t.length,_.ignoreDiffsBefore))),_&&_.ignoreDiffsAfter&&(a=Math.min(t.length,Math.max(0,_.ignoreDiffsAfter)));for(var u=l,g=e.length;u<a;u++)u>=g?i[i.length]=u:(n=t[u],r=e[u],(!n||I.length&&(o=n.__nonDataRow||r.__nonDataRow)&&n.__group!==r.__group||n.__group&&!n.equals(r)||o&&(n.__groupTotals||r.__groupTotals)||n[s]!=r[s]||d&&d[n[s]])&&(i[i.length]=u));return i}(c,n);return c=n,r}function se(){if(!m){var e=i.extend(!0,{},j()),t=c.length,n=b,r=ue(g);M&&b<S*M&&(S=Math.max(0,Math.ceil(b/M)-1),r=ue(g)),d=null,w=_,_={},n!==b&&(T.notify(e,null,u),O.notify(j(),null,u)),t!==c.length&&A.notify({previous:t,current:c.length,dataView:u,callingOnRowsChanged:r.length>0},null,u),r.length>0&&N.notify({rows:r,dataView:u,calledOnRowCountChanged:t!==c.length},null,u),(t!==c.length||r.length>0)&&G.notify({rowsDiff:r,previousRowCount:t,currentRowCount:c.length,rowCountChanged:t!==c.length,rowsChanged:r.length>0,dataView:u},null,u)}}e=i.extend(!0,{},{groupItemMetadataProvider:null,inlineFilters:!1},e),i.extend(this,{beginUpdate:function(){m=!0},endUpdate:function(){m=!1,se()},setPagingOptions:function(e){T.notify(j(),null,u),null!=e.pageSize&&(M=e.pageSize,S=M?Math.min(S,Math.max(0,Math.ceil(b/M)-1)):0),null!=e.pageNum&&(S=Math.min(e.pageNum,Math.max(0,Math.ceil(b/M)-1))),O.notify(j(),null,u),se()},getPagingInfo:j,getIdPropertyName:function(){return s},getItems:function(){return g},setItems:function(e,t){void 0!==t&&(s=t),g=y=e,f={},K(),function(){for(var e,t=0,n=g.length;t<n;t++)if(void 0===(e=g[t][s])||f[e]!==t)throw new Error("Each data element must implement a unique 'id' property")}(),se(),F.notify({idProperty:t},null,u)},setFilter:function(t){p=t,e.inlineFilters&&(o=function(){var e=ne(p),t="{ continue _coreloop; }$1",n="{ _retval[_idx++] = $item$; continue _coreloop; }$1",r=e.body.replace(/return false\s*([;}]|\}|$)/gi,t).replace(/return!1([;}]|\}|$)/gi,t).replace(/return true\s*([;}]|\}|$)/gi,n).replace(/return!0([;}]|\}|$)/gi,n).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ($1) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),o=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","$filter$; ","} ","return _retval; "].join("");o=(o=(o=o.replace(/\$filter\$/gi,r)).replace(/\$item\$/gi,e.params[0])).replace(/\$args\$/gi,e.params[1]);var i=new Function("_items,_args",o),l="compiledFilter";return i.displayName=l,i.name=oe(i,l),i}(),a=function(){var e=ne(p),t="{ continue _coreloop; }$1",n="{ _cache[_i] = true;_retval[_idx++] = $item$; continue _coreloop; }$1",r=e.body.replace(/return false\s*([;}]|\}|$)/gi,t).replace(/return!1([;}]|\}|$)/gi,t).replace(/return true\s*([;}]|\}|$)/gi,n).replace(/return!0([;}]|\}|$)/gi,n).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ((_cache[_i] = $1)) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),o=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","if (_cache[_i]) { ","_retval[_idx++] = $item$; ","continue _coreloop; ","} ","$filter$; ","} ","return _retval; "].join("");o=(o=(o=o.replace(/\$filter\$/gi,r)).replace(/\$item\$/gi,e.params[0])).replace(/\$args\$/gi,e.params[1]);var i=new Function("_items,_args,_cache",o),l="compiledFilterWithCaching";return i.displayName=l,i.name=oe(i,l),i}()),se()},getFilter:function(){return p},getFilteredItems:function(){return y},sort:B,fastSort:z,reSort:function(){n?B(n,v):t&&z(t,v)},setGrouping:V,getGrouping:function(){return I},groupBy:function(e,t,n){V(null!=e?{getter:e,formatter:t,comparer:n}:[])},setAggregators:function(e,t){if(!I.length)throw new Error("At least one grouping must be specified before calling setAggregators().");I[0].aggregators=e,I[0].aggregateCollapsed=t,V(I)},collapseAllGroups:function(e){J(e,!0)},expandAllGroups:function(e){J(e,!1)},collapseGroup:function(e){var t,n,r=Array.prototype.slice.call(arguments),o=r[0];1===r.length&&-1!==o.indexOf(E)?(t=o,n=o.split(E).length-1):(t=r.join(E),n=r.length-1),Q(n,t,!0),D.notify({level:n,groupingKey:t})},expandGroup:function(e){var t,n,r=Array.prototype.slice.call(arguments),o=r[0];1===r.length&&-1!==o.indexOf(E)?(n=o.split(E).length-1,t=o):(n=r.length-1,t=r.join(E)),Q(n,t,!1),P.notify({level:n,groupingKey:t})},getGroups:function(){return R},getIdxById:function(e){return f[e]},getRowByItem:function(e){return q(),h[e[s]]},getRowById:function(e){return q(),h[e]},getItemById:U,getItemByIdx:function(e){return g[e]},mapItemsToRows:function(e){var t=[];q();for(var n=0,r=e.length;n<r;n++){var o=h[e[n][s]];null!=o&&(t[t.length]=o)}return t},mapRowsToIds:function(e){for(var t=[],n=0,r=e.length;n<r;n++)e[n]<c.length&&(t[t.length]=c[e[n]][s]);return t},mapIdsToRows:function(e){var t=[];q();for(var n=0,r=e.length;n<r;n++){var o=h[e[n]];null!=o&&(t[t.length]=o)}return t},setRefreshHints:function(e){_=e},setFilterArgs:function(e){r=e},refresh:se,updateItem:L,insertItem:k,addItem:function(e){g.push(e),K(g.length-1),se()},deleteItem:H,sortedAddItem:W,sortedUpdateItem:function(e,t){if(void 0===f[e]||e!==t[s])throw new Error("Invalid or non-matching id "+f[e]);if(!n)throw new Error("sortedUpdateItem() requires a sort comparer, use sort()");var r=U(e);0!==n(r,t)?(H(e),W(t)):L(e,t)},syncGridSelection:function(e,t,n){var r,o=this,a=o.mapRowsToIds(e.getSelectedRows()),u=new l.Event;function s(t){a.join(",")!=t.join(",")&&(a=t,u.notify({grid:e,ids:a,dataView:o},new l.EventData,o))}return e.onSelectedRowsChanged.subscribe((function(t,l){if(!r){var u=o.mapRowsToIds(e.getSelectedRows());if(n&&e.getOptions().multiSelect)s(i.grep(a,(function(e){return void 0===o.getRowById(e)})).concat(u));else s(u)}})),this.onRowsOrCountChanged.subscribe((function(){if(a.length>0){r=!0;var n=o.mapIdsToRows(a);t||s(o.mapRowsToIds(n)),e.setSelectedRows(n),r=!1}})),u},syncGridCellCssStyles:function(e,t){var n,r;function o(e){for(var t in n={},e){var r=c[t][s];n[r]=e[t]}}function i(){if(n){r=!0,q();var o={};for(var i in n){var l=h[i];null!=l&&(o[l]=n[i])}e.setCellCssStyles(t,o),r=!1}}o(e.getCellCssStyles(t)),e.onCellCssStylesChanged.subscribe((function(n,l){r||t==l.key&&(l.hash?o(l.hash):(e.onCellCssStylesChanged.unsubscribe(),u.onRowsOrCountChanged.unsubscribe(i)))})),this.onRowsOrCountChanged.subscribe(i)},getLength:function(){return c.length},getItem:function(e){var t=c[e];if(t&&t.__group&&t.totals&&!t.totals.initialized){var n=I[t.level];n.displayTotalsRow||(Y(t.totals),t.title=n.formatter?n.formatter(t):t.value)}else t&&t.__groupTotals&&!t.initialized&&Y(t);return t},getItemMetadata:function(t){var n=c[t];return void 0===n?null:n.__group?e.groupItemMetadataProvider.getGroupRowMetadata(n):n.__groupTotals?e.groupItemMetadataProvider.getTotalsRowMetadata(n):null},onSetItemsCalled:F,onRowCountChanged:A,onRowsChanged:N,onRowsOrCountChanged:G,onBeforePagingInfoChanged:T,onPagingInfoChanged:O,onGroupExpanded:P,onGroupCollapsed:D})},Aggregators:a,Data:{Aggregators:a}}},
504: function _(e,t,i,n,o){var l=e(494),a=e(496);function s(e){var t,i;function n(){var t=e.column.editorFixedDecimalPlaces;return void 0===t&&(t=s.DefaultDecimalPlaces),t||0===t?t:null}this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=l("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?u:c).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(o){i=o[e.column.field];var l=n();null!==l&&(i||0===i)&&i.toFixed&&(i=i.toFixed(l)),t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){var e=parseFloat(t.val());s.AllowEmptyValue?e||0===e||(e=""):e=e||0;var i=n();return null!==i&&(e||0===e)&&e.toFixed&&(e=parseFloat(e.toFixed(i))),e},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid number"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}function u(e){var t=this.selectionStart,i=this.value.length;(e.keyCode===a.keyCode.LEFT&&t>0||e.keyCode===a.keyCode.RIGHT&&t<i-1)&&e.stopImmediatePropagation()}function c(e){e.keyCode!==a.keyCode.LEFT&&e.keyCode!==a.keyCode.RIGHT||e.stopImmediatePropagation()}s.DefaultDecimalPlaces=null,s.AllowEmptyValue=!1,t.exports={Editors:{Text:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=l("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?u:c).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.getValue=function(){return t.val()},this.setValue=function(e){t.val(e)},this.loadValue=function(n){i=n[e.column.field]||"",t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Integer:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=l("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?u:c).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid integer"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Float:s,Date:function(e){var t,i,n=!1;this.init=function(){(t=l("<INPUT type=text class='editor-text' />")).appendTo(e.container),t.focus().select(),t.datepicker({showOn:"button",buttonImageOnly:!0,beforeShow:function(){n=!0},onClose:function(){n=!1}}),t.width(t.width()-18)},this.destroy=function(){l.datepicker.dpDiv.stop(!0,!0),t.datepicker("hide"),t.datepicker("destroy"),t.remove()},this.show=function(){n&&l.datepicker.dpDiv.stop(!0,!0).show()},this.hide=function(){n&&l.datepicker.dpDiv.stop(!0,!0).hide()},this.position=function(e){n&&l.datepicker.dpDiv.css("top",e.top+30).css("left",e.left)},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},YesNoSelect:function(e){var t,i;this.init=function(){(t=l("<SELECT tabIndex='0' class='editor-yesno'><OPTION value='yes'>Yes</OPTION><OPTION value='no'>No</OPTION></SELECT>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){t.val((i=n[e.column.field])?"yes":"no"),t.select()},this.serializeValue=function(){return"yes"==t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return t.val()!=i},this.validate=function(){return{valid:!0,msg:null}},this.init()},Checkbox:function(e){var t,i;this.init=function(){(t=l("<INPUT type=checkbox value='true' class='editor-checkbox' hideFocus>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){(i=!!n[e.column.field])?t.prop("checked",!0):t.prop("checked",!1)},this.preClick=function(){t.prop("checked",!t.prop("checked"))},this.serializeValue=function(){return t.prop("checked")},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return this.serializeValue()!==i},this.validate=function(){return{valid:!0,msg:null}},this.init()},PercentComplete:function(e){var t,i,n;this.init=function(){(t=l("<INPUT type=text class='editor-percentcomplete' />")).width(l(e.container).innerWidth()-25),t.appendTo(e.container),(i=l("<div class='editor-percentcomplete-picker' />").appendTo(e.container)).append("<div class='editor-percentcomplete-helper'><div class='editor-percentcomplete-wrapper'><div class='editor-percentcomplete-slider' /><div class='editor-percentcomplete-buttons' /></div></div>"),i.find(".editor-percentcomplete-buttons").append("<button val=0>Not started</button><br/><button val=50>In Progress</button><br/><button val=100>Complete</button>"),t.focus().select(),i.find(".editor-percentcomplete-slider").slider({orientation:"vertical",range:"min",value:n,slide:function(e,i){t.val(i.value)}}),i.find(".editor-percentcomplete-buttons button").on("click",(function(e){t.val(l(this).attr("val")),i.find(".editor-percentcomplete-slider").slider("value",l(this).attr("val"))}))},this.destroy=function(){t.remove(),i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(n=i[e.column.field]),t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==n)&&(parseInt(t.val(),10)||0)!=n},this.validate=function(){return isNaN(parseInt(t.val(),10))?{valid:!1,msg:"Please enter a valid positive number"}:{valid:!0,msg:null}},this.init()},LongText:function(e){var t,i,n,o=this;this.init=function(){var n=l("body");e.grid.getOptions().editorCellNavOnLRKeys;i=l("<DIV style='z-index:10000;position:absolute;background:white;padding:5px;border:3px solid gray; -moz-border-radius:10px; border-radius:10px;'/>").appendTo(n),t=l("<TEXTAREA hidefocus rows=5 style='background:white;width:250px;height:80px;border:0;outline:0'>").appendTo(i),l("<DIV style='text-align:right'><BUTTON>Save</BUTTON><BUTTON>Cancel</BUTTON></DIV>").appendTo(i),i.find("button:first").on("click",this.save),i.find("button:last").on("click",this.cancel),t.on("keydown",this.handleKeyDown),o.position(e.position),t.focus().select()},this.handleKeyDown=function(t){if(t.which==a.keyCode.ENTER&&t.ctrlKey)o.save();else if(t.which==a.keyCode.ESCAPE)t.preventDefault(),o.cancel();else if(t.which==a.keyCode.TAB&&t.shiftKey)t.preventDefault(),e.grid.navigatePrev();else if(t.which==a.keyCode.TAB)t.preventDefault(),e.grid.navigateNext();else if((t.which==a.keyCode.LEFT||t.which==a.keyCode.RIGHT)&&e.grid.getOptions().editorCellNavOnLRKeys){var i=this.selectionStart,n=this.value.length;t.keyCode===a.keyCode.LEFT&&0===i&&e.grid.navigatePrev(),t.keyCode===a.keyCode.RIGHT&&i>=n-1&&e.grid.navigateNext()}},this.save=function(){e.commitChanges()},this.cancel=function(){t.val(n),e.cancelChanges()},this.hide=function(){i.hide()},this.show=function(){i.show()},this.position=function(e){i.css("top",e.top-5).css("left",e.left-5)},this.destroy=function(){i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(n=i[e.column.field]),t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""===t.val()&&null==n)&&t.val()!=n},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}}}},
505: function _(e,n,r,t,c){e(496);n.exports={Formatters:{PercentComplete:function(e,n,r,t,c){return null==r||""===r?"-":r<50?"<span style='color:red;font-weight:bold;'>"+r+"%</span>":"<span style='color:green'>"+r+"%</span>"},PercentCompleteBar:function(e,n,r,t,c){return null==r||""===r?"":"<span class='percent-complete-bar' style='background:"+(r<30?"red":r<70?"silver":"green")+";width:"+r+"%'></span>"},YesNo:function(e,n,r,t,c){return r?"Yes":"No"},Checkmark:function(e,n,r,t,c){return r?"<img src='../images/tick.png'>":""},Checkbox:function(e,n,r,t,c){return'<img class="slick-edit-preclick" src="../images/'+(r?"CheckboxY":"CheckboxN")+'.png">'}}}},
506: function _(t,o,r,e,n){var a=t(494),l=t(496);o.exports={RemoteModel:function(){var t=50,o={length:0},r="",e=null,n=1,i=null,s=null,u=new l.Event,f=new l.Event;function c(){for(var t in o)delete o[t];o.length=0}function h(l,c){if(s){s.abort();for(var h=s.fromPage;h<=s.toPage;h++)o[h*t]=void 0}l<0&&(l=0),o.length>0&&(c=Math.min(c,o.length-1));for(var v=Math.floor(l/t),m=Math.floor(c/t);void 0!==o[v*t]&&v<m;)v++;for(;void 0!==o[m*t]&&v<m;)m--;if(v>m||v==m&&void 0!==o[v*t])f.notify({from:l,to:c});else{var g="http://octopart.com/api/v3/parts/search?apikey=68b25f31&include[]=short_description&show[]=uid&show[]=manufacturer&show[]=mpn&show[]=brand&show[]=octopart_url&show[]=short_description&q="+r+"&start="+v*t+"&limit="+((m-v)*t+t);null!=e&&(g+="&sortby="+e+(n>0?"+asc":"+desc")),null!=i&&clearTimeout(i),i=setTimeout((function(){for(var r=v;r<=m;r++)o[r*t]=null;u.notify({from:l,to:c}),(s=a.jsonp({url:g,callbackParameter:"callback",cache:!0,success:d,error:function(){!function(t,o){alert("error loading pages "+t+" to "+o)}(v,m)}})).fromPage=v,s.toPage=m}),50)}}function d(t){var r=t.request.start,e=r+t.results.length;o.length=Math.min(parseInt(t.hits),1e3);for(var n=0;n<t.results.length;n++){var a=t.results[n].item;o[r+n]=a,o[r+n].index=r+n}s=null,f.notify({from:r,to:e})}return{data:o,clear:c,isDataLoaded:function(t,r){for(var e=t;e<=r;e++)if(null==o[e]||null==o[e])return!1;return!0},ensureData:h,reloadData:function(t,r){for(var e=t;e<=r;e++)delete o[e];h(t,r)},setSort:function(t,o){e=t,n=o,c()},setSearch:function(t){r=t,c()},onDataLoading:u,onDataLoaded:f}}}},
507: function _(e,s,t,o,l){var a=e(494),r=e(496);s.exports={GroupItemMetadataProvider:function(e){var s,t={checkboxSelect:!1,checkboxSelectCssClass:"slick-group-select-checkbox",checkboxSelectPlugin:null,groupCssClass:"slick-group",groupTitleCssClass:"slick-group-title",totalsCssClass:"slick-group-totals",groupFocusable:!0,totalsFocusable:!1,toggleCssClass:"slick-group-toggle",toggleExpandedCssClass:"expanded",toggleCollapsedCssClass:"collapsed",enableExpandCollapse:!0,groupFormatter:function(e,s,t,l,a,r){if(!o.enableExpandCollapse)return a.title;var c=15*a.level+"px";return(o.checkboxSelect?'<span class="'+o.checkboxSelectCssClass+" "+(a.selectChecked?"checked":"unchecked")+'"></span>':"")+"<span class='"+o.toggleCssClass+" "+(a.collapsed?o.toggleCollapsedCssClass:o.toggleExpandedCssClass)+"' style='margin-left:"+c+"'></span><span class='"+o.groupTitleCssClass+"' level='"+a.level+"'>"+a.title+"</span>"},totalsFormatter:function(e,s,t,o,l,a){return o.groupTotalsFormatter&&o.groupTotalsFormatter(l,o,a)||""},includeHeaderTotals:!1},o=a.extend(!0,{},t,e);function l(e,t){var l=a(e.target),c=this.getDataItem(t.row);if(c&&c instanceof r.Group&&l.hasClass(o.toggleCssClass)){var n=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:n.top,ignoreDiffsAfter:n.bottom+1}),c.collapsed?this.getData().expandGroup(c.groupingKey):this.getData().collapseGroup(c.groupingKey),e.stopImmediatePropagation(),e.preventDefault()}if(c&&c instanceof r.Group&&l.hasClass(o.checkboxSelectCssClass)){c.selectChecked=!c.selectChecked,l.removeClass(c.selectChecked?"unchecked":"checked"),l.addClass(c.selectChecked?"checked":"unchecked");var i=s.getData().mapItemsToRows(c.rows);(c.selectChecked?o.checkboxSelectPlugin.selectRows:o.checkboxSelectPlugin.deSelectRows)(i)}}function c(e,t){if(o.enableExpandCollapse&&e.which==r.keyCode.SPACE){var l=this.getActiveCell();if(l){var a=this.getDataItem(l.row);if(a&&a instanceof r.Group){var c=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:c.top,ignoreDiffsAfter:c.bottom+1}),a.collapsed?this.getData().expandGroup(a.groupingKey):this.getData().collapseGroup(a.groupingKey),e.stopImmediatePropagation(),e.preventDefault()}}}}return{init:function(e){(s=e).onClick.subscribe(l),s.onKeyDown.subscribe(c)},destroy:function(){s&&(s.onClick.unsubscribe(l),s.onKeyDown.unsubscribe(c))},getGroupRowMetadata:function(e){var s=e&&e.level;return{selectable:!1,focusable:o.groupFocusable,cssClasses:o.groupCssClass+" slick-group-level-"+s,formatter:o.includeHeaderTotals&&o.totalsFormatter,columns:{0:{colspan:o.includeHeaderTotals?"1":"*",formatter:o.groupFormatter,editor:null}}}},getTotalsRowMetadata:function(e){var s=e&&e.group&&e.group.level;return{selectable:!1,focusable:o.totalsFocusable,cssClasses:o.totalsCssClass+" slick-group-level-"+s,formatter:o.totalsFormatter,editor:null}},getOptions:function(){return o},setOptions:function(e){a.extend(!0,o,e)}}}}},
508: function _(i,e,t,n,o){var r;n();const s=i(312);class _ extends s.HTMLBoxView{get orientation(){return"horizontal"}get default_size(){return this.model.default_size}_width_policy(){return"horizontal"==this.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.orientation?"fixed":super._height_policy()}box_sizing(){const i=super.box_sizing();return"horizontal"==this.orientation?null==i.width&&(i.width=this.default_size):null==i.height&&(i.height=this.default_size),i}}t.WidgetView=_,_.__name__="WidgetView";class h extends s.HTMLBox{constructor(i){super(i)}}t.Widget=h,r=h,h.__name__="Widget",r.define((({Number:i})=>({default_size:[i,300]}))),r.override({margin:[5,5,5,5]})},
509: function _(e,i,t,s,n){var u;s();const c=e(508),o=e(75),a=e(190);class r extends c.Widget{constructor(e){super(e)}initialize(){super.initialize(),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())}}t.TableWidget=r,u=r,r.__name__="TableWidget",u.define((({Ref:e})=>({source:[e(o.ColumnDataSource),()=>new o.ColumnDataSource],view:[e(a.CDSView),()=>new a.CDSView]})))},
510: function _(t,e,i,r,o){var l;r();const d=t(489),n=t(486),a=t(34),s=t(20),u=t(53);class f extends u.Model{constructor(t){super(t)}toColumn(){var t;return{id:(0,a.uniqueId)(),field:this.field,name:null!==(t=this.title)&&void 0!==t?t:this.field,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}}}i.TableColumn=f,l=f,f.__name__="TableColumn",l.define((({Boolean:t,Number:e,String:i,Nullable:r,Ref:o})=>({field:[i],title:[r(i),null],width:[e,300],formatter:[o(d.StringFormatter),()=>new d.StringFormatter],editor:[o(n.StringEditor),()=>new n.StringEditor],sortable:[t,!0],default_sort:[s.Sort,"ascending"],visible:[t,!0]})))},
511: function _(A,o,e,r,i){r(),e.root="bk-root",e.default='.bk-root{}.bk-root .slick-header.ui-state-default,.bk-root .slick-headerrow.ui-state-default,.bk-root .slick-footerrow.ui-state-default,.bk-root .slick-top-panel-scroller.ui-state-default,.bk-root .slick-group-header.ui-state-default{width:100%;overflow:auto;position:relative;border-left:0px !important;}.bk-root .slick-header.ui-state-default{overflow:inherit;}.bk-root .slick-header::-webkit-scrollbar,.bk-root .slick-headerrow::-webkit-scrollbar,.bk-root .slick-footerrow::-webkit-scrollbar{display:none;}.bk-root .slick-header-columns,.bk-root .slick-headerrow-columns,.bk-root .slick-footerrow-columns,.bk-root .slick-group-header-columns{position:relative;white-space:nowrap;cursor:default;overflow:hidden;}.bk-root .slick-header-column.ui-state-default,.bk-root .slick-group-header-column.ui-state-default{position:relative;display:inline-block;box-sizing:content-box !important;overflow:hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;height:16px;line-height:16px;margin:0;padding:4px;border-right:1px solid silver;border-left:0px !important;border-top:0px !important;border-bottom:0px !important;float:left;}.bk-root .slick-footerrow-column.ui-state-default{-o-text-overflow:ellipsis;text-overflow:ellipsis;margin:0;padding:4px;border-right:1px solid silver;border-left:0px;border-top:0px;border-bottom:0px;float:left;line-height:20px;vertical-align:middle;}.bk-root .slick-headerrow-column.ui-state-default,.bk-root .slick-footerrow-column.ui-state-default{padding:4px;}.bk-root .slick-header-column-sorted{font-style:italic;}.bk-root .slick-sort-indicator{display:inline-block;width:8px;height:5px;margin-left:4px;margin-top:6px;float:left;}.bk-root .slick-sort-indicator-numbered{display:inline-block;width:8px;height:5px;margin-left:4px;margin-top:0;line-height:20px;float:left;font-family:Arial;font-style:normal;font-weight:bold;color:#6190CD;}.bk-root .slick-sort-indicator-desc{background:url(images/sort-desc.gif);}.bk-root .slick-sort-indicator-asc{background:url(images/sort-asc.gif);}.bk-root .slick-resizable-handle{position:absolute;font-size:0.1px;display:block;cursor:col-resize;width:9px;right:-5px;top:0;height:100%;z-index:1;}.bk-root .slick-sortable-placeholder{background:silver;}.bk-root .grid-canvas{position:relative;outline:0;}.bk-root .slick-row.ui-widget-content,.bk-root .slick-row.ui-state-active{position:absolute;border:0px;width:100%;}.bk-root .slick-cell,.bk-root .slick-headerrow-column,.bk-root .slick-footerrow-column{position:absolute;border:1px solid transparent;border-right:1px dotted silver;border-bottom-color:silver;overflow:hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;vertical-align:middle;z-index:1;padding:1px 2px 2px 1px;margin:0;white-space:nowrap;cursor:default;}.bk-root .slick-cell,.bk-root .slick-headerrow-column{border-bottom-color:silver;}.bk-root .slick-footerrow-column{border-top-color:silver;}.bk-root .slick-group-toggle{display:inline-block;}.bk-root .slick-cell.highlighted{background:lightskyblue;background:rgba(0, 0, 255, 0.2);-webkit-transition:all 0.5s;-moz-transition:all 0.5s;-o-transition:all 0.5s;transition:all 0.5s;}.bk-root .slick-cell.flashing{border:1px solid red !important;}.bk-root .slick-cell.editable{z-index:11;overflow:visible;background:white;border-color:black;border-style:solid;}.bk-root .slick-cell:focus{outline:none;}.bk-root .slick-reorder-proxy{display:inline-block;background:blue;opacity:0.15;cursor:move;}.bk-root .slick-reorder-guide{display:inline-block;height:2px;background:blue;opacity:0.7;}.bk-root .slick-selection{z-index:10;position:absolute;border:2px dashed black;}.bk-root .slick-pane{position:absolute;outline:0;overflow:hidden;width:100%;}.bk-root .slick-pane-header{display:block;}.bk-root .slick-header{overflow:hidden;position:relative;}.bk-root .slick-headerrow{overflow:hidden;position:relative;}.bk-root .slick-top-panel-scroller{overflow:hidden;position:relative;}.bk-root .slick-top-panel{width:10000px;}.bk-root .slick-viewport{position:relative;outline:0;width:100%;}.bk-root .slick-header-columns{background:url(\'images/header-columns-bg.gif\') repeat-x center bottom;border-bottom:1px solid silver;}.bk-root .slick-header-column{background:url(\'images/header-columns-bg.gif\') repeat-x center bottom;border-right:1px solid silver;}.bk-root .slick-header-column:hover,.bk-root .slick-header-column-active{background:white url(\'images/header-columns-over-bg.gif\') repeat-x center bottom;}.bk-root .slick-headerrow{background:#fafafa;}.bk-root .slick-headerrow-column{background:#fafafa;border-bottom:0;height:100%;}.bk-root .slick-row.ui-state-active{background:#F5F7D7;}.bk-root .slick-row{position:absolute;background:white;border:0px;line-height:20px;}.bk-root .slick-row.selected{z-index:10;background:#DFE8F6;}.bk-root .slick-cell{padding-left:4px;padding-right:4px;}.bk-root .slick-group{border-bottom:2px solid silver;}.bk-root .slick-group-toggle{width:9px;height:9px;margin-right:5px;}.bk-root .slick-group-toggle.expanded{background:url(images/collapse.gif) no-repeat center center;}.bk-root .slick-group-toggle.collapsed{background:url(images/expand.gif) no-repeat center center;}.bk-root .slick-group-totals{color:gray;background:white;}.bk-root .slick-group-select-checkbox{width:13px;height:13px;margin:3px 10px 0 0;display:inline-block;}.bk-root .slick-group-select-checkbox.checked{background:url(images/GrpCheckboxY.png) no-repeat center center;}.bk-root .slick-group-select-checkbox.unchecked{background:url(images/GrpCheckboxN.png) no-repeat center center;}.bk-root .slick-cell.selected{background-color:beige;}.bk-root .slick-cell.active{border-color:gray;border-style:solid;}.bk-root .slick-sortable-placeholder{background:silver !important;}.bk-root .slick-row.odd{background:#fafafa;}.bk-root .slick-row.ui-state-active{background:#F5F7D7;}.bk-root .slick-row.loading{opacity:0.5;}.bk-root .slick-cell.invalid{border-color:red;-moz-animation-duration:0.2s;-webkit-animation-duration:0.2s;-moz-animation-name:slickgrid-invalid-hilite;-webkit-animation-name:slickgrid-invalid-hilite;}@-moz-keyframes slickgrid-invalid-hilite{from{box-shadow:0 0 6px red;}to{box-shadow:none;}}@-webkit-keyframes slickgrid-invalid-hilite{from{box-shadow:0 0 6px red;}to{box-shadow:none;}}.bk-root .slick-column-name,.bk-root .slick-sort-indicator{display:inline-block;float:left;margin-bottom:100px;}.bk-root .slick-header-button{display:inline-block;float:right;vertical-align:top;margin:1px;margin-bottom:100px;height:15px;width:15px;background-repeat:no-repeat;background-position:center center;cursor:pointer;}.bk-root .slick-header-button-hidden{width:0;-webkit-transition:0.2s width;-ms-transition:0.2s width;transition:0.2s width;}.bk-root .slick-header-column:hover > .slick-header-button{width:15px;}.bk-root .slick-header-menubutton{position:absolute;right:0;top:0;bottom:0;width:14px;background-repeat:no-repeat;background-position:left center;background-image:url(../images/down.gif);cursor:pointer;display:none;border-left:thin ridge silver;}.bk-root .slick-header-column:hover > .slick-header-menubutton,.bk-root .slick-header-column-active .slick-header-menubutton{display:inline-block;}.bk-root .slick-header-menu{position:absolute;display:inline-block;margin:0;padding:2px;cursor:default;}.bk-root .slick-header-menuitem{list-style:none;margin:0;padding:0;cursor:pointer;}.bk-root .slick-header-menuicon{display:inline-block;width:16px;height:16px;vertical-align:middle;margin-right:4px;background-repeat:no-repeat;background-position:center center;}.bk-root .slick-header-menucontent{display:inline-block;vertical-align:middle;}.bk-root .slick-header-menuitem-disabled{color:silver;}.bk-root .slick-header-menuitem.slick-header-menuitem-divider{cursor:default;border:none;overflow:hidden;padding:0;height:1px;margin:8px 2px;background-color:#cecece;}.bk-root .slick-header-menuitem-divider.slick-header-menuitem:hover{background-color:#cecece;}.bk-root .slick-columnpicker{border:1px solid #718BB7;background:#f0f0f0;padding:6px;-moz-box-shadow:2px 2px 2px silver;-webkit-box-shadow:2px 2px 2px silver;box-shadow:2px 2px 2px silver;min-width:150px;cursor:default;position:absolute;z-index:20;overflow:auto;resize:both;}.bk-root .slick-columnpicker > .close{float:right;}.bk-root .slick-columnpicker .title{font-size:16px;width:60%;border-bottom:solid 1px #d6d6d6;margin-bottom:10px;}.bk-root .slick-columnpicker li{list-style:none;margin:0;padding:0;background:none;}.bk-root .slick-columnpicker input{margin:4px;}.bk-root .slick-columnpicker li a{display:block;padding:4px;font-weight:bold;}.bk-root .slick-columnpicker li a:hover{background:white;}.bk-root .slick-columnpicker-list li.hidden{display:none;}.bk-root .slick-pager{width:100%;height:26px;border:1px solid gray;border-top:0;background:url(\'../images/header-columns-bg.gif\') repeat-x center bottom;vertical-align:middle;}.bk-root .slick-pager .slick-pager-status{display:inline-block;padding:6px;}.bk-root .slick-pager .ui-icon-container{display:inline-block;margin:2px;border-color:gray;}.bk-root .slick-pager .slick-pager-nav{display:inline-block;float:left;padding:2px;}.bk-root .slick-pager .slick-pager-settings{display:block;float:right;padding:2px;}.bk-root .slick-pager .slick-pager-settings *{vertical-align:middle;}.bk-root .slick-pager .slick-pager-settings a{padding:2px;text-decoration:underline;cursor:pointer;}.bk-root .slick-header-columns{border-bottom:1px solid silver;background-image:none;}.bk-root .slick-header-column{border-right:1px solid transparent;background-image:none;}.bk-root .slick-header-column:last-of-type{border-right-color:transparent;}.bk-root .slick-header-column:hover,.bk-root .slick-header-column-active{background-color:#F0F8FF;background-image:none;}.bk-root .slick-group-toggle.expanded{background-image:url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIMwADCBxIUIDBgwIEChgwwECBAgQUFjBAkaJCABgxGlB4AGHCAAIQiBypEEECkScJqgwQEAA7");}.bk-root .slick-group-toggle.collapsed{background-image:url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIOAADCBxIUIDBgwIEChgwAECBAgQUFjAAQIABAwoBaNSIMYCAAwIqGlSIAEHFkiQTIBCgkqDLAAEBADs=");}.bk-root .slick-group-select-checkbox.checked{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAAEcSURBVChTjdI9S8NQFAbg/raQXVwCRRFE7GK7OXTwD+ikk066VF3a0ja0hQTyQdJrwNq0zrYSQRLEXMSWSlCIb8glqRcFD+9yz3nugXwU4n9XQqMoGjj36uBJsTwuaNo3EwBG4Yy7pe7Gv8YcvhJCGFVsjxsjxujj6OTSGlHv+U2WZUZbPWKOv1ZjT5a7pbIoiptbO5b73mwrjHa1B27l8VlTEIS1damlTnEE+EEN9/P8WrfH81qdAIGeXvTTmzltdCy46sEhxpKUINReZR9NnqZbr9puugxV3NjWh/k74WmmEdWhmUNy2jNmWRc6fZTVADCqao52u+DGWTACYNT3fRxwtatPufTNR4yCIGAUn5hS+vJHhWGY/ANx/A3tvdv+1tZmuwAAAABJRU5ErkJggg==");}.bk-root .slick-group-select-checkbox.unchecked{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAACXSURBVChT1dIxC4MwEAXg/v8/VOhQVDBNakV0KA6pxS4JhWRSIYPEJxwdDi1de7wleR+3JIf486w0hKCKRpSvvOhZcCmvNQBRuKqdah03U7UjNNH81rOaBYDo8SQaPX8JANFEaLaGBeAPaaY61rGksiN6TmR5H1j9CSoAosYYHLA7vTxYMvVEZa0liif23r93xjm3/oEYF8PiDn/I2FHCAAAAAElFTkSuQmCC");}.bk-root .slick-sort-indicator-desc{background-image:url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgeAAUAGEgQgIAACBEKLHgwYcKFBh1KFNhQosOKEgMCADs=");}.bk-root .slick-sort-indicator-asc{background-image:url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgbAAMIDABgoEGDABIeRJhQ4cKGEA8KmEiRosGAADs=");}.bk-root .slick-header-menubutton{background-image:url("data:image/gif;base64,R0lGODlhDgAOAIABADtKYwAAACH5BAEAAAEALAAAAAAOAA4AAAISjI+py+0PHZgUsGobhTn6DxoFADs=");}.bk-root .slick-pager{background-image:none;}'},
512: function _(t,e,s,r,a){var i;r();const n=t(499),{Avg:u,Min:g,Max:o,Sum:c}=n.Data.Aggregators,l=t(53);class _ extends l.Model{constructor(t){super(t)}}s.RowAggregator=_,i=_,_.__name__="RowAggregator",i.define((({String:t})=>({field_:[t,""]})));const m=new u;class h extends _{constructor(){super(...arguments),this.key="avg",this.init=m.init,this.accumulate=m.accumulate,this.storeResult=m.storeResult}}s.AvgAggregator=h,h.__name__="AvgAggregator";const A=new g;class R extends _{constructor(){super(...arguments),this.key="min",this.init=A.init,this.accumulate=A.accumulate,this.storeResult=A.storeResult}}s.MinAggregator=R,R.__name__="MinAggregator";const x=new o;class d extends _{constructor(){super(...arguments),this.key="max",this.init=x.init,this.accumulate=x.accumulate,this.storeResult=x.storeResult}}s.MaxAggregator=d,d.__name__="MaxAggregator";const M=new c;class w extends _{constructor(){super(...arguments),this.key="sum",this.init=M.init,this.accumulate=M.accumulate,this.storeResult=M.storeResult}}s.SumAggregator=w,w.__name__="SumAggregator"},
513: function _(e,t,s,o,r){var a,i;o();const l=e(43),n=e(499),u=e(487),g=e(492),c=e(75),p=e(512),h=e(53);function d(e,t,s,o,r){const{collapsed:a,level:i,title:n}=r,u=(0,l.span)({class:"slick-group-toggle "+(a?"collapsed":"expanded"),style:{"margin-left":15*i+"px"}}),g=(0,l.span)({class:"slick-group-title",level:i},n);return`${u.outerHTML}${g.outerHTML}`}function f(e,t){const s=this.getDataItem(t.row);s instanceof n.Group&&e.target.classList.contains("slick-group-toggle")&&(s.collapsed?this.getData().expandGroup(s.groupingKey):this.getData().collapseGroup(s.groupingKey),e.stopImmediatePropagation(),e.preventDefault(),this.invalidate(),this.render())}class m extends h.Model{constructor(e){super(e)}get comparer(){return(e,t)=>e.value===t.value?0:e.value>t.value?1:-1}}s.GroupingInfo=m,a=m,m.__name__="GroupingInfo",a.define((({Boolean:e,String:t,Array:s,Ref:o})=>({getter:[t,""],aggregators:[s(o(p.RowAggregator)),[]],collapsed:[e,!1]})));class w extends g.TableDataProvider{constructor(e,t,s,o){super(e,t),this.columns=s,this.groupingInfos=[],this.groupingDelimiter=":|:",this.target=o}setGrouping(e){this.groupingInfos=e,this.toggledGroupsByLevel=e.map((()=>({}))),this.refresh()}extractGroups(e,t){const s=[],o=new Map,r=t?t.level+1:0,{comparer:a,getter:i}=this.groupingInfos[r];return e.forEach((e=>{const a=this.source.data[i][e];let l=o.get(a);if(!l){const e=t?`${t.groupingKey}${this.groupingDelimiter}${a}`:`${a}`;l=Object.assign(new n.Group,{value:a,level:r,groupingKey:e}),s.push(l),o.set(a,l)}l.rows.push(e)})),r<this.groupingInfos.length-1&&s.forEach((e=>{e.groups=this.extractGroups(e.rows,e)})),s.sort(a),s}calculateTotals(e,t){const s={avg:{},max:{},min:{},sum:{}},{source:{data:o}}=this,r=Object.keys(o),a=e.rows.map((e=>r.reduce(((t,s)=>Object.assign(Object.assign({},t),{[s]:o[s][e]})),{})));return t.forEach((e=>{e.init(),a.forEach((t=>e.accumulate(t))),e.storeResult(s)})),s}addTotals(e,t=0){const{aggregators:s,collapsed:o}=this.groupingInfos[t],r=this.toggledGroupsByLevel[t];e.forEach((e=>{e.groups&&this.addTotals(e.groups,t+1),s.length&&e.rows.length&&(e.totals=this.calculateTotals(e,s)),e.collapsed=o!==r[e.groupingKey],e.title=e.value?`${e.value}`:""}))}flattenedGroupedRows(e,t=0){const s=[];return e.forEach((e=>{if(s.push(e),!e.collapsed){const o=e.groups?this.flattenedGroupedRows(e.groups,t+1):e.rows;s.push(...o)}})),s}refresh(){const e=this.extractGroups([...this.view.indices]),t=this.source.data[this.columns[0].field];e.length&&(this.addTotals(e),this.rows=this.flattenedGroupedRows(e),this.target.data={row_indices:this.rows.map((e=>e instanceof n.Group?e.rows:e)),labels:this.rows.map((e=>e instanceof n.Group?e.title:t[e]))})}getLength(){return this.rows.length}getItem(e){const t=this.rows[e],{source:{data:s}}=this;return t instanceof n.Group?t:Object.keys(s).reduce(((e,o)=>Object.assign(Object.assign({},e),{[o]:s[o][t]})),{[u.DTINDEX_NAME]:t})}getItemMetadata(e){const t=this.rows[e],s=this.columns.slice(1),o=t instanceof n.Group?this.groupingInfos[t.level].aggregators:[];return t instanceof n.Group?{selectable:!1,focusable:!1,cssClasses:"slick-group",columns:[{formatter:d},...s.map((function(e){const{field:t,formatter:s}=e,r=o.find((({field_:e})=>e===t));if(r){const{key:e}=r;return{formatter:(o,r,a,i,l)=>s?s(o,r,l.totals[e][t],i,l):""}}return{}}))]}:{}}collapseGroup(e){const t=e.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[t][e]=!this.groupingInfos[t].collapsed,this.refresh()}expandGroup(e){const t=e.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[t][e]=this.groupingInfos[t].collapsed,this.refresh()}}s.DataCubeProvider=w,w.__name__="DataCubeProvider";class v extends g.DataTableView{render(){const e={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:!1,autosizeColsMode:this.autosize,multiColumnSort:!1,editable:this.model.editable,autoEdit:this.model.auto_edit,rowHeight:this.model.row_height},t=this.model.columns.map((e=>e.toColumn()));var s,o;t[0].formatter=(s=t[0].formatter,o=this.model.grouping.length,(e,t,r,a,i)=>{const n=(0,l.span)({class:"slick-group-toggle",style:{"margin-left":15*(null!=o?o:0)+"px"}}),u=s?s(e,t,r,a,i):`${r}`;return`${n.outerHTML}${u&&u.replace(/^<div/,"<span").replace(/div>$/,"span>")}`}),delete t[0].editor,this.data=new w(this.model.source,this.model.view,t,this.model.target),this.data.setGrouping(this.model.grouping),this.el.style.width=`${this.model.width}px`,this.grid=new n.Grid(this.el,this.data,t,e),this.grid.onClick.subscribe(f)}}s.DataCubeView=v,v.__name__="DataCubeView";class b extends g.DataTable{constructor(e){super(e)}}s.DataCube=b,i=b,b.__name__="DataCube",i.prototype.default_view=v,i.define((({Array:e,Ref:t})=>({grouping:[e(t(m)),[]],target:[t(c.ColumnDataSource)]})))},
}, 484, {"models/widgets/tables/main":484,"models/widgets/tables/index":485,"models/widgets/tables/cell_editors":486,"models/widgets/tables/definitions":487,"styles/widgets/tables.css":488,"models/widgets/tables/cell_formatters":489,"models/widgets/tables/data_table":492,"models/widgets/widget":508,"models/widgets/tables/table_widget":509,"models/widgets/tables/table_column":510,"styles/widgets/slickgrid.css":511,"models/widgets/tables/row_aggregators":512,"models/widgets/tables/data_cube":513}, {});});
