import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxPageConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable name of the page, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#display_name DialogflowCxPage#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The language of the following fields in page:.
     *
     * Page.entry_fulfillment.messages
     * Page.entry_fulfillment.conditional_cases
     * Page.event_handlers.trigger_fulfillment.messages
     * Page.event_handlers.trigger_fulfillment.conditional_cases
     * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
     * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
     * Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
     * Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
     * Page.transition_routes.trigger_fulfillment.messages
     * Page.transition_routes.trigger_fulfillment.conditional_cases
     * If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#language_code DialogflowCxPage#language_code}
     *
     * @stability stable
     */
    readonly languageCode?: string;
    /**
     * The flow to create a page for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#parent DialogflowCxPage#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * Ordered list of TransitionRouteGroups associated with the page.
     *
     * Transition route groups must be unique within a page.
     * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
     * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
     * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#transition_route_groups DialogflowCxPage#transition_route_groups}
     *
     * @stability stable
     */
    readonly transitionRouteGroups?: string[];
    /**
     * entry_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#entry_fulfillment DialogflowCxPage#entry_fulfillment}
     *
     * @stability stable
     */
    readonly entryFulfillment?: DialogflowCxPageEntryFulfillment;
    /**
     * event_handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#event_handlers DialogflowCxPage#event_handlers}
     *
     * @stability stable
     */
    readonly eventHandlers?: DialogflowCxPageEventHandlers[];
    /**
     * form block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#form DialogflowCxPage#form}
     *
     * @stability stable
     */
    readonly form?: DialogflowCxPageForm;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#timeouts DialogflowCxPage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxPageTimeouts;
    /**
     * transition_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#transition_routes DialogflowCxPage#transition_routes}
     *
     * @stability stable
     */
    readonly transitionRoutes?: DialogflowCxPageTransitionRoutes[];
}
/**
 * @stability stable
 */
export interface DialogflowCxPageEntryFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxPageEntryFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageEntryFulfillmentMessagesTextOutputReference | DialogflowCxPageEntryFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageEntryFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageEntryFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageEntryFulfillmentMessagesText | undefined);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageEntryFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxPageEntryFulfillmentMessagesText;
}
export declare function dialogflowCxPageEntryFulfillmentMessagesToTerraform(struct?: DialogflowCxPageEntryFulfillmentMessages): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageEntryFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxPageEntryFulfillmentMessages[];
}
export declare function dialogflowCxPageEntryFulfillmentToTerraform(struct?: DialogflowCxPageEntryFulfillmentOutputReference | DialogflowCxPageEntryFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageEntryFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageEntryFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageEntryFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxPageEntryFulfillmentMessages[];
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxPageEntryFulfillmentMessages[]);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxPageEntryFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference | DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentMessages): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageEventHandlersTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[];
}
export declare function dialogflowCxPageEventHandlersTriggerFulfillmentToTerraform(struct?: DialogflowCxPageEventHandlersTriggerFulfillmentOutputReference | DialogflowCxPageEventHandlersTriggerFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageEventHandlersTriggerFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxPageEventHandlersTriggerFulfillmentMessages[];
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[]);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageEventHandlers {
    /**
     * The name of the event to handle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#event DialogflowCxPage#event}
     *
     * @stability stable
     */
    readonly event?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_flow DialogflowCxPage#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_page DialogflowCxPage#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxPageEventHandlersTriggerFulfillment;
}
export declare function dialogflowCxPageEventHandlersToTerraform(struct?: DialogflowCxPageEventHandlers): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference | DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText;
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[];
}
export declare function dialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference | DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[];
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[]);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageFormParametersFillBehavior {
    /**
     * initial_prompt_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#initial_prompt_fulfillment DialogflowCxPage#initial_prompt_fulfillment}
     *
     * @stability stable
     */
    readonly initialPromptFulfillment?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment;
}
export declare function dialogflowCxPageFormParametersFillBehaviorToTerraform(struct?: DialogflowCxPageFormParametersFillBehaviorOutputReference | DialogflowCxPageFormParametersFillBehavior): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageFormParametersFillBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageFormParametersFillBehavior | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageFormParametersFillBehavior | undefined);
    private _initialPromptFulfillment;
    /**
     * @stability stable
     */
    get initialPromptFulfillment(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference;
    /**
     * @stability stable
     */
    putInitialPromptFulfillment(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): void;
    /**
     * @stability stable
     */
    resetInitialPromptFulfillment(): void;
    /**
     * @stability stable
     */
    get initialPromptFulfillmentInput(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageFormParameters {
    /**
     * The human-readable name of the parameter, unique within the form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#display_name DialogflowCxPage#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The entity type of the parameter.
     *
     * Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#entity_type DialogflowCxPage#entity_type}
     *
     * @stability stable
     */
    readonly entityType?: string;
    /**
     * Indicates whether the parameter represents a list of values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#is_list DialogflowCxPage#is_list}
     *
     * @stability stable
     */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the parameter content should be redacted in log.
     *
     * If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#redact DialogflowCxPage#redact}
     *
     * @stability stable
     */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the parameter is required.
     *
     * Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
     * Required parameters must be filled before form filling concludes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#required DialogflowCxPage#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * fill_behavior block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#fill_behavior DialogflowCxPage#fill_behavior}
     *
     * @stability stable
     */
    readonly fillBehavior?: DialogflowCxPageFormParametersFillBehavior;
}
export declare function dialogflowCxPageFormParametersToTerraform(struct?: DialogflowCxPageFormParameters): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageForm {
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#parameters DialogflowCxPage#parameters}
     *
     * @stability stable
     */
    readonly parameters?: DialogflowCxPageFormParameters[];
}
export declare function dialogflowCxPageFormToTerraform(struct?: DialogflowCxPageFormOutputReference | DialogflowCxPageForm): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageFormOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageForm | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageForm | undefined);
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): DialogflowCxPageFormParameters[];
    /**
     * @stability stable
     */
    set parameters(value: DialogflowCxPageFormParameters[]);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): DialogflowCxPageFormParameters[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#create DialogflowCxPage#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#delete DialogflowCxPage#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#update DialogflowCxPage#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dialogflowCxPageTimeoutsToTerraform(struct?: DialogflowCxPageTimeoutsOutputReference | DialogflowCxPageTimeouts): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages): any;
/**
 * @stability stable
 */
export interface DialogflowCxPageTransitionRoutesTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[];
}
export declare function dialogflowCxPageTransitionRoutesTriggerFulfillmentToTerraform(struct?: DialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference | DialogflowCxPageTransitionRoutesTriggerFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxPageTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[];
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[]);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxPageTransitionRoutes {
    /**
     * The condition to evaluate against form parameters or session parameters.
     *
     * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#condition DialogflowCxPage#condition}
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * The unique identifier of an Intent.
     *
     * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#intent DialogflowCxPage#intent}
     *
     * @stability stable
     */
    readonly intent?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_flow DialogflowCxPage#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_page DialogflowCxPage#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxPageTransitionRoutesTriggerFulfillment;
}
export declare function dialogflowCxPageTransitionRoutesToTerraform(struct?: DialogflowCxPageTransitionRoutes): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html google_dialogflow_cx_page}.
 *
 * @stability stable
 */
export declare class DialogflowCxPage extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html google_dialogflow_cx_page} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxPageConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _languageCode?;
    /**
     * @stability stable
     */
    get languageCode(): string;
    /**
     * @stability stable
     */
    set languageCode(value: string);
    /**
     * @stability stable
     */
    resetLanguageCode(): void;
    /**
     * @stability stable
     */
    get languageCodeInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    /**
     * @stability stable
     */
    get transitionRouteGroups(): string[];
    /**
     * @stability stable
     */
    set transitionRouteGroups(value: string[]);
    /**
     * @stability stable
     */
    resetTransitionRouteGroups(): void;
    /**
     * @stability stable
     */
    get transitionRouteGroupsInput(): string[] | undefined;
    private _entryFulfillment;
    /**
     * @stability stable
     */
    get entryFulfillment(): DialogflowCxPageEntryFulfillmentOutputReference;
    /**
     * @stability stable
     */
    putEntryFulfillment(value: DialogflowCxPageEntryFulfillment): void;
    /**
     * @stability stable
     */
    resetEntryFulfillment(): void;
    /**
     * @stability stable
     */
    get entryFulfillmentInput(): DialogflowCxPageEntryFulfillment | undefined;
    private _eventHandlers?;
    /**
     * @stability stable
     */
    get eventHandlers(): DialogflowCxPageEventHandlers[];
    /**
     * @stability stable
     */
    set eventHandlers(value: DialogflowCxPageEventHandlers[]);
    /**
     * @stability stable
     */
    resetEventHandlers(): void;
    /**
     * @stability stable
     */
    get eventHandlersInput(): DialogflowCxPageEventHandlers[] | undefined;
    private _form;
    /**
     * @stability stable
     */
    get form(): DialogflowCxPageFormOutputReference;
    /**
     * @stability stable
     */
    putForm(value: DialogflowCxPageForm): void;
    /**
     * @stability stable
     */
    resetForm(): void;
    /**
     * @stability stable
     */
    get formInput(): DialogflowCxPageForm | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxPageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxPageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxPageTimeouts | undefined;
    private _transitionRoutes?;
    /**
     * @stability stable
     */
    get transitionRoutes(): DialogflowCxPageTransitionRoutes[];
    /**
     * @stability stable
     */
    set transitionRoutes(value: DialogflowCxPageTransitionRoutes[]);
    /**
     * @stability stable
     */
    resetTransitionRoutes(): void;
    /**
     * @stability stable
     */
    get transitionRoutesInput(): DialogflowCxPageTransitionRoutes[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
