/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Relational;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Feature
extends IdentifiableAnnotation
implements Relational,
Serializable {
    private String lemma;
    private List<Span<Term>> references;
    private List<ExternalRef> externalReferences;

    Feature(String id, String lemma, List<Span<Term>> references) {
        super(id);
        if (references.size() < 1) {
            throw new IllegalStateException("Features must contain at least one reference span");
        }
        if (references.get(0).size() < 1) {
            throw new IllegalStateException("Features' reference's spans must contain at least one target");
        }
        this.id = id;
        this.lemma = lemma;
        this.references = references;
        this.externalReferences = new ArrayList<ExternalRef>();
    }

    Feature(Feature feature, HashMap<String, Term> terms) {
        super(feature.id);
        this.id = feature.id;
        this.lemma = feature.lemma;
        String id = feature.getId();
        this.references = new ArrayList<Span<Term>>();
        for (Span<Term> span : feature.getSpans()) {
            List<Term> targets = span.getTargets();
            ArrayList<Term> copiedTargets = new ArrayList<Term>();
            for (Term term : targets) {
                Term copiedTerm = terms.get(term.getId());
                if (copiedTerm == null) {
                    throw new IllegalStateException("Term not found when copying " + id);
                }
                copiedTargets.add(copiedTerm);
            }
            if (span.hasHead()) {
                Term copiedHead = terms.get(span.getHead().getId());
                this.references.add(new Span<Term>(copiedTargets, copiedHead));
                continue;
            }
            this.references.add(new Span(copiedTargets));
        }
        this.externalReferences = new ArrayList<ExternalRef>();
        for (ExternalRef externalRef : feature.getExternalRefs()) {
            this.externalReferences.add(new ExternalRef(externalRef));
        }
    }

    public boolean isAProperty() {
        return this.id.matches("p.*");
    }

    public boolean isACategory() {
        return this.id.matches("c.*");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    void setId(String id) {
        this.id = id;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public List<Term> getTerms() {
        return this.references.get(0).getTargets();
    }

    public void addTerm(Term term) {
        this.references.get(0).addTarget(term);
    }

    public void addTerm(Term term, boolean isHead) {
        this.references.get(0).addTarget(term, isHead);
    }

    public List<Span<Term>> getSpans() {
        return this.references;
    }

    public void addSpan(Span<Term> span) {
        this.references.add(span);
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    public String getSpanStr(Span<Term> span) {
        String str = "";
        for (Term term : span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + term.getStr();
        }
        return str;
    }

    @Override
    public String getStr() {
        return this.getSpanStr(this.getSpans().get(0));
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Span<Term> span : this.getSpans()) {
            terms.addAll(span.getTargets());
        }
        referenced.put(KAFDocument.AnnotationType.TERM, terms);
        return referenced;
    }

    public List<List<Term>> getReferences() {
        ArrayList<List<Term>> list = new ArrayList<List<Term>>();
        for (Span<Term> span : this.references) {
            list.add(span.getTargets());
        }
        return list;
    }

    public void addReference(List<Term> span) {
        this.references.add(KAFDocument.list2Span(span));
    }
}

