/*
 * Decompiled with CFR 0.152.
 */
package ixa.pipe.dep.eu;

import ixa.kaflib.KAFDocument;
import ixa.kaflib.Term;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Annotate {
    private final String baliabideDir;
    private final File bohnetTmpFitx;
    private final File brownBohnetTmpFitx;
    private final File simBohnetTmpFitx;
    private final File simMaltTmpFitx;
    private final File brownMaltTmpFitx;
    private final File bohnetParsedTmpFitx;
    private final File brownBohnetParsedTmpFitx;
    private final File simBohnetParsedTmpFitx;
    private final File brownMaltParsedTmpFitx;
    private final File simMaltParsedTmpFitx;
    private final File blenderBohnetTmpFitx;
    private final File blenderBrownBohnetTmpFitx;
    private final File blenderSimBohnetTmpFitx;
    private final File blenderEmaitzaTmpFitx;
    private final Hashtable<String, String> brown = new Hashtable();
    private final Hashtable<String, String> sim = new Hashtable();

    public Annotate(String baliabideak) throws IOException {
        this.baliabideDir = baliabideak;
        this.bohnetTmpFitx = File.createTempFile("Bohnet.conll", ".tmp", new File(this.baliabideDir + "/Bohnet"));
        this.bohnetTmpFitx.deleteOnExit();
        this.brownBohnetTmpFitx = File.createTempFile("Brown_Bohnet.conll", ".tmp", new File(this.baliabideDir + "/BrownBohnet"));
        this.brownBohnetTmpFitx.deleteOnExit();
        this.simBohnetTmpFitx = File.createTempFile("Sim_Bohnet.conll", ".tmp", new File(this.baliabideDir + "/SimBohnet"));
        this.simBohnetTmpFitx.deleteOnExit();
        this.simMaltTmpFitx = File.createTempFile("Sim_Malt.conll", ".tmp", new File(this.baliabideDir + "/SimMalt"));
        this.simMaltTmpFitx.deleteOnExit();
        this.brownMaltTmpFitx = File.createTempFile("Brown_Malt.conll", ".tmp", new File(this.baliabideDir + "/BrownMalt"));
        this.brownMaltTmpFitx.deleteOnExit();
        this.bohnetParsedTmpFitx = File.createTempFile("Bohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/Bohnet"));
        this.bohnetParsedTmpFitx.deleteOnExit();
        this.brownBohnetParsedTmpFitx = File.createTempFile("Brown_Bohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/BrownBohnet"));
        this.brownBohnetParsedTmpFitx.deleteOnExit();
        this.simBohnetParsedTmpFitx = File.createTempFile("Sim_Bohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/SimBohnet"));
        this.simBohnetParsedTmpFitx.deleteOnExit();
        this.brownMaltParsedTmpFitx = File.createTempFile("BrownMalt.conll.parsed", ".tmp", new File(this.baliabideDir + "/BrownMalt"));
        this.brownMaltParsedTmpFitx.deleteOnExit();
        this.simMaltParsedTmpFitx = File.createTempFile("SimMalt.conll.parsed", ".tmp", new File(this.baliabideDir + "/SimMalt"));
        this.simMaltParsedTmpFitx.deleteOnExit();
        this.blenderBohnetTmpFitx = File.createTempFile("Bohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/Blender"));
        this.blenderBohnetTmpFitx.deleteOnExit();
        this.blenderBrownBohnetTmpFitx = File.createTempFile("BrownBohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/Blender"));
        this.blenderBrownBohnetTmpFitx.deleteOnExit();
        this.blenderSimBohnetTmpFitx = File.createTempFile("SimBohnet.conll.parsed", ".tmp", new File(this.baliabideDir + "/Blender"));
        this.blenderSimBohnetTmpFitx.deleteOnExit();
        this.blenderEmaitzaTmpFitx = File.createTempFile("Azken_emaitza.conll", ".tmp", new File(this.baliabideDir + "/Blender"));
        this.blenderEmaitzaTmpFitx.deleteOnExit();
    }

    void lortuDependentziakMate(KAFDocument kaf, String conllHelbidea) throws IOException, FileNotFoundException {
        this.kargatuBrown();
        this.kargatuSim();
        this.KAF2MateAll(kaf);
        this.exekutatuBohnet();
        this.exekutatuBrownBohnet();
        this.exekutatuSimBohnet();
        this.exekutatuBrownMalt();
        this.exekutatuSimMalt();
        this.exekutatuBlender();
        BufferedReader br = new BufferedReader(new FileReader(this.blenderEmaitzaTmpFitx));
        String lerroa = br.readLine();
        List<Term> terminoak = kaf.getTerms();
        int zenbatgarrena = 0;
        String Conll07 = "";
        Vector<String> inprimatzekoa = new Vector<String>();
        while (lerroa != null) {
            if (lerroa.contains("\t")) {
                String[] zatiak = lerroa.split("\t");
                int unekoarenZenb = Integer.parseInt(zatiak[0]);
                String hitza = zatiak[1];
                String lema = zatiak[2];
                String kategoria = zatiak[3];
                String azpikategoria = zatiak[4];
                String feats = zatiak[5];
                int head = Integer.parseInt(zatiak[6]);
                String deprel = zatiak[7];
                String idaztekoaBerri = unekoarenZenb + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + head + "\t" + deprel + "\t_\t_\n";
                inprimatzekoa.add(idaztekoaBerri);
                int diferentzia = 0;
                int hurrengoa = 0;
                if (head != 0) {
                    Term unekoa = terminoak.get(zenbatgarrena);
                    if (head > unekoarenZenb) {
                        diferentzia = head - unekoarenZenb;
                        hurrengoa = zenbatgarrena + diferentzia;
                    } else {
                        diferentzia = unekoarenZenb - head;
                        hurrengoa = zenbatgarrena - diferentzia;
                    }
                    Term nora = terminoak.get(hurrengoa);
                    kaf.newDep(nora, unekoa, deprel);
                }
                ++zenbatgarrena;
            } else {
                inprimatzekoa.add("\n");
            }
            lerroa = br.readLine();
        }
        br.close();
        if (!conllHelbidea.contentEquals("Hutsa")) {
            this.inprimatu(conllHelbidea, inprimatzekoa);
        }
    }

    public void KAF2MateAll(KAFDocument kaf) throws IOException {
        this.sortuBohnet(kaf);
        this.sortuBrownBohnet(kaf);
        this.sortuSimBohnet(kaf);
        this.sortuBrownMalt(kaf);
        this.sortuSimMalt(kaf);
    }

    private String lortuKategoria(String[] zatiak) {
        String emaitza = "_";
        if (!(zatiak[0].contains("@") || zatiak[0].contains("BIZ") || zatiak[0].contains("EZEZAG"))) {
            emaitza = zatiak[0];
        } else if (zatiak[0].contains("EZEZAG") && zatiak[1].contains("IZE")) {
            emaitza = "IZE";
        }
        return emaitza;
    }

    private String lortuAzpikategoria(String[] zatiak, String kategoria) {
        String emaitza = "_";
        if (zatiak[0].contains("IZE") || kategoria.contains("IZE")) {
            if (zatiak[1].contains("ARR") || zatiak[1].contains("LIB") || zatiak[1].contains("IZB") || zatiak[1].contains("ZKI")) {
                emaitza = "IZE_" + zatiak[1];
            }
        } else if (zatiak[0].contains("ADL") || zatiak[0].contains("ADT") || zatiak[0].contains("PRT") || zatiak[0].contains("ADJ") || zatiak[0].contains("BST")) {
            emaitza = zatiak[0];
        } else if (zatiak[0].contains("ADB")) {
            emaitza = "ADB_ADB";
        } else if (zatiak[0].contains("DET")) {
            if (zatiak[1].contains("BAN") || zatiak[1].contains("DZG") || zatiak[1].contains("DZH") || zatiak[1].contains("ERKARR") || zatiak[1].contains("ERKIND") || zatiak[1].contains("NOLARR") || zatiak[1].contains("NOLGAL") || zatiak[1].contains("ORD") || zatiak[1].contains("ORO")) {
                emaitza = "DET_" + zatiak[1];
            }
        } else if (zatiak[0].contains("IOR")) {
            if (zatiak[1].contains("ELK") || zatiak[1].contains("IZGGAL") || zatiak[1].contains("IZGMGB") || zatiak[1].contains("PERARR") || zatiak[1].contains("PERIND")) {
                emaitza = "IOR_" + zatiak[1];
            }
        } else if (zatiak[0].contains("LOT")) {
            if (zatiak[1].contains("JNT") || zatiak[1].contains("LOK")) {
                emaitza = "LOT_" + zatiak[1];
            }
        } else if (zatiak[0].contains("ADI") && (zatiak[1].contains("SIN") || zatiak[1].contains("ADK") || zatiak[1].contains("ADP") || zatiak[1].contains("FAK"))) {
            emaitza = "ADI_" + zatiak[1];
        }
        if (kategoria.contains("IZEELI")) {
            emaitza = kategoria;
        }
        return emaitza;
    }

    private String lortuFeats(String[] zatiak) {
        String emaitza;
        String num;
        String ni;
        String nk;
        String nr;
        String dadudio;
        String mdn;
        String asp;
        String adm;
        String erl;
        Vector<String> denak = new Vector<String>();
        String kasua = this.lortuKasua(zatiak);
        if (!kasua.contentEquals("")) {
            denak.add(kasua);
        }
        if (!(erl = this.lortuErl(zatiak)).contentEquals("")) {
            denak.add(erl);
        }
        if (!(adm = this.lortuAdm(zatiak)).contentEquals("")) {
            denak.add(adm);
        }
        if (!(asp = this.lortuAsp(zatiak)).contentEquals("")) {
            denak.add(asp);
        }
        if (!(mdn = this.lortuMdn(zatiak)).contentEquals("")) {
            denak.add(mdn);
        }
        if (!(dadudio = this.lortuDadudio(zatiak)).contentEquals("")) {
            denak.add(dadudio);
        }
        if (!(nr = this.lortuNr(zatiak)).contentEquals("")) {
            denak.add(nr);
        }
        if (!(nk = this.lortuNk(zatiak)).contentEquals("")) {
            denak.add(nk);
        }
        if (!(ni = this.lortuNi(zatiak)).contentEquals("")) {
            denak.add(ni);
        }
        if (!(num = this.lortuNum(zatiak)).contentEquals("")) {
            denak.add(num);
        }
        if ((emaitza = Annotate.join(denak, "|")).contentEquals("")) {
            emaitza = "_";
        }
        return emaitza;
    }

    private String lortuHiruFeatsBrown(String[] zatiak, String hitza) {
        Vector<String> denak = new Vector<String>();
        String brown = this.lortuBrown(hitza);
        String kasua = this.lortuKasua(zatiak);
        if (kasua.contentEquals("")) {
            kasua = "null";
        }
        denak.add(kasua);
        String num = this.lortuNum(zatiak);
        if (num.contentEquals("")) {
            num = "null";
        }
        denak.add(num);
        String erl = this.lortuErl(zatiak);
        if (erl.contentEquals("")) {
            erl = "null";
        }
        denak.add(erl);
        denak.add(brown);
        String emaitza = Annotate.join(denak, "|");
        return emaitza;
    }

    private String lortuAzpikategoriKonkretua(String ezaugarriak, String hitza) {
        String emaitza = "";
        if (ezaugarriak.contains("BEREIZ")) {
            emaitza = "PUNT_BEREIZ";
        } else if (hitza.contains(":")) {
            emaitza = "PUNT_BI_PUNT";
        } else if (hitza.contains("...")) {
            emaitza = "PUNT_HIRU";
        } else if (hitza.contains(";")) {
            emaitza = "PUNT_PUNT_KOMA";
        } else if (hitza.contains("?")) {
            emaitza = "PUNT_GALD";
        } else if (hitza.contains("!")) {
            emaitza = "PUNT_ESKL";
        } else if (hitza.contains(",")) {
            emaitza = "PUNT_KOMA";
        } else if (hitza.contains(".")) {
            emaitza = "PUNT_PUNT";
        }
        return emaitza;
    }

    private String lortuKasua(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("ABL") && !zatiak[i].contentEquals("ABS") && !zatiak[i].contentEquals("ABU") && !zatiak[i].contentEquals("ALA") && !zatiak[i].contentEquals("BNK") && !zatiak[i].contentEquals("DAT") && !zatiak[i].contentEquals("DES") && !zatiak[i].contentEquals("DESK") && !zatiak[i].contentEquals("ERG") && !zatiak[i].contentEquals("GEL") && !zatiak[i].contentEquals("GEN") && !zatiak[i].contentEquals("INE") && !zatiak[i].contentEquals("INS") && !zatiak[i].contentEquals("MOT") && !zatiak[i].contentEquals("PAR") && !zatiak[i].contentEquals("PRO") && !zatiak[i].contentEquals("SOZ") && !zatiak[i].contentEquals("ZERO")) continue;
            emaitza = "KAS=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuErl(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("AURK") && !zatiak[i].contentEquals("BALD") && !zatiak[i].contentEquals("DENB") && !zatiak[i].contentEquals("ERLT") && !zatiak[i].contentEquals("ESPL") && !zatiak[i].contentEquals("HAUT") && !zatiak[i].contentEquals("HELB") && !zatiak[i].contentEquals("KAUS") && !zatiak[i].contentEquals("KONPL") && !zatiak[i].contentEquals("KONT") && !zatiak[i].contentEquals("MOD") && !zatiak[i].contentEquals("MOS") && !zatiak[i].contentEquals("ONDO") && !zatiak[i].contentEquals("ZHG") && !zatiak[i].contentEquals("MOD\\/DENB")) continue;
            if (zatiak[i].contentEquals("MOD\\/DENB")) {
                zatiak[i] = "MODDENB";
            }
            emaitza = "ERL=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuAdm(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("ADIZE") && !zatiak[i].contentEquals("PART")) continue;
            emaitza = "ADM=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuAsp(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("BURU") && !zatiak[i].contentEquals("EZBU") && !zatiak[i].contentEquals("GERO") && !zatiak[i].contentEquals("PNT")) continue;
            emaitza = "ASP=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuMdn(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("A1") && !zatiak[i].contentEquals("A2") && !zatiak[i].contentEquals("A3") && !zatiak[i].contentEquals("A4") && !zatiak[i].contentEquals("B1") && !zatiak[i].contentEquals("B2") && !zatiak[i].contentEquals("B3") && !zatiak[i].contentEquals("B4") && !zatiak[i].contentEquals("B5") && !zatiak[i].contentEquals("B6") && !zatiak[i].contentEquals("B7") && !zatiak[i].contentEquals("B8") && !zatiak[i].contentEquals("C") && !zatiak[i].contentEquals("B5A") && !zatiak[i].contentEquals("B5B")) continue;
            emaitza = "MDN=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuDadudio(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contentEquals("NOR") && !zatiak[i].contentEquals("NOR_NORK") && !zatiak[i].contentEquals("NOR_NORI") && !zatiak[i].contentEquals("NOR_NORI_NORK")) continue;
            emaitza = "DADUDIO=" + zatiak[i];
        }
        return emaitza;
    }

    private String lortuNr(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contains("NR_")) continue;
            String[] zat = zatiak[i].split("_");
            emaitza = "NOR=" + zat[1];
        }
        return emaitza;
    }

    private String lortuNk(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contains("NK_")) continue;
            String[] zat = zatiak[i].split("_");
            emaitza = "NORK=" + zat[1];
        }
        return emaitza;
    }

    private String lortuNi(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (!zatiak[i].contains("NI_")) continue;
            String[] zat = zatiak[i].split("_");
            emaitza = "NORI=" + zat[1];
        }
        return emaitza;
    }

    private String lortuNum(String[] zatiak) {
        String emaitza = "";
        for (int i = 0; i < zatiak.length; ++i) {
            if (zatiak[i].contentEquals("NUMP")) {
                emaitza = "NUM=P";
                continue;
            }
            if (!zatiak[i].contentEquals("NUMS")) continue;
            emaitza = "NUM=S";
        }
        return emaitza;
    }

    public static String join(Vector<String> parts, String delim) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.elementAt(i);
            result.append(part);
            if (delim == null || i >= parts.size() - 1) continue;
            result.append(delim);
        }
        return result.toString();
    }

    private void inprimatu(String helbidea, Vector<String> inprimatzekoa) throws IOException {
        String ruta = helbidea;
        File archivo = new File(ruta);
        BufferedWriter bw = new BufferedWriter(new FileWriter(archivo));
        for (int i = 0; i < inprimatzekoa.size(); ++i) {
            bw.write(inprimatzekoa.elementAt(i));
        }
        bw.close();
    }

    private String lortuBrown(String hitza) {
        String bueltatzekoa = "";
        if (this.brown.containsKey(hitza)) {
            bueltatzekoa = this.brown.get(hitza);
        } else if (this.brown.containsKey(hitza.toLowerCase())) {
            bueltatzekoa = this.brown.get(hitza.toLowerCase());
        } else if (this.brown.containsKey(hitza.toUpperCase())) {
            bueltatzekoa = this.brown.get(hitza.toUpperCase());
        }
        return bueltatzekoa;
    }

    private void kargatuBrown() throws FileNotFoundException, IOException {
        String ruta = this.baliabideDir + "/Brown.txt";
        BufferedReader br = new BufferedReader(new FileReader(new File(ruta)));
        String linea = "";
        while ((linea = br.readLine()) != null) {
            String[] zatiak = linea.split("\t");
            String osoa = zatiak[0];
            String hitza = zatiak[1];
            String laukoa = "";
            String osobi = "";
            if (osoa.length() > 4) {
                laukoa = osoa.substring(0, 4);
                osobi = "CLUSTER=" + osoa + "|CLUSTERM=" + laukoa;
            } else {
                laukoa = osoa;
                osobi = "CLUSTER=" + osoa + "|CLUSTERM=" + laukoa;
            }
            this.brown.put(hitza, osobi);
            linea = br.readLine();
        }
        br.close();
    }

    private void kargatuSim() throws FileNotFoundException, IOException {
        String ruta = this.baliabideDir + "/Sim.txt";
        BufferedReader br = new BufferedReader(new FileReader(new File(ruta)));
        String linea = "";
        while ((linea = br.readLine()) != null) {
            String[] zatiak = linea.split(" ");
            String hitza = zatiak[0];
            String clus = "CLUSTERS=" + zatiak[1];
            this.sim.put(hitza, clus);
            linea = br.readLine();
        }
        br.close();
    }

    private void sortuBohnet(KAFDocument kaf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.bohnetTmpFitx));
        List<Term> terminoak = kaf.getTerms();
        String hitza = "";
        String lema = "";
        String ezaugarriak = "";
        String kategoria = "";
        String azpikategoria = "";
        String feats = "";
        String emaitza = "";
        int aurrekoarenSent = -1;
        int unekoarenSent = 0;
        int unekoarenZenbakia = 0;
        for (Term terminoa : terminoak) {
            unekoarenSent = terminoa.getSent();
            if (unekoarenSent != aurrekoarenSent) {
                unekoarenZenbakia = 1;
                aurrekoarenSent = unekoarenSent;
            } else {
                ++unekoarenZenbakia;
            }
            hitza = terminoa.getForm();
            lema = terminoa.getLemma();
            ezaugarriak = terminoa.getCase();
            if (ezaugarriak.contains(" ")) {
                String[] zatiak = ezaugarriak.split(" ");
                kategoria = this.lortuKategoria(zatiak);
                azpikategoria = this.lortuAzpikategoria(zatiak, kategoria);
                feats = this.lortuFeats(zatiak);
            } else {
                kategoria = "PUNT";
                azpikategoria = this.lortuAzpikategoriKonkretua(ezaugarriak, hitza);
                feats = "_";
            }
            emaitza = unekoarenZenbakia == 1 && unekoarenSent != 1 ? "\n" + unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n" : unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n";
            bw.write(emaitza);
        }
        bw.close();
    }

    private void sortuBrownBohnet(KAFDocument kaf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.brownBohnetTmpFitx));
        List<Term> terminoak = kaf.getTerms();
        String hitza = "";
        String lema = "";
        String ezaugarriak = "";
        String kategoria = "";
        String azpikategoria = "";
        String feats = "";
        String tartekofeats = "";
        String emaitza = "";
        String brown = "";
        String atzizkia = "Null";
        int aurrekoarenSent = -1;
        int unekoarenSent = 0;
        int unekoarenZenbakia = 0;
        for (Term terminoa : terminoak) {
            unekoarenSent = terminoa.getSent();
            if (unekoarenSent != aurrekoarenSent) {
                unekoarenZenbakia = 1;
                aurrekoarenSent = unekoarenSent;
            } else {
                ++unekoarenZenbakia;
            }
            hitza = terminoa.getForm();
            lema = terminoa.getLemma();
            ezaugarriak = terminoa.getCase();
            if (ezaugarriak.contains(" ")) {
                String[] zatiak = ezaugarriak.split(" ");
                kategoria = this.lortuKategoria(zatiak);
                azpikategoria = this.lortuAzpikategoria(zatiak, kategoria);
                tartekofeats = this.lortuFeats(zatiak);
                brown = this.lortuBrown(hitza);
                atzizkia = this.lortuAtzizkia(hitza, lema);
                feats = brown.equalsIgnoreCase("") ? tartekofeats : (!tartekofeats.contains("_") ? tartekofeats + "|" + brown + "|" + atzizkia : brown + "|" + atzizkia);
            } else {
                kategoria = "PUNT";
                azpikategoria = this.lortuAzpikategoriKonkretua(ezaugarriak, hitza);
                feats = "_";
            }
            emaitza = unekoarenZenbakia == 1 && unekoarenSent != 1 ? "\n" + unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n" : unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n";
            bw.write(emaitza);
        }
        bw.close();
    }

    private void sortuSimBohnet(KAFDocument kaf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.simBohnetTmpFitx));
        List<Term> terminoak = kaf.getTerms();
        String hitza = "";
        String lema = "";
        String ezaugarriak = "";
        String kategoria = "";
        String azpikategoria = "";
        String tartekofeats = "";
        String atzizkia = "";
        String feats = "";
        String sim = "";
        String emaitza = "";
        int aurrekoarenSent = -1;
        int unekoarenSent = 0;
        int unekoarenZenbakia = 0;
        for (Term terminoa : terminoak) {
            unekoarenSent = terminoa.getSent();
            if (unekoarenSent != aurrekoarenSent) {
                unekoarenZenbakia = 1;
                aurrekoarenSent = unekoarenSent;
            } else {
                ++unekoarenZenbakia;
            }
            hitza = terminoa.getForm();
            lema = terminoa.getLemma();
            ezaugarriak = terminoa.getCase();
            if (ezaugarriak.contains(" ")) {
                String[] zatiak = ezaugarriak.split(" ");
                kategoria = this.lortuKategoria(zatiak);
                azpikategoria = this.lortuAzpikategoria(zatiak, kategoria);
                tartekofeats = this.lortuFeats(zatiak);
                atzizkia = this.lortuAtzizkia(hitza, lema);
                sim = this.lortuSim(hitza);
                feats = sim.equalsIgnoreCase("") ? tartekofeats : (!tartekofeats.contains("_") ? tartekofeats + "|" + sim + "|" + atzizkia : sim + "|" + atzizkia);
            } else {
                kategoria = "PUNT";
                azpikategoria = this.lortuAzpikategoriKonkretua(ezaugarriak, hitza);
                feats = "_";
            }
            emaitza = unekoarenZenbakia == 1 && unekoarenSent != 1 ? "\n" + unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n" : unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + feats + "\t_\t_\t_\t_\t_\t_\t_\t_\t_\t_\n";
            bw.write(emaitza);
        }
        bw.close();
    }

    private void sortuBrownMalt(KAFDocument kaf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.brownMaltTmpFitx));
        List<Term> terminoak = kaf.getTerms();
        String hitza = "";
        String lema = "";
        String ezaugarriak = "";
        String kategoria = "";
        String azpikategoria = "";
        String tartekofeats = "";
        String atzizkia = "";
        String feats = "";
        String brown = "";
        String emaitza = "";
        int aurrekoarenSent = -1;
        int unekoarenSent = 0;
        int unekoarenZenbakia = 0;
        for (Term terminoa : terminoak) {
            unekoarenSent = terminoa.getSent();
            if (unekoarenSent != aurrekoarenSent) {
                unekoarenZenbakia = 1;
                aurrekoarenSent = unekoarenSent;
            } else {
                ++unekoarenZenbakia;
            }
            hitza = terminoa.getForm();
            lema = terminoa.getLemma();
            ezaugarriak = terminoa.getCase();
            if (ezaugarriak.contains(" ")) {
                String[] zatiak = ezaugarriak.split(" ");
                kategoria = this.lortuKategoria(zatiak);
                azpikategoria = this.lortuAzpikategoria(zatiak, kategoria);
                tartekofeats = this.lortuFeats(zatiak);
                brown = this.lortuBrown(hitza);
                atzizkia = this.lortuAtzizkia(hitza, lema);
                feats = brown.equalsIgnoreCase("") ? tartekofeats : (!tartekofeats.contains("_") ? tartekofeats + "|" + brown + "|" + atzizkia : brown + "|" + atzizkia);
            } else {
                kategoria = "PUNT";
                azpikategoria = this.lortuAzpikategoriKonkretua(ezaugarriak, hitza);
                feats = "_";
            }
            emaitza = unekoarenZenbakia == 1 && unekoarenSent != 1 ? "\n" + unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t_\t_\t_\t_\n" : unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t_\t_\t_\t_\n";
            bw.write(emaitza);
        }
        bw.close();
    }

    private void sortuSimMalt(KAFDocument kaf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.simMaltTmpFitx));
        List<Term> terminoak = kaf.getTerms();
        String hitza = "";
        String lema = "";
        String ezaugarriak = "";
        String kategoria = "";
        String azpikategoria = "";
        String tartekofeats = "";
        String atzizkia = "";
        String sim = "";
        String feats = "";
        String emaitza = "";
        int aurrekoarenSent = -1;
        int unekoarenSent = 0;
        int unekoarenZenbakia = 0;
        for (Term terminoa : terminoak) {
            unekoarenSent = terminoa.getSent();
            if (unekoarenSent != aurrekoarenSent) {
                unekoarenZenbakia = 1;
                aurrekoarenSent = unekoarenSent;
            } else {
                ++unekoarenZenbakia;
            }
            hitza = terminoa.getForm();
            lema = terminoa.getLemma();
            ezaugarriak = terminoa.getCase();
            if (ezaugarriak.contains(" ")) {
                String[] zatiak = ezaugarriak.split(" ");
                kategoria = this.lortuKategoria(zatiak);
                azpikategoria = this.lortuAzpikategoria(zatiak, kategoria);
                tartekofeats = this.lortuFeats(zatiak);
                atzizkia = this.lortuAtzizkia(hitza, lema);
                sim = this.lortuSim(hitza);
                feats = sim.equalsIgnoreCase("") ? tartekofeats : (!tartekofeats.contains("_") ? tartekofeats + "|" + sim + "|" + atzizkia : sim + "|" + atzizkia);
            } else {
                kategoria = "PUNT";
                azpikategoria = this.lortuAzpikategoriKonkretua(ezaugarriak, hitza);
                feats = "_";
            }
            emaitza = unekoarenZenbakia == 1 && unekoarenSent != 1 ? "\n" + unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t_\t_\t_\t_\n" : unekoarenZenbakia + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t_\t_\t_\t_\n";
            bw.write(emaitza);
        }
        bw.close();
    }

    private String lortuAtzizkia(String hitza, String lema) {
        String emaitza = "ATZIZKIA=Null";
        if (!(lema.contains("*") || lema.contains("?") || lema.contains(".") || lema.contains(")") || lema.contains("(") || lema.contains("[") || lema.contains("]") || lema.contains("+"))) {
            Pattern p = Pattern.compile(lema);
            Matcher m = p.matcher(hitza);
            int luzerahitza = hitza.length();
            int luzeralema = lema.length();
            int tartea = luzerahitza - luzeralema;
            if (m.find() && tartea != 0) {
                emaitza = "ATZIZKIA=" + hitza.substring(luzeralema);
            }
        }
        return emaitza;
    }

    private String lortuSim(String hitza) {
        String bueltatzekoa = "";
        if (this.sim.containsKey(hitza)) {
            bueltatzekoa = this.sim.get(hitza);
        } else if (this.sim.containsKey(hitza.toLowerCase())) {
            bueltatzekoa = this.sim.get(hitza.toLowerCase());
        } else if (this.sim.containsKey(hitza.toUpperCase())) {
            bueltatzekoa = this.sim.get(hitza.toUpperCase());
        }
        return bueltatzekoa;
    }

    private void exekutatuBrownBohnet() throws FileNotFoundException, IOException {
        String modeloa = this.baliabideDir + "/BrownBohnet/prs.model";
        String anna = this.baliabideDir + "/mate-tools/anna-3.3.jar";
        String tartekoaTmpFitxIzena = this.brownBohnetTmpFitx.getAbsolutePath();
        String parsedTmpFitxIzena = this.brownBohnetParsedTmpFitx.getAbsolutePath();
        String helbideOsoa = "java -Xmx1G -classpath " + anna + " is2.parser.Parser -model " + modeloa + " -test " + tartekoaTmpFitxIzena + " -out " + parsedTmpFitxIzena;
        try {
            Process process = Runtime.getRuntime().exec(helbideOsoa);
            String errorStr = "";
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((errorStr = errorStream.readLine()) != null) {
                System.err.println("[ERROREA anna-BrownBohnet]: " + errorStr);
            }
            errorStream.close();
            process.waitFor();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
        BufferedReader br = new BufferedReader(new FileReader(this.brownBohnetParsedTmpFitx));
        String lerroa = br.readLine();
        Vector<String> inprimatzekoa = new Vector<String>();
        while (lerroa != null) {
            if (lerroa.contains("\t")) {
                String[] zatiak = lerroa.split("\t");
                int unekoarenZenb = Integer.parseInt(zatiak[0]);
                String hitza = zatiak[1];
                String lema = zatiak[2];
                String kategoria = zatiak[4];
                String azpikategoria = zatiak[5];
                String feats = zatiak[6];
                int head = Integer.parseInt(zatiak[9]);
                String deprel = zatiak[11];
                String idaztekoaBerri = unekoarenZenb + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + head + "\t" + deprel + "\t_\t_\n";
                inprimatzekoa.add(idaztekoaBerri);
            } else {
                inprimatzekoa.add("\n");
            }
            lerroa = br.readLine();
        }
        br.close();
        String blenderBrownBohnetTmpFitxIzena = this.blenderBrownBohnetTmpFitx.getAbsolutePath();
        this.inprimatuBrownBohnet(blenderBrownBohnetTmpFitxIzena, inprimatzekoa);
    }

    private void exekutatuBohnet() throws FileNotFoundException, IOException {
        String modeloa = this.baliabideDir + "/Bohnet/prs.model";
        String anna = this.baliabideDir + "/mate-tools/anna-3.3.jar";
        String tartekoaTmpFitxIzena = this.bohnetTmpFitx.getAbsolutePath();
        String parsedTmpFitxIzena = this.bohnetParsedTmpFitx.getAbsolutePath();
        String helbideOsoa = "java -Xmx1G -classpath " + anna + " is2.parser.Parser -model " + modeloa + " -test " + tartekoaTmpFitxIzena + " -out " + parsedTmpFitxIzena;
        try {
            Process process = Runtime.getRuntime().exec(helbideOsoa);
            String errorStr = "";
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((errorStr = errorStream.readLine()) != null) {
                System.err.println("[ERROREA anna-Bohnet]: " + errorStr);
            }
            errorStream.close();
            process.waitFor();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
        BufferedReader br = new BufferedReader(new FileReader(this.bohnetParsedTmpFitx));
        String lerroa = br.readLine();
        Vector<String> inprimatzekoa = new Vector<String>();
        while (lerroa != null) {
            if (lerroa.contains("\t")) {
                String[] zatiak = lerroa.split("\t");
                int unekoarenZenb = Integer.parseInt(zatiak[0]);
                String hitza = zatiak[1];
                String lema = zatiak[2];
                String kategoria = zatiak[4];
                String azpikategoria = zatiak[5];
                String feats = zatiak[6];
                int head = Integer.parseInt(zatiak[9]);
                String deprel = zatiak[11];
                String idaztekoaBerri = unekoarenZenb + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + head + "\t" + deprel + "\t_\t_\n";
                inprimatzekoa.add(idaztekoaBerri);
            } else {
                inprimatzekoa.add("\n");
            }
            lerroa = br.readLine();
        }
        br.close();
        String blenderBohnetTmpFitxIzena = this.blenderBohnetTmpFitx.getAbsolutePath();
        this.inprimatuBohnet(blenderBohnetTmpFitxIzena, inprimatzekoa);
    }

    private void exekutatuSimBohnet() throws FileNotFoundException, IOException {
        String modeloa = this.baliabideDir + "/SimBohnet/prs.model";
        String anna = this.baliabideDir + "/mate-tools/anna-3.3.jar";
        String tartekoaTmpFitxIzena = this.simBohnetTmpFitx.getAbsolutePath();
        String parsedTmpFitxIzena = this.simBohnetParsedTmpFitx.getAbsolutePath();
        String helbideOsoa = "java -Xmx1G -classpath " + anna + " is2.parser.Parser -model " + modeloa + " -test " + tartekoaTmpFitxIzena + " -out " + parsedTmpFitxIzena;
        try {
            Process process = Runtime.getRuntime().exec(helbideOsoa);
            String errorStr = "";
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((errorStr = errorStream.readLine()) != null) {
                System.err.println("[ERROREA anna-SimBohnet]: " + errorStr);
            }
            errorStream.close();
            process.waitFor();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
        BufferedReader br = new BufferedReader(new FileReader(this.simBohnetParsedTmpFitx));
        String lerroa = br.readLine();
        Vector<String> inprimatzekoa = new Vector<String>();
        while (lerroa != null) {
            if (lerroa.contains("\t")) {
                String[] zatiak = lerroa.split("\t");
                int unekoarenZenb = Integer.parseInt(zatiak[0]);
                String hitza = zatiak[1];
                String lema = zatiak[2];
                String kategoria = zatiak[4];
                String azpikategoria = zatiak[5];
                String feats = zatiak[6];
                int head = Integer.parseInt(zatiak[9]);
                String deprel = zatiak[11];
                String idaztekoaBerri = unekoarenZenb + "\t" + hitza + "\t" + lema + "\t" + kategoria + "\t" + azpikategoria + "\t" + feats + "\t" + head + "\t" + deprel + "\t_\t_\n";
                inprimatzekoa.add(idaztekoaBerri);
            } else {
                inprimatzekoa.add("\n");
            }
            lerroa = br.readLine();
        }
        br.close();
        String blenderSimBohnetTmpFitxIzena = this.blenderSimBohnetTmpFitx.getAbsolutePath();
        this.inprimatuSimBohnet(blenderSimBohnetTmpFitxIzena, inprimatzekoa);
    }

    private void exekutatuBrownMalt() {
        String anna = this.baliabideDir + "/maltparser/maltparser-1.7.jar";
        String tartekoaTmpFitxIzena = this.brownMaltTmpFitx.getAbsolutePath();
        String parsedTmpFitxIzena = this.brownMaltParsedTmpFitx.getAbsolutePath();
        String helbideOsoa = "java -jar -Xmx1g " + anna + " -w " + this.baliabideDir + "/BrownMalt/ -c langModel -i " + tartekoaTmpFitxIzena + " -o " + parsedTmpFitxIzena + " -m parse ";
        String blender = this.baliabideDir + "/Blender/";
        try {
            Process process = Runtime.getRuntime().exec(helbideOsoa);
            process.waitFor();
            Process process2 = Runtime.getRuntime().exec("mv " + parsedTmpFitxIzena + " " + blender);
            process2.waitFor();
            process2.destroy();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
    }

    private void exekutatuSimMalt() {
        String anna = this.baliabideDir + "/maltparser/maltparser-1.7.jar";
        String tartekoaTmpFitxIzena = this.simMaltTmpFitx.getAbsolutePath();
        String parsedTmpFitxIzena = this.simMaltParsedTmpFitx.getAbsolutePath();
        String helbideOsoa = "java -jar -Xmx1g " + anna + " -w " + this.baliabideDir + "/SimMalt/ -c langModel -i " + tartekoaTmpFitxIzena + " -o " + parsedTmpFitxIzena + " -m parse ";
        String blender = this.baliabideDir + "/Blender/";
        try {
            Process process = Runtime.getRuntime().exec(helbideOsoa);
            process.waitFor();
            Process process2 = Runtime.getRuntime().exec("mv " + parsedTmpFitxIzena + " " + blender);
            process2.waitFor();
            process2.destroy();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
    }

    private void exekutatuBlender() {
        String jar = this.baliabideDir + "/maltblender/MaltBlender_0.0.1.jar";
        String ebaluatzailea = this.baliabideDir + "/Blender/eval07.pl";
        String emaitza = this.blenderEmaitzaTmpFitx.getAbsolutePath();
        String gold = this.baliabideDir + "/Blender/dev.Basque.pred.conll";
        String bohnetEstimazioa = this.baliabideDir + "/Blender/dev.Basque.pred.parsed.bohnet.conll.oinarria";
        String bohnetTesta = this.blenderBohnetTmpFitx.getAbsolutePath();
        String brownBohnetEstimazioa = this.baliabideDir + "/Blender/dev.Basque.pred.parsed.bohnet.brown.conll";
        String brownBohnetTesta = this.blenderBrownBohnetTmpFitx.getAbsolutePath();
        String simBohnetEstimazioa = this.baliabideDir + "/Blender/dev.Basque.pred.parsed.bohnet.sim.conll";
        String simBohnetTesta = this.blenderSimBohnetTmpFitx.getAbsolutePath();
        String brownMaltEstimazioa = this.baliabideDir + "/Blender/dev.Basque.pred.parsed.brown.malt";
        File brownMaltTestFitx = new File(this.baliabideDir + "/Blender/" + this.brownMaltParsedTmpFitx.getName());
        String brownMaltTesta = brownMaltTestFitx.getAbsolutePath();
        brownMaltTestFitx.deleteOnExit();
        String simMaltEstimazioa = this.baliabideDir + "/Blender/dev.Basque.pred.parsed.sim.malt";
        File simMaltTestFitx = new File(this.baliabideDir + "/Blender/" + this.simMaltParsedTmpFitx.getName());
        String simMaltTesta = simMaltTestFitx.getAbsolutePath();
        simMaltTestFitx.deleteOnExit();
        String agindua = "java -DPERL=/usr/bin/perl -DEVALUATOR=" + ebaluatzailea + " -jar " + jar + " -o " + emaitza + " -h " + gold + " -w 3 -l 3 -H " + brownBohnetEstimazioa + " " + bohnetEstimazioa + " " + simBohnetEstimazioa + " " + brownMaltEstimazioa + " " + simMaltEstimazioa + " -F " + brownBohnetTesta + " " + bohnetTesta + " " + simBohnetTesta + " " + brownMaltTesta + " " + simMaltTesta;
        try {
            Process process = Runtime.getRuntime().exec(agindua);
            String errorStr = "";
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((errorStr = errorStream.readLine()) != null) {
                System.err.println("[ERROREA MaltBlender-Blender]: " + errorStr);
            }
            errorStream.close();
            process.waitFor();
        }
        catch (Exception errorea) {
            System.out.println("Salbuespena: " + errorea.toString());
        }
    }

    private void inprimatuBohnet(String conllHelbidea, Vector<String> inprimatzekoa) throws IOException {
        String ruta = conllHelbidea;
        File archivo = new File(ruta);
        BufferedWriter bohnet = new BufferedWriter(new FileWriter(archivo));
        for (int i = 0; i < inprimatzekoa.size(); ++i) {
            bohnet.write(inprimatzekoa.elementAt(i));
        }
        bohnet.close();
    }

    private void inprimatuBrownBohnet(String conllHelbidea, Vector<String> inprimatzekoa) throws IOException {
        String ruta = conllHelbidea;
        File archivo = new File(ruta);
        BufferedWriter brownBohnet = new BufferedWriter(new FileWriter(archivo));
        for (int i = 0; i < inprimatzekoa.size(); ++i) {
            brownBohnet.write(inprimatzekoa.elementAt(i));
        }
        brownBohnet.close();
    }

    private void inprimatuSimBohnet(String conllHelbidea, Vector<String> inprimatzekoa) throws IOException {
        String ruta = conllHelbidea;
        File archivo = new File(ruta);
        BufferedWriter simBohnet = new BufferedWriter(new FileWriter(archivo));
        for (int i = 0; i < inprimatzekoa.size(); ++i) {
            simBohnet.write(inprimatzekoa.elementAt(i));
        }
        simBohnet.close();
    }
}

