/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

public class TokenNameFinderCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final String type;
    private byte[] featureGeneratorBytes;
    private Map<String, Object> resources;
    private TokenNameFinderEvaluationMonitor[] listeners;
    private FMeasure fmeasure = new FMeasure();
    private SequenceCodec<String> codec;
    private TokenNameFinderFactory factory;

    public TokenNameFinderCrossValidator(String languageCode, String type, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> codec, TokenNameFinderEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.type = type;
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.params = trainParams;
        this.listeners = listeners;
        this.codec = codec;
    }

    public TokenNameFinderCrossValidator(String languageCode, String type, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources, TokenNameFinderEvaluationMonitor ... listeners) {
        this(languageCode, type, trainParams, featureGeneratorBytes, resources, new BioCodec(), listeners);
    }

    public TokenNameFinderCrossValidator(String languageCode, String type, TrainingParameters trainParams, TokenNameFinderFactory factory, TokenNameFinderEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.type = type;
        this.params = trainParams;
        this.factory = factory;
        this.listeners = listeners;
    }

    public void evaluate(ObjectStream<NameSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<DocumentSample> partitioner = new CrossValidationPartitioner<DocumentSample>(new NameToDocumentSampleStream(samples), nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<DocumentSample> trainingSampleStream = partitioner.next();
            TokenNameFinderModel model = this.factory != null ? NameFinderME.train(this.languageCode, this.type, new DocumentToNameSampleStream(trainingSampleStream), this.params, this.factory) : NameFinderME.train(this.languageCode, this.type, (ObjectStream<NameSample>)new DocumentToNameSampleStream(trainingSampleStream), this.params, this.featureGeneratorBytes, this.resources);
            TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model), this.listeners);
            evaluator.evaluate(new DocumentToNameSampleStream(trainingSampleStream.getTestSampleStream()));
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    private class DocumentToNameSampleStream
    extends FilterObjectStream<DocumentSample, NameSample> {
        private Iterator<NameSample> documentSamples;

        protected DocumentToNameSampleStream(ObjectStream<DocumentSample> samples) {
            super(samples);
            this.documentSamples = Collections.emptyList().iterator();
        }

        @Override
        public NameSample read() throws IOException {
            if (this.documentSamples.hasNext()) {
                return this.documentSamples.next();
            }
            DocumentSample docSample = (DocumentSample)this.samples.read();
            if (docSample != null) {
                this.documentSamples = Arrays.asList(docSample.getSamples()).iterator();
                return this.read();
            }
            return null;
        }
    }

    private class NameToDocumentSampleStream
    extends FilterObjectStream<NameSample, DocumentSample> {
        private NameSample beginSample;

        protected NameToDocumentSampleStream(ObjectStream<NameSample> samples) {
            super(samples);
        }

        @Override
        public DocumentSample read() throws IOException {
            NameSample sample;
            ArrayList<NameSample> document = new ArrayList<NameSample>();
            if (this.beginSample == null) {
                this.beginSample = (NameSample)this.samples.read();
            }
            if (this.beginSample == null) {
                return null;
            }
            document.add(this.beginSample);
            while ((sample = (NameSample)this.samples.read()) != null) {
                if (sample.isClearAdaptiveDataSet()) {
                    this.beginSample = sample;
                    break;
                }
                document.add(sample);
            }
            if (sample == null) {
                this.beginSample = null;
            }
            return new DocumentSample(document.toArray(new NameSample[document.size()]));
        }

        @Override
        public void reset() throws IOException, UnsupportedOperationException {
            super.reset();
            this.beginSample = null;
        }
    }

    private class DocumentSample {
        private NameSample[] samples;

        DocumentSample(NameSample[] samples) {
            this.samples = samples;
        }

        private NameSample[] getSamples() {
            return this.samples;
        }
    }
}

